/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HintUtil;
import com.intellij.codeInsight.hints.HintWidthAdjustment;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FocusModeModel;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.ui.paint.EffectPainter;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J,\u0010\u0017\u001a\u00020\u00182\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\u001d\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0005\u00a2\u0006\u0002\b\"R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Lcom/intellij/codeInsight/daemon/impl/HintRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "text", "", "<init>", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "setText", "widthAdjustment", "Lcom/intellij/codeInsight/hints/HintWidthAdjustment;", "getWidthAdjustment", "()Lcom/intellij/codeInsight/hints/HintWidthAdjustment;", "setWidthAdjustment", "(Lcom/intellij/codeInsight/hints/HintWidthAdjustment;)V", "calcWidthInPixels", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "getTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "editor", "Lcom/intellij/openapi/editor/Editor;", "paint", "", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "textAttributes", "useEditorFont", "", "getFontMetrics", "Lcom/intellij/codeInsight/daemon/impl/HintRenderer$Companion$MyFontMetrics;", "getFontMetrics$", "Companion", "intellij.platform.ide.impl"})
public class HintRenderer
implements EditorCustomElementRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String text;
    @Nullable
    private HintWidthAdjustment widthAdjustment;
    @NotNull
    private static final Key<Companion.MyFontMetrics> HINT_FONT_METRICS;
    public static final float BACKGROUND_ALPHA = 0.55f;

    public HintRenderer(@Nullable String text2) {
        this.text = text2;
    }

    @Nullable
    public final String getText() {
        return this.text;
    }

    public final void setText(@Nullable String string) {
        this.text = string;
    }

    @Nullable
    public final HintWidthAdjustment getWidthAdjustment() {
        return this.widthAdjustment;
    }

    public final void setWidthAdjustment(@Nullable HintWidthAdjustment hintWidthAdjustment) {
        this.widthAdjustment = hintWidthAdjustment;
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Editor editor2 = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        return Companion.calcWidthInPixels(editor2, this.text, this.widthAdjustment, this.useEditorFont());
    }

    @Nullable
    protected TextAttributes getTextAttributes(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return editor2.getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT);
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
        TextAttributes textAttributes2;
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        Editor editor2 = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        if (!(editor3 instanceof EditorImpl)) {
            return;
        }
        Segment focusModeRange = ((EditorImpl)editor3).getFocusModeRange();
        if (focusModeRange != null && (inlay.getOffset() <= focusModeRange.getStartOffset() || focusModeRange.getEndOffset() <= inlay.getOffset())) {
            textAttributes2 = (TextAttributes)((EditorImpl)editor3).getUserData(FocusModeModel.FOCUS_MODE_ATTRIBUTES);
            if (textAttributes2 == null) {
                textAttributes2 = this.getTextAttributes(editor3);
            }
        } else {
            textAttributes2 = this.getTextAttributes(editor3);
        }
        TextAttributes attributes = textAttributes2;
        EditorImpl editorImpl = (EditorImpl)editor3;
        TextAttributes textAttributes3 = attributes;
        if (textAttributes3 == null) {
            textAttributes3 = textAttributes;
        }
        Companion.paintHint(g, editorImpl, r, this.text, attributes, textAttributes3, this.widthAdjustment, this.useEditorFont());
    }

    protected boolean useEditorFont() {
        return Companion.useEditorFontFromSettings();
    }

    @JvmName(name="getFontMetrics$")
    protected final /* synthetic */ Companion.MyFontMetrics getFontMetrics$(Editor editor2, boolean useEditorFont) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return HintRenderer.getFontMetrics(editor2, useEditorFont);
    }

    @JvmStatic
    public static final int calcWidthInPixels(@NotNull Editor editor2, @Nullable String text2, @Nullable HintWidthAdjustment widthAdjustment) {
        return Companion.calcWidthInPixels(editor2, text2, widthAdjustment);
    }

    @JvmStatic
    public static final int calcWidthInPixels(@NotNull Editor editor2, @Nullable String text2, @Nullable HintWidthAdjustment widthAdjustment, boolean useEditorFont) {
        return Companion.calcWidthInPixels(editor2, text2, widthAdjustment, useEditorFont);
    }

    @JvmStatic
    public static final void paintHint(@NotNull Graphics g, @NotNull EditorImpl editor2, @NotNull Rectangle r, @Nullable String text2, @Nullable TextAttributes attributes, @NotNull TextAttributes textAttributes, @Nullable HintWidthAdjustment widthAdjustment) {
        Companion.paintHint(g, editor2, r, text2, attributes, textAttributes, widthAdjustment);
    }

    @JvmStatic
    public static final void paintHint(@NotNull Graphics g, @NotNull EditorImpl editor2, @NotNull Rectangle r, @Nullable String text2, @Nullable TextAttributes attributes, @NotNull TextAttributes textAttributes, @Nullable HintWidthAdjustment widthAdjustment, boolean useEditorFont) {
        Companion.paintHint(g, editor2, r, text2, attributes, textAttributes, widthAdjustment, useEditorFont);
    }

    @JvmStatic
    @NotNull
    protected static final Companion.MyFontMetrics getFontMetrics(@NotNull Editor editor2, boolean useEditorFont) {
        return Companion.getFontMetrics(editor2, useEditorFont);
    }

    @JvmStatic
    protected static final int calcHintTextWidth(@Nullable String text2, @NotNull FontMetrics fontMetrics) {
        return Companion.calcHintTextWidth(text2, fontMetrics);
    }

    static {
        Key key = Key.create((String)"ParameterHintFontMetrics");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        HINT_FONT_METRICS = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u00010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007JF\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007JN\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u001cH\u0002J \u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0002J,\u0010\"\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0005J\u0006\u0010'\u001a\u00020\rJ\u0018\u0010(\u001a\u00020)2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010*\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010#\u001a\u00020$H\u0005R!\u0010+\u001a\u0015\u0012\f\u0012\n -*\u0004\u0018\u00010&0&0,\u00a2\u0006\u0002\b.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/codeInsight/daemon/impl/HintRenderer$Companion;", "", "<init>", "()V", "calcWidthInPixels", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "text", "", "widthAdjustment", "Lcom/intellij/codeInsight/hints/HintWidthAdjustment;", "useEditorFont", "", "paintHint", "", "g", "Ljava/awt/Graphics;", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "r", "Ljava/awt/Rectangle;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "textAttributes", "isInsufficientContrast", "surroundingAttributes", "toGray", "", "Ljava/awt/Color;", "srcOverBlend", "foreground", "background", "foregroundAlpha", "", "calcWidthAdjustment", "fontMetrics", "Ljava/awt/FontMetrics;", "getFontMetrics", "Lcom/intellij/codeInsight/daemon/impl/HintRenderer$Companion$MyFontMetrics;", "useEditorFontFromSettings", "getFont", "Ljava/awt/Font;", "calcHintTextWidth", "HINT_FONT_METRICS", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "BACKGROUND_ALPHA", "MyFontMetrics", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final int calcWidthInPixels(@NotNull Editor editor2, @Nullable String text2, @Nullable HintWidthAdjustment widthAdjustment) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return this.calcWidthInPixels(editor2, text2, widthAdjustment, this.useEditorFontFromSettings());
        }

        @JvmStatic
        public final int calcWidthInPixels(@NotNull Editor editor2, @Nullable String text2, @Nullable HintWidthAdjustment widthAdjustment, boolean useEditorFont) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            FontMetrics fontMetrics = HintRenderer.getFontMetrics(editor2, useEditorFont).getMetrics();
            return HintRenderer.calcHintTextWidth(text2, fontMetrics) + this.calcWidthAdjustment(text2, editor2, fontMetrics, widthAdjustment);
        }

        @JvmStatic
        public final void paintHint(@NotNull Graphics g, @NotNull EditorImpl editor2, @NotNull Rectangle r, @Nullable String text2, @Nullable TextAttributes attributes, @NotNull TextAttributes textAttributes, @Nullable HintWidthAdjustment widthAdjustment) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            this.paintHint(g, editor2, r, text2, attributes, textAttributes, widthAdjustment, this.useEditorFontFromSettings());
        }

        @JvmStatic
        public final void paintHint(@NotNull Graphics g, @NotNull EditorImpl editor2, @NotNull Rectangle r, @Nullable String text2, @Nullable TextAttributes attributes, @NotNull TextAttributes textAttributes, @Nullable HintWidthAdjustment widthAdjustment, boolean useEditorFont) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            int ascent = editor2.getAscent();
            int descent = editor2.getDescent();
            Graphics2D g2d = (Graphics2D)g;
            if (text2 != null && attributes != null) {
                Color foregroundColor;
                MyFontMetrics fontMetrics = HintRenderer.getFontMetrics(editor2, useEditorFont);
                int gap = r.height < fontMetrics.getLineHeight() + 2 ? 1 : 2;
                Color backgroundColor = attributes.getBackgroundColor();
                if (backgroundColor != null) {
                    float alpha = this.isInsufficientContrast(attributes, textAttributes) ? 1.0f : 0.55f;
                    GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
                    GraphicsUtil.paintWithAlpha((Graphics)g, (float)alpha);
                    g.setColor(backgroundColor);
                    g.fillRoundRect(r.x + 2, r.y + gap, r.width - 4, r.height - gap * 2, 8, 8);
                    config.restore();
                }
                if ((foregroundColor = attributes.getForegroundColor()) != null) {
                    Object savedHint = g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                    Shape savedClip = g.getClip();
                    g.setColor(foregroundColor);
                    g.setFont(this.getFont(editor2, useEditorFont));
                    g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope((boolean)false));
                    g.clipRect(r.x + 3, r.y + 2, r.width - 6, r.height - 4);
                    FontMetrics metrics = fontMetrics.getMetrics();
                    int startX = r.x + 7;
                    int startY = r.y + Math.max(ascent, (r.height + metrics.getAscent() - metrics.getDescent()) / 2) - 1;
                    Editor editor3 = editor2;
                    FontMetrics fontMetrics2 = ((Graphics2D)g).getFontMetrics();
                    Intrinsics.checkNotNullExpressionValue((Object)fontMetrics2, (String)"getFontMetrics(...)");
                    int adjustment = this.calcWidthAdjustment(text2, editor3, fontMetrics2, widthAdjustment);
                    if (adjustment == 0) {
                        ((Graphics2D)g).drawString(text2, startX, startY);
                    } else {
                        HintWidthAdjustment hintWidthAdjustment = widthAdjustment;
                        Intrinsics.checkNotNull((Object)hintWidthAdjustment);
                        int adjustmentPosition = hintWidthAdjustment.getAdjustmentPosition();
                        String string = text2.substring(0, adjustmentPosition);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        String firstPart = string;
                        String string2 = text2.substring(adjustmentPosition);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        String secondPart = string2;
                        ((Graphics2D)g).drawString(firstPart, startX, startY);
                        ((Graphics2D)g).drawString(secondPart, startX + g.getFontMetrics().stringWidth(firstPart) + adjustment, startY);
                    }
                    g.setClip(savedClip);
                    g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedHint);
                }
            }
            Color effectColor = textAttributes.getEffectColor();
            EffectType effectType = textAttributes.getEffectType();
            if (effectColor != null) {
                g.setColor(effectColor);
                int xStart = r.x;
                int xEnd = r.x + r.width;
                int y = r.y + ascent;
                Font font = editor2.getColorsScheme().getFont(EditorFontType.PLAIN);
                Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
                Font font2 = font;
                EffectType effectType2 = effectType;
                switch (effectType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[effectType2.ordinal()]) {
                    case 1: {
                        EffectPainter.LINE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font2);
                        break;
                    }
                    case 2: {
                        EffectPainter.BOLD_LINE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font2);
                        break;
                    }
                    case 3: {
                        EffectPainter.STRIKE_THROUGH.paint(g2d, xStart, y, xEnd - xStart, editor2.getCharHeight(), (Object)font2);
                        break;
                    }
                    case 4: {
                        EffectPainter.WAVE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font2);
                        break;
                    }
                    case 5: {
                        EffectPainter.BOLD_DOTTED_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font2);
                    }
                }
            }
        }

        private final boolean isInsufficientContrast(TextAttributes attributes, TextAttributes surroundingAttributes) {
            Color backgroundUnderHint = surroundingAttributes.getBackgroundColor();
            if (backgroundUnderHint == null || attributes.getForegroundColor() == null) {
                return false;
            }
            Color color = attributes.getBackgroundColor();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackgroundColor(...)");
            Color backgroundBlended = this.srcOverBlend(color, backgroundUnderHint, 0.55f);
            double backgroundBlendedGrayed = this.toGray(backgroundBlended);
            Color color2 = attributes.getForegroundColor();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getForegroundColor(...)");
            double textGrayed = this.toGray(color2);
            double delta = Math.abs(backgroundBlendedGrayed - textGrayed);
            return delta < 10.0;
        }

        private final double toGray(Color $this$toGray) {
            return 0.3 * (double)$this$toGray.getRed() + 0.59 * (double)$this$toGray.getGreen() + 0.11 * (double)$this$toGray.getBlue();
        }

        private final Color srcOverBlend(Color foreground, Color background, float foregroundAlpha) {
            float r = (float)foreground.getRed() * foregroundAlpha + (float)background.getRed() * (1.0f - foregroundAlpha);
            float g = (float)foreground.getGreen() * foregroundAlpha + (float)background.getGreen() * (1.0f - foregroundAlpha);
            float b = (float)foreground.getBlue() * foregroundAlpha + (float)background.getBlue() * (1.0f - foregroundAlpha);
            return new Color(MathKt.roundToInt((float)r), MathKt.roundToInt((float)g), MathKt.roundToInt((float)b));
        }

        private final int calcWidthAdjustment(String text2, Editor editor2, FontMetrics fontMetrics, HintWidthAdjustment widthAdjustment) {
            if (widthAdjustment == null || !(editor2 instanceof EditorImpl)) {
                return 0;
            }
            int editorTextWidth = ((EditorImpl)editor2).getFontMetrics(0).stringWidth(widthAdjustment.getEditorTextToMatch());
            return Math.max(0, editorTextWidth + HintRenderer.calcHintTextWidth(widthAdjustment.getHintTextToMatch(), fontMetrics) - HintRenderer.calcHintTextWidth(text2, fontMetrics));
        }

        @JvmStatic
        @NotNull
        protected final MyFontMetrics getFontMetrics(@NotNull Editor editor2, boolean useEditorFont) {
            String familyName;
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            float size2 = HintUtil.INSTANCE.getSize(editor2);
            MyFontMetrics metrics = (MyFontMetrics)editor2.getUserData(HINT_FONT_METRICS);
            TextAttributes attributes = editor2.getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT);
            int fontType = attributes.getFontType();
            String string = familyName = useEditorFont ? EditorColorsManager.getInstance().getGlobalScheme().getEditorFontName() : StartupUiUtil.getLabelFont().getFamily();
            if (metrics != null) {
                Intrinsics.checkNotNull((Object)familyName);
                if (!metrics.isActual(editor2, size2, fontType, familyName)) {
                    metrics = null;
                }
            }
            if (metrics == null) {
                metrics = new MyFontMetrics(editor2, size2, fontType, useEditorFont);
                editor2.putUserData(HINT_FONT_METRICS, (Object)metrics);
            }
            return metrics;
        }

        public final boolean useEditorFontFromSettings() {
            return EditorSettingsExternalizable.getInstance().isUseEditorFontInInlays();
        }

        private final Font getFont(Editor editor2, boolean useEditorFont) {
            return HintRenderer.getFontMetrics(editor2, useEditorFont).getFont();
        }

        @JvmStatic
        protected final int calcHintTextWidth(@Nullable String text2, @NotNull FontMetrics fontMetrics) {
            Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
            String string = text2;
            return string == null ? 0 : fontMetrics.stringWidth(string) + 14;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ&\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/codeInsight/daemon/impl/HintRenderer$Companion$MyFontMetrics;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "size", "", "fontType", "", "useEditorFont", "", "<init>", "(Lcom/intellij/openapi/editor/Editor;FIZ)V", "metrics", "Ljava/awt/FontMetrics;", "getMetrics", "()Ljava/awt/FontMetrics;", "lineHeight", "getLineHeight", "()I", "font", "Ljava/awt/Font;", "getFont", "()Ljava/awt/Font;", "isActual", "familyName", "", "getCurrentContext", "Ljava/awt/font/FontRenderContext;", "intellij.platform.ide.impl"})
        public static final class MyFontMetrics {
            @NotNull
            private final FontMetrics metrics;
            private final int lineHeight;

            public MyFontMetrics(@NotNull Editor editor2, float size2, @JdkConstants.FontStyle int fontType, boolean useEditorFont) {
                Font font;
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                if (useEditorFont) {
                    Font editorFont = EditorUtil.getEditorFont();
                    font = editorFont.deriveFont(fontType, size2);
                } else {
                    String familyName = UIManager.getFont("Label.font").getFamily();
                    font = StartupUiUtil.getFontWithFallback((String)familyName, (int)fontType, (float)size2);
                }
                Font font2 = font;
                FontRenderContext context = this.getCurrentContext(editor2);
                FontMetrics fontMetrics = FontInfo.getFontMetrics(font2, context);
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
                this.metrics = fontMetrics;
                this.lineHeight = (int)Math.ceil(font2.createGlyphVector(context, "Ap").getVisualBounds().getHeight());
            }

            @NotNull
            public final FontMetrics getMetrics() {
                return this.metrics;
            }

            public final int getLineHeight() {
                return this.lineHeight;
            }

            @NotNull
            public final Font getFont() {
                Font font = this.metrics.getFont();
                Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
                return font;
            }

            public final boolean isActual(@NotNull Editor editor2, float size2, int fontType, @NotNull String familyName) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
                Font font = this.metrics.getFont();
                if (!Intrinsics.areEqual((Object)familyName, (Object)font.getFamily()) || !(size2 == font.getSize2D()) || fontType != font.getStyle()) {
                    return false;
                }
                FontRenderContext currentContext = this.getCurrentContext(editor2);
                return currentContext.equals(this.metrics.getFontRenderContext());
            }

            private final FontRenderContext getCurrentContext(Editor editor2) {
                FontRenderContext editorContext = FontInfo.getFontRenderContext(editor2.getContentComponent());
                return new FontRenderContext(editorContext.getTransform(), AntialiasingType.getKeyForCurrentScope((boolean)false), UISettings.Companion.getEditorFractionalMetricsHint());
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[EffectType.values().length];
                try {
                    nArray[EffectType.LINE_UNDERSCORE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EffectType.BOLD_LINE_UNDERSCORE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EffectType.STRIKEOUT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EffectType.WAVE_UNDERSCORE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EffectType.BOLD_DOTTED_LINE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

