/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.EditMemorySettingsService;
import com.intellij.diagnostic.VMOptions;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import java.nio.file.Path;
import javax.swing.Icon;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/diagnostic/EditMemorySettingsPanel;", "", "option", "Lcom/intellij/diagnostic/VMOptions$MemoryKind;", "memoryLow", "", "suggested", "", "<init>", "(Lcom/intellij/diagnostic/VMOptions$MemoryKind;ZI)V", "newValueField", "Lcom/intellij/ui/components/JBTextField;", "getNewValueField", "()Lcom/intellij/ui/components/JBTextField;", "setNewValueField", "(Lcom/intellij/ui/components/JBTextField;)V", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nEditMemorySettingsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditMemorySettingsPanel.kt\ncom/intellij/diagnostic/EditMemorySettingsPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class EditMemorySettingsPanel {
    @NotNull
    private final VMOptions.MemoryKind option;
    private final boolean memoryLow;
    private final int suggested;
    public JBTextField newValueField;
    @JvmField
    @NotNull
    public final DialogPanel panel;

    public EditMemorySettingsPanel(@NotNull VMOptions.MemoryKind option2, boolean memoryLow, int suggested) {
        Intrinsics.checkNotNullParameter((Object)((Object)option2), (String)"option");
        this.option = option2;
        this.memoryLow = memoryLow;
        this.suggested = suggested;
        this.panel = BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> EditMemorySettingsPanel.panel$lambda$0(this, arg_0)));
    }

    @NotNull
    public final JBTextField getNewValueField() {
        JBTextField jBTextField = this.newValueField;
        if (jBTextField != null) {
            return jBTextField;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"newValueField");
        return null;
    }

    public final void setNewValueField(@NotNull JBTextField jBTextField) {
        Intrinsics.checkNotNullParameter((Object)jBTextField, (String)"<set-?>");
        this.newValueField = jBTextField;
    }

    private static final Unit panel$lambda$0(EditMemorySettingsPanel this$0, Panel $this$panel) {
        JBLabel jBLabel;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        int current = VMOptions.readOption(this$0.option, true);
        Path path = EditMemorySettingsService.getInstance().getUserOptionsFile();
        if (path == null) {
            throw new IllegalStateException();
        }
        Path file2 = path;
        if (this$0.memoryLow) {
            Panel.row$default($this$panel, null, arg_0 -> EditMemorySettingsPanel.panel$lambda$0$0(this$0, arg_0), 1, null);
        }
        Panel.row$default($this$panel, null, EditMemorySettingsPanel::panel$lambda$0$1, 1, null);
        JBLabel $this$panel_u24lambda_u240_u242 = jBLabel = new JBLabel(this$0.option.label() + ":");
        boolean bl = false;
        char c = '-';
        String string = this$0.option.optionName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"optionName");
        String string2 = string;
        $this$panel_u24lambda_u240_u242.setToolTipText(c + string2);
        JBLabel optionLabel = jBLabel;
        $this$panel.row((JLabel)optionLabel, (Function1<? super Row, Unit>)((Function1)arg_0 -> EditMemorySettingsPanel.panel$lambda$0$3(this$0, current, arg_0)));
        Panel.row$default($this$panel, null, arg_0 -> EditMemorySettingsPanel.panel$lambda$0$4(file2, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0(EditMemorySettingsPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        if (this$0.option == VMOptions.MemoryKind.HEAP) {
            long free = Runtime.getRuntime().freeMemory() >> 20;
            long max = Runtime.getRuntime().maxMemory() >> 20;
            Object[] objectArray = new Object[]{String.valueOf(free), String.valueOf(max)};
            String string = DiagnosticBundle.message("change.memory.usage", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            v1 = $this$row.label(string);
        } else {
            String string = DiagnosticBundle.message("change.memory.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            v1 = $this$row.label(string);
        }
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DiagnosticBundle.message("change.memory.act", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$3(EditMemorySettingsPanel this$0, int $current, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.setNewValueField(TextFieldKt.columns(TextFieldKt.text($this$row.textField(), String.valueOf(this$0.suggested)), 5).gap(RightGap.SMALL).focused().getComponent());
        String string = $current == -1 ? DiagnosticBundle.message("change.memory.unknown", new Object[0]) : String.valueOf($current);
        Intrinsics.checkNotNull((Object)string);
        String formatted = string;
        Object[] objectArray = new Object[]{formatted};
        String string2 = DiagnosticBundle.message("change.memory.units", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Row.text$default($this$row, string2, 0, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4(Path $file, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Icon icon2 = AllIcons.General.Information;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Information");
        $this$row.icon(icon2).align(AlignY.TOP.INSTANCE).gap(RightGap.SMALL);
        Object[] objectArray = new Object[]{((Object)$file).toString()};
        String string = DiagnosticBundle.message("change.memory.file", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.text$default($this$row, string, Integer.MAX_VALUE, null, 4, null);
        return Unit.INSTANCE;
    }
}

