/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.FusFreezeReporterKt;
import com.intellij.diagnostic.PerformanceListener;
import com.intellij.diagnostic.UILatencyLogger;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/diagnostic/FusFreezeReporter;", "Lcom/intellij/diagnostic/PerformanceListener;", "<init>", "()V", "previousLoggedUiResponse", "", "uiFreezeFinished", "", "durationMs", "reportDir", "Ljava/nio/file/Path;", "uiResponded", "latencyMs", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nFusFreezeReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FusFreezeReporter.kt\ncom/intellij/diagnostic/FusFreezeReporter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,38:1\n12970#2,2:39\n*S KotlinDebug\n*F\n+ 1 FusFreezeReporter.kt\ncom/intellij/diagnostic/FusFreezeReporter\n*L\n33#1:39,2\n*E\n"})
final class FusFreezeReporter
implements PerformanceListener {
    private volatile long previousLoggedUiResponse;

    public void uiFreezeFinished(long durationMs, @Nullable Path reportDir) {
        if (!FusFreezeReporterKt.access$isDebugEnabled$p()) {
            LifecycleUsageTriggerCollector.onFreeze(durationMs);
        }
    }

    public void uiResponded(long latencyMs2) {
        long currentTime = System.nanoTime();
        long elapsedMs = TimeUnit.NANOSECONDS.toMillis(currentTime - this.previousLoggedUiResponse);
        if (elapsedMs >= 100000L) {
            this.previousLoggedUiResponse = currentTime;
            UILatencyLogger.LATENCY.log((Object)latencyMs2);
        }
        if (latencyMs2 >= 100L && !FusFreezeReporterKt.access$isDebugEnabled$p()) {
            boolean bl;
            block3: {
                Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
                Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
                Object[] $this$any$iv = projectArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Project it = (Project)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!DumbService.Companion.isDumb(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            boolean hasIndexingGoingOn = bl;
            UILatencyLogger.LAGGING.log((Object)latencyMs2, (Object)hasIndexingGoingOn);
        }
    }
}

