/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.PlatformMemoryUtil;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.win32.StdCallLibrary;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0004\n\u000b\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\b\u001a\u00060\tR\u00020\u0001H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/diagnostic/WindowsMemoryUtil;", "Lcom/intellij/diagnostic/PlatformMemoryUtil;", "<init>", "()V", "kernel32", "Lcom/sun/jna/platform/win32/Kernel32;", "psapi", "Lcom/intellij/diagnostic/WindowsMemoryUtil$Psapi;", "newMemoryStatsProvider", "Lcom/intellij/diagnostic/PlatformMemoryUtil$MemoryStatsProvider;", "WindowsMemoryStatsProvider", "WindowsMemoryStats", "Psapi", "ProcessMemoryCountersEx2", "intellij.platform.ide.impl"})
final class WindowsMemoryUtil
extends PlatformMemoryUtil {
    @NotNull
    private final Kernel32 kernel32;
    @NotNull
    private final Psapi psapi;

    public WindowsMemoryUtil() {
        Kernel32 kernel32 = Kernel32.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kernel32, (String)"INSTANCE");
        this.kernel32 = kernel32;
        Library library = Native.load((String)"psapi", Psapi.class);
        Intrinsics.checkNotNullExpressionValue((Object)library, (String)"load(...)");
        this.psapi = (Psapi)library;
    }

    @Override
    @NotNull
    public PlatformMemoryUtil.MemoryStatsProvider newMemoryStatsProvider() {
        return new WindowsMemoryStatsProvider();
    }

    @Structure.FieldOrder(value={"cb", "PageFaultCount", "PeakWorkingSetSize", "WorkingSetSize", "QuotaPeakPagedPoolUsage", "QuotaPagedPoolUsage", "QuotaPeakNonPagedPoolUsage", "QuotaNonPagedPoolUsage", "PagefileUsage", "PeakPagefileUsage", "PrivateUsage", "PrivateWorkingSetSize", "SharedCommitUsage"})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/diagnostic/WindowsMemoryUtil$ProcessMemoryCountersEx2;", "Lcom/sun/jna/Structure;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "cb", "", "PageFaultCount", "PeakWorkingSetSize", "", "WorkingSetSize", "QuotaPeakPagedPoolUsage", "QuotaPagedPoolUsage", "QuotaPeakNonPagedPoolUsage", "QuotaNonPagedPoolUsage", "PagefileUsage", "PeakPagefileUsage", "PrivateUsage", "PrivateWorkingSetSize", "SharedCommitUsage", "close", "", "intellij.platform.ide.impl"})
    public static final class ProcessMemoryCountersEx2
    extends Structure
    implements AutoCloseable {
        @JvmField
        public int cb;
        @JvmField
        public int PageFaultCount;
        @JvmField
        public long PeakWorkingSetSize;
        @JvmField
        public long WorkingSetSize;
        @JvmField
        public long QuotaPeakPagedPoolUsage;
        @JvmField
        public long QuotaPagedPoolUsage;
        @JvmField
        public long QuotaPeakNonPagedPoolUsage;
        @JvmField
        public long QuotaNonPagedPoolUsage;
        @JvmField
        public long PagefileUsage;
        @JvmField
        public long PeakPagefileUsage;
        @JvmField
        public long PrivateUsage;
        @JvmField
        public long PrivateWorkingSetSize;
        @JvmField
        public long SharedCommitUsage;

        @Override
        public void close() {
            block0: {
                Pointer pointer = this.getPointer();
                Memory memory = pointer instanceof Memory ? (Memory)pointer : null;
                if (memory == null) break block0;
                memory.close();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bb\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/diagnostic/WindowsMemoryUtil$Psapi;", "Lcom/sun/jna/win32/StdCallLibrary;", "GetProcessMemoryInfo", "", "process", "Lcom/sun/jna/Pointer;", "counters", "Lcom/intellij/diagnostic/WindowsMemoryUtil$ProcessMemoryCountersEx2;", "size", "", "intellij.platform.ide.impl"})
    private static interface Psapi
    extends StdCallLibrary {
        public boolean GetProcessMemoryInfo(@NotNull Pointer var1, @NotNull ProcessMemoryCountersEx2 var2, int var3);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/intellij/diagnostic/WindowsMemoryUtil$WindowsMemoryStats;", "", "workingSetSize", "", "privateWorkingSetSize", "privateUsage", "<init>", "(JJJ)V", "getWorkingSetSize", "()J", "getPrivateWorkingSetSize", "getPrivateUsage", "toMemoryStats", "Lcom/intellij/diagnostic/PlatformMemoryUtil$MemoryStats;", "intellij.platform.ide.impl"})
    private static final class WindowsMemoryStats {
        private final long workingSetSize;
        private final long privateWorkingSetSize;
        private final long privateUsage;

        public WindowsMemoryStats(long workingSetSize, long privateWorkingSetSize, long privateUsage) {
            this.workingSetSize = workingSetSize;
            this.privateWorkingSetSize = privateWorkingSetSize;
            this.privateUsage = privateUsage;
        }

        public final long getWorkingSetSize() {
            return this.workingSetSize;
        }

        public final long getPrivateWorkingSetSize() {
            return this.privateWorkingSetSize;
        }

        public final long getPrivateUsage() {
            return this.privateUsage;
        }

        @NotNull
        public final PlatformMemoryUtil.MemoryStats toMemoryStats() {
            return new PlatformMemoryUtil.MemoryStats(this.workingSetSize, this.privateWorkingSetSize, this.privateUsage, this.workingSetSize - this.privateWorkingSetSize);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/diagnostic/WindowsMemoryUtil$WindowsMemoryStatsProvider;", "Lcom/intellij/diagnostic/PlatformMemoryUtil$MemoryStatsProvider;", "Lcom/intellij/diagnostic/PlatformMemoryUtil;", "<init>", "(Lcom/intellij/diagnostic/WindowsMemoryUtil;)V", "memoryCounters", "Lcom/intellij/diagnostic/WindowsMemoryUtil$ProcessMemoryCountersEx2;", "getCurrentProcessMemoryStatsInner", "Lcom/intellij/diagnostic/PlatformMemoryUtil$MemoryStats;", "close", "", "intellij.platform.ide.impl"})
    private final class WindowsMemoryStatsProvider
    extends PlatformMemoryUtil.MemoryStatsProvider {
        @Nullable
        private ProcessMemoryCountersEx2 memoryCounters;

        /*
         * WARNING - void declaration
         */
        public WindowsMemoryStatsProvider() {
            void $this$memoryCounters_u24lambda_u240;
            ProcessMemoryCountersEx2 processMemoryCountersEx2;
            ProcessMemoryCountersEx2 processMemoryCountersEx22 = processMemoryCountersEx2 = new ProcessMemoryCountersEx2();
            WindowsMemoryStatsProvider windowsMemoryStatsProvider = this;
            boolean bl = false;
            $this$memoryCounters_u24lambda_u240.cb = $this$memoryCounters_u24lambda_u240.size();
            windowsMemoryStatsProvider.memoryCounters = processMemoryCountersEx2;
        }

        @Override
        @Nullable
        protected PlatformMemoryUtil.MemoryStats getCurrentProcessMemoryStatsInner() {
            ProcessMemoryCountersEx2 processMemoryCountersEx2 = this.memoryCounters;
            if (processMemoryCountersEx2 == null) {
                return null;
            }
            ProcessMemoryCountersEx2 memoryCounters = processMemoryCountersEx2;
            Pointer processHandle = WindowsMemoryUtil.this.kernel32.GetCurrentProcess().getPointer();
            Psapi psapi = WindowsMemoryUtil.this.psapi;
            Intrinsics.checkNotNull((Object)processHandle);
            boolean success2 = psapi.GetProcessMemoryInfo(processHandle, memoryCounters, memoryCounters.size());
            if (!success2) {
                return null;
            }
            memoryCounters.read();
            return new WindowsMemoryStats(memoryCounters.WorkingSetSize, memoryCounters.PrivateWorkingSetSize, memoryCounters.PrivateUsage).toMemoryStats();
        }

        @Override
        public void close() {
            ProcessMemoryCountersEx2 processMemoryCountersEx2 = this.memoryCounters;
            if (processMemoryCountersEx2 != null) {
                processMemoryCountersEx2.close();
            }
            this.memoryCounters = null;
        }
    }
}

