/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.fus;

import com.intellij.openapi.application.ReadActionListener;
import com.intellij.openapi.application.WriteActionListener;
import com.intellij.openapi.application.WriteIntentReadActionListener;
import com.intellij.util.ui.EDT;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.SingleWriterRecorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\u0014\u0010\r\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\u0014\u0010\u000e\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\u0014\u0010\u000f\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\u0014\u0010\u0010\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\u0014\u0010\u0011\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\u0014\u0010\u0012\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\u0014\u0010\u0013\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\u0014\u0010\u0014\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\f\u0010\u0015\u001a\u00020\n*\u00020\u0007H\u0002J\f\u0010\u0016\u001a\u00020\n*\u00020\u0007H\u0002J\f\u0010\u0017\u001a\u00020\n*\u00020\u0007H\u0002J \u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/diagnostic/fus/EdtLockAggregatingListener;", "Lcom/intellij/openapi/application/WriteActionListener;", "Lcom/intellij/openapi/application/ReadActionListener;", "Lcom/intellij/openapi/application/WriteIntentReadActionListener;", "<init>", "()V", "readingLockRecorder", "Lcom/intellij/diagnostic/fus/EdtLockAggregatingListener$Recorder;", "writeLockRecorder", "beforeWriteActionStart", "", "action", "Ljava/lang/Class;", "writeActionStarted", "writeActionFinished", "beforeReadActionStart", "beforeWriteIntentReadActionStart", "readActionStarted", "writeIntentReadActionStarted", "writeIntentReadActionFinished", "readActionFinished", "lockReleased", "beforeLockAcquisition", "lockAcquired", "exportHistogram", "Lorg/HdrHistogram/Histogram;", "existing", "isRead", "", "isWaiting", "Recorder", "intellij.platform.ide.impl"})
final class EdtLockAggregatingListener
implements WriteActionListener,
ReadActionListener,
WriteIntentReadActionListener {
    @NotNull
    private final Recorder readingLockRecorder = new Recorder(null, null, null, null, 0, 31, null);
    @NotNull
    private final Recorder writeLockRecorder = new Recorder(null, null, null, null, 0, 31, null);

    public void beforeWriteActionStart(@NotNull Class<?> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.beforeLockAcquisition(this.writeLockRecorder);
    }

    public void writeActionStarted(@NotNull Class<?> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.lockAcquired(this.writeLockRecorder);
    }

    public void writeActionFinished(@NotNull Class<?> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.lockReleased(this.writeLockRecorder);
    }

    public void beforeReadActionStart(@NotNull Class<?> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.beforeLockAcquisition(this.readingLockRecorder);
    }

    public void beforeWriteIntentReadActionStart(@NotNull Class<?> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.beforeLockAcquisition(this.readingLockRecorder);
    }

    public void readActionStarted(@NotNull Class<?> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.lockAcquired(this.readingLockRecorder);
    }

    public void writeIntentReadActionStarted(@NotNull Class<?> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.lockAcquired(this.readingLockRecorder);
    }

    public void writeIntentReadActionFinished(@NotNull Class<?> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.lockReleased(this.readingLockRecorder);
    }

    public void readActionFinished(@NotNull Class<?> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.lockReleased(this.readingLockRecorder);
    }

    private final void lockReleased(Recorder $this$lockReleased) {
        if (!EDT.isCurrentThreadEdt()) {
            return;
        }
        $this$lockReleased.setAcquiredCounter($this$lockReleased.getAcquiredCounter() - 1);
        if ($this$lockReleased.getAcquiredCounter() == 0) {
            long now = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            TimeSource.Monotonic.ValueTimeMark executionIntentMark = $this$lockReleased.getMarkOfExecutionIntent-LFT3Okc();
            if (executionIntentMark != null) {
                long timeOfExecution = TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)now, (long)executionIntentMark.unbox-impl());
                $this$lockReleased.getExecutionTimeRecorder().recordValue(Duration.getInWholeNanoseconds-impl((long)timeOfExecution));
            }
            $this$lockReleased.setMarkOfExecutionIntent-rEXM0dE(null);
        }
    }

    private final void beforeLockAcquisition(Recorder $this$beforeLockAcquisition) {
        if (!EDT.isCurrentThreadEdt()) {
            return;
        }
        if ($this$beforeLockAcquisition.getAcquiredCounter() == 0) {
            $this$beforeLockAcquisition.setMarkOfAcquisitionIntent-rEXM0dE(TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto()));
        }
    }

    private final void lockAcquired(Recorder $this$lockAcquired) {
        if (!EDT.isCurrentThreadEdt()) {
            return;
        }
        if ($this$lockAcquired.getAcquiredCounter() == 0) {
            long now = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            TimeSource.Monotonic.ValueTimeMark acquisitionIntentMark = $this$lockAcquired.getMarkOfAcquisitionIntent-LFT3Okc();
            if (acquisitionIntentMark != null) {
                long timeToWaitForAcquisition = TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)now, (long)acquisitionIntentMark.unbox-impl());
                $this$lockAcquired.getWaitingTimeRecorder().recordValue(Duration.getInWholeNanoseconds-impl((long)timeToWaitForAcquisition));
            }
            $this$lockAcquired.setMarkOfAcquisitionIntent-rEXM0dE(null);
            $this$lockAcquired.setMarkOfExecutionIntent-rEXM0dE(TimeSource.Monotonic.ValueTimeMark.box-impl((long)now));
        }
        $this$lockAcquired.setAcquiredCounter($this$lockAcquired.getAcquiredCounter() + 1);
    }

    @NotNull
    public final Histogram exportHistogram(@Nullable Histogram existing, boolean isRead, boolean isWaiting) {
        Histogram histogram;
        Pair pair = TuplesKt.to((Object)isRead, (Object)isWaiting);
        if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)true, (Object)true))) {
            Histogram histogram2 = this.readingLockRecorder.getWaitingTimeRecorder().getIntervalHistogram(existing);
            histogram = histogram2;
            Intrinsics.checkNotNullExpressionValue((Object)histogram2, (String)"getIntervalHistogram(...)");
        } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)true, (Object)false))) {
            Histogram histogram3 = this.readingLockRecorder.getExecutionTimeRecorder().getIntervalHistogram(existing);
            histogram = histogram3;
            Intrinsics.checkNotNullExpressionValue((Object)histogram3, (String)"getIntervalHistogram(...)");
        } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)false, (Object)true))) {
            Histogram histogram4 = this.writeLockRecorder.getWaitingTimeRecorder().getIntervalHistogram(existing);
            histogram = histogram4;
            Intrinsics.checkNotNullExpressionValue((Object)histogram4, (String)"getIntervalHistogram(...)");
        } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)false, (Object)false))) {
            Histogram histogram5 = this.writeLockRecorder.getExecutionTimeRecorder().getIntervalHistogram(existing);
            histogram = histogram5;
            Intrinsics.checkNotNullExpressionValue((Object)histogram5, (String)"getIntervalHistogram(...)");
        } else {
            throw new IllegalStateException("unreachable".toString());
        }
        return histogram;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B=\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\b\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\b\u001eJ\t\u0010\u001f\u001a\u00020\tH\u00c6\u0003JD\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0002\b!J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020\tH\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"Lcom/intellij/diagnostic/fus/EdtLockAggregatingListener$Recorder;", "", "waitingTimeRecorder", "Lorg/HdrHistogram/SingleWriterRecorder;", "executionTimeRecorder", "markOfAcquisitionIntent", "Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;", "markOfExecutionIntent", "acquiredCounter", "", "<init>", "(Lorg/HdrHistogram/SingleWriterRecorder;Lorg/HdrHistogram/SingleWriterRecorder;Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "getWaitingTimeRecorder", "()Lorg/HdrHistogram/SingleWriterRecorder;", "getExecutionTimeRecorder", "getMarkOfAcquisitionIntent-LFT3Okc", "()Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;", "setMarkOfAcquisitionIntent-rEXM0dE", "(Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;)V", "getMarkOfExecutionIntent-LFT3Okc", "setMarkOfExecutionIntent-rEXM0dE", "getAcquiredCounter", "()I", "setAcquiredCounter", "(I)V", "component1", "component2", "component3", "component3-LFT3Okc", "component4", "component4-LFT3Okc", "component5", "copy", "copy-ScUP2V8", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.ide.impl"})
    private static final class Recorder {
        @NotNull
        private final SingleWriterRecorder waitingTimeRecorder;
        @NotNull
        private final SingleWriterRecorder executionTimeRecorder;
        @Nullable
        private TimeSource.Monotonic.ValueTimeMark markOfAcquisitionIntent;
        @Nullable
        private TimeSource.Monotonic.ValueTimeMark markOfExecutionIntent;
        private int acquiredCounter;

        private Recorder(SingleWriterRecorder waitingTimeRecorder, SingleWriterRecorder executionTimeRecorder, TimeSource.Monotonic.ValueTimeMark markOfAcquisitionIntent, TimeSource.Monotonic.ValueTimeMark markOfExecutionIntent, int acquiredCounter) {
            Intrinsics.checkNotNullParameter((Object)waitingTimeRecorder, (String)"waitingTimeRecorder");
            Intrinsics.checkNotNullParameter((Object)executionTimeRecorder, (String)"executionTimeRecorder");
            this.waitingTimeRecorder = waitingTimeRecorder;
            this.executionTimeRecorder = executionTimeRecorder;
            this.markOfAcquisitionIntent = markOfAcquisitionIntent;
            this.markOfExecutionIntent = markOfExecutionIntent;
            this.acquiredCounter = acquiredCounter;
        }

        public /* synthetic */ Recorder(SingleWriterRecorder singleWriterRecorder, SingleWriterRecorder singleWriterRecorder2, TimeSource.Monotonic.ValueTimeMark valueTimeMark, TimeSource.Monotonic.ValueTimeMark valueTimeMark2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                singleWriterRecorder = new SingleWriterRecorder(2);
            }
            if ((n2 & 2) != 0) {
                singleWriterRecorder2 = new SingleWriterRecorder(2);
            }
            if ((n2 & 4) != 0) {
                valueTimeMark = null;
            }
            if ((n2 & 8) != 0) {
                valueTimeMark2 = null;
            }
            if ((n2 & 0x10) != 0) {
                n = 0;
            }
            this(singleWriterRecorder, singleWriterRecorder2, valueTimeMark, valueTimeMark2, n, null);
        }

        @NotNull
        public final SingleWriterRecorder getWaitingTimeRecorder() {
            return this.waitingTimeRecorder;
        }

        @NotNull
        public final SingleWriterRecorder getExecutionTimeRecorder() {
            return this.executionTimeRecorder;
        }

        @Nullable
        public final TimeSource.Monotonic.ValueTimeMark getMarkOfAcquisitionIntent-LFT3Okc() {
            return this.markOfAcquisitionIntent;
        }

        public final void setMarkOfAcquisitionIntent-rEXM0dE(@Nullable TimeSource.Monotonic.ValueTimeMark valueTimeMark) {
            this.markOfAcquisitionIntent = valueTimeMark;
        }

        @Nullable
        public final TimeSource.Monotonic.ValueTimeMark getMarkOfExecutionIntent-LFT3Okc() {
            return this.markOfExecutionIntent;
        }

        public final void setMarkOfExecutionIntent-rEXM0dE(@Nullable TimeSource.Monotonic.ValueTimeMark valueTimeMark) {
            this.markOfExecutionIntent = valueTimeMark;
        }

        public final int getAcquiredCounter() {
            return this.acquiredCounter;
        }

        public final void setAcquiredCounter(int n) {
            this.acquiredCounter = n;
        }

        @NotNull
        public final SingleWriterRecorder component1() {
            return this.waitingTimeRecorder;
        }

        @NotNull
        public final SingleWriterRecorder component2() {
            return this.executionTimeRecorder;
        }

        @Nullable
        public final TimeSource.Monotonic.ValueTimeMark component3-LFT3Okc() {
            return this.markOfAcquisitionIntent;
        }

        @Nullable
        public final TimeSource.Monotonic.ValueTimeMark component4-LFT3Okc() {
            return this.markOfExecutionIntent;
        }

        public final int component5() {
            return this.acquiredCounter;
        }

        @NotNull
        public final Recorder copy-ScUP2V8(@NotNull SingleWriterRecorder waitingTimeRecorder, @NotNull SingleWriterRecorder executionTimeRecorder, @Nullable TimeSource.Monotonic.ValueTimeMark markOfAcquisitionIntent, @Nullable TimeSource.Monotonic.ValueTimeMark markOfExecutionIntent, int acquiredCounter) {
            Intrinsics.checkNotNullParameter((Object)waitingTimeRecorder, (String)"waitingTimeRecorder");
            Intrinsics.checkNotNullParameter((Object)executionTimeRecorder, (String)"executionTimeRecorder");
            return new Recorder(waitingTimeRecorder, executionTimeRecorder, markOfAcquisitionIntent, markOfExecutionIntent, acquiredCounter, null);
        }

        public static /* synthetic */ Recorder copy-ScUP2V8$default(Recorder recorder, SingleWriterRecorder singleWriterRecorder, SingleWriterRecorder singleWriterRecorder2, TimeSource.Monotonic.ValueTimeMark valueTimeMark, TimeSource.Monotonic.ValueTimeMark valueTimeMark2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                singleWriterRecorder = recorder.waitingTimeRecorder;
            }
            if ((n2 & 2) != 0) {
                singleWriterRecorder2 = recorder.executionTimeRecorder;
            }
            if ((n2 & 4) != 0) {
                valueTimeMark = recorder.markOfAcquisitionIntent;
            }
            if ((n2 & 8) != 0) {
                valueTimeMark2 = recorder.markOfExecutionIntent;
            }
            if ((n2 & 0x10) != 0) {
                n = recorder.acquiredCounter;
            }
            return recorder.copy-ScUP2V8(singleWriterRecorder, singleWriterRecorder2, valueTimeMark, valueTimeMark2, n);
        }

        @NotNull
        public String toString() {
            return "Recorder(waitingTimeRecorder=" + this.waitingTimeRecorder + ", executionTimeRecorder=" + this.executionTimeRecorder + ", markOfAcquisitionIntent=" + this.markOfAcquisitionIntent + ", markOfExecutionIntent=" + this.markOfExecutionIntent + ", acquiredCounter=" + this.acquiredCounter + ")";
        }

        public int hashCode() {
            int result2 = this.waitingTimeRecorder.hashCode();
            result2 = result2 * 31 + this.executionTimeRecorder.hashCode();
            result2 = result2 * 31 + (this.markOfAcquisitionIntent == null ? 0 : TimeSource.Monotonic.ValueTimeMark.hashCode-impl((long)this.markOfAcquisitionIntent.unbox-impl()));
            result2 = result2 * 31 + (this.markOfExecutionIntent == null ? 0 : TimeSource.Monotonic.ValueTimeMark.hashCode-impl((long)this.markOfExecutionIntent.unbox-impl()));
            result2 = result2 * 31 + Integer.hashCode(this.acquiredCounter);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Recorder)) {
                return false;
            }
            Recorder recorder = (Recorder)other;
            if (!Intrinsics.areEqual((Object)this.waitingTimeRecorder, (Object)recorder.waitingTimeRecorder)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.executionTimeRecorder, (Object)recorder.executionTimeRecorder)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.markOfAcquisitionIntent, (Object)recorder.markOfAcquisitionIntent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.markOfExecutionIntent, (Object)recorder.markOfExecutionIntent)) {
                return false;
            }
            return this.acquiredCounter == recorder.acquiredCounter;
        }

        public /* synthetic */ Recorder(SingleWriterRecorder waitingTimeRecorder, SingleWriterRecorder executionTimeRecorder, TimeSource.Monotonic.ValueTimeMark markOfAcquisitionIntent, TimeSource.Monotonic.ValueTimeMark markOfExecutionIntent, int acquiredCounter, DefaultConstructorMarker $constructor_marker) {
            this(waitingTimeRecorder, executionTimeRecorder, markOfAcquisitionIntent, markOfExecutionIntent, acquiredCounter);
        }
    }
}

