/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.util;

import java.nio.ByteBuffer;
import java.security.InvalidParameterException;
import kotlin.Metadata;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&J\b\u0010\u0010\u001a\u00020\u0011H&J\b\u0010\f\u001a\u00020\u000fH&J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006H&J\b\u0010\u0012\u001a\u00020\u0018H&J\b\u0010\u0019\u001a\u00020\u001aH&J\b\u0010\u001b\u001a\u00020\u0006H&J\b\u0010\u001c\u001a\u00020\u000fH&J\b\u0010\u001d\u001a\u00020\u000fH\u0016J\u0006\u0010\u001e\u001a\u00020\u000fJ\u0006\u0010\u001f\u001a\u00020\u0006J\u0006\u0010 \u001a\u00020\u0006J\u0006\u0010!\u001a\u00020\u000fJ\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u0006R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006&"}, d2={"Lcom/intellij/diagnostic/hprof/util/HProfReadBuffer;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "value", "", "idSize", "getIdSize", "()I", "setIdSize", "(I)V", "position", "", "newPosition", "", "isEof", "", "get", "bytes", "", "getByteBuffer", "Ljava/nio/ByteBuffer;", "size", "", "getShort", "", "getInt", "getLong", "getId", "getRawId", "getUnsignedByte", "getUnsignedShort", "getUnsignedInt", "getUTF8String", "", "skip", "n", "intellij.platform.ide.impl"})
public abstract class HProfReadBuffer
implements AutoCloseable {
    private int idSize;

    public final int getIdSize() {
        return this.idSize;
    }

    public final void setIdSize(int value) {
        if (this.idSize != 0) {
            throw new IllegalStateException("ID size cannot be reassigned.");
        }
        if (value != 1 && value != 2 && value != 4 && value != 8) {
            throw new InvalidParameterException("ID size can only be 1, 2, 4 or 8.");
        }
        this.idSize = value;
    }

    public abstract void position(long var1);

    public abstract boolean isEof();

    public abstract long position();

    public abstract void get(@NotNull byte[] var1);

    @NotNull
    public abstract ByteBuffer getByteBuffer(int var1);

    public abstract byte get();

    public abstract short getShort();

    public abstract int getInt();

    public abstract long getLong();

    public long getId() {
        return this.getRawId();
    }

    public final long getRawId() {
        return switch (this.idSize) {
            case 1 -> this.getUnsignedByte();
            case 2 -> this.getUnsignedShort();
            case 4 -> this.getUnsignedInt();
            case 8 -> this.getLong();
            default -> throw new IllegalArgumentException("ID size not assigned yet.");
        };
    }

    public final int getUnsignedByte() {
        return Byte.toUnsignedInt(this.get());
    }

    public final int getUnsignedShort() {
        return Short.toUnsignedInt(this.getShort());
    }

    public final long getUnsignedInt() {
        return Integer.toUnsignedLong(this.getInt());
    }

    @NotNull
    public final String getUTF8String() {
        int length = this.getUnsignedShort();
        byte[] bytes = new byte[length];
        this.get(bytes);
        return new String(bytes, Charsets.UTF_8);
    }

    public final void skip(int n) {
        this.position(this.position() + (long)n);
    }
}

