/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.visitors;

import com.intellij.diagnostic.hprof.classstore.ThreadInfo;
import com.intellij.diagnostic.hprof.parser.HProfVisitor;
import com.intellij.diagnostic.hprof.parser.RecordType;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0016\n\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J8\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J(\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/diagnostic/hprof/visitors/CollectThreadInfoVisitor;", "Lcom/intellij/diagnostic/hprof/parser/HProfVisitor;", "threadsMap", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "Lcom/intellij/diagnostic/hprof/classstore/ThreadInfo;", "stringIdMap", "", "<init>", "(Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;)V", "stackFrameIdToStringMap", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "classSerialNumberToNameMap", "preVisit", "", "visitLoadClass", "classSerialNumber", "", "classObjectId", "stackSerialNumber", "classNameStringId", "visitStackFrame", "stackFrameId", "methodNameStringId", "methodSignatureStringId", "sourceFilenameStringId", "lineNumber", "", "getStackFrameString", "visitStackTrace", "stackTraceSerialNumber", "threadSerialNumber", "numberOfFrames", "stackFrameIds", "", "intellij.platform.ide.impl"})
public final class CollectThreadInfoVisitor
extends HProfVisitor {
    @NotNull
    private final Long2ObjectMap<ThreadInfo> threadsMap;
    @NotNull
    private final Long2ObjectMap<String> stringIdMap;
    @NotNull
    private final Long2ObjectOpenHashMap<String> stackFrameIdToStringMap;
    @NotNull
    private final Long2ObjectOpenHashMap<String> classSerialNumberToNameMap;

    public CollectThreadInfoVisitor(@NotNull Long2ObjectMap<ThreadInfo> threadsMap, @NotNull Long2ObjectMap<String> stringIdMap) {
        Intrinsics.checkNotNullParameter(threadsMap, (String)"threadsMap");
        Intrinsics.checkNotNullParameter(stringIdMap, (String)"stringIdMap");
        this.threadsMap = threadsMap;
        this.stringIdMap = stringIdMap;
        this.stackFrameIdToStringMap = new Long2ObjectOpenHashMap();
        this.classSerialNumberToNameMap = new Long2ObjectOpenHashMap();
    }

    @Override
    public void preVisit() {
        this.disableAll();
        this.enable(RecordType.StackFrame);
        this.enable(RecordType.StackTrace);
        this.enable(RecordType.LoadClass);
    }

    @Override
    public void visitLoadClass(long classSerialNumber, long classObjectId, long stackSerialNumber, long classNameStringId) {
        Object object = this.stringIdMap.get(classNameStringId);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this.classSerialNumberToNameMap.put(classSerialNumber, (Object)StringsKt.replace$default((String)((String)object), (String)"/", (String)".", (boolean)false, (int)4, null));
    }

    @Override
    public void visitStackFrame(long stackFrameId, long methodNameStringId, long methodSignatureStringId, long sourceFilenameStringId, long classSerialNumber, int lineNumber) {
        this.stackFrameIdToStringMap.put(stackFrameId, (Object)this.getStackFrameString(methodNameStringId, sourceFilenameStringId, classSerialNumber, lineNumber));
    }

    private final String getStackFrameString(long methodNameStringId, long sourceFilenameStringId, long classSerialNumber, int lineNumber) {
        StringBuilder sb = new StringBuilder();
        if (classSerialNumber != 0L) {
            sb.append((String)this.classSerialNumberToNameMap.get(classSerialNumber));
            sb.append(".");
            v0 = methodNameStringId != 0L ? sb.append((String)this.stringIdMap.get(methodNameStringId)) : sb.append("<unknown method>");
        } else {
            v0 = sb.append("<unknown location>");
        }
        if (lineNumber == -1) {
            sb.append("(Native method)");
        } else if (sourceFilenameStringId != 0L) {
            sb.append("(" + this.stringIdMap.get(sourceFilenameStringId));
            if (lineNumber > 0) {
                sb.append(":" + lineNumber);
            }
            sb.append(")");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public void visitStackTrace(long stackTraceSerialNumber, long threadSerialNumber, int numberOfFrames, @NotNull long[] stackFrameIds) {
        Intrinsics.checkNotNullParameter((Object)stackFrameIds, (String)"stackFrameIds");
        ArrayList<Object> frames = new ArrayList<Object>(stackFrameIds.length);
        for (long id2 : stackFrameIds) {
            frames.add(this.stackFrameIdToStringMap.get(id2));
        }
        this.threadsMap.put(threadSerialNumber, (Object)new ThreadInfo((List<String>)frames));
    }
}

