/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.fusCollectors;

import com.intellij.diagnostic.VMOptions;
import com.intellij.featureStatistics.fusCollectors.EventsIdentityThrottle;
import com.intellij.featureStatistics.fusCollectors.EventsRateThrottle;
import com.intellij.featureStatistics.fusCollectors.ThrowableDescription;
import com.intellij.internal.DebugAttachDetector;
import com.intellij.internal.statistic.collectors.fus.MethodNameRuleValidator;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringListEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.Strings;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class LifecycleUsageTriggerCollector
extends CounterUsagesCollector {
    private static final Logger LOG = Logger.getInstance(LifecycleUsageTriggerCollector.class);
    private static final EventLogGroup LIFECYCLE = new EventLogGroup("lifecycle", 75);
    private static final EventField<Boolean> eapField = EventFields.Boolean((String)"eap");
    private static final EventField<Boolean> testField = EventFields.Boolean((String)"test");
    private static final EventField<Boolean> commandLineField = EventFields.Boolean((String)"command_line");
    private static final EventField<Boolean> internalField = EventFields.Boolean((String)"internal");
    private static final EventField<Boolean> headlessField = EventFields.Boolean((String)"headless");
    private static final EventField<Boolean> debugAgentField = EventFields.Boolean((String)"debug_agent");
    private static final VarargEventId IDE_EVENT_START = LIFECYCLE.registerVarargEvent("ide.start", new EventField[]{eapField, testField, commandLineField, internalField, headlessField, debugAgentField});
    private static final EventId1<Boolean> IDE_CLOSE = LIFECYCLE.registerEvent("ide.close", (EventField)EventFields.Boolean((String)"restart"));
    private static final EventId2<Long, Boolean> PROJECT_OPENING_FINISHED = LIFECYCLE.registerEvent("project.opening.finished", (EventField)EventFields.Long((String)"duration_ms"), (EventField)EventFields.Boolean((String)"project_tab"));
    private static final EventId PROJECT_OPENED = LIFECYCLE.registerEvent("project.opened");
    private static final EventId PROJECT_CLOSED = LIFECYCLE.registerEvent("project.closed");
    private static final EventField<Long> projectTotalCloseDurationField = EventFields.Long((String)"total_duration_ms");
    private static final EventField<Long> projectSaveDurationField = EventFields.Long((String)"save_duration_ms");
    private static final EventField<Long> projectClosingDurationField = EventFields.Long((String)"closing_duration_ms");
    private static final EventField<Long> projectDisposeDurationField = EventFields.Long((String)"dispose_duration_ms");
    private static final VarargEventId PROJECT_CLOSED_AND_DISPOSED = LIFECYCLE.registerVarargEvent("project.closed.and.disposed", new EventField[]{projectTotalCloseDurationField, projectSaveDurationField, projectClosingDurationField, projectDisposeDurationField});
    private static final EventId PROJECT_MODULE_ATTACHED = LIFECYCLE.registerEvent("project.module.attached");
    private static final EventId PROTOCOL_OPEN_COMMAND_HANDLED = LIFECYCLE.registerEvent("protocol.open.command.handled");
    private static final EventId FRAME_ACTIVATED = LIFECYCLE.registerEvent("frame.activated");
    private static final EventId FRAME_DEACTIVATED = LIFECYCLE.registerEvent("frame.deactivated");
    private static final EventId1<Long> IDE_FREEZE = LIFECYCLE.registerEvent("ide.freeze", (EventField)EventFields.DurationMs);
    private static final EventId FREEZE_POPUP_SHOWN = LIFECYCLE.registerEvent("freeze.popup.shown", "Happens when the IDE shows a popup that indicates UI freeze");
    private static final EventId3<PluginInfo, Long, Boolean> IDE_FREEZE_DETECTED_PLUGIN = LIFECYCLE.registerEvent("ide.freeze.detected.plugin", (EventField)EventFields.PluginInfo, (EventField)EventFields.DurationMs, (EventField)EventFields.Boolean((String)"reported_to_user"));
    private static final EventId1<PluginInfo> IDE_FREEZE_PLUGIN_ISSUE_REPORTED = LIFECYCLE.registerEvent("ide.freeze.reported.plugin", (EventField)EventFields.PluginInfo);
    private static final EventId1<PluginInfo> IDE_FREEZE_PLUGIN_IGNORED = LIFECYCLE.registerEvent("ide.freeze.ignored.plugin", (EventField)EventFields.PluginInfo);
    private static final ClassEventField errorField = EventFields.Class((String)"error");
    private static final EventField<VMOptions.MemoryKind> memoryErrorKindField = EventFields.Enum((String)"memory_error_kind", VMOptions.MemoryKind.class, kind -> Strings.toLowerCase((String)kind.name()));
    private static final EventField<Integer> errorHashField = EventFields.Int((String)"error_hash");
    private static final StringListEventField errorFramesField = EventFields.StringListValidatedByCustomRule((String)"error_frames", MethodNameRuleValidator.class);
    private static final EventField<Integer> errorSizeField = EventFields.Int((String)"error_size");
    private static final EventField<Boolean> tooManyErrorsField = EventFields.Boolean((String)"too_many_errors");
    private static final VarargEventId IDE_ERROR = LIFECYCLE.registerVarargEvent("ide.error", new EventField[]{EventFields.PluginInfo, errorField, memoryErrorKindField, errorHashField, errorFramesField, errorSizeField, tooManyErrorsField});
    private static final EventId IDE_CRASH_DETECTED = LIFECYCLE.registerEvent("ide.crash.detected");
    private static final EventId IDE_DEADLOCK_DETECTED = LIFECYCLE.registerEvent("ide.deadlock.detected");
    private static final EventField<ProjectOpenMode> projectOpenModeField = EventFields.Enum((String)"mode", ProjectOpenMode.class, mode -> Strings.toLowerCase((String)mode.name()));
    private static final EventId1<ProjectOpenMode> PROJECT_FRAME_SELECTED = LIFECYCLE.registerEvent("project.frame.selected", projectOpenModeField);
    private static final EventId1<Integer> EARLY_ERRORS = LIFECYCLE.registerEvent("early.errors", (EventField)EventFields.Int((String)"errors_ignored"));
    private static final EventsRateThrottle ourErrorRateThrottle = new EventsRateThrottle(100, 300000L);
    private static final EventsIdentityThrottle ourErrorIdentityThrottle = new EventsIdentityThrottle(50, 3600000L);

    public EventLogGroup getGroup() {
        return LIFECYCLE;
    }

    public static void onIdeStart() {
        Application app = ApplicationManager.getApplication();
        IDE_EVENT_START.log(new EventPair[]{eapField.with((Object)app.isEAP()), testField.with((Object)StatisticsUploadAssistant.isTestStatisticsEnabled()), commandLineField.with((Object)app.isCommandLine()), internalField.with((Object)app.isInternal()), headlessField.with((Object)app.isHeadlessEnvironment()), debugAgentField.with((Object)DebugAttachDetector.isDebugEnabled())});
    }

    public static void onIdeClose(boolean restart) {
        IDE_CLOSE.log((Object)restart);
    }

    /*
     * WARNING - void declaration
     */
    public static void onProjectOpenFinished(@NotNull Project project2, long time, boolean bl) {
        void isTab;
        if (project2 == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(0);
        }
        PROJECT_OPENING_FINISHED.log(project2, (Object)time, (Object)((boolean)isTab));
    }

    public static void onProjectOpened(@NotNull Project project2) {
        if (project2 == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(1);
        }
        PROJECT_OPENED.log(project2);
    }

    public static void onBeforeProjectClosed(@NotNull Project project2) {
        if (project2 == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(2);
        }
        PROJECT_CLOSED.log(project2);
    }

    /*
     * WARNING - void declaration
     */
    public static void onProjectClosedAndDisposed(@NotNull Project project2, long closeStartedMs, long saveSettingsDurationMs, long l, long l2) {
        void disposeDurationMs;
        void closingDurationMs;
        if (project2 == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(3);
        }
        long totalCloseDurationMs = System.currentTimeMillis() - closeStartedMs;
        PROJECT_CLOSED_AND_DISPOSED.log(project2, new EventPair[]{projectTotalCloseDurationField.with((Object)totalCloseDurationMs), projectSaveDurationField.with((Object)saveSettingsDurationMs), projectClosingDurationField.with((Object)((long)closingDurationMs)), projectDisposeDurationField.with((Object)((long)disposeDurationMs))});
    }

    public static void onProjectModuleAttached(@NotNull Project project2) {
        if (project2 == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(4);
        }
        PROJECT_MODULE_ATTACHED.log(project2);
    }

    public static void onProtocolOpenCommandHandled(@Nullable Project project2) {
        PROTOCOL_OPEN_COMMAND_HANDLED.log(project2);
    }

    public static void onFrameActivated(@Nullable Project project2) {
        FRAME_ACTIVATED.log(project2);
    }

    public static void onFrameDeactivated(@Nullable Project project2) {
        FRAME_DEACTIVATED.log(project2);
    }

    public static void onFreeze(long durationMs) {
        IDE_FREEZE.log((Object)durationMs);
    }

    public static void onFreezePopupShown() {
        FREEZE_POPUP_SHOWN.log(null);
    }

    public static void onError(@Nullable PluginId pluginId, @NotNull Throwable throwable, @Nullable VMOptions.MemoryKind memoryErrorKind) {
        if (throwable == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(5);
        }
        try {
            ThrowableDescription description = new ThrowableDescription(throwable);
            ArrayList<EventPair> data2 = new ArrayList<EventPair>();
            data2.add(EventFields.PluginInfo.with((Object)(pluginId == null ? PluginInfoDetectorKt.getPlatformPlugin() : PluginInfoDetectorKt.getPluginInfoById((PluginId)pluginId))));
            data2.add(errorField.with(description.getThrowableClass()));
            if (memoryErrorKind != null) {
                data2.add(memoryErrorKindField.with((Object)memoryErrorKind));
            }
            if (ourErrorRateThrottle.tryPass(System.currentTimeMillis())) {
                List<String> frames = description.getLastFrames(50);
                int frameHash = frames.hashCode();
                data2.add(errorHashField.with((Object)frameHash));
                if (ourErrorIdentityThrottle.tryPass(frameHash, System.currentTimeMillis())) {
                    data2.add(errorFramesField.with(frames));
                    data2.add(errorSizeField.with((Object)description.getSize()));
                }
            } else {
                data2.add(tooManyErrorsField.with((Object)true));
            }
            IDE_ERROR.log(data2);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    public static void onCrashDetected() {
        IDE_CRASH_DETECTED.log();
    }

    public static void onDeadlockDetected() {
        IDE_DEADLOCK_DETECTED.log();
    }

    public static void onProjectFrameSelected(int option2) {
        ProjectOpenMode optionValue;
        switch (option2) {
            case 0: {
                optionValue = ProjectOpenMode.New;
                break;
            }
            case 1: {
                optionValue = ProjectOpenMode.Same;
                break;
            }
            case 2: {
                optionValue = ProjectOpenMode.Attach;
                break;
            }
            default: {
                return;
            }
        }
        PROJECT_FRAME_SELECTED.log((Object)optionValue);
    }

    public static void onEarlyErrorsIgnored(int numErrors) {
        EARLY_ERRORS.log((Object)numErrors);
    }

    /*
     * WARNING - void declaration
     */
    public static void pluginFreezeDetected(@NotNull PluginId pluginId, long durationMs, boolean bl) {
        void reportedToUser;
        if (pluginId == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(6);
        }
        IDE_FREEZE_DETECTED_PLUGIN.log((Object)PluginInfoDetectorKt.getPluginInfoById((PluginId)pluginId), (Object)durationMs, (Object)((boolean)reportedToUser));
    }

    public static void pluginFreezeReported(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(7);
        }
        IDE_FREEZE_PLUGIN_ISSUE_REPORTED.log((Object)PluginInfoDetectorKt.getPluginInfoById((PluginId)pluginId));
    }

    public static void pluginFreezeIgnored(@NotNull PluginId id2) {
        if (id2 == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(8);
        }
        IDE_FREEZE_PLUGIN_IGNORED.log((Object)PluginInfoDetectorKt.getPluginInfoById((PluginId)id2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        objectArray2[1] = "com/intellij/featureStatistics/fusCollectors/LifecycleUsageTriggerCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onProjectOpenFinished";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onProjectOpened";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onBeforeProjectClosed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "onProjectClosedAndDisposed";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "onProjectModuleAttached";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "onError";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "pluginFreezeDetected";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "pluginFreezeReported";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "pluginFreezeIgnored";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum ProjectOpenMode {
        New,
        Same,
        Attach;

    }
}

