/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.CaretRestorationDecider;
import com.intellij.formatting.DefaultCaretRestorationDecider;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CaretPositionKeeper {
    Editor myEditor;
    Document myDocument;
    CaretModel myCaretModel;
    RangeMarker myBeforeCaretRangeMarker;
    String myCaretIndentToRestore;
    int myVisualColumnToRestore;
    boolean myBlankLineIndentPreserved;

    CaretPositionKeeper(@NotNull Editor editor2, @NotNull CodeStyleSettings settings, @NotNull Language language) {
        boolean shouldFixCaretPosition;
        if (editor2 == null) {
            CaretPositionKeeper.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            CaretPositionKeeper.$$$reportNull$$$0(1);
        }
        if (language == null) {
            CaretPositionKeeper.$$$reportNull$$$0(2);
        }
        this.myVisualColumnToRestore = -1;
        this.myEditor = editor2;
        this.myCaretModel = editor2.getCaretModel();
        this.myDocument = editor2.getDocument();
        this.myBlankLineIndentPreserved = CaretPositionKeeper.isBlankLineIndentPreserved(settings, language);
        Project project2 = this.myEditor.getProject();
        if (project2 != null) {
            PsiDocumentManager.getInstance((Project)project2).commitDocument(this.myDocument);
        }
        int caretOffset = this.getCaretOffset();
        CaretRestorationDecider decider = CaretRestorationDecider.forLanguage((Language)language);
        if (decider == null) {
            decider = DefaultCaretRestorationDecider.INSTANCE;
        }
        if (shouldFixCaretPosition = decider.shouldRestoreCaret(this.myDocument, this.myEditor, caretOffset)) {
            this.initRestoreInfo(caretOffset);
        }
    }

    private static boolean isBlankLineIndentPreserved(@NotNull CodeStyleSettings settings, @NotNull Language language) {
        CommonCodeStyleSettings langSettings;
        CommonCodeStyleSettings.IndentOptions indentOptions;
        if (settings == null) {
            CaretPositionKeeper.$$$reportNull$$$0(3);
        }
        if (language == null) {
            CaretPositionKeeper.$$$reportNull$$$0(4);
        }
        return (indentOptions = (langSettings = settings.getCommonSettings(language)).getIndentOptions()) != null && indentOptions.KEEP_INDENTS_ON_EMPTY_LINES;
    }

    private void initRestoreInfo(int caretOffset) {
        int lineStartOffset = CaretPositionKeeper.getLineStartOffsetByTotalOffset(this.myDocument, caretOffset);
        this.myVisualColumnToRestore = this.myCaretModel.getVisualPosition().column;
        this.myCaretIndentToRestore = this.myDocument.getText(TextRange.create((int)lineStartOffset, (int)caretOffset));
        this.myBeforeCaretRangeMarker = this.myDocument.createRangeMarker(0, lineStartOffset);
    }

    public void restoreCaretPosition() {
        if (this.isVirtualSpaceEnabled()) {
            this.restoreVisualPosition();
        } else {
            this.restorePositionByIndentInsertion();
        }
    }

    private void restorePositionByIndentInsertion() {
        if (this.myBeforeCaretRangeMarker == null || !this.myBeforeCaretRangeMarker.isValid() || this.myCaretIndentToRestore == null || this.myBlankLineIndentPreserved) {
            return;
        }
        int newCaretLineStartOffset = this.myBeforeCaretRangeMarker.getEndOffset();
        this.myBeforeCaretRangeMarker.dispose();
        if (this.myCaretModel.getVisualPosition().column == this.myVisualColumnToRestore) {
            return;
        }
        Project project2 = this.myEditor.getProject();
        if (project2 == null || PsiDocumentManager.getInstance((Project)project2).isDocumentBlockedByPsi(this.myDocument)) {
            return;
        }
        this.insertWhiteSpaceIndentIfNeeded(newCaretLineStartOffset);
    }

    private void restoreVisualPosition() {
        if (this.myVisualColumnToRestore < 0) {
            EditorUtil.runWithAnimationDisabled(this.myEditor, () -> this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE));
            return;
        }
        VisualPosition position = this.myCaretModel.getVisualPosition();
        if (this.myVisualColumnToRestore != position.column) {
            this.myCaretModel.moveToVisualPosition(new VisualPosition(position.line, this.myVisualColumnToRestore));
        }
    }

    private void insertWhiteSpaceIndentIfNeeded(int caretLineOffset) {
        int lineToInsertIndent = this.myDocument.getLineNumber(caretLineOffset);
        if (!this.lineContainsWhiteSpaceSymbolsOnly(lineToInsertIndent)) {
            return;
        }
        int lineToInsertStartOffset = this.myDocument.getLineStartOffset(lineToInsertIndent);
        if (lineToInsertIndent != this.getCurrentCaretLine()) {
            this.myCaretModel.moveToOffset(lineToInsertStartOffset);
        }
        this.myDocument.replaceString(lineToInsertStartOffset, caretLineOffset, (CharSequence)this.myCaretIndentToRestore);
    }

    private boolean isVirtualSpaceEnabled() {
        return this.myEditor.getSettings().isVirtualSpace();
    }

    private int getCaretOffset() {
        int caretOffset = this.myCaretModel.getOffset();
        int upperBound = Math.max(this.myDocument.getTextLength() - 1, 0);
        caretOffset = Math.clamp((long)caretOffset, 0, upperBound);
        return caretOffset;
    }

    private boolean lineContainsWhiteSpaceSymbolsOnly(int lineNumber) {
        int startOffset = this.myDocument.getLineStartOffset(lineNumber);
        int endOffset = this.myDocument.getLineEndOffset(lineNumber);
        return CharArrayUtil.isEmptyOrSpaces((CharSequence)this.myDocument.getCharsSequence(), (int)startOffset, (int)endOffset);
    }

    private int getCurrentCaretLine() {
        return this.myDocument.getLineNumber(this.myCaretModel.getOffset());
    }

    static int getLineStartOffsetByTotalOffset(Document document2, int offset) {
        int line = document2.getLineNumber(offset);
        return document2.getLineStartOffset(line);
    }

    static int getLineEndOffsetByTotalOffset(Document document2, int offset) {
        int line = document2.getLineNumber(offset);
        return document2.getLineEndOffset(line);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/CaretPositionKeeper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isBlankLineIndentPreserved";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

