/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.help.impl;

import com.intellij.help.impl.MacHelpUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.help.KeymapHelpIdPresenter;
import com.intellij.openapi.help.WebHelpProvider;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.platform.ide.customization.ExternalProductResourceUrls;
import com.intellij.util.Url;
import java.util.Map;
import java.util.Objects;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Nullable;

public class HelpManagerImpl
extends HelpManager {
    private static final ExtensionPointName<WebHelpProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.webHelpProvider");

    public void invokeHelp(@Nullable String id2) {
        HelpManagerImpl.logWillOpenHelpId((String)id2);
        String helpUrl = HelpManagerImpl.getHelpUrl(id2);
        if (helpUrl != null) {
            BrowserUtil.browse((String)helpUrl);
        }
    }

    @Nullable
    public static String getHelpUrl(@Nullable String id2) {
        id2 = Objects.requireNonNullElse(id2, "top");
        for (WebHelpProvider provider : EP_NAME.getExtensionList()) {
            String url;
            String prefix = provider.getHelpTopicPrefix();
            if (prefix.isEmpty() || !id2.startsWith(prefix) || (url = provider.getHelpPageUrl(id2)) == null) continue;
            return url;
        }
        if (MacHelpUtil.isApplicable() && MacHelpUtil.invokeHelp(id2)) {
            return null;
        }
        Function1 urlSupplier = ExternalProductResourceUrls.getInstance().getHelpPageUrl();
        if (urlSupplier == null) {
            return null;
        }
        Url url = (Url)urlSupplier.invoke((Object)id2);
        Keymap activeKeymap = KeymapManagerEx.getInstanceEx().getActiveKeymap();
        if (activeKeymap.canModify()) {
            activeKeymap = activeKeymap.getParent();
        }
        if (activeKeymap != null) {
            String keymapID = ((KeymapHelpIdPresenter)ApplicationManager.getApplication().getService(KeymapHelpIdPresenter.class)).getKeymapIdForHelp(activeKeymap);
            url = url.addParameters(Map.of("keymap", keymapID));
        }
        return IdeUrlTrackingParametersProvider.getInstance().augmentUrl(url.toExternalForm());
    }
}

