/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.ApplicationActivationStateManagerState;
import com.intellij.ide.IdeEventQueueKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutineSupport;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowEvent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0016\u0010\r\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ide/ApplicationActivationStateManager;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "state", "Lcom/intellij/ide/ApplicationActivationStateManagerState;", "delayedDeactivatedJob", "Lkotlinx/coroutines/Job;", "isActive", "", "()Z", "updateState", "windowEvent", "Ljava/awt/event/WindowEvent;", "setActive", "app", "Lcom/intellij/openapi/application/Application;", "window", "Ljava/awt/Window;", "", "Lcom/intellij/openapi/application/impl/ApplicationImpl;", "getIdeFrameFromWindow", "Lcom/intellij/openapi/wm/IdeFrame;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nApplicationActivationStateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationActivationStateManager.kt\ncom/intellij/ide/ApplicationActivationStateManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,118:1\n13#2:119\n*S KotlinDebug\n*F\n+ 1 ApplicationActivationStateManager.kt\ncom/intellij/ide/ApplicationActivationStateManager\n*L\n18#1:119\n*E\n"})
public final class ApplicationActivationStateManager {
    @NotNull
    public static final ApplicationActivationStateManager INSTANCE = new ApplicationActivationStateManager();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static ApplicationActivationStateManagerState state;
    @Nullable
    private static Job delayedDeactivatedJob;

    private ApplicationActivationStateManager() {
    }

    public final boolean isActive() {
        return state.isActive();
    }

    public final boolean updateState(@NotNull WindowEvent windowEvent) {
        Intrinsics.checkNotNullParameter((Object)windowEvent, (String)"windowEvent");
        Application app = ApplicationManager.getApplication();
        if (!(app instanceof ApplicationImpl) || ((ApplicationImpl)app).isExitInProgress() || ((ApplicationImpl)app).isDisposed()) {
            return false;
        }
        Window window = windowEvent.getWindow();
        if (windowEvent.getID() == 205 || windowEvent.getID() == 207) {
            if (state.isInactive()) {
                return this.setActive(app, window);
            }
        } else if (windowEvent.getID() == 206 && windowEvent.getOppositeWindow() == null) {
            IdeFrame ideFrame;
            if (IdeEventQueueKt.getSkipWindowDeactivationEvents()) {
                LOG.warn("Skipped " + windowEvent);
                return false;
            }
            if (state.isActive() && (ideFrame = this.getIdeFrameFromWindow(window)) != null) {
                MessageBus messageBus = ((ApplicationImpl)app).getMessageBus();
                Topic topic = ApplicationActivationListener.TOPIC;
                Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                ((ApplicationActivationListener)messageBus.syncPublisher(topic)).applicationDeactivated(ideFrame);
            }
            state = ApplicationActivationStateManagerState.DEACTIVATING;
            LOG.debug("The app is in the deactivating state");
            Job job2 = delayedDeactivatedJob;
            if (job2 != null) {
                Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
            }
            delayedDeactivatedJob = BuildersKt.launch$default((CoroutineScope)((ApplicationImpl)app).getCoroutineScope(), (CoroutineContext)((CoroutineContext)new CoroutineName("ApplicationDeactivation")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(window, app, null){
                int label;
                final /* synthetic */ Window $window;
                final /* synthetic */ Application $app;
                {
                    this.$window = $window;
                    this.$app = $app;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)Registry.Companion.intValue("application.deactivation.timeout", 1500), (DurationUnit)DurationUnit.MILLISECONDS), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl14
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl14:
                            // 2 sources

                            v1 = CoroutinesKt.ui$default((Dispatchers)Dispatchers.INSTANCE, (CoroutineSupport.UiDispatcherKind)CoroutineSupport.UiDispatcherKind.STRICT, (boolean)false, (int)2, null);
                            v2 = ModalityState.any();
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"any(...)");
                            this.label = 2;
                            v3 = BuildersKt.withContext((CoroutineContext)v1.plus(ModalityKt.asContextElement((ModalityState)v2)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$window, this.$app, null){
                                Object L$0;
                                Object L$1;
                                int label;
                                final /* synthetic */ Window $window;
                                final /* synthetic */ Application $app;
                                {
                                    this.$window = $window;
                                    this.$app = $app;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            if (ApplicationActivationStateManager.access$getState$p() != ApplicationActivationStateManagerState.DEACTIVATING) {
                                                return Unit.INSTANCE;
                                            }
                                            ApplicationActivationStateManager.access$setState$p(ApplicationActivationStateManagerState.DEACTIVATED);
                                            ApplicationActivationStateManager.access$getLOG$p().debug("The app is in the deactivated state");
                                            IdeFrame ideFrame = ApplicationActivationStateManager.access$getIdeFrameFromWindow(ApplicationActivationStateManager.INSTANCE, this.$window);
                                            if (ideFrame == null) return Unit.INSTANCE;
                                            MessageBus messageBus = ((ApplicationImpl)this.$app).getMessageBus();
                                            Topic topic = ApplicationActivationListener.TOPIC;
                                            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                                            ApplicationActivationListener publisher = (ApplicationActivationListener)messageBus.syncPublisher(topic);
                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)ideFrame);
                                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)publisher);
                                            this.label = 1;
                                            Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getUiWithModelAccess((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(publisher, ideFrame, null){
                                                int label;
                                                final /* synthetic */ ApplicationActivationListener $publisher;
                                                final /* synthetic */ IdeFrame $ideFrame;
                                                {
                                                    this.$publisher = $publisher;
                                                    this.$ideFrame = $ideFrame;
                                                    super(2, $completion);
                                                }

                                                public final Object invokeSuspend(Object $result) {
                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            IdeFrame ideFrame = this.$ideFrame;
                                                            Intrinsics.checkNotNull((Object)ideFrame, (String)"null cannot be cast to non-null type java.awt.Window");
                                                            this.$publisher.delayedApplicationDeactivated((Window)ideFrame);
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (Continuation)((Continuation)this));
                                            if (object2 != object) return Unit.INSTANCE;
                                            return object;
                                        }
                                        case 1: {
                                            ApplicationActivationListener publisher = (ApplicationActivationListener)this.L$1;
                                            IdeFrame ideFrame = (IdeFrame)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v3 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl25
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl25:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return true;
        }
        return false;
    }

    private final boolean setActive(Application app, Window window) {
        IdeFrame ideFrame;
        state = ApplicationActivationStateManagerState.ACTIVE;
        LOG.debug("The app is in the active state");
        Job job2 = delayedDeactivatedJob;
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        delayedDeactivatedJob = null;
        if (!app.isDisposed() && (ideFrame = this.getIdeFrameFromWindow(window)) != null) {
            MessageBus messageBus = app.getMessageBus();
            Topic topic = ApplicationActivationListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            ((ApplicationActivationListener)messageBus.syncPublisher(topic)).applicationActivated(ideFrame);
            return true;
        }
        return false;
    }

    public final void updateState(@NotNull ApplicationImpl app, @NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)((Object)app), (String)"app");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        if (state.isInactive()) {
            this.setActive((Application)app, window);
        }
    }

    private final IdeFrame getIdeFrameFromWindow(Window window) {
        Component component2;
        Window window2 = window;
        return window2 == null ? null : ((component2 = ComponentUtil.findUltimateParent((Component)window2)) instanceof IdeFrame ? (IdeFrame)component2 : null);
    }

    public static final /* synthetic */ ApplicationActivationStateManagerState access$getState$p() {
        return state;
    }

    public static final /* synthetic */ void access$setState$p(ApplicationActivationStateManagerState applicationActivationStateManagerState) {
        state = applicationActivationStateManagerState;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ IdeFrame access$getIdeFrameFromWindow(ApplicationActivationStateManager $this, Window window) {
        return $this.getIdeFrameFromWindow(window);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ApplicationActivationStateManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        state = ApplicationActivationStateManagerState.DEACTIVATED;
    }
}

