/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.diagnostic.logs.DebugLogLevel;
import com.intellij.diagnostic.logs.LogCategory;
import com.intellij.diagnostic.logs.LogLevelConfigurationManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.DebugLogConfigureActionKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0014J\r\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0014J\b\u0010\u0011\u001a\u00020\tH\u0016J\u0006\u0010\u0012\u001a\u00020\u0005R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/actions/DebugLogConfigureDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lcom/intellij/diagnostic/logs/LogLevelConfigurationManager$State;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/diagnostic/logs/LogLevelConfigurationManager$State;)V", "myTextArea", "Ljavax/swing/JTextArea;", "getDimensionServiceKey", "", "createNorthPanel", "Lcom/intellij/ui/components/JBLabel;", "createCenterPanel", "Ljavax/swing/JScrollPane;", "Lorg/jetbrains/annotations/NotNull;", "getPreferredFocusedComponent", "getLogCategories", "intellij.platform.ide.impl"})
final class DebugLogConfigureDialog
extends DialogWrapper {
    @NotNull
    private final JTextArea myTextArea;

    public DebugLogConfigureDialog(@NotNull Project project2, @NotNull LogLevelConfigurationManager.State state2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        super(project2, false);
        this.myTextArea = new JTextArea(10, 30);
        this.myTextArea.setMargin((Insets)JBUI.insets((int)2));
        this.myTextArea.setText(CollectionsKt.joinToString$default((Iterable)state2.categories, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> DebugLogConfigureDialog._init_$lambda$0(state2, arg_0), (int)30, null));
        this.setTitle(IdeBundle.message((String)"dialog.title.custom.debug.log.configuration", (Object[])new Object[0]));
        this.init();
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.actions.DebugLogConfigureAction";
    }

    @NotNull
    protected JBLabel createNorthPanel() {
        Object[] objectArray = new Object[]{":trace", ":all", ":separate"};
        return new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)IdeBundle.message((String)"label.enable.debug.level", (Object[])objectArray)));
    }

    @NotNull
    protected JScrollPane createCenterPanel() {
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTextArea);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        return jScrollPane;
    }

    @NotNull
    public JTextArea getPreferredFocusedComponent() {
        return this.myTextArea;
    }

    @NotNull
    public final LogLevelConfigurationManager.State getLogCategories() {
        List logCategories = new ArrayList();
        HashSet<String> categoriesWithDedicatedFiles = new HashSet<String>();
        String string = this.myTextArea.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        CharSequence charSequence = string;
        Regex regex = DebugLogConfigureActionKt.access$getALL_POSSIBLE_SEPARATORS$p();
        int n = 0;
        for (String line : regex.split(charSequence, n)) {
            String line2 = ((Object)StringsKt.trim((CharSequence)line)).toString();
            if (!(((CharSequence)line2).length() > 0)) continue;
            char[] cArray = new char[]{':'};
            List split = StringsKt.split$default((CharSequence)line2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            DebugLogLevel level = DebugLogLevel.DEBUG;
            String category = ((Object)StringsKt.trim((CharSequence)((String)split.get(0)))).toString();
            for (String token : CollectionsKt.drop((Iterable)split, (int)1)) {
                String string2 = token.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                switch (((Object)StringsKt.trim((CharSequence)string2)).toString()) {
                    case "trace": {
                        level = DebugLogLevel.TRACE;
                        break;
                    }
                    case "all": {
                        level = DebugLogLevel.ALL;
                        break;
                    }
                    case "separate": {
                        categoriesWithDedicatedFiles.add(category);
                    }
                }
            }
            logCategories.add(new LogCategory(category, level));
        }
        return new LogLevelConfigurationManager.State(logCategories, (Set<String>)categoriesWithDedicatedFiles);
    }

    private static final CharSequence _init_$lambda$0(LogLevelConfigurationManager.State $state, LogCategory it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object line = switch (WhenMappings.$EnumSwitchMapping$0[it.getLevel().ordinal()]) {
            case 1 -> it.getCategory();
            case 2 -> it.getCategory() + ":trace";
            case 3 -> it.getCategory() + ":all";
            default -> throw new NoWhenBranchMatchedException();
        };
        if ($state.categoriesWithSeparateFiles.contains(it.getCategory())) {
            line = (String)line + ":separate";
        }
        return (CharSequence)line;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DebugLogLevel.values().length];
            try {
                nArray[DebugLogLevel.DEBUG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DebugLogLevel.TRACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DebugLogLevel.ALL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

