/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.fileEditor.FileEditorManagerKeys;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SplitAction
extends AnAction
implements DumbAware,
ActionRemoteBehaviorSpecification.Frontend {
    public static final Key<Boolean> FORBID_TAB_SPLIT = FileEditorManagerKeys.FORBID_TAB_SPLIT;
    private final int orientation;
    private final boolean closeSource;

    protected SplitAction(int orientation) {
        this(orientation, false);
    }

    protected SplitAction(int orientation, boolean closeSource) {
        this.orientation = orientation;
        this.closeSource = closeSource;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        EditorWindow window;
        if (event == null) {
            SplitAction.$$$reportNull$$$0(0);
        }
        if ((window = (EditorWindow)event.getData(EditorWindow.DATA_KEY)) == null) {
            return;
        }
        VirtualFile file2 = window.getContextFile();
        if (this.closeSource && file2 != null) {
            file2.putUserData(EditorWindow.DRAG_START_PINNED_KEY, (Object)window.isFilePinned(file2));
            window.closeFile(file2, false, false);
        }
        window.split(this.orientation, true, file2, true);
    }

    public void update(@NotNull AnActionEvent event) {
        EditorWindow window;
        if (event == null) {
            SplitAction.$$$reportNull$$$0(1);
        }
        VirtualFile selectedFile = (window = (EditorWindow)event.getData(EditorWindow.DATA_KEY)) == null ? null : window.getContextFile();
        boolean enabled2 = this.isEnabled(selectedFile, window);
        event.getPresentation().setEnabledAndVisible(enabled2);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            SplitAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private boolean isEnabled(@Nullable VirtualFile file2, @Nullable EditorWindow window) {
        if (file2 == null || window == null) {
            return false;
        }
        if (!this.closeSource && FileEditorManagerImpl.forbidSplitFor(file2)) {
            return false;
        }
        int minimum = this.closeSource ? 2 : 1;
        return window.getTabCount() >= minimum;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/SplitAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/SplitAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

