/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.ReloadMode;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.actions.WebPreviewFileEditorKt;
import com.intellij.ide.browsers.actions.WebPreviewVirtualFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.jcef.JCEFHtmlPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.beans.PropertyChangeListener;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.BuiltInServerBundle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\r\u0010\u0014\u001a\u00070\u0013\u00a2\u0006\u0002\b\rH\u0016J\u0019\u0010\u0015\u001a\u00130\f\u00a2\u0006\u000e\b\u0016\u0012\n\b\u0017\u0012\u0006\b\n0\u00188\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0007H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0016J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010%\u001a\u00020\u000fH\u0016R\u0016\u0010\u0003\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/ide/browsers/actions/WebPreviewFileEditor;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "file", "Lcom/intellij/ide/browsers/actions/WebPreviewVirtualFile;", "<init>", "(Lcom/intellij/ide/browsers/actions/WebPreviewVirtualFile;)V", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "panel", "Lcom/intellij/ui/jcef/JCEFHtmlPanel;", "url", "", "Lorg/jetbrains/annotations/NotNull;", "reloadPage", "", "reloadPage$intellij_platform_ide_impl", "showPreviewTooltip", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "getName", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "setState", "state", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "getFile", "isModified", "", "isValid", "addPropertyChangeListener", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "dispose", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nWebPreviewFileEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebPreviewFileEditor.kt\ncom/intellij/ide/browsers/actions/WebPreviewFileEditor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,119:1\n13#2:120\n*S KotlinDebug\n*F\n+ 1 WebPreviewFileEditor.kt\ncom/intellij/ide/browsers/actions/WebPreviewFileEditor\n*L\n69#1:120\n*E\n"})
public final class WebPreviewFileEditor
extends UserDataHolderBase
implements FileEditor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final VirtualFile file;
    @NotNull
    private final JCEFHtmlPanel panel;
    @NotNull
    private final String url;
    @NotNull
    private static final AtomicInteger previewsOpened = new AtomicInteger();

    public WebPreviewFileEditor(@NotNull WebPreviewVirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)((Object)file2), (String)"file");
        VirtualFile virtualFile = (VirtualFile)file2.getUserData(WebPreviewFileEditorKt.getCUSTOM_ORIGINAL_FILE());
        if (virtualFile == null) {
            virtualFile = file2.getOriginalFile();
        }
        this.file = virtualFile;
        String string = file2.getPreviewUrl().toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
        this.url = string;
        String string2 = this.url;
        this.panel = new JCEFHtmlPanel(string2){

            protected Color getBackgroundColor() {
                Color color = Color.WHITE;
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"WHITE");
                return color;
            }
        };
    }

    public final void reloadPage$intellij_platform_ide_impl() {
        this.panel.loadURL(this.url);
        previewsOpened.incrementAndGet();
        this.showPreviewTooltip();
    }

    private final void showPreviewTooltip() {
        ApplicationManager.getApplication().invokeLater(() -> WebPreviewFileEditor.showPreviewTooltip$lambda$0(this));
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.panel.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.panel.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @NotNull
    public String getName() {
        Object[] objectArray = new Object[]{this.file.getName()};
        String string = IdeBundle.message((String)"web.preview.file.editor.name", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void setState(@NotNull FileEditorState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.file;
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file");
        return virtualFile;
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    public void dispose() {
        previewsOpened.decrementAndGet();
        Disposer.dispose((Disposable)((Disposable)this.panel));
    }

    private static final void showPreviewTooltip$lambda$0(WebPreviewFileEditor this$0) {
        String string = BuiltInServerBundle.message((String)"reload.on.save.preview.got.it.content", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        GotItTooltip gotItTooltip = new GotItTooltip("web.preview.reload.on.save", string, (Disposable)this$0);
        if (!gotItTooltip.canShow()) {
            return;
        }
        if (WebBrowserManager.PREVIEW_RELOAD_MODE_DEFAULT != ReloadMode.RELOAD_ON_SAVE) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(WebPreviewFileEditor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Default value for " + BuiltInServerBundle.message((String)"reload.on.save.preview.got.it.title", (Object[])new Object[0]) + " has changed, tooltip is outdated.");
            return;
        }
        if (WebBrowserManager.getInstance().getWebPreviewReloadMode() != ReloadMode.RELOAD_ON_SAVE) {
            return;
        }
        String string2 = BuiltInServerBundle.message((String)"reload.on.save.preview.got.it.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        GotItTooltip gotItTooltip2 = gotItTooltip.withHeader(string2).withPosition(Balloon.Position.above);
        String string3 = CommonBundle.message((String)"action.text.configure.ellipsis", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        gotItTooltip2.withLink(string3, WebPreviewFileEditor::showPreviewTooltip$lambda$0$0);
        JComponent jComponent = this$0.panel.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        gotItTooltip.show(jComponent, (Function2<? super Component, ? super Balloon, ? extends Point>)((Function2)WebPreviewFileEditor::showPreviewTooltip$lambda$0$1));
    }

    private static final void showPreviewTooltip$lambda$0$0() {
        ShowSettingsUtil.getInstance().showSettingsDialog(null, arg_0 -> WebPreviewFileEditor.showPreviewTooltip$lambda$0$0$1(WebPreviewFileEditor::showPreviewTooltip$lambda$0$0$0, arg_0), null);
    }

    private static final boolean showPreviewTooltip$lambda$0$0$0(Configurable it) {
        return it instanceof SearchableConfigurable && Intrinsics.areEqual((Object)((SearchableConfigurable)it).getId(), (Object)"reference.settings.ide.settings.web.browsers");
    }

    private static final boolean showPreviewTooltip$lambda$0$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Point showPreviewTooltip$lambda$0$1(Component component2, Balloon balloon2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"<unused var>");
        return new Point(0, 0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/browsers/actions/WebPreviewFileEditor$Companion;", "", "<init>", "()V", "previewsOpened", "Ljava/util/concurrent/atomic/AtomicInteger;", "isPreviewOpened", "", "()Z", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isPreviewOpened() {
            return previewsOpened.get() > 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

