/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import com.intellij.ide.dnd.AdvancedDnDSource;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.Highlighters;
import com.intellij.ide.dnd.SmoothAutoScroller;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.reference.SoftReference;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.util.ui.GeometryUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.MultiResolutionImageProvider;
import com.intellij.util.ui.TimerUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.InputEvent;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DnDManagerImpl
extends DnDManager {
    private static final Logger LOG = Logger.getInstance(DnDManagerImpl.class);
    @NonNls
    private static final String SOURCE_KEY = "DnD Source";
    @NonNls
    private static final String TARGET_KEY = "DnD Target";
    private static final Key<Pair<Image, Point>> DRAGGED_IMAGE_KEY = new Key("draggedImage");
    private DnDEventImpl myCurrentEvent;
    private DnDEvent myLastHighlightedEvent;
    private static final DnDTarget NULL_TARGET = new NullTarget();
    private WeakReference<DnDTarget> myLastProcessedTarget = new WeakReference<DnDTarget>(NULL_TARGET);
    private DragSourceContext myCurrentDragContext;
    @Nullable
    private WeakReference<Component> myLastProcessedOverComponent;
    private Point myLastProcessedPoint;
    private String myLastMessage;
    private DnDEvent myLastProcessedEvent;
    private final DragGestureListener myDragGestureListener = new MyDragGestureListener();
    private final DropTargetListener myDropTargetListener = new MyDropTargetListener();
    private static final Image EMPTY_IMAGE = ImageUtil.createImage((int)1, (int)1, (int)3);
    private final Timer myTooltipTimer = TimerUtil.createNamedTimer((String)"DndManagerImpl tooltip timer", (int)ToolTipManager.sharedInstance().getInitialDelay(), e -> this.onTimer());
    private Runnable myHighlighterShowRequest;
    private Rectangle myLastHighlightedRec;
    private int myLastProcessedAction;
    private WeakReference<Component> myLastDropHandler;
    private boolean dragMotionThresholdInitialized = false;

    public void registerSource(@NotNull AdvancedDnDSource source) {
        if (source == null) {
            DnDManagerImpl.$$$reportNull$$$0(0);
        }
        this.registerSource((DnDSource)source, source.getComponent());
    }

    public void registerSource(@NotNull DnDSource source, @NotNull JComponent component2) {
        if (source == null) {
            DnDManagerImpl.$$$reportNull$$$0(1);
        }
        if (component2 == null) {
            DnDManagerImpl.$$$reportNull$$$0(2);
        }
        if (!this.dragMotionThresholdInitialized) {
            this.initializeDragMotionThreshold();
        }
        component2.putClientProperty(SOURCE_KEY, source);
        DragSource defaultDragSource = DragSource.getDefaultDragSource();
        defaultDragSource.createDefaultDragGestureRecognizer(component2, 3, this.myDragGestureListener);
    }

    private void initializeDragMotionThreshold() {
        int motionThreshold = Registry.intValue((String)"ide.dnd.threshold", (int)-1, (int)-1, (int)50);
        if (motionThreshold != -1) {
            try {
                Class<?> awtAccessor = Class.forName("sun.awt.AWTAccessor");
                Method getToolkitAccessor = awtAccessor.getMethod("getToolkitAccessor", new Class[0]);
                getToolkitAccessor.setAccessible(true);
                Object toolkitAccessor = getToolkitAccessor.invoke(null, new Object[0]);
                Method setDesktopProperty = toolkitAccessor.getClass().getMethod("setDesktopProperty", Toolkit.class, String.class, Object.class);
                setDesktopProperty.setAccessible(true);
                setDesktopProperty.invoke(toolkitAccessor, Toolkit.getDefaultToolkit(), "DnD.gestureMotionThreshold", motionThreshold);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOG.warn("An exception occurred when trying to set the DnD.gestureMotionThreshold desktop property. Likely causes: a bug or not running under the JetBrains Runtime", (Throwable)e);
            }
        }
        this.dragMotionThresholdInitialized = true;
    }

    public void registerSource(final @NotNull DnDSource source, final @NotNull JComponent component2, @NotNull Disposable parentDisposable) {
        if (source == null) {
            DnDManagerImpl.$$$reportNull$$$0(3);
        }
        if (component2 == null) {
            DnDManagerImpl.$$$reportNull$$$0(4);
        }
        if (parentDisposable == null) {
            DnDManagerImpl.$$$reportNull$$$0(5);
        }
        this.registerSource(source, component2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                DnDManagerImpl.this.unregisterSource(source, component2);
            }
        });
    }

    public void unregisterSource(@NotNull AdvancedDnDSource source) {
        if (source == null) {
            DnDManagerImpl.$$$reportNull$$$0(6);
        }
        this.unregisterSource((DnDSource)source, source.getComponent());
    }

    public void unregisterSource(@NotNull DnDSource source, @NotNull JComponent component2) {
        if (source == null) {
            DnDManagerImpl.$$$reportNull$$$0(7);
        }
        if (component2 == null) {
            DnDManagerImpl.$$$reportNull$$$0(8);
        }
        component2.putClientProperty(SOURCE_KEY, null);
        this.cleanup(null, null);
    }

    private void cleanup(@Nullable DnDTarget target, @Nullable JComponent targetComponent) {
        Runnable cleanup = () -> {
            if (this.shouldCancelCurrentDnDOperation(target, targetComponent)) {
                this.myLastProcessedOverComponent = null;
                this.myCurrentDragContext = null;
                this.resetEvents("cleanup");
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            cleanup.run();
        } else {
            SwingUtilities.invokeLater(cleanup);
        }
    }

    private boolean shouldCancelCurrentDnDOperation(DnDTarget target, JComponent targetComponent) {
        DnDEvent currentDnDEvent = this.myLastProcessedEvent;
        if (currentDnDEvent == null) {
            return true;
        }
        if (target != null && targetComponent != null) {
            for (Container eachParent = targetComponent; eachParent != null; eachParent = eachParent.getParent()) {
                if (!target.equals((Object)DnDManagerImpl.getTarget(eachParent))) continue;
                return true;
            }
        }
        return false;
    }

    public void registerTarget(DnDTarget target, JComponent component2) {
        component2.putClientProperty(TARGET_KEY, target);
        new DropTarget(component2, 3, this.myDropTargetListener);
    }

    public DropTargetListener getDropTargetListener() {
        return this.myDropTargetListener;
    }

    public void registerTarget(final @NotNull DnDTarget target, final @NotNull JComponent component2, @NotNull Disposable parentDisposable) {
        if (target == null) {
            DnDManagerImpl.$$$reportNull$$$0(9);
        }
        if (component2 == null) {
            DnDManagerImpl.$$$reportNull$$$0(10);
        }
        if (parentDisposable == null) {
            DnDManagerImpl.$$$reportNull$$$0(11);
        }
        this.registerTarget(target, component2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                DnDManagerImpl.this.unregisterTarget(target, component2);
            }
        });
    }

    public void unregisterTarget(DnDTarget target, JComponent component2) {
        component2.putClientProperty(TARGET_KEY, null);
        this.cleanup(target, component2);
    }

    public void updateCurrentEvent() {
        if (this.myCurrentEvent == null) {
            return;
        }
        this.updateCurrentEvent(this.myCurrentEvent.getCurrentOverComponent(), this.myCurrentEvent.getPoint(), this.myCurrentEvent.getAction().getActionId(), this.myCurrentEvent.getTransferDataFlavors(), this.myCurrentEvent);
    }

    private DnDEventImpl updateCurrentEvent(Component aComponentOverDragging, Point aPoint, int nativeAction, DataFlavor @Nullable [] flavors, @Nullable Transferable transferable) {
        DnDTarget processedTarget;
        boolean sameTarget;
        DnDTarget target;
        JComponent jComp;
        DnDTarget target2;
        LOG.debug("updateCurrentEvent: ", new Object[]{aComponentOverDragging});
        DnDEventImpl currentEvent = this.myCurrentEvent;
        if (this.myCurrentEvent == null && aComponentOverDragging instanceof JComponent && (target2 = DnDManagerImpl.getTarget(jComp = (JComponent)aComponentOverDragging)) instanceof DnDNativeTarget) {
            DnDEventImpl event = (DnDEventImpl)jComp.getClientProperty("DnDEvent");
            if (event == null) {
                DnDNativeTarget.EventInfo info = new DnDNativeTarget.EventInfo(flavors, transferable);
                event = new DnDEventImpl(this, DnDAction.COPY, info, aPoint);
                jComp.putClientProperty("DnDEvent", event);
            }
            currentEvent = event;
        }
        if (currentEvent == null) {
            return null;
        }
        DnDAction dndAction = DnDManagerImpl.getDnDActionForPlatformAction(nativeAction);
        if (dndAction == null) {
            return null;
        }
        currentEvent.updateAction(dndAction);
        currentEvent.setPoint(aPoint);
        currentEvent.setHandlerComponent(aComponentOverDragging);
        boolean samePoint = currentEvent.getPoint().equals(this.myLastProcessedPoint);
        Component component2 = this.myLastProcessedOverComponent != null ? (Component)this.myLastProcessedOverComponent.get() : null;
        boolean sameComponent = currentEvent.getCurrentOverComponent().equals(component2);
        boolean sameAction = nativeAction == this.myLastProcessedAction;
        LOG.debug("updateCurrentEvent: point:", new Object[]{aPoint});
        LOG.debug("updateCurrentEvent: action:", new Object[]{nativeAction});
        if (samePoint && sameComponent && sameAction && transferable != this.myCurrentEvent) {
            return currentEvent;
        }
        DnDTarget immediateTarget = target = DnDManagerImpl.getTarget(aComponentOverDragging);
        Component eachParent = aComponentOverDragging;
        Pair pair = (Pair)currentEvent.getUserData(DRAGGED_IMAGE_KEY);
        if (pair != null) {
            target.updateDraggedImage((Image)pair.first, aPoint, (Point)pair.second);
        }
        LOG.debug("updateCurrentEvent: action:" + nativeAction);
        while (true) {
            boolean canGoToParent = this.update((DnDTargetChecker)target, currentEvent);
            if (currentEvent.isDropPossible()) {
                if (!currentEvent.wasDelegated()) break;
                target = currentEvent.getDelegatedTarget();
                break;
            }
            if (!canGoToParent || (eachParent = DnDManagerImpl.findAllowedParentComponent(eachParent)) == null) break;
            target = DnDManagerImpl.getTarget(eachParent);
        }
        LOG.debug("updateCurrentEvent: target:" + String.valueOf(target));
        LOG.debug("updateCurrentEvent: immediateTarget:" + String.valueOf(immediateTarget));
        if (!currentEvent.isDropPossible() && !immediateTarget.equals((Object)target)) {
            this.update((DnDTargetChecker)immediateTarget, currentEvent);
        }
        this.updateCursor();
        Container current = (Container)currentEvent.getCurrentOverComponent();
        Point point = currentEvent.getPointOn(DnDManagerImpl.getLayeredPane(current));
        Rectangle inPlaceRect = new Rectangle(point.x - 5, point.y - 5, 5, 5);
        if (!currentEvent.equals(this.myLastProcessedEvent)) {
            this.hideCurrentHighlighter();
        }
        boolean bl = sameTarget = (processedTarget = this.getLastProcessedTarget()) != null && processedTarget.equals((Object)target);
        if (sameTarget) {
            if (currentEvent.isDropPossible()) {
                if (!this.myLastProcessedPoint.equals(currentEvent.getPoint()) && !Highlighters.isVisibleExcept(48)) {
                    this.hideCurrentHighlighter();
                    this.queueTooltip(currentEvent, DnDManagerImpl.getLayeredPane(current), inPlaceRect);
                }
            } else if (this.myLastProcessedPoint == null || !this.myLastProcessedPoint.equals(currentEvent.getPoint())) {
                this.hideCurrentHighlighter();
                this.queueTooltip(currentEvent, DnDManagerImpl.getLayeredPane(current), inPlaceRect);
            }
        } else {
            this.hideCurrentHighlighter();
            if (processedTarget != null) {
                processedTarget.cleanUpOnLeave();
            }
            currentEvent.clearDropHandler();
            if (!currentEvent.isDropPossible()) {
                this.queueTooltip(currentEvent, DnDManagerImpl.getLayeredPane(current), inPlaceRect);
            }
        }
        this.myLastProcessedTarget = new WeakReference<DnDTarget>(target);
        this.myLastProcessedPoint = currentEvent.getPoint();
        this.myLastProcessedOverComponent = new WeakReference<Component>(currentEvent.getCurrentOverComponent());
        this.myLastProcessedAction = currentEvent.getAction().getActionId();
        this.myLastProcessedEvent = (DnDEvent)currentEvent.clone();
        return currentEvent;
    }

    private void updateCursor() {
        Cursor cursor;
        if (this.myCurrentDragContext == null || this.myCurrentEvent == null) {
            return;
        }
        if (this.myCurrentEvent.isDropPossible()) {
            cursor = this.myCurrentEvent.getCursor();
            if (cursor == null) {
                cursor = this.myCurrentEvent.getAction().getCursor();
            }
        } else {
            cursor = this.myCurrentEvent.getAction().getRejectCursor();
        }
        this.myCurrentDragContext.setCursor(cursor);
    }

    private boolean update(DnDTargetChecker target, DnDEvent currentEvent) {
        LOG.debug("update target:" + String.valueOf(target));
        currentEvent.clearDelegatedTarget();
        boolean canGoToParent = target.update(currentEvent);
        String message = DnDManagerImpl.isMessageProvided(currentEvent) ? currentEvent.getExpectedDropResult() : "";
        if (this.myLastMessage != null && !this.myLastMessage.equals(message)) {
            this.hideCurrentHighlighter();
        }
        this.myLastMessage = message;
        return canGoToParent;
    }

    @Nullable
    private static Component findAllowedParentComponent(@NotNull Component aComponentOverDragging) {
        DnDTarget target;
        if (aComponentOverDragging == null) {
            DnDManagerImpl.$$$reportNull$$$0(12);
        }
        Component eachParent = aComponentOverDragging;
        do {
            if ((eachParent = eachParent.getParent()) != null) continue;
            return null;
        } while ((target = DnDManagerImpl.getTarget(eachParent)) == NULL_TARGET);
        return eachParent;
    }

    @Nullable
    private static DnDSource getSource(Component component2) {
        if (component2 instanceof JComponent) {
            return (DnDSource)((JComponent)component2).getClientProperty(SOURCE_KEY);
        }
        return null;
    }

    private static DnDTarget getTarget(Component component2) {
        DnDTarget target;
        if (component2 instanceof JComponent && (target = (DnDTarget)((JComponent)component2).getClientProperty(TARGET_KEY)) != null) {
            return target;
        }
        return NULL_TARGET;
    }

    void showHighlighter(Component aComponent, int aType, DnDEvent aEvent) {
        this.showHighlighter(aComponent.getParent(), aEvent, aComponent.getBounds(), aType);
    }

    void showHighlighter(RelativeRectangle rectangle, int aType, DnDEvent aEvent) {
        JLayeredPane layeredPane2 = DnDManagerImpl.getLayeredPane(rectangle.getPoint().getComponent());
        this.showHighlighter(layeredPane2, rectangle, aType, aEvent);
    }

    void showHighlighter(JLayeredPane layeredPane2, RelativeRectangle rectangle, int aType, DnDEvent event) {
        JList list2;
        Component component2;
        Rectangle bounds = rectangle.getRectangleOn((Component)layeredPane2);
        RelativePoint point = rectangle.getPoint();
        Component component3 = component2 = point == null ? null : point.getOriginalComponent();
        if (component2 instanceof JTree) {
            JTree tree2 = (JTree)component2;
            Rectangle visible = tree2.getVisibleRect();
            int dx = point.getOriginalPoint().x - visible.x;
            if (aType == 1 || dx < 0) {
                bounds.x -= dx;
                bounds.width = visible.width;
            } else {
                bounds.width = visible.width - dx;
            }
        } else if (component2 instanceof JList && 0 == (list2 = (JList)component2).getLayoutOrientation()) {
            Rectangle visible = list2.getVisibleRect();
            int dx = point.getOriginalPoint().x - visible.x;
            bounds.x -= dx;
            bounds.width = visible.width;
        }
        this.showHighlighter((Component)layeredPane2, event, bounds, aType);
    }

    private boolean isEventBeingHighlighted(DnDEvent event) {
        return event.equals((Object)this.getLastHighlightedEvent());
    }

    private void showHighlighter(Component parent, DnDEvent aEvent, Rectangle bounds, int aType) {
        JLayeredPane layeredPane2 = DnDManagerImpl.getLayeredPane(parent);
        if (layeredPane2 == null) {
            return;
        }
        if (this.isEventBeingHighlighted(aEvent) && GeometryUtil.isWithin((Rectangle)this.myLastHighlightedRec, (Point2D)aEvent.getPointOn((Component)layeredPane2))) {
            return;
        }
        Rectangle rectangle = SwingUtilities.convertRectangle(parent, bounds, layeredPane2);
        this.setLastHighlightedEvent((DnDEvent)((DnDEventImpl)aEvent).clone(), rectangle);
        Highlighters.hide();
        Highlighters.show(aType, layeredPane2, rectangle, aEvent);
        if (DnDManagerImpl.isMessageProvided(aEvent)) {
            this.queueTooltip(aEvent, layeredPane2, rectangle);
        } else {
            Highlighters.hide(48);
        }
    }

    private void queueTooltip(DnDEvent aEvent, JLayeredPane aLayeredPane, Rectangle aRectangle) {
        this.myHighlighterShowRequest = () -> {
            if (this.myCurrentEvent != aEvent) {
                return;
            }
            Highlighters.hide(48);
            if (aEvent.isDropPossible()) {
                Highlighters.show(16, aLayeredPane, aRectangle, aEvent);
            } else {
                Highlighters.show(32, aLayeredPane, aRectangle, aEvent);
            }
        };
        this.myTooltipTimer.restart();
    }

    private static boolean isMessageProvided(DnDEvent aEvent) {
        return aEvent.getExpectedDropResult() != null && !aEvent.getExpectedDropResult().trim().isEmpty();
    }

    void hideCurrentHighlighter() {
        Highlighters.hide();
        this.clearRequest();
        this.setLastHighlightedEvent(null, null);
    }

    private void clearRequest() {
        this.myHighlighterShowRequest = null;
        this.myTooltipTimer.stop();
    }

    private void onTimer() {
        if (this.myHighlighterShowRequest != null) {
            this.myHighlighterShowRequest.run();
        }
        this.clearRequest();
    }

    @Nullable
    private static JLayeredPane getLayeredPane(@Nullable Component aComponent) {
        if (aComponent == null) {
            return null;
        }
        if (aComponent instanceof JLayeredPane) {
            return (JLayeredPane)aComponent;
        }
        if (aComponent instanceof JFrame) {
            return ((JFrame)aComponent).getRootPane().getLayeredPane();
        }
        if (aComponent instanceof JDialog) {
            return ((JDialog)aComponent).getRootPane().getLayeredPane();
        }
        Window window = SwingUtilities.getWindowAncestor(aComponent);
        if (window instanceof JFrame) {
            return ((JFrame)window).getRootPane().getLayeredPane();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getRootPane().getLayeredPane();
        }
        return null;
    }

    private DnDTarget getLastProcessedTarget() {
        return (DnDTarget)this.myLastProcessedTarget.get();
    }

    private DnDEvent getLastHighlightedEvent() {
        return this.myLastHighlightedEvent;
    }

    private void setLastHighlightedEvent(@Nullable DnDEvent lastHighlightedEvent, @Nullable Rectangle aRectangle) {
        this.myLastHighlightedEvent = lastHighlightedEvent;
        this.myLastHighlightedRec = aRectangle;
    }

    private void resetEvents(@NonNls String s) {
        this.myCurrentEvent = DnDManagerImpl.resetEvent(this.myCurrentEvent);
        this.myLastProcessedEvent = DnDManagerImpl.resetEvent(this.myLastProcessedEvent);
        this.myLastHighlightedEvent = DnDManagerImpl.resetEvent(this.myLastHighlightedEvent);
        LOG.debug("Reset events: " + s);
    }

    @Nullable
    private static DnDEventImpl resetEvent(DnDEvent event) {
        if (event == null) {
            return null;
        }
        event.cleanUp();
        return null;
    }

    private static DnDAction getDnDActionForPlatformAction(int platformAction) {
        boolean altOnly = UISettings.getInstance().getDndWithPressedAltOnly();
        return switch (platformAction) {
            case 1 -> {
                if (altOnly) {
                    yield DnDAction.MOVE;
                }
                yield DnDAction.COPY;
            }
            case 2 -> {
                if (altOnly) {
                    yield DnDAction.COPY;
                }
                yield DnDAction.MOVE;
            }
            case 0x40000000 -> DnDAction.LINK;
            default -> null;
        };
    }

    private void onDragExit() {
        DnDTarget target;
        if (this.myCurrentDragContext != null) {
            this.myCurrentDragContext.setCursor(null);
        }
        if ((target = this.getLastProcessedTarget()) != null) {
            target.cleanUpOnLeave();
        }
        this.hideCurrentHighlighter();
    }

    public void setLastDropHandler(@Nullable Component c) {
        this.myLastDropHandler = c == null ? null : new WeakReference<Component>(c);
    }

    @Nullable
    public Component getLastDropHandler() {
        return (Component)SoftReference.dereference(this.myLastDropHandler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aComponentOverDragging";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/dnd/DnDManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerSource";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterSource";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "registerTarget";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "findAllowedParentComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyDragGestureListener
    implements DragGestureListener {
        private MyDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent event) {
            try {
                Image mrImage;
                Pair pair;
                DnDSource source = DnDManagerImpl.getSource(event.getComponent());
                if (source == null || !MouseDragHelper.checkModifiers((InputEvent)event.getTriggerEvent()) || DnDManagerImpl.this.myCurrentEvent != null) {
                    return;
                }
                DnDAction action2 = DnDManagerImpl.getDnDActionForPlatformAction(event.getDragAction());
                if (!source.canStartDragging(action2, event.getDragOrigin())) {
                    return;
                }
                LOG.debug("Starting dragging for " + String.valueOf(action2));
                DnDManagerImpl.this.hideCurrentHighlighter();
                DnDDragStartBean bean = source.startDragging(action2, event.getDragOrigin());
                DnDManagerImpl.this.myCurrentEvent = new DnDEventImpl(DnDManagerImpl.this, action2, bean.getAttachedObject(), bean.getPoint());
                DnDManagerImpl.this.myCurrentEvent.setOrgPoint(event.getDragOrigin());
                Pair pair2 = pair = bean.isEmpty() ? null : source.createDraggedImage(action2, event.getDragOrigin(), bean);
                if (pair == null) {
                    pair = Pair.create((Object)EMPTY_IMAGE, (Object)new Point(0, 0));
                }
                if (SystemInfo.isMac && (mrImage = MultiResolutionImageProvider.convertFromJBImage((Image)((Image)pair.first))) != null) {
                    pair = new Pair((Object)mrImage, (Object)((Point)pair.second));
                }
                if (!DragSource.isDragImageSupported()) {
                    DnDManagerImpl.this.myCurrentEvent.putUserData(DRAGGED_IMAGE_KEY, pair);
                }
                event.startDrag(DragSource.DefaultCopyDrop, (Image)pair.first, (Point)pair.second, DnDManagerImpl.this.myCurrentEvent, new MyDragSourceListener(source));
            }
            catch (InvalidDnDOperationException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    private final class MyDropTargetListener
    implements DropTargetListener {
        private MyDropTargetListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop(DropTargetDropEvent dtde) {
            SmoothAutoScroller.getSharedListener().drop(dtde);
            try {
                Component component2 = dtde.getDropTargetContext().getComponent();
                DnDEventImpl event = DnDManagerImpl.this.updateCurrentEvent(component2, dtde.getLocation(), dtde.getDropAction(), dtde.getCurrentDataFlavors(), dtde.getTransferable());
                if (event != null && event.isDropPossible()) {
                    dtde.acceptDrop(dtde.getDropAction());
                    boolean success2 = this.doDrop(component2, event);
                    if (event.shouldRemoveHighlighting()) {
                        DnDManagerImpl.this.hideCurrentHighlighter();
                    }
                    dtde.dropComplete(success2);
                } else {
                    dtde.rejectDrop();
                }
            }
            catch (Throwable e) {
                LOG.error(e);
                dtde.rejectDrop();
            }
            finally {
                DnDManagerImpl.this.resetEvents("Stop dragging2");
            }
        }

        private boolean doDrop(Component component2, DnDEventImpl currentEvent) {
            boolean success2 = true;
            if (currentEvent.canHandleDrop()) {
                currentEvent.handleDrop();
            } else {
                DnDTarget target = DnDManagerImpl.getTarget(component2);
                if (target instanceof DnDDropHandler.WithResult) {
                    success2 = ((DnDDropHandler.WithResult)target).tryDrop((DnDEvent)currentEvent);
                } else {
                    target.drop((DnDEvent)currentEvent);
                }
            }
            MyDropTargetListener.cleanTargetComponent(component2);
            DnDManagerImpl.this.setLastDropHandler(component2);
            DnDManagerImpl.this.myCurrentDragContext = null;
            return success2;
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            SmoothAutoScroller.getSharedListener().dragEnter(dtde);
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            SmoothAutoScroller.getSharedListener().dragOver(dtde);
            DnDEventImpl event = DnDManagerImpl.this.updateCurrentEvent(dtde.getDropTargetContext().getComponent(), dtde.getLocation(), dtde.getDropAction(), dtde.getCurrentDataFlavors(), dtde.getTransferable());
            if (DnDManagerImpl.this.myCurrentEvent == null) {
                if (event != null && event.isDropPossible()) {
                    dtde.acceptDrag(event.getAction().getActionId());
                } else {
                    dtde.rejectDrag();
                }
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            SmoothAutoScroller.getSharedListener().dragExit(dte);
            DnDManagerImpl.this.onDragExit();
            MyDropTargetListener.cleanTargetComponent(dte.getDropTargetContext().getComponent());
        }

        private static void cleanTargetComponent(Component c) {
            DnDTarget target = DnDManagerImpl.getTarget(c);
            if (target instanceof DnDNativeTarget && c instanceof JComponent) {
                ((JComponent)c).putClientProperty("DnDEvent", null);
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            SmoothAutoScroller.getSharedListener().dropActionChanged(dtde);
            DnDManagerImpl.this.updateCurrentEvent(dtde.getDropTargetContext().getComponent(), dtde.getLocation(), dtde.getDropAction(), dtde.getCurrentDataFlavors(), dtde.getTransferable());
        }
    }

    private static final class NullTarget
    implements DnDTarget {
        private NullTarget() {
        }

        public boolean update(DnDEvent aEvent) {
            aEvent.setDropPossible(false, "You cannot drop anything here");
            return false;
        }

        public void drop(DnDEvent aEvent) {
        }
    }

    private final class MyDragSourceListener
    implements DragSourceListener {
        private final DnDSource mySource;

        MyDragSourceListener(DnDSource source) {
            this.mySource = source;
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
            LOG.debug("dragEnter:" + String.valueOf(dsde.getDragSourceContext().getComponent()));
            DnDManagerImpl.this.myCurrentDragContext = dsde.getDragSourceContext();
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
            LOG.debug("dragOver:" + String.valueOf(dsde.getDragSourceContext().getComponent()));
            DnDManagerImpl.this.myCurrentDragContext = dsde.getDragSourceContext();
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
            this.mySource.dropActionChanged(dsde.getGestureModifiers());
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            this.mySource.dragDropEnd((DnDEvent)DnDManagerImpl.this.myCurrentEvent, dsde);
            DnDTarget target = DnDManagerImpl.this.getLastProcessedTarget();
            if (target != null) {
                target.cleanUpOnLeave();
            }
            DnDManagerImpl.this.resetEvents("dragDropEnd:" + String.valueOf(dsde.getDragSourceContext().getComponent()));
            Highlighters.hide(48);
            DnDManagerImpl.this.myCurrentDragContext = null;
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
            LOG.debug("Stop dragging1");
            DnDManagerImpl.this.onDragExit();
        }
    }
}

