/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.DynamicBundle;
import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.gdpr.AgreementUiBuilder;
import com.intellij.ide.gdpr.AgreementUiKt;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.ide.gdpr.EndUserAgreement;
import com.intellij.l10n.LocalizationUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.AppUIUtil;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\b\u0010\u0004\u001a\u00020\u0001H\u0007\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\b\u0010\r\u001a\u00020\u000eH\u0001\u00a8\u0006\u000f"}, d2={"showEndUserAndDataSharingAgreements", "", "agreement", "Lcom/intellij/ide/gdpr/EndUserAgreement$Document;", "showDataSharingAgreement", "configureDataSharing", "Lcom/intellij/ide/gdpr/AgreementUiBuilder;", "bundle", "Ljava/util/ResourceBundle;", "prepareConsentsHtml", "Lcom/intellij/openapi/util/text/HtmlChunk;", "consent", "Lcom/intellij/ide/gdpr/Consent;", "isReleaseAgreementsEnabled", "", "intellij.platform.ide.impl"})
@JvmName(name="Agreements")
@ApiStatus.Internal
public final class Agreements {
    public static final void showEndUserAndDataSharingAgreements(@NotNull EndUserAgreement.Document agreement) {
        Intrinsics.checkNotNullParameter((Object)agreement, (String)"agreement");
        boolean isPrivacyPolicy = agreement.isPrivacyPolicy();
        ResourceBundle resourceBundle = DynamicBundle.getResourceBundle((ClassLoader)DynamicBundle.class.getClassLoader(), (String)"messages.AgreementsBundle", (Locale)LocalizationUtil.getLocale$default((LocalizationUtil)LocalizationUtil.INSTANCE, (boolean)false, (int)1, null));
        Intrinsics.checkNotNullExpressionValue((Object)resourceBundle, (String)"getResourceBundle(...)");
        ResourceBundle bundle = resourceBundle;
        AgreementUiKt.showAgreementUi((Function1<? super AgreementUiBuilder, Unit>)((Function1)arg_0 -> Agreements.showEndUserAndDataSharingAgreements$lambda$0(agreement, isPrivacyPolicy, bundle, arg_0)));
    }

    @ApiStatus.Internal
    public static final void showDataSharingAgreement() {
        AgreementUiKt.showAgreementUi((Function1<? super AgreementUiBuilder, Unit>)((Function1)Agreements::showDataSharingAgreement$lambda$0));
    }

    private static final void configureDataSharing(AgreementUiBuilder $this$configureDataSharing, ResourceBundle bundle) {
        Consent dataSharingConsent = (Consent)((List)ConsentOptions.getInstance().getConsents(ConsentOptions.condUsageStatsConsent()).getFirst()).get(0);
        Intrinsics.checkNotNull((Object)dataSharingConsent);
        String string = Agreements.prepareConsentsHtml(dataSharingConsent, bundle).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        $this$configureDataSharing.setHtmlText(string);
        $this$configureDataSharing.setTitle(bundle.getString("dataSharing.dialog.title"));
        $this$configureDataSharing.clearBottomPanel();
        $this$configureDataSharing.focusToText();
        String string2 = bundle.getString("dataSharing.dialog.accept");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        AgreementUiBuilder.acceptButton$default($this$configureDataSharing, string2, false, arg_0 -> Agreements.configureDataSharing$lambda$0(dataSharingConsent, arg_0), 2, null);
        String string3 = bundle.getString("dataSharing.dialog.decline");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        $this$configureDataSharing.declineButton(string3, (Function1<? super DialogWrapper, Unit>)((Function1)arg_0 -> Agreements.configureDataSharing$lambda$1(dataSharingConsent, arg_0)));
    }

    private static final HtmlChunk prepareConsentsHtml(Consent consent, ResourceBundle bundle) {
        HtmlChunk htmlChunk;
        if (ConsentOptions.getInstance().isEAP()) {
            htmlChunk = HtmlChunk.empty();
        } else {
            String string = bundle.getString("dataSharing.applyToAll.hint");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String string2 = ApplicationInfoImpl.getShadowInstance().getShortCompanyName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getShortCompanyName(...)");
            String hint = StringsKt.replace$default((String)string, (String)"{0}", (String)string2, (boolean)false, (int)4, null);
            htmlChunk = (HtmlChunk)HtmlChunk.text((String)hint).wrapWith("hint").wrapWith("p");
        }
        HtmlChunk htmlChunk2 = htmlChunk;
        Intrinsics.checkNotNull((Object)htmlChunk2);
        HtmlChunk allProductChunk = htmlChunk2;
        String string = bundle.getString("dataSharing.revoke.hint");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String string3 = ShowSettingsUtil.getSettingsMenuName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSettingsMenuName(...)");
        String preferenceHint = StringsKt.replace$default((String)string, (String)"{0}", (String)string3, (boolean)false, (int)4, null);
        HtmlChunk.Element element = HtmlChunk.text((String)preferenceHint).wrapWith("hint").wrapWith("p");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"wrapWith(...)");
        HtmlChunk.Element preferenceChunk = element;
        HtmlChunk.Element element2 = HtmlChunk.text((String)bundle.getString("dataSharing.consents.title")).wrapWith("h1");
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"wrapWith(...)");
        HtmlChunk.Element title2 = element2;
        HtmlChunk.Element element3 = new HtmlBuilder().append((HtmlChunk)title2).append((HtmlChunk)HtmlChunk.p().addRaw(consent.getText())).append(allProductChunk).append((HtmlChunk)preferenceChunk).wrapWithHtmlBody();
        Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"wrapWithHtmlBody(...)");
        return (HtmlChunk)element3;
    }

    @VisibleForTesting
    public static final boolean isReleaseAgreementsEnabled() {
        return Boolean.parseBoolean(System.getProperty("test.release.agreements"));
    }

    private static final Unit showEndUserAndDataSharingAgreements$lambda$0(EndUserAgreement.Document $agreement, boolean $isPrivacyPolicy, ResourceBundle $bundle, AgreementUiBuilder $this$showAgreementUi) {
        Intrinsics.checkNotNullParameter((Object)$this$showAgreementUi, (String)"$this$showAgreementUi");
        String string = $agreement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        $this$showAgreementUi.setHtmlText(string);
        $this$showAgreementUi.setTitle($isPrivacyPolicy ? ApplicationInfoImpl.getShadowInstance().getShortCompanyName() + " " + $bundle.getString("userAgreement.dialog.privacyPolicy.title") : ApplicationNamesInfo.getInstance().getFullProductName() + " " + $bundle.getString("userAgreement.dialog.userAgreement.title"));
        String string2 = $bundle.getString("userAgreement.dialog.exit");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        $this$showAgreementUi.declineButton(string2, (Function1<? super DialogWrapper, Unit>)((Function1)Agreements::showEndUserAndDataSharingAgreements$lambda$0$0));
        String string3 = $bundle.getString("userAgreement.dialog.checkBox");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        $this$showAgreementUi.checkBox(string3, (Function1<? super JCheckBox, Unit>)((Function1)arg_0 -> Agreements.showEndUserAndDataSharingAgreements$lambda$0$1($this$showAgreementUi, arg_0)));
        if (ApplicationInfoImpl.getShadowInstance().isEAP() && !Agreements.isReleaseAgreementsEnabled()) {
            String string4 = $bundle.getString("userAgreement.dialog.continue");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
            $this$showAgreementUi.acceptButton(string4, false, (Function1<? super DialogWrapper, Unit>)((Function1)arg_0 -> Agreements.showEndUserAndDataSharingAgreements$lambda$0$2($agreement, arg_0)));
            $this$showAgreementUi.eapPanel = $isPrivacyPolicy;
        } else {
            String string5 = $bundle.getString("userAgreement.dialog.continue");
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getString(...)");
            $this$showAgreementUi.acceptButton(string5, false, (Function1<? super DialogWrapper, Unit>)((Function1)arg_0 -> Agreements.showEndUserAndDataSharingAgreements$lambda$0$3($agreement, $this$showAgreementUi, $bundle, arg_0)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit showEndUserAndDataSharingAgreements$lambda$0$0(DialogWrapper it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
            System.exit(11);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        ApplicationManagerEx.getApplicationEx().exit(3, 11);
        return Unit.INSTANCE;
    }

    private static final Unit showEndUserAndDataSharingAgreements$lambda$0$1(AgreementUiBuilder $this_showAgreementUi, JCheckBox checkBox) {
        Intrinsics.checkNotNullParameter((Object)checkBox, (String)"checkBox");
        $this_showAgreementUi.enableAcceptButton(checkBox.isSelected());
        return Unit.INSTANCE;
    }

    private static final Unit showEndUserAndDataSharingAgreements$lambda$0$2(EndUserAgreement.Document $agreement, DialogWrapper dialogWrapper) {
        Intrinsics.checkNotNullParameter((Object)dialogWrapper, (String)"dialogWrapper");
        EndUserAgreement.setAccepted($agreement);
        dialogWrapper.close(0);
        return Unit.INSTANCE;
    }

    private static final Unit showEndUserAndDataSharingAgreements$lambda$0$3(EndUserAgreement.Document $agreement, AgreementUiBuilder $this_showAgreementUi, ResourceBundle $bundle, DialogWrapper dialogWrapper) {
        Intrinsics.checkNotNullParameter((Object)dialogWrapper, (String)"dialogWrapper");
        EndUserAgreement.setAccepted($agreement);
        if (ConsentOptions.needToShowUsageStatsConsent()) {
            Agreements.configureDataSharing($this_showAgreementUi, $bundle);
        } else {
            dialogWrapper.close(0);
        }
        return Unit.INSTANCE;
    }

    private static final Unit showDataSharingAgreement$lambda$0(AgreementUiBuilder $this$showAgreementUi) {
        Intrinsics.checkNotNullParameter((Object)$this$showAgreementUi, (String)"$this$showAgreementUi");
        ResourceBundle resourceBundle = DynamicBundle.getResourceBundle((ClassLoader)$this$showAgreementUi.getClass().getClassLoader(), (String)"messages.AgreementsBundle", (Locale)Locale.getDefault());
        Intrinsics.checkNotNullExpressionValue((Object)resourceBundle, (String)"getResourceBundle(...)");
        Agreements.configureDataSharing($this$showAgreementUi, resourceBundle);
        return Unit.INSTANCE;
    }

    private static final Unit configureDataSharing$lambda$0(Consent $dataSharingConsent, DialogWrapper it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AppUIUtil.saveConsents(CollectionsKt.listOf((Object)$dataSharingConsent.derive(true)));
        it.close(0);
        return Unit.INSTANCE;
    }

    private static final Unit configureDataSharing$lambda$1(Consent $dataSharingConsent, DialogWrapper it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AppUIUtil.saveConsents(CollectionsKt.listOf((Object)$dataSharingConsent.derive(false)));
        it.close(1);
        return Unit.INSTANCE;
    }
}

