/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentSettingsUi;
import com.intellij.ide.gdpr.localConsents.LocalConsentOptions;
import com.intellij.ide.gdpr.ui.consents.ConsentForcedState;
import com.intellij.ide.gdpr.ui.consents.ConsentUi;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0001\u001a,\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0001\u001a.\u0010\u000b\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0000\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001c\u0010\u000f\u001a\u00020\u0007*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0003H\u0002\u001a\"\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\nH\u0002\u001a\u0019\u0010\u0018\u001a\t\u0018\u00010\u0019\u00a2\u0006\u0002\b\u001a2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u001a\u0019\u0010\u001b\u001a\u00020\u000e*\u00020\u00102\u000b\u0010\u001c\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001aH\u0002\u001a\u001a\u0010\u001d\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001a2\u000b\u0010\u001e\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001aH\u0002\u00a8\u0006\u001f"}, d2={"createNoOptionsConsentSettings", "Lcom/intellij/openapi/ui/DialogPanel;", "preferencesMode", "", "createConsentSettings", "consentMapping", "", "Lcom/intellij/ide/gdpr/ConsentSettingsUi$ConsentStateSupplier;", "consents", "", "Lcom/intellij/ide/gdpr/Consent;", "partitionConsentsAndLocalConsents", "Lkotlin/Pair;", "addBorder", "", "createConsentElement", "Lcom/intellij/ui/dsl/builder/Panel;", "consent", "addCheckBox", "createConsentStateSupplier", "forcedState", "Lcom/intellij/ide/gdpr/ui/consents/ConsentForcedState;", "cb", "Lcom/intellij/ui/components/JBCheckBox;", "getWarning", "", "Lcom/intellij/openapi/util/NlsSafe;", "addWarningRow", "warning", "processCheckboxComment", "text", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nConsentSettingsBody.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsentSettingsBody.kt\ncom/intellij/ide/gdpr/ConsentSettingsBodyKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n1563#2:152\n1634#2,3:153\n3301#2,10:156\n*S KotlinDebug\n*F\n+ 1 ConsentSettingsBody.kt\ncom/intellij/ide/gdpr/ConsentSettingsBodyKt\n*L\n67#1:152\n67#1:153,3\n68#1:156,10\n*E\n"})
public final class ConsentSettingsBodyKt {
    @ApiStatus.Internal
    @NotNull
    public static final DialogPanel createNoOptionsConsentSettings(boolean preferencesMode) {
        DialogPanel dialogPanel;
        DialogPanel $this$createNoOptionsConsentSettings_u24lambda_u241 = dialogPanel = BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)ConsentSettingsBodyKt::createNoOptionsConsentSettings$lambda$0));
        boolean bl = false;
        ConsentSettingsBodyKt.addBorder($this$createNoOptionsConsentSettings_u24lambda_u241, preferencesMode);
        return dialogPanel;
    }

    @ApiStatus.Internal
    @NotNull
    public static final DialogPanel createConsentSettings(@NotNull Collection<ConsentSettingsUi.ConsentStateSupplier> consentMapping, boolean preferencesMode, @NotNull List<Consent> consents) {
        DialogPanel dialogPanel;
        Intrinsics.checkNotNullParameter(consentMapping, (String)"consentMapping");
        Intrinsics.checkNotNullParameter(consents, (String)"consents");
        boolean addCheckBox = preferencesMode || consents.size() > 1;
        DialogPanel $this$createConsentSettings_u24lambda_u241 = dialogPanel = BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> ConsentSettingsBodyKt.createConsentSettings$lambda$0(consents, preferencesMode, addCheckBox, consentMapping, arg_0)));
        boolean bl = false;
        $this$createConsentSettings_u24lambda_u241.setBackground(preferencesMode ? UIUtil.getPanelBackground() : UIUtil.getEditorPaneBackground());
        ConsentSettingsBodyKt.addBorder($this$createConsentSettings_u24lambda_u241, preferencesMode);
        return dialogPanel;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<List<Consent>, List<Consent>> partitionConsentsAndLocalConsents(@NotNull List<Consent> consents) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(consents, (String)"consents");
        Iterable $this$map$iv = (Iterable)LocalConsentOptions.INSTANCE.getLocalConsents().getFirst();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Consent consent = (Consent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getId());
        }
        List localConsentIds = (List)destination$iv$iv;
        Iterable $this$partition$iv = consents;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            Consent consent = (Consent)element$iv;
            boolean bl = false;
            boolean bl2 = !localConsentIds.contains(consent.getId()) ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        return new Pair(first$iv, second$iv);
    }

    private static final void addBorder(DialogPanel $this$addBorder, boolean preferencesMode) {
        if (!preferencesMode) {
            $this$addBorder.setBorder(JBUI.Borders.empty((int)10));
        }
    }

    private static final ConsentSettingsUi.ConsentStateSupplier createConsentElement(Panel $this$createConsentElement, Consent consent, boolean addCheckBox) {
        ConsentSettingsUi.ConsentStateSupplier consentStateSupplier;
        ConsentUi consentUi = ConsentSettingsUi.getConsentUi(consent);
        Intrinsics.checkNotNullExpressionValue((Object)consentUi, (String)"getConsentUi(...)");
        ConsentUi consentUi2 = consentUi;
        ConsentForcedState forcedState = consentUi2.getForcedState();
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        if (addCheckBox) {
            v1 = Panel.row$default($this$createConsentElement, null, arg_0 -> ConsentSettingsBodyKt.createConsentElement$lambda$0(consentUi2, consent, result2, forcedState, arg_0), 1, null);
        } else {
            result2.element = new ConsentSettingsUi.ConsentStateSupplier(consent, ConsentSettingsBodyKt::createConsentElement$lambda$1);
            v1 = Panel.row$default($this$createConsentElement, null, arg_0 -> ConsentSettingsBodyKt.createConsentElement$lambda$2(consent, arg_0), 1, null);
        }
        String warning = ConsentSettingsBodyKt.getWarning(forcedState);
        if (warning != null) {
            ConsentSettingsBodyKt.addWarningRow($this$createConsentElement, warning);
        }
        if (result2.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"result");
            consentStateSupplier = null;
        } else {
            consentStateSupplier = (ConsentSettingsUi.ConsentStateSupplier)result2.element;
        }
        return consentStateSupplier;
    }

    private static final ConsentSettingsUi.ConsentStateSupplier createConsentStateSupplier(ConsentForcedState forcedState, JBCheckBox cb, Consent consent) {
        ConsentSettingsUi.ConsentStateSupplier consentStateSupplier;
        ConsentForcedState consentForcedState = forcedState;
        if (consentForcedState instanceof ConsentForcedState.ExternallyDisabled) {
            cb.setEnabled(false);
            cb.setSelected(false);
            consentStateSupplier = new ConsentSettingsUi.ConsentStateSupplier(consent, () -> ConsentSettingsBodyKt.createConsentStateSupplier$lambda$0(consent));
        } else if (consentForcedState instanceof ConsentForcedState.AlwaysEnabled) {
            cb.setEnabled(false);
            cb.setSelected(true);
            consentStateSupplier = new ConsentSettingsUi.ConsentStateSupplier(consent, () -> ConsentSettingsBodyKt.createConsentStateSupplier$lambda$1(consent));
        } else {
            consentStateSupplier = new ConsentSettingsUi.ConsentStateSupplier(consent, () -> ConsentSettingsBodyKt.createConsentStateSupplier$lambda$2(cb));
        }
        return consentStateSupplier;
    }

    private static final String getWarning(ConsentForcedState forcedState) {
        ConsentForcedState consentForcedState = forcedState;
        return consentForcedState instanceof ConsentForcedState.ExternallyDisabled ? ((ConsentForcedState.ExternallyDisabled)forcedState).getDescription() : (consentForcedState instanceof ConsentForcedState.AlwaysEnabled ? ((ConsentForcedState.AlwaysEnabled)forcedState).getDescription() : null);
    }

    private static final void addWarningRow(Panel $this$addWarningRow, String warning) {
        Panel.row$default($this$addWarningRow, null, arg_0 -> ConsentSettingsBodyKt.addWarningRow$lambda$0(warning, arg_0), 1, null);
    }

    private static final String processCheckboxComment(String text2) {
        Object object = new String[]{"\n"};
        List paragraphs = StringsKt.split$default((CharSequence)text2, (String[])object, (boolean)false, (int)0, (int)6, null);
        if (paragraphs.size() <= 1) {
            return text2;
        }
        object = "<p style=\"margin-top:" + ConsentSettingsUi.getParagraphSpace() + "px;\">";
        return CollectionsKt.joinToString$default((Iterable)paragraphs, (CharSequence)((CharSequence)object), (CharSequence)"<p>", null, (int)0, null, null, (int)60, null);
    }

    private static final Unit createNoOptionsConsentSettings$lambda$0(Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default($this$panel, null, ConsentSettingsBodyKt::createNoOptionsConsentSettings$lambda$0$0, 1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit createNoOptionsConsentSettings$lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"gdpr.label.there.are.no.data.sharing.options.available", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string).align(Align.CENTER);
        return Unit.INSTANCE;
    }

    private static final Unit createConsentSettings$lambda$0(List $consents, boolean $preferencesMode, boolean $addCheckBox, Collection $consentMapping, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default($this$panel, null, ConsentSettingsBodyKt::createConsentSettings$lambda$0$0, 1, null);
        Pair<List<Consent>, List<Consent>> pair = ConsentSettingsBodyKt.partitionConsentsAndLocalConsents($consents);
        List actualConsents = (List)pair.component1();
        List localConsentsAsConsents = (List)pair.component2();
        if (!actualConsents.isEmpty()) {
            Panel.group$default($this$panel, IdeBundle.message((String)"gdpr.data.sharing.consents.title", (Object[])new Object[0]), false, arg_0 -> ConsentSettingsBodyKt.createConsentSettings$lambda$0$1(actualConsents, $addCheckBox, $consentMapping, arg_0), 2, null);
        }
        if (!localConsentsAsConsents.isEmpty()) {
            Panel.group$default($this$panel, IdeBundle.message((String)"gdpr.data.sharing.local.settings.title", (Object[])new Object[0]), false, arg_0 -> ConsentSettingsBodyKt.createConsentSettings$lambda$0$2(localConsentsAsConsents, $addCheckBox, $consentMapping, arg_0), 2, null);
        }
        if (!$preferencesMode) {
            Panel.row$default($this$panel, null, ConsentSettingsBodyKt::createConsentSettings$lambda$0$3, 1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createConsentSettings$lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"gdpr.data.sharing.title.comment.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.comment$default($this$row, string, 0, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createConsentSettings$lambda$0$1(List $actualConsents, boolean $addCheckBox, Collection $consentMapping, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        for (Consent consent : $actualConsents) {
            ConsentSettingsUi.ConsentStateSupplier supplier = ConsentSettingsBodyKt.createConsentElement($this$group, consent, $addCheckBox);
            $consentMapping.add(supplier);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createConsentSettings$lambda$0$2(List $localConsentsAsConsents, boolean $addCheckBox, Collection $consentMapping, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        for (Consent consent : $localConsentsAsConsents) {
            ConsentSettingsUi.ConsentStateSupplier supplier = ConsentSettingsBodyKt.createConsentElement($this$group, consent, $addCheckBox);
            $consentMapping.add(supplier);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createConsentSettings$lambda$0$3(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{ShowSettingsUtil.getSettingsMenuName()};
        String string = IdeBundle.message((String)"gdpr.hint.text.you.can.always.change.this.behavior", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.comment$default($this$row, string, 0, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createConsentElement$lambda$0(ConsentUi $consentUi, Consent $consent, Ref.ObjectRef $result, ConsentForcedState $forcedState, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JBCheckBox cb = (JBCheckBox)ButtonKt.selected(Cell.comment$default($this$row.checkBox($consentUi.getCheckBoxText()), ConsentSettingsBodyKt.processCheckboxComment($consentUi.getCheckBoxCommentText()), 0, null, 6, null), $consent.isAccepted()).getComponent();
        $result.element = ConsentSettingsBodyKt.createConsentStateSupplier($forcedState, cb, $consent);
        return Unit.INSTANCE;
    }

    private static final Boolean createConsentElement$lambda$1() {
        return true;
    }

    private static final Unit createConsentElement$lambda$2(Consent $consent, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JEditorPane jEditorPane = ConsentSettingsUi.createSingleConsent($consent);
        Intrinsics.checkNotNullExpressionValue((Object)jEditorPane, (String)"createSingleConsent(...)");
        $this$row.cell((JComponent)jEditorPane).align(AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Boolean createConsentStateSupplier$lambda$0(Consent $consent) {
        return $consent.isAccepted();
    }

    private static final Boolean createConsentStateSupplier$lambda$1(Consent $consent) {
        return $consent.isAccepted();
    }

    private static final Boolean createConsentStateSupplier$lambda$2(JBCheckBox $cb) {
        return $cb.isSelected();
    }

    private static final Unit addWarningRow$lambda$0(String $warning, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Icon icon2 = AllIcons.General.Warning;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Warning");
        $this$row.icon(icon2).gap(RightGap.SMALL).align(AlignY.TOP.INSTANCE);
        Row.comment$default($this$row, $warning, 70, null, 4, null);
        return Unit.INSTANCE;
    }
}

