/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.ide.Prefs;
import com.intellij.ide.gdpr.Agreements;
import com.intellij.ide.gdpr.Version;
import com.intellij.l10n.LocalizationUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ResourceUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EndUserAgreement {
    private static final Logger LOG = Logger.getInstance(EndUserAgreement.class);
    private static final String POLICY_TEXT_PROPERTY = "jb.privacy.policy.text";
    private static final String PRIVACY_POLICY_DOCUMENT_NAME = "privacy";
    private static final String PRIVACY_POLICY_EAP_DOCUMENT_NAME = "privacyEap";
    private static final String CWM_GUEST_EULA_NAME = "cwmGuestEua";
    private static final String EULA_DOCUMENT_NAME = "eua";
    private static final String EULA_COMMUNITY_DOCUMENT_NAME = "euaCommunity";
    private static final String EULA_MPS_DOCUMENT_NAME = "euaMps";
    private static final String EULA_MPS_CUSTOM_DOCUMENT_KEY = "mps.eua.document.name";
    private static final String EULA_EAP_DOCUMENT_NAME = "euaEap";
    private static final String PRIVACY_POLICY_CONTENT_FILE_NAME = "Cached";
    private static final String DEFAULT_DOC_NAME = "eua";
    private static final String DEFAULT_DOC_EAP_NAME = "euaEap";
    private static final String ACTIVE_DOC_FILE_NAME = "documentName";
    private static final String ACTIVE_DOC_EAP_FILE_NAME = "documentName.eap";
    private static final String RELATIVE_RESOURCE_PATH = "PrivacyPolicy";
    private static final String VERSION_COMMENT_START = "<!--";
    private static final String VERSION_COMMENT_END = "-->";
    private static final Version MAGIC_VERSION = new Version(999, 999);

    public static Path getDocumentContentFile() {
        return EndUserAgreement.getDocumentContentFile(EndUserAgreement.getDocumentName());
    }

    @NotNull
    public static Path getDocumentContentFile(@NotNull String docName) {
        if (docName == null) {
            EndUserAgreement.$$$reportNull$$$0(0);
        }
        Path path = EndUserAgreement.getDataRoot().resolve((String)(PRIVACY_POLICY_DOCUMENT_NAME.equals(docName) ? PRIVACY_POLICY_CONTENT_FILE_NAME : docName + ".cached"));
        if (path == null) {
            EndUserAgreement.$$$reportNull$$$0(1);
        }
        return path;
    }

    @NotNull
    private static Path getDocumentNameFile() {
        Path path = EndUserAgreement.getDataRoot().resolve(EndUserAgreement.shouldUseEAPAgreement() ? ACTIVE_DOC_EAP_FILE_NAME : ACTIVE_DOC_FILE_NAME);
        if (path == null) {
            EndUserAgreement.$$$reportNull$$$0(2);
        }
        return path;
    }

    private static boolean shouldUseEAPAgreement() {
        return ApplicationInfoImpl.getShadowInstance().isEAP() && !Agreements.isReleaseAgreementsEnabled();
    }

    @NotNull
    private static Path getDataRoot() {
        Path path = PathManager.getCommonDataPath().resolve(RELATIVE_RESOURCE_PATH);
        if (path == null) {
            EndUserAgreement.$$$reportNull$$$0(3);
        }
        return path;
    }

    private static String getBundledResourcePath(String docName) {
        return PRIVACY_POLICY_DOCUMENT_NAME.equals(docName) ? "PrivacyPolicy.html" : docName + ".html";
    }

    public static void setAccepted(@NotNull Document doc) {
        if (doc == null) {
            EndUserAgreement.$$$reportNull$$$0(4);
        }
        EndUserAgreement.setAcceptedVersion(doc.getName(), doc.getVersion());
    }

    public static void setAcceptedVersion(@NotNull String docName, @NotNull Version version) {
        if (docName == null) {
            EndUserAgreement.$$$reportNull$$$0(5);
        }
        if (version == null) {
            EndUserAgreement.$$$reportNull$$$0(6);
        }
        String versionKey = EndUserAgreement.getAcceptedVersionKey(docName);
        if (version.isUnknown()) {
            Prefs.remove((String)versionKey);
        } else {
            Prefs.put((String)versionKey, (String)version.toString());
        }
    }

    @NotNull
    public static Version getAcceptedVersion(@NotNull String docName) {
        if (docName == null) {
            EndUserAgreement.$$$reportNull$$$0(7);
        }
        String versionKey = EndUserAgreement.getAcceptedVersionKey(docName);
        Version version = Version.fromString(Prefs.get((String)versionKey, null));
        if (version == null) {
            EndUserAgreement.$$$reportNull$$$0(8);
        }
        return version;
    }

    @NotNull
    public static Document getLatestDocument() {
        Document fromProperty;
        String text2 = System.getProperty(POLICY_TEXT_PROPERTY, null);
        if (text2 != null && !(fromProperty = new Document(PRIVACY_POLICY_DOCUMENT_NAME, text2)).getVersion().isUnknown()) {
            Document document2 = fromProperty;
            if (document2 == null) {
                EndUserAgreement.$$$reportNull$$$0(9);
            }
            return document2;
        }
        String docName = EndUserAgreement.getDocumentName();
        Document defaultDocument = EndUserAgreement.loadDocument(docName);
        Locale locale = Locale.getDefault();
        List localizedDocsNames = LocalizationUtil.INSTANCE.getSuffixLocalizedPaths(docName, locale);
        for (String localizedDocName : localizedDocsNames) {
            Document document3 = EndUserAgreement.loadDocument(localizedDocName);
            if (document3.getText().isEmpty() || defaultDocument.getVersion().isNewer(document3.getVersion())) continue;
            Document document4 = document3;
            if (document4 == null) {
                EndUserAgreement.$$$reportNull$$$0(10);
            }
            return document4;
        }
        Document document5 = defaultDocument;
        if (document5 == null) {
            EndUserAgreement.$$$reportNull$$$0(11);
        }
        return document5;
    }

    @NotNull
    private static Document loadDocument(String docName) {
        Document fromFile = EndUserAgreement.loadContent(docName, EndUserAgreement.getDocumentContentFile(docName));
        if (fromFile != null && !fromFile.getVersion().isUnknown()) {
            Document document2 = fromFile;
            if (document2 == null) {
                EndUserAgreement.$$$reportNull$$$0(12);
            }
            return document2;
        }
        return EndUserAgreement.loadContent(docName, EndUserAgreement.getBundledResourcePath(docName));
    }

    public static void updateCachedContentToLatestBundledVersion() {
        String docName = EndUserAgreement.getDocumentName();
        Locale locale = Locale.getDefault();
        List localizedDocsNames = LocalizationUtil.INSTANCE.getSuffixLocalizedPaths(docName, locale);
        for (String localizedDocName : localizedDocsNames) {
            EndUserAgreement.updateCachedContentToLatestBundledVersion(localizedDocName);
        }
        EndUserAgreement.updateCachedContentToLatestBundledVersion(docName);
    }

    private static void updateCachedContentToLatestBundledVersion(@NotNull String docName) {
        if (docName == null) {
            EndUserAgreement.$$$reportNull$$$0(13);
        }
        try {
            Document cached = EndUserAgreement.loadContent(docName, EndUserAgreement.getDocumentContentFile(docName));
            if (cached == null || cached.getVersion().isUnknown()) {
                return;
            }
            Document bundled = EndUserAgreement.loadContent(docName, EndUserAgreement.getBundledResourcePath(docName));
            if (!bundled.getVersion().isUnknown() && bundled.getVersion().isNewer(cached.getVersion())) {
                EndUserAgreement.writeToFile(EndUserAgreement.getDocumentContentFile(docName), bundled.getText());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void writeToFile(@NotNull Path file2, @NotNull String text2) {
        if (file2 == null) {
            EndUserAgreement.$$$reportNull$$$0(14);
        }
        if (text2 == null) {
            EndUserAgreement.$$$reportNull$$$0(15);
        }
        try {
            Files.createDirectories(file2.getParent(), new FileAttribute[0]);
            Files.writeString(file2, (CharSequence)text2, new OpenOption[0]);
        }
        catch (NoSuchFileException e) {
            LOG.info(e.getMessage());
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    public static void updateContent(@NotNull String docName, @NotNull String text2) {
        if (docName == null) {
            EndUserAgreement.$$$reportNull$$$0(16);
        }
        if (text2 == null) {
            EndUserAgreement.$$$reportNull$$$0(17);
        }
        EndUserAgreement.writeToFile(EndUserAgreement.getDocumentContentFile(docName), text2);
    }

    public static void updateActiveDocumentName(@NotNull String docName) {
        if (docName == null) {
            EndUserAgreement.$$$reportNull$$$0(18);
        }
        EndUserAgreement.writeToFile(EndUserAgreement.getDocumentNameFile(), docName);
    }

    @NotNull
    private static Document loadContent(String docName, String resourcePath) {
        try {
            byte[] data2 = ResourceUtil.getResourceAsBytes((String)resourcePath, (ClassLoader)EndUserAgreement.class.getClassLoader());
            if (data2 != null) {
                return new Document(docName, new String(data2, StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            LOG.info(docName + ": " + e.getMessage());
            LOG.debug((Throwable)e);
        }
        return new Document(docName, "");
    }

    @Nullable
    public static Document loadContent(String docName, Path file2) {
        try {
            return new Document(docName, Files.readString(file2));
        }
        catch (NoSuchFileException ignored) {
            return null;
        }
        catch (IOException e) {
            LOG.info(docName + ": " + e.getMessage());
            LOG.debug((Throwable)e);
            return new Document(docName, "");
        }
    }

    @NotNull
    private static String getDocumentName() {
        block10: {
            String string;
            if (!PlatformUtils.isCommercialEdition()) {
                if (PlatformUtils.isCommunityEdition()) {
                    return EndUserAgreement.shouldUseEAPAgreement() ? "euaEap" : EULA_COMMUNITY_DOCUMENT_NAME;
                }
                if (PlatformUtils.isMPS()) {
                    if (EndUserAgreement.isValidFileName(System.getProperty(EULA_MPS_CUSTOM_DOCUMENT_KEY))) {
                        String string2 = System.getProperty(EULA_MPS_CUSTOM_DOCUMENT_KEY);
                        if (string2 == null) {
                            EndUserAgreement.$$$reportNull$$$0(19);
                        }
                        return string2;
                    }
                    return EndUserAgreement.shouldUseEAPAgreement() ? "euaEap" : EULA_MPS_DOCUMENT_NAME;
                }
                if (PlatformUtils.isJetBrainsClient()) {
                    return CWM_GUEST_EULA_NAME;
                }
                if (PlatformUtils.isGateway()) {
                    return EndUserAgreement.shouldUseEAPAgreement() ? "euaEap" : "eua";
                }
                return EndUserAgreement.shouldUseEAPAgreement() ? PRIVACY_POLICY_EAP_DOCUMENT_NAME : PRIVACY_POLICY_DOCUMENT_NAME;
            }
            try {
                String docName = Files.readString(EndUserAgreement.getDocumentNameFile());
                if (!EndUserAgreement.isValidFileName(docName)) break block10;
                string = docName;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string == null) {
                EndUserAgreement.$$$reportNull$$$0(20);
            }
            return string;
        }
        return EndUserAgreement.shouldUseEAPAgreement() ? "euaEap" : "eua";
    }

    private static boolean isValidFileName(String docName) {
        if (docName != null && !docName.isBlank()) {
            try {
                Paths.get(docName, new String[0]);
                return true;
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
        }
        return false;
    }

    @NotNull
    private static String getAcceptedVersionKey(@NotNull String docName) {
        if (docName == null) {
            EndUserAgreement.$$$reportNull$$$0(21);
        }
        if (PRIVACY_POLICY_DOCUMENT_NAME.equals(docName)) {
            return "JetBrains.privacy_policy.accepted_version";
        }
        Object keyName = docName;
        if ("euaEap".equals(docName)) {
            keyName = "ij_" + (String)keyName;
        }
        String string = "JetBrains.privacy_policy." + (String)keyName + "_accepted_version";
        if (string == null) {
            EndUserAgreement.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 8, 9, 10, 11, 12, 19, 20, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/gdpr/EndUserAgreement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/gdpr/EndUserAgreement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentContentFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentNameFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataRoot";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedVersion";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLatestDocument";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDocument";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedVersionKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentContentFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 22: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setAccepted";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setAcceptedVersion";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAcceptedVersion";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateCachedContentToLatestBundledVersion";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "writeToFile";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateContent";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "updateActiveDocumentName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAcceptedVersionKey";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 8, 9, 10, 11, 12, 19, 20, 22 -> new IllegalStateException(string);
        };
    }

    public static final class Document {
        private final String myName;
        private final String myText;
        private final Version myVersion;

        public Document(String name2, String text2) {
            this.myName = name2;
            this.myText = text2;
            this.myVersion = Document.parseVersion(text2);
        }

        public boolean isPrivacyPolicy() {
            return EndUserAgreement.PRIVACY_POLICY_DOCUMENT_NAME.equals(this.myName) || EndUserAgreement.PRIVACY_POLICY_EAP_DOCUMENT_NAME.equals(this.myName);
        }

        public boolean isAccepted() {
            Version thisVersion = this.getVersion();
            if (thisVersion.isUnknown() || MAGIC_VERSION.equals(thisVersion)) {
                return true;
            }
            Version acceptedByUser = EndUserAgreement.getAcceptedVersion(this.getName());
            return !acceptedByUser.isUnknown() && acceptedByUser.getMajor() >= thisVersion.getMajor();
        }

        public String getName() {
            return this.myName;
        }

        public Version getVersion() {
            return this.myVersion;
        }

        public String getText() {
            return this.myText;
        }

        @NotNull
        private static Version parseVersion(String text2) {
            if (text2 == null || text2.isBlank()) {
                Version version = Version.UNKNOWN;
                if (version == null) {
                    Document.$$$reportNull$$$0(0);
                }
                return version;
            }
            Iterator iterator = text2.lines().iterator();
            while (iterator.hasNext()) {
                int endComment;
                String line = (String)iterator.next();
                int startComment = line.indexOf(EndUserAgreement.VERSION_COMMENT_START);
                if (startComment < 0 || (endComment = line.indexOf(EndUserAgreement.VERSION_COMMENT_END)) <= startComment) continue;
                Version version = Version.fromString(line.substring(startComment + EndUserAgreement.VERSION_COMMENT_START.length(), endComment).trim());
                if (version == null) {
                    Document.$$$reportNull$$$0(1);
                }
                return version;
            }
            Version version = Version.UNKNOWN;
            if (version == null) {
                Document.$$$reportNull$$$0(2);
            }
            return version;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/gdpr/EndUserAgreement$Document", "parseVersion"));
        }
    }

    public static final class PluginAgreementUpdateDescriptor {
        private static final ExtensionPointName<PluginAgreementUpdateDescriptor> EP_NAME = ExtensionPointName.create((String)"com.intellij.endUserAgreementUpdater");
        @Attribute(value="productCode")
        public String productCode;
        @Attribute(value="documentName")
        public String documentName;

        @NotNull
        public static List<PluginAgreementUpdateDescriptor> getDescriptors() {
            List list2 = EP_NAME.getExtensionList();
            if (list2 == null) {
                PluginAgreementUpdateDescriptor.$$$reportNull$$$0(0);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/gdpr/EndUserAgreement$PluginAgreementUpdateDescriptor", "getDescriptors"));
        }
    }
}

