/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr.ui.consents;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.DataCollectionAgreement;
import com.intellij.ide.gdpr.ui.consents.AiDataCollectionExternalSettings;
import com.intellij.ide.gdpr.ui.consents.ConsentForcedState;
import com.intellij.ide.gdpr.ui.consents.ConsentUi;
import com.intellij.ide.gdpr.ui.consents.TraceDataCollectionConsentUIKt;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J\r\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/gdpr/ui/consents/TraceDataCollectionConsentUI;", "Lcom/intellij/ide/gdpr/ui/consents/ConsentUi;", "consent", "Lcom/intellij/ide/gdpr/Consent;", "<init>", "(Lcom/intellij/ide/gdpr/Consent;)V", "getCheckBoxText", "", "Lcom/intellij/openapi/util/NlsSafe;", "getCheckBoxCommentText", "getForcedState", "Lcom/intellij/ide/gdpr/ui/consents/ConsentForcedState;", "intellij.platform.ide.impl"})
public final class TraceDataCollectionConsentUI
implements ConsentUi {
    @NotNull
    private final Consent consent;

    public TraceDataCollectionConsentUI(@NotNull Consent consent) {
        Intrinsics.checkNotNullParameter((Object)consent, (String)"consent");
        this.consent = consent;
    }

    @Override
    @NotNull
    public String getCheckBoxText() {
        String string = StringUtil.capitalize((String)this.consent.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"capitalize(...)");
        return string;
    }

    @Override
    @NotNull
    public String getCheckBoxCommentText() {
        String string = this.consent.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @Override
    @Nullable
    public ConsentForcedState getForcedState() {
        DataCollectionAgreement dataCollectionAgreement;
        AiDataCollectionExternalSettings externalSettings = AiDataCollectionExternalSettings.Companion.findSettingsImplementedByAiAssistant();
        if (TraceDataCollectionConsentUIKt.access$getLOG$p().isDebugEnabled()) {
            TraceDataCollectionConsentUIKt.access$getLOG$p().debug("AiDataCollectionExternalSettings: " + externalSettings);
        }
        if (externalSettings != null) {
            boolean isForciblyDisabled = externalSettings.isForciblyDisabled();
            if (TraceDataCollectionConsentUIKt.access$getLOG$p().isDebugEnabled()) {
                TraceDataCollectionConsentUIKt.access$getLOG$p().debug("AiDataCollectionExternalSettings: isForciblyDisabled: " + isForciblyDisabled);
            }
            if (isForciblyDisabled) {
                String string = externalSettings.getForciblyDisabledDescription();
                if (string == null) {
                    String string2 = IdeBundle.message((String)"gdpr.consent.externally.disabled.warning", (Object[])new Object[0]);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                }
                return new ConsentForcedState.ExternallyDisabled(string);
            }
        }
        DataCollectionAgreement dataCollectionAgreement2 = dataCollectionAgreement = DataCollectionAgreement.Companion.getInstance();
        return switch (dataCollectionAgreement2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[dataCollectionAgreement2.ordinal()]) {
            case 1 -> new ConsentForcedState.AlwaysEnabled(IdeBundle.message((String)"gdpr.data.collection.consent.setting.enabled.warning.text", (Object[])new Object[0]));
            case 2 -> new ConsentForcedState.ExternallyDisabled(IdeBundle.message((String)"gdpr.data.collection.consent.setting.disabled.warning.text", (Object[])new Object[0]));
            case 3 -> null;
            default -> null;
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataCollectionAgreement.values().length];
            try {
                nArray[DataCollectionAgreement.YES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataCollectionAgreement.NO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataCollectionAgreement.NOT_SET.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

