/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.api;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginDependencyImpl;
import com.intellij.ide.plugins.api.PluginDto;
import com.intellij.ide.plugins.newui.PluginDependencyModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.IntellijInternalApi;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IntellijInternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 42\u00020\u0001:\u00014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0010H\u0016J\u000f\u0010\u001a\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u001bH\u0016J\u000f\u0010\u001c\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u001dH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0010H\u0016J\u000f\u0010 \u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u001dH\u0016J\n\u0010!\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010#\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010$\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010%\u001a\u00020\u0018H\u0016J\b\u0010&\u001a\u00020\u0018H\u0016J\b\u0010'\u001a\u00020\u0018H\u0016J\b\u0010(\u001a\u00020\u0018H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\n\u0010*\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010+\u001a\u0004\u0018\u00010,H\u0016J\n\u0010-\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010.\u001a\u0004\u0018\u00010/H\u0016J\b\u00100\u001a\u00020\u0018H\u0017J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0018H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u00065"}, d2={"Lcom/intellij/ide/plugins/api/PluginDtoDescriptorWrapper;", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "pluginDto", "Lcom/intellij/ide/plugins/api/PluginDto;", "<init>", "(Lcom/intellij/ide/plugins/api/PluginDto;)V", "dependenciesList", "", "Lcom/intellij/ide/plugins/PluginDependency;", "getDependenciesList", "()Ljava/util/List;", "dependenciesList$delegate", "Lkotlin/Lazy;", "getPluginId", "Lcom/intellij/openapi/extensions/PluginId;", "getName", "", "getVersion", "getProductCode", "getReleaseDate", "Ljava/util/Date;", "getReleaseVersion", "", "isLicenseOptional", "", "getChangeNotes", "getCategory", "Lcom/intellij/openapi/util/NlsSafe;", "getDisplayCategory", "Lorg/jetbrains/annotations/Nls;", "getSinceBuild", "getUntilBuild", "getDescription", "getVendor", "getVendorEmail", "getVendorUrl", "getUrl", "isBundled", "allowBundledUpdate", "isImplementationDetail", "isRequireRestart", "getDependencies", "getResourceBundleBaseName", "getPluginPath", "Ljava/nio/file/Path;", "getDescriptorPath", "getPluginClassLoader", "Ljava/lang/ClassLoader;", "isEnabled", "setEnabled", "", "enabled", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nPluginDtoDescriptorWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginDtoDescriptorWrapper.kt\ncom/intellij/ide/plugins/api/PluginDtoDescriptorWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1563#2:113\n1634#2,3:114\n*S KotlinDebug\n*F\n+ 1 PluginDtoDescriptorWrapper.kt\ncom/intellij/ide/plugins/api/PluginDtoDescriptorWrapper\n*L\n19#1:113\n19#1:114,3\n*E\n"})
public final class PluginDtoDescriptorWrapper
implements IdeaPluginDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginDto pluginDto;
    @NotNull
    private final Lazy dependenciesList$delegate;
    @NotNull
    private static final Logger LOG;

    public PluginDtoDescriptorWrapper(@NotNull PluginDto pluginDto) {
        Intrinsics.checkNotNullParameter((Object)pluginDto, (String)"pluginDto");
        this.pluginDto = pluginDto;
        this.dependenciesList$delegate = LazyKt.lazy(() -> PluginDtoDescriptorWrapper.dependenciesList_delegate$lambda$0(this));
    }

    private final List<PluginDependency> getDependenciesList() {
        Lazy lazy = this.dependenciesList$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public PluginId getPluginId() {
        return this.pluginDto.getPluginId();
    }

    @NotNull
    public String getName() {
        String string = this.pluginDto.getName();
        if (string == null) {
            string = this.pluginDto.getPluginId().getIdString();
        }
        return string;
    }

    @Nullable
    public String getVersion() {
        return this.pluginDto.getVersion();
    }

    @Nullable
    public String getProductCode() {
        return this.pluginDto.getProductCode();
    }

    @Nullable
    public Date getReleaseDate() {
        return this.pluginDto.getDate() > 0L ? new Date(this.pluginDto.getDate()) : null;
    }

    public int getReleaseVersion() {
        return this.pluginDto.getReleaseVersion();
    }

    public boolean isLicenseOptional() {
        return this.pluginDto.isLicenseOptional();
    }

    @Nullable
    public String getChangeNotes() {
        return this.pluginDto.getChangeNotes();
    }

    @Nullable
    public String getCategory() {
        return this.pluginDto.getCategory();
    }

    @Nullable
    public String getDisplayCategory() {
        return this.pluginDto.getDisplayCategory();
    }

    @Nullable
    public String getSinceBuild() {
        return this.pluginDto.getSinceBuild();
    }

    @Nullable
    public String getUntilBuild() {
        return this.pluginDto.getUntilBuild();
    }

    @Nullable
    public String getDescription() {
        return this.pluginDto.getDescription();
    }

    @Nullable
    public String getVendor() {
        return this.pluginDto.getVendor();
    }

    @Nullable
    public String getVendorEmail() {
        LOG.error("No direct mapping for vendorEmail in PluginDto");
        return null;
    }

    @Nullable
    public String getVendorUrl() {
        LOG.error("No direct mapping for vendorUrl in PluginDto");
        return null;
    }

    @Nullable
    public String getUrl() {
        LOG.error("No direct mapping for url in PluginDto");
        return null;
    }

    public boolean isBundled() {
        return this.pluginDto.isBundled();
    }

    public boolean allowBundledUpdate() {
        return this.pluginDto.getAllowBundledUpdate();
    }

    public boolean isImplementationDetail() {
        return this.pluginDto.isImplementationDetail();
    }

    public boolean isRequireRestart() {
        LOG.error("No direct mapping for isRequireRestart in PluginDto");
        return false;
    }

    @NotNull
    public List<PluginDependency> getDependencies() {
        return this.getDependenciesList();
    }

    @Nullable
    public String getResourceBundleBaseName() {
        LOG.error("No direct mapping for resourceBundleBaseName in PluginDto");
        return null;
    }

    @Nullable
    public Path getPluginPath() {
        return null;
    }

    @Nullable
    public String getDescriptorPath() {
        LOG.error("No direct mapping for descriptorPath in PluginDto");
        return null;
    }

    @Nullable
    public ClassLoader getPluginClassLoader() {
        LOG.error("No direct mapping for pluginClassLoader in PluginDto");
        return null;
    }

    @Deprecated(message="Deprecated in Java")
    public boolean isEnabled() {
        return this.pluginDto.isEnabled();
    }

    @Deprecated(message="see com.intellij.openapi.extensions.PluginDescriptor.setEnabled")
    public void setEnabled(boolean enabled2) {
        LOG.error("Write operations are not allowed here");
    }

    /*
     * WARNING - void declaration
     */
    private static final List dependenciesList_delegate$lambda$0(PluginDtoDescriptorWrapper this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.pluginDto.getDependencies();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PluginDependencyModel pluginDependencyModel = (PluginDependencyModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PluginDependencyImpl(it.getPluginId(), null, it.isOptional()));
        }
        return (List)destination$iv$iv;
    }

    static {
        Logger logger = Logger.getInstance(PluginDtoDescriptorWrapper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/plugins/api/PluginDtoDescriptorWrapper$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

