/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.EmptyCaret;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.ui.ExtendableHTMLViewFactory;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;

final class ErrorComponent
extends JEditorPane {
    private static final String KEY = "EnableCallback";

    ErrorComponent() {
        UIUtil.convertToLabel((JEditorPane)this);
        this.setCaret(EmptyCaret.INSTANCE);
        HTMLEditorKit htmlEditorKit = new HTMLEditorKitBuilder().withViewFactoryExtensions(new Function2[]{ExtendableHTMLViewFactory.Extensions.ICONS, ExtendableHTMLViewFactory.Extensions.WORD_WRAP}).build();
        this.setEditorKit(htmlEditorKit);
        StyleSheet sheet = ((HTMLEditorKit)this.getEditorKit()).getStyleSheet();
        sheet.addRule("span {color: " + ColorUtil.toHtmlColor((Color)NamedColorUtil.getErrorForeground()) + "}");
        sheet.addRule("a {color: " + ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED) + "}");
        this.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                Object callback;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((callback = ErrorComponent.this.getClientProperty(ErrorComponent.KEY)) instanceof Runnable) {
                    ApplicationManager.getApplication().invokeLater((Runnable)callback, ModalityState.any());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/newui/ErrorComponent$1", "hyperlinkActivated"));
            }
        });
    }

    void setErrors(@NotNull List<? extends HtmlChunk> errors, @NotNull Runnable enableCallback) {
        if (errors == null) {
            ErrorComponent.$$$reportNull$$$0(0);
        }
        if (enableCallback == null) {
            ErrorComponent.$$$reportNull$$$0(1);
        }
        this.setVisible(!errors.isEmpty());
        if (this.isVisible()) {
            HtmlChunk content2 = (HtmlChunk)errors.stream().collect(HtmlChunk.toFragment((HtmlChunk)HtmlChunk.nbsp()));
            content2 = content2.wrapWith(HtmlChunk.body()).wrapWith(HtmlChunk.html());
            String string = content2.toString();
            this.setText(string);
            this.putClientProperty(KEY, enableCallback);
        }
    }

    @NotNull
    @NlsSafe
    private static String toHtml(@NotNull List<? extends HtmlChunk> chunks) {
        if (chunks == null) {
            ErrorComponent.$$$reportNull$$$0(2);
        }
        ArrayList<HtmlChunk> newChunks = new ArrayList<HtmlChunk>();
        Iterator<? extends HtmlChunk> iterator = chunks.iterator();
        while (iterator.hasNext()) {
            newChunks.add(iterator.next());
            if (!iterator.hasNext()) continue;
            newChunks.add(HtmlChunk.nbsp());
        }
        String string = HtmlChunk.html().children(newChunks).toString();
        if (string == null) {
            ErrorComponent.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enableCallback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunks";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/ErrorComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/ErrorComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setErrors";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toHtml";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

