/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.marketplace.utils.MarketplaceUrls;
import com.intellij.ide.plugins.newui.HiDPIPluginLogoIcon;
import com.intellij.ide.plugins.newui.LazyPluginLogoIcon;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.ide.plugins.newui.PluginLogoIconProvider;
import com.intellij.ide.plugins.newui.PluginLogoKt;
import com.intellij.ide.plugins.newui.PluginLogoLoader;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UIThemeProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.JBColor;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.ui.svg.SvgKt;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.Sanitize_nameKt;
import com.intellij.util.io.URLUtil;
import com.intellij.util.lang.ZipFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBImageIcon;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u000e\u001a\b\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\fH\u0007\u001a\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u0014H\u0000\u001a\u001a\u0010!\u001a\u0004\u0018\u00010\u00062\u0006\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020\u0014H\u0002\u001a\u0010\u0010$\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0010\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020'H\u0002\u001a \u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002\u001a&\u0010.\u001a\u00020\u00162\f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+H\u0002\u001a \u00102\u001a\u00020\u00162\u0006\u00103\u001a\u0002012\u0006\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+H\u0002\u001a \u00104\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+2\u0006\u00103\u001a\u000201H\u0002\u001a(\u00105\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+2\u0006\u00103\u001a\u0002012\u0006\u00106\u001a\u00020\u0014H\u0002\u001a \u00107\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u00022\u0006\u00108\u001a\u0002012\u0006\u00109\u001a\u00020\u0002H\u0002\u001a\"\u0010:\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a,\u0010;\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+2\b\u0010 \u001a\u0004\u0018\u00010\u00062\b\u0010<\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0010\u0010=\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u0002H\u0002\u001a\u0012\u0010!\u001a\u0004\u0018\u00010\u00062\u0006\u0010>\u001a\u000201H\u0002\"C\u0010\u0000\u001a7\u0012\u000e\u0012\f0\u0002\u00a2\u0006\u0002\b\u0003\u00a2\u0006\u0002\b\u0004\u0012\u001e\u0012\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0002\b\u0003\u00a2\u0006\u0002\b\u00040\u0001\u00a2\u0006\u0002\b\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0007\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"iconCache", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lkotlin/Pair;", "Lcom/intellij/ide/plugins/newui/PluginLogoIconProvider;", "MISSING", "CACHE_DIR", "PLUGIN_ICON", "PLUGIN_ICON_DARK", "PLUGIN_ICON_SIZE", "", "PLUGIN_ICON_SIZE_SCALED", "PLUGIN_ICON_SIZE_SCALE", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Default", "lafListenerAdded", "", "initLafListener", "", "getIcon", "descriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "reloadPluginIcon", "Ljavax/swing/Icon;", "icon", "width", "height", "getPluginIconFileName", "light", "tryLoadIcon", "zipFile", "Lcom/intellij/util/lang/ZipFile;", "getIdForKey", "loadFileIcon", "data", "", "loadPluginIconsFromUrl", "idPlugin", "lazyIcon", "Lcom/intellij/ide/plugins/newui/LazyPluginLogoIcon;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "loadPluginIconsFromExploded", "paths", "", "Ljava/nio/file/Path;", "loadPluginIconsFromFile", "path", "tryLoadDirIcons", "tryLoadJarIcons", "put", "downloadOrCheckUpdateFile", "file", "theme", "getOrLoadIcon", "putIcon", "dark", "putMissingIcon", "iconFile", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nPluginLogo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginLogo.kt\ncom/intellij/ide/plugins/newui/PluginLogoKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,423:1\n1#2:424\n1761#3,3:425\n42#4,3:428\n13#5:431\n*S KotlinDebug\n*F\n+ 1 PluginLogo.kt\ncom/intellij/ide/plugins/newui/PluginLogoKt\n*L\n171#1:425,3\n337#1:428,3\n57#1:431\n*E\n"})
public final class PluginLogoKt {
    @NotNull
    private static final ConcurrentMap<String, Pair<PluginLogoIconProvider, PluginLogoIconProvider>> iconCache;
    @NotNull
    private static final Pair<PluginLogoIconProvider, PluginLogoIconProvider> MISSING;
    @NotNull
    private static final String CACHE_DIR = "imageCache";
    @NotNull
    private static final String PLUGIN_ICON = "pluginIcon.svg";
    @NotNull
    private static final String PLUGIN_ICON_DARK = "pluginIcon_dark.svg";
    private static final int PLUGIN_ICON_SIZE = 40;
    private static final int PLUGIN_ICON_SIZE_SCALED = 50;
    private static final float PLUGIN_ICON_SIZE_SCALE = 1.25f;
    @NotNull
    private static final Logger LOG;
    @Nullable
    private static PluginLogoIconProvider Default;
    private static boolean lafListenerAdded;

    private static final void initLafListener() {
        if (!lafListenerAdded) {
            lafListenerAdded = true;
            if (GraphicsEnvironment.isHeadless()) {
                return;
            }
            Application application = ApplicationManager.getApplication();
            MessageBusConnection messageBusConnection = application.getMessageBus().connect();
            Topic topic = LafManagerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, PluginLogoKt::initLafListener$lambda$0);
            UIThemeProvider.EP_NAME.addChangeListener(PluginLogoKt::initLafListener$lambda$1, (Disposable)application);
        }
    }

    private static final PluginLogoIconProvider getIcon(IdeaPluginDescriptor descriptor2) {
        PluginLogoIconProvider pluginLogoIconProvider;
        Pair<PluginLogoIconProvider, PluginLogoIconProvider> icons = PluginLogoKt.getOrLoadIcon(descriptor2);
        if (icons == null) {
            pluginLogoIconProvider = PluginLogo.INSTANCE.getDefault();
        } else if (JBColor.isBright()) {
            Object object = icons.getFirst();
            Intrinsics.checkNotNull((Object)object);
            pluginLogoIconProvider = (PluginLogoIconProvider)object;
        } else {
            Object object = icons.getSecond();
            Intrinsics.checkNotNull((Object)object);
            pluginLogoIconProvider = (PluginLogoIconProvider)object;
        }
        return pluginLogoIconProvider;
    }

    @ApiStatus.Internal
    @NotNull
    public static final Icon reloadPluginIcon(@NotNull Icon icon2, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        if (icon2 instanceof CachedImageIcon) {
            boolean bl;
            boolean bl2 = bl = width == height;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            return (Icon)((CachedImageIcon)icon2).scale((float)width / (float)((CachedImageIcon)icon2).getIconWidth());
        }
        return icon2;
    }

    @NotNull
    public static final String getPluginIconFileName(boolean light) {
        return "META-INF/" + (light ? PLUGIN_ICON : PLUGIN_ICON_DARK);
    }

    private static final PluginLogoIconProvider tryLoadIcon(ZipFile zipFile, boolean light) {
        String pluginIconFileName = PluginLogoKt.getPluginIconFileName(light);
        try {
            PluginLogoIconProvider pluginLogoIconProvider;
            byte[] byArray = zipFile.getData(pluginIconFileName);
            if (byArray != null) {
                byte[] it = byArray;
                boolean bl = false;
                pluginLogoIconProvider = PluginLogoKt.loadFileIcon(it);
            } else {
                pluginLogoIconProvider = null;
            }
            return pluginLogoIconProvider;
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.warn("Cannot load plugin icon (zipFile=" + zipFile + ", pluginIconFileName=" + pluginIconFileName + ")");
            LOG.debug(e);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final String getIdForKey(IdeaPluginDescriptor descriptor2) {
        String string;
        String string2 = descriptor2.getPluginId().getIdString();
        if (descriptor2.getPluginPath() != null) {
            boolean bl;
            String string3;
            block5: {
                void $this$any$iv;
                Iterable iterable = MyPluginModel.Companion.getInstallingPlugins();
                string3 = string2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PluginUiModel it = (PluginUiModel)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getPluginId(), (Object)descriptor2.getPluginId())) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            boolean bl3 = bl;
            string2 = string3;
            if (!bl3 && !InstalledPluginsState.getInstance().wasInstalled(descriptor2.getPluginId())) {
                string = "#local";
                return string2 + string;
            }
        }
        string = "";
        return string2 + string;
    }

    private static final PluginLogoIconProvider loadFileIcon(byte[] data2) {
        Object[] objectArray = new Integer[]{40, 50};
        List images = SvgKt.loadWithSizes$default((List)CollectionsKt.listOf((Object[])objectArray), (byte[])data2, (float)0.0f, (int)4, null);
        return new HiDPIPluginLogoIcon(new JBImageIcon((Image)images.get(0)), new JBImageIcon((Image)images.get(1)));
    }

    private static final void loadPluginIconsFromUrl(String idPlugin, LazyPluginLogoIcon lazyIcon, CoroutineContext coroutineContext) {
        String idFileName = Sanitize_nameKt.sanitizeFileName$default((String)idPlugin, null, (boolean)false, null, (int)14, null);
        String[] stringArray = new String[]{CACHE_DIR};
        Path cache = Path.of(PathManager.getPluginTempPath(), stringArray);
        Path lightFile = cache.resolve(idFileName + ".svg");
        Path darkFile = cache.resolve(idFileName + "_dark.svg");
        JobKt.ensureActive((CoroutineContext)coroutineContext);
        try {
            Intrinsics.checkNotNull((Object)lightFile);
            PluginLogoKt.downloadOrCheckUpdateFile(idPlugin, lightFile, "");
            Intrinsics.checkNotNull((Object)darkFile);
            PluginLogoKt.downloadOrCheckUpdateFile(idPlugin, darkFile, "&theme=DARCULA");
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            PluginLogoKt.putMissingIcon(idPlugin);
            return;
        }
        JobKt.ensureActive((CoroutineContext)coroutineContext);
        PluginLogoIconProvider light = PluginLogoKt.tryLoadIcon(lightFile);
        PluginLogoIconProvider dark = PluginLogoKt.tryLoadIcon(darkFile);
        PluginLogoKt.putIcon(idPlugin, lazyIcon, light, dark);
    }

    private static final void loadPluginIconsFromExploded(Collection<? extends Path> paths, String idPlugin, LazyPluginLogoIcon lazyIcon) {
        for (Path path : paths) {
            if (!(Files.isDirectory(path, new LinkOption[0]) ? PluginLogoKt.tryLoadDirIcons(idPlugin, lazyIcon, path) : PluginLogoKt.tryLoadJarIcons(idPlugin, lazyIcon, path, false))) continue;
            return;
        }
        PluginLogoKt.putMissingIcon(idPlugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void loadPluginIconsFromFile(Path path, String idPlugin, LazyPluginLogoIcon lazyIcon) {
        block17: {
            block15: {
                Object object;
                if (!Files.isDirectory(path, new LinkOption[0])) break block15;
                if (System.getProperty("idea.required.plugins.id") != null) {
                    Path path2 = path.resolve("classes");
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                    if (PluginLogoKt.tryLoadDirIcons(idPlugin, lazyIcon, path2)) {
                        return;
                    }
                }
                if (PluginLogoKt.tryLoadDirIcons(idPlugin, lazyIcon, path)) {
                    return;
                }
                Path libFile = path.resolve("lib");
                try {
                    List list2;
                    object = Files.newDirectoryStream(libFile);
                    Throwable throwable = null;
                    try {
                        DirectoryStream it = (DirectoryStream)object;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        list2 = CollectionsKt.toList((Iterable)it);
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                            throw throwable3;
                        }
                    }
                    CloseableKt.closeFinally(object, (Throwable)throwable);
                    object = list2;
                }
                catch (NoSuchFileException noSuchFileException) {
                    object = null;
                }
                catch (NotDirectoryException notDirectoryException) {
                    object = null;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    object = null;
                }
                Closeable files2 = object;
                object = (Collection)((Object)files2);
                if (object == null || object.isEmpty()) {
                    PluginLogoKt.putMissingIcon(idPlugin);
                    return;
                }
                object = files2.iterator();
                while (object.hasNext()) {
                    Path file2 = (Path)object.next();
                    if (!StringsKt.endsWith$default((String)((Object)file2).toString(), (String)".jar", (boolean)false, (int)2, null)) {
                        Intrinsics.checkNotNull((Object)file2);
                        if (PluginLogoKt.tryLoadDirIcons(idPlugin, lazyIcon, file2)) {
                            return;
                        }
                    }
                    Intrinsics.checkNotNull((Object)file2);
                    if (!PluginLogoKt.tryLoadJarIcons(idPlugin, lazyIcon, file2, false)) continue;
                    return;
                }
                break block17;
            }
            PluginLogoKt.tryLoadJarIcons(idPlugin, lazyIcon, path, true);
            return;
        }
        PluginLogoKt.putMissingIcon(idPlugin);
    }

    private static final boolean tryLoadDirIcons(String idPlugin, LazyPluginLogoIcon lazyIcon, Path path) {
        Path path2 = path.resolve(PluginLogoKt.getPluginIconFileName(true));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        PluginLogoIconProvider light = PluginLogoKt.tryLoadIcon(path2);
        Path path3 = path.resolve(PluginLogoKt.getPluginIconFileName(false));
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        PluginLogoIconProvider dark = PluginLogoKt.tryLoadIcon(path3);
        if (light == null && dark == null) {
            return false;
        }
        PluginLogoKt.putIcon(idPlugin, lazyIcon, light, dark);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean tryLoadJarIcons(String idPlugin, LazyPluginLogoIcon lazyIcon, Path path, boolean put2) {
        String pathString = ((Object)path).toString();
        if (!StringsKt.endsWith((String)pathString, (String)".zip", (boolean)true) && !StringsKt.endsWith((String)pathString, (String)".jar", (boolean)true) || !Files.exists(path, new LinkOption[0])) {
            return false;
        }
        try {
            AutoCloseable autoCloseable = (AutoCloseable)ZipFile.load((Path)path);
            Throwable throwable = null;
            try {
                ZipFile zipFile = (ZipFile)autoCloseable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)zipFile);
                PluginLogoIconProvider light = PluginLogoKt.tryLoadIcon(zipFile, true);
                PluginLogoIconProvider dark = PluginLogoKt.tryLoadIcon(zipFile, false);
                if (put2 || light != null || dark != null) {
                    PluginLogoKt.putIcon(idPlugin, lazyIcon, light, dark);
                    boolean bl2 = true;
                    return bl2;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
        return false;
    }

    private static final void downloadOrCheckUpdateFile(String idPlugin, Path file2, String theme) {
        try {
            String url = MarketplaceUrls.getPluginManagerUrl() + "/api/icon?pluginId=" + URLUtil.encodeURIComponent((String)idPlugin) + theme;
            MarketplaceRequests.Companion.readOrUpdateFile(file2, url, null, "", downloadOrCheckUpdateFile.1.INSTANCE);
        }
        catch (HttpRequests.HttpStatusException url) {
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
    }

    private static final Pair<PluginLogoIconProvider, PluginLogoIconProvider> getOrLoadIcon(IdeaPluginDescriptor descriptor2) {
        String idPlugin = PluginLogoKt.getIdForKey(descriptor2);
        Pair icons = (Pair)iconCache.get(idPlugin);
        if (icons != null) {
            return icons.getFirst() == null && icons.getSecond() == null ? null : icons;
        }
        LazyPluginLogoIcon lazyIcon = new LazyPluginLogoIcon(PluginLogo.INSTANCE.getDefault());
        Pair lazyIcons = TuplesKt.to((Object)lazyIcon, (Object)lazyIcon);
        iconCache.put(idPlugin, (Pair<PluginLogoIconProvider, PluginLogoIconProvider>)lazyIcons);
        Pair info = TuplesKt.to((Object)descriptor2, (Object)lazyIcon);
        boolean $i$f$service = false;
        Class<PluginLogoLoader> serviceClass$iv = PluginLogoLoader.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        PluginLogoLoader pluginLogoLoader = (PluginLogoLoader)object;
        List<Pair<IdeaPluginDescriptor, LazyPluginLogoIcon>> prepareToLoad = pluginLogoLoader.prepareToLoad;
        if (prepareToLoad == null) {
            pluginLogoLoader.schedulePluginIconLoading(CollectionsKt.listOf((Object)info));
        } else {
            prepareToLoad.add((Pair<IdeaPluginDescriptor, LazyPluginLogoIcon>)info);
        }
        return lazyIcons;
    }

    private static final void putIcon(String idPlugin, LazyPluginLogoIcon lazyIcon, PluginLogoIconProvider light, PluginLogoIconProvider dark) {
        PluginLogoIconProvider pluginLogoIconProvider;
        if (light == null && dark == null) {
            iconCache.put(idPlugin, (Pair<PluginLogoIconProvider, PluginLogoIconProvider>)new Pair((Object)PluginLogo.INSTANCE.getDefault(), (Object)PluginLogo.INSTANCE.getDefault()));
            return;
        }
        PluginLogoIconProvider pluginLogoIconProvider2 = light;
        if (pluginLogoIconProvider2 == null) {
            PluginLogoIconProvider pluginLogoIconProvider3 = dark;
            pluginLogoIconProvider2 = pluginLogoIconProvider3;
            Intrinsics.checkNotNull((Object)pluginLogoIconProvider3);
        }
        if ((pluginLogoIconProvider = dark) == null) {
            pluginLogoIconProvider = light;
        }
        Pair icons = new Pair((Object)pluginLogoIconProvider2, (Object)pluginLogoIconProvider);
        iconCache.put(idPlugin, (Pair<PluginLogoIconProvider, PluginLogoIconProvider>)icons);
        PluginLogoIconProvider pluginLogoIconProvider4 = JBColor.isBright() ? (PluginLogoIconProvider)icons.getFirst() : (PluginLogoIconProvider)icons.getSecond();
        Intrinsics.checkNotNull((Object)pluginLogoIconProvider4);
        lazyIcon.setLogoIcon(pluginLogoIconProvider4);
    }

    private static final void putMissingIcon(String idPlugin) {
        iconCache.put(idPlugin, MISSING);
    }

    private static final PluginLogoIconProvider tryLoadIcon(Path iconFile) {
        try {
            byte[] data2 = Files.readAllBytes(iconFile);
            Intrinsics.checkNotNull((Object)data2);
            return data2.length == 0 ? null : PluginLogoKt.loadFileIcon(data2);
        }
        catch (NoSuchFileException data2) {
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.warn("Cannot load plugin icon (file=" + iconFile + ")");
            LOG.debug(e);
        }
        return null;
    }

    private static final void initLafListener$lambda$0(LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Default = null;
        HiDPIPluginLogoIcon.clearCache();
    }

    private static final void initLafListener$lambda$1() {
        Default = null;
        HiDPIPluginLogoIcon.clearCache();
    }

    public static final /* synthetic */ void access$initLafListener() {
        PluginLogoKt.initLafListener();
    }

    public static final /* synthetic */ PluginLogoIconProvider access$getIcon(IdeaPluginDescriptor descriptor2) {
        return PluginLogoKt.getIcon(descriptor2);
    }

    public static final /* synthetic */ PluginLogoIconProvider access$getDefault$p() {
        return Default;
    }

    public static final /* synthetic */ void access$setDefault$p(PluginLogoIconProvider pluginLogoIconProvider) {
        Default = pluginLogoIconProvider;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ String access$getIdForKey(IdeaPluginDescriptor descriptor2) {
        return PluginLogoKt.getIdForKey(descriptor2);
    }

    public static final /* synthetic */ void access$loadPluginIconsFromUrl(String idPlugin, LazyPluginLogoIcon lazyIcon, CoroutineContext coroutineContext) {
        PluginLogoKt.loadPluginIconsFromUrl(idPlugin, lazyIcon, coroutineContext);
    }

    public static final /* synthetic */ void access$loadPluginIconsFromExploded(Collection paths, String idPlugin, LazyPluginLogoIcon lazyIcon) {
        PluginLogoKt.loadPluginIconsFromExploded(paths, idPlugin, lazyIcon);
    }

    public static final /* synthetic */ void access$loadPluginIconsFromFile(Path path, String idPlugin, LazyPluginLogoIcon lazyIcon) {
        PluginLogoKt.loadPluginIconsFromFile(path, idPlugin, lazyIcon);
    }

    static {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakValueMap(...)");
        iconCache = concurrentMap;
        MISSING = new Pair(null, null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PluginLogo.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

