/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PendingDynamicPluginInstall;
import com.intellij.ide.plugins.PluginEnableDisableAction;
import com.intellij.ide.plugins.PluginEnabledState;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Pair;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u00106\u001a\u00020\u001e2\u0006\u00107\u001a\u00020\nJ\u000e\u00108\u001a\u00020\u001e2\u0006\u00107\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R#\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00190\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\rR\u001d\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00190\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\rR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001f\"\u0004\b \u0010!R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0012R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0012R\u001f\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010'0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\rR)\u0010)\u001a\u001a\u0012\u0004\u0012\u00020\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020'0*0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\rR\u001c\u0010-\u001a\u0004\u0018\u00010.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u001f\"\u0004\b5\u0010!\u00a8\u00069"}, d2={"Lcom/intellij/ide/plugins/newui/PluginManagerSession;", "", "sessionId", "", "<init>", "(Ljava/lang/String;)V", "getSessionId", "()Ljava/lang/String;", "dynamicPluginsToInstall", "", "Lcom/intellij/openapi/extensions/PluginId;", "Lcom/intellij/ide/plugins/PendingDynamicPluginInstall;", "getDynamicPluginsToInstall", "()Ljava/util/Map;", "pluginsToRemoveOnCancel", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "getPluginsToRemoveOnCancel", "()Ljava/util/Set;", "dynamicPluginsToUninstall", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "getDynamicPluginsToUninstall", "dependentToRequiredListMap", "getDependentToRequiredListMap", "installsInProgress", "Lcom/intellij/ide/plugins/newui/PluginUiModel;", "getInstallsInProgress", "updatesInProgress", "getUpdatesInProgress", "isUiDisposedWithApply", "", "()Z", "setUiDisposedWithApply", "(Z)V", "errorPluginsToDisable", "getErrorPluginsToDisable", "uninstalledPlugins", "getUninstalledPlugins", "pluginStates", "Lcom/intellij/ide/plugins/PluginEnabledState;", "getPluginStates", "statesDiff", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/ide/plugins/PluginEnableDisableAction;", "getStatesDiff", "updateService", "Lcom/intellij/ide/plugins/newui/PluginUpdatesService;", "getUpdateService", "()Lcom/intellij/ide/plugins/newui/PluginUpdatesService;", "setUpdateService", "(Lcom/intellij/ide/plugins/newui/PluginUpdatesService;)V", "needRestart", "getNeedRestart", "setNeedRestart", "isPluginDisabled", "pluginId", "isPluginEnabled", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class PluginManagerSession {
    @NotNull
    private final String sessionId;
    @NotNull
    private final Map<PluginId, PendingDynamicPluginInstall> dynamicPluginsToInstall;
    @NotNull
    private final Set<IdeaPluginDescriptorImpl> pluginsToRemoveOnCancel;
    @NotNull
    private final Set<IdeaPluginDescriptor> dynamicPluginsToUninstall;
    @NotNull
    private final Map<PluginId, Set<PluginId>> dependentToRequiredListMap;
    @NotNull
    private final Map<PluginId, PluginUiModel> installsInProgress;
    @NotNull
    private final Map<PluginId, PluginUiModel> updatesInProgress;
    private boolean isUiDisposedWithApply;
    @NotNull
    private final Set<PluginId> errorPluginsToDisable;
    @NotNull
    private final Set<PluginId> uninstalledPlugins;
    @NotNull
    private final Map<PluginId, PluginEnabledState> pluginStates;
    @NotNull
    private final Map<IdeaPluginDescriptor, Pair<PluginEnableDisableAction, PluginEnabledState>> statesDiff;
    @Nullable
    private PluginUpdatesService updateService;
    private boolean needRestart;

    public PluginManagerSession(@NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        this.sessionId = sessionId;
        this.dynamicPluginsToInstall = new ConcurrentHashMap();
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.pluginsToRemoveOnCancel = set;
        Set set2 = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"createConcurrentSet(...)");
        this.dynamicPluginsToUninstall = set2;
        this.dependentToRequiredListMap = new ConcurrentHashMap();
        this.installsInProgress = new ConcurrentHashMap();
        this.updatesInProgress = new ConcurrentHashMap();
        Set set3 = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"createConcurrentSet(...)");
        this.errorPluginsToDisable = set3;
        Set set4 = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set4, (String)"createConcurrentSet(...)");
        this.uninstalledPlugins = set4;
        this.pluginStates = new LinkedHashMap();
        this.statesDiff = new ConcurrentHashMap();
    }

    @NotNull
    public final String getSessionId() {
        return this.sessionId;
    }

    @NotNull
    public final Map<PluginId, PendingDynamicPluginInstall> getDynamicPluginsToInstall() {
        return this.dynamicPluginsToInstall;
    }

    @NotNull
    public final Set<IdeaPluginDescriptorImpl> getPluginsToRemoveOnCancel() {
        return this.pluginsToRemoveOnCancel;
    }

    @NotNull
    public final Set<IdeaPluginDescriptor> getDynamicPluginsToUninstall() {
        return this.dynamicPluginsToUninstall;
    }

    @NotNull
    public final Map<PluginId, Set<PluginId>> getDependentToRequiredListMap() {
        return this.dependentToRequiredListMap;
    }

    @NotNull
    public final Map<PluginId, PluginUiModel> getInstallsInProgress() {
        return this.installsInProgress;
    }

    @NotNull
    public final Map<PluginId, PluginUiModel> getUpdatesInProgress() {
        return this.updatesInProgress;
    }

    public final boolean isUiDisposedWithApply() {
        return this.isUiDisposedWithApply;
    }

    public final void setUiDisposedWithApply(boolean bl) {
        this.isUiDisposedWithApply = bl;
    }

    @NotNull
    public final Set<PluginId> getErrorPluginsToDisable() {
        return this.errorPluginsToDisable;
    }

    @NotNull
    public final Set<PluginId> getUninstalledPlugins() {
        return this.uninstalledPlugins;
    }

    @NotNull
    public final Map<PluginId, PluginEnabledState> getPluginStates() {
        return this.pluginStates;
    }

    @NotNull
    public final Map<IdeaPluginDescriptor, Pair<PluginEnableDisableAction, PluginEnabledState>> getStatesDiff() {
        return this.statesDiff;
    }

    @Nullable
    public final PluginUpdatesService getUpdateService() {
        return this.updateService;
    }

    public final void setUpdateService(@Nullable PluginUpdatesService pluginUpdatesService) {
        this.updateService = pluginUpdatesService;
    }

    public final boolean getNeedRestart() {
        return this.needRestart;
    }

    public final void setNeedRestart(boolean bl) {
        this.needRestart = bl;
    }

    public final boolean isPluginDisabled(@NotNull PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        PluginEnabledState pluginEnabledState = this.pluginStates.get(pluginId);
        return pluginEnabledState != null ? pluginEnabledState.isDisabled() : true;
    }

    public final boolean isPluginEnabled(@NotNull PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        PluginEnabledState pluginEnabledState = this.pluginStates.get(pluginId);
        return pluginEnabledState != null ? pluginEnabledState.isEnabled() : true;
    }
}

