/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginUtilsKt;
import com.intellij.ide.plugins.newui.PluginInstallationCustomization;
import com.intellij.ide.plugins.newui.PluginSource;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.plugins.newui.PluginUiModelAdapter;
import com.intellij.ide.plugins.newui.UiPluginManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformUtils;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0003\u001a\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u0002H\u0007\u001a\u000e\u0010\b\u001a\u0004\u0018\u00010\u0007*\u00020\u0002H\u0007\u001a\u000e\u0010\t\u001a\u0004\u0018\u00010\u0007*\u00020\u0002H\u0007\u001a\u0012\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b*\u00020\u0002H\u0007\u001a\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0007H\u0007\u001a \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b*\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0007*\u00020\u0002H\u0007\u001a\u001b\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\u0014\u001a\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0002H\u0007\u001a\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0007\u001a\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001a*\u0004\u0018\u00010\u001a2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"getPluginDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "Lcom/intellij/ide/plugins/newui/PluginUiModel;", "K_FORMAT", "Ljava/text/DecimalFormat;", "M_FORMAT", "presentableRating", "", "presentableDownloads", "presentableSize", "calculateTags", "", "sessionId", "customizeIfNeeded", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "presentableDate", "getTrialPeriodByProductCode", "", "code", "(Lcom/intellij/ide/plugins/newui/PluginUiModel;Ljava/lang/String;)Ljava/lang/Integer;", "isPaidPlugin", "", "addInstalledSource", "", "pluginSource", "Lcom/intellij/ide/plugins/newui/PluginSource;", "addSource", "intellij.platform.ide.impl"})
public final class PluginUiModelKt {
    @NotNull
    private static final DecimalFormat K_FORMAT = new DecimalFormat("###.#K");
    @NotNull
    private static final DecimalFormat M_FORMAT = new DecimalFormat("###.#M");

    @ApiStatus.Internal
    private static final IdeaPluginDescriptor getPluginDescriptor(PluginUiModel $this$getPluginDescriptor) {
        if ($this$getPluginDescriptor instanceof PluginUiModelAdapter) {
            return ((PluginUiModelAdapter)$this$getPluginDescriptor).getPluginDescriptor();
        }
        throw new IllegalStateException("PluginUiModelAdapter expected");
    }

    @NlsSafe
    @ApiStatus.Internal
    @Nullable
    public static final String presentableRating(@NotNull PluginUiModel $this$presentableRating) {
        Intrinsics.checkNotNullParameter((Object)$this$presentableRating, (String)"<this>");
        String string = $this$presentableRating.getRating();
        if (string == null) {
            return null;
        }
        String rating = string;
        if (StringsKt.isBlank((CharSequence)rating)) {
            return null;
        }
        try {
            double value = Double.parseDouble(rating);
            if (value > 0.0) {
                return StringsKt.removeSuffix((String)rating, (CharSequence)".0");
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    @IntellijInternalApi
    @NlsSafe
    @ApiStatus.Internal
    @Nullable
    public static final String presentableDownloads(@NotNull PluginUiModel $this$presentableDownloads) {
        Intrinsics.checkNotNullParameter((Object)$this$presentableDownloads, (String)"<this>");
        String string = $this$presentableDownloads.getDownloads();
        if (string == null) {
            return null;
        }
        String downloads = string;
        if (StringsKt.isBlank((CharSequence)downloads)) {
            return null;
        }
        try {
            long value = Long.parseLong(downloads);
            return value <= 1000L ? String.valueOf(value) : (value < 1000000L ? K_FORMAT.format((double)value / 1000.0) : M_FORMAT.format((double)value / 1000000.0));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @NlsSafe
    @ApiStatus.Internal
    @Nullable
    public static final String presentableSize(@NotNull PluginUiModel $this$presentableSize) {
        Intrinsics.checkNotNullParameter((Object)$this$presentableSize, (String)"<this>");
        String string = $this$presentableSize.getSize();
        if (string == null) {
            return null;
        }
        String size2 = string;
        if (StringsKt.isBlank((CharSequence)size2)) {
            return null;
        }
        try {
            String string2;
            long value = Long.parseLong(size2);
            if (value >= 0L) {
                String string3 = StringUtil.formatFileSize((long)value);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"formatFileSize(...)");
                String string4 = string3;
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                String string5 = string4.toUpperCase(locale);
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
            } else {
                string2 = null;
            }
            return string2;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static final List<String> calculateTags(@NotNull PluginUiModel $this$calculateTags) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateTags, (String)"<this>");
        return PluginUiModelKt.customizeIfNeeded(PluginUtilsKt.getTags($this$calculateTags.getDescriptor()), $this$calculateTags.getPluginId());
    }

    @ApiStatus.Internal
    @NotNull
    public static final List<String> calculateTags(@NotNull PluginUiModel $this$calculateTags, @NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateTags, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        List<String> result2 = PluginUtilsKt.getTags($this$calculateTags.getDescriptor());
        if (UiPluginManager.Companion.getInstance().isPluginRequiresUltimateButItIsDisabled(sessionId, $this$calculateTags.getPluginId())) {
            List list2;
            List $this$calculateTags_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$calculateTags_u24lambda_u240.addAll((Collection)result2);
            boolean bl2 = PlatformUtils.isPyCharmPro() ? $this$calculateTags_u24lambda_u240.add("Pro") : $this$calculateTags_u24lambda_u240.add("Ultimate");
            return CollectionsKt.build((List)list2);
        }
        return PluginUiModelKt.customizeIfNeeded(result2, $this$calculateTags.getPluginId());
    }

    private static final List<String> customizeIfNeeded(List<String> $this$customizeIfNeeded, PluginId pluginId) {
        PluginInstallationCustomization pluginInstallationCustomization = PluginInstallationCustomization.Companion.findPluginInstallationCustomization(pluginId);
        if (pluginInstallationCustomization == null) {
            return $this$customizeIfNeeded;
        }
        PluginInstallationCustomization customization = pluginInstallationCustomization;
        return customization.customizeTags($this$customizeIfNeeded);
    }

    @NlsSafe
    @ApiStatus.Internal
    @Nullable
    public static final String presentableDate(@NotNull PluginUiModel $this$presentableDate) {
        Intrinsics.checkNotNullParameter((Object)$this$presentableDate, (String)"<this>");
        return $this$presentableDate.getDate() > 0L && $this$presentableDate.getDate() != Long.MAX_VALUE ? PluginManagerConfigurable.DATE_FORMAT.format(new Date($this$presentableDate.getDate())) : null;
    }

    @ApiStatus.Internal
    @Nullable
    public static final Integer getTrialPeriodByProductCode(@NotNull PluginUiModel $this$getTrialPeriodByProductCode, @NotNull String code) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$getTrialPeriodByProductCode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Map<String, Integer> map2 = $this$getTrialPeriodByProductCode.getCustomTrialPeriods();
        if (map2 != null) {
            Integer n2 = $this$getTrialPeriodByProductCode.getDefaultTrialPeriod();
            Intrinsics.checkNotNull((Object)n2);
            n = map2.getOrDefault(code, n2);
        } else {
            n = null;
        }
        return n;
    }

    @ApiStatus.Internal
    public static final boolean isPaidPlugin(@NotNull PluginUiModel $this$isPaidPlugin) {
        Intrinsics.checkNotNullParameter((Object)$this$isPaidPlugin, (String)"<this>");
        return $this$isPaidPlugin.isPaid() || $this$isPaidPlugin.isConverted();
    }

    @ApiStatus.Internal
    public static final void addInstalledSource(@NotNull PluginUiModel $this$addInstalledSource, @NotNull PluginSource pluginSource) {
        Intrinsics.checkNotNullParameter((Object)$this$addInstalledSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)pluginSource), (String)"pluginSource");
        $this$addInstalledSource.setSource(PluginUiModelKt.addSource($this$addInstalledSource.getSource(), pluginSource));
    }

    @ApiStatus.Internal
    @Nullable
    public static final PluginSource addSource(@Nullable PluginSource $this$addSource, @Nullable PluginSource pluginSource) {
        if ($this$addSource == null || $this$addSource == pluginSource) {
            return pluginSource;
        }
        return PluginSource.BOTH;
    }

    public static final /* synthetic */ IdeaPluginDescriptor access$getPluginDescriptor(PluginUiModel $receiver) {
        return PluginUiModelKt.getPluginDescriptor($receiver);
    }
}

