/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.Region;
import com.intellij.ide.RegionSettings;
import com.intellij.ide.ui.LanguageAndRegionUi;
import com.intellij.ide.ui.localization.statistics.EventSource;
import com.intellij.ide.ui.localization.statistics.LocalizationActionsStatistics;
import com.intellij.l10n.LocalizationUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/ui/LanguageAndRegionConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "<init>", "()V", "initSelectionLanguage", "Ljava/util/Locale;", "initSelectionRegion", "Lcom/intellij/ide/Region;", "eventSource", "Lcom/intellij/ide/ui/localization/statistics/EventSource;", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "apply", "", "intellij.platform.ide.impl"})
public final class LanguageAndRegionConfigurable
extends BoundSearchableConfigurable {
    private Locale initSelectionLanguage;
    private Region initSelectionRegion;
    @NotNull
    private final EventSource eventSource;

    public LanguageAndRegionConfigurable() {
        String string = IdeBundle.message((String)"title.language.and.region", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, "language-region-settings", "preferences.language.and.region");
        this.eventSource = EventSource.SETTINGS;
    }

    @NotNull
    public DialogPanel createPanel() {
        this.initSelectionLanguage = LocalizationUtil.INSTANCE.getLocale(true);
        Region region = RegionSettings.getRegion();
        Intrinsics.checkNotNullExpressionValue((Object)region, (String)"getRegion(...)");
        this.initSelectionRegion = region;
        return BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> LanguageAndRegionConfigurable.createPanel$lambda$0(this, arg_0)));
    }

    public void apply() {
        block8: {
            Region region;
            Locale locale;
            Region selectedRegion;
            Locale selectedLocale;
            block7: {
                super.apply();
                selectedLocale = LocalizationUtil.INSTANCE.getLocale(true);
                Region region2 = RegionSettings.getRegion();
                Intrinsics.checkNotNullExpressionValue((Object)region2, (String)"getRegion(...)");
                selectedRegion = region2;
                Locale locale2 = this.initSelectionLanguage;
                if (locale2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"initSelectionLanguage");
                    locale2 = null;
                }
                if (!Intrinsics.areEqual((Object)locale2.toLanguageTag(), (Object)selectedLocale.toLanguageTag())) break block7;
                Region region3 = this.initSelectionRegion;
                if (region3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"initSelectionRegion");
                    region3 = null;
                }
                if (region3 == selectedRegion) break block8;
            }
            if ((locale = this.initSelectionLanguage) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"initSelectionLanguage");
                locale = null;
            }
            if ((region = this.initSelectionRegion) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"initSelectionRegion");
                region = null;
            }
            LocalizationActionsStatistics.INSTANCE.settingsUpdated(selectedLocale, locale, selectedRegion, region, this.eventSource);
            LanguageAndRegionUi.showRestartDialog$default(LanguageAndRegionUi.INSTANCE, false, 1, null);
        }
    }

    private static final Unit createPanel$lambda$0(LanguageAndRegionConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Disposable disposable = this$0.getDisposable();
        Intrinsics.checkNotNull((Object)disposable);
        LanguageAndRegionUi.INSTANCE.createContent($this$panel, null, disposable, null, this$0.eventSource);
        return Unit.INSTANCE;
    }
}

