/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.ide.ui.laf.intellij.IdeaPopupMenuUI;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.WindowRoundedCornersManager;
import com.intellij.ui.popup.HeavyWeightPopup;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/ui/laf/OurPopupFactory;", "Ljavax/swing/PopupFactory;", "delegate", "<init>", "(Ljavax/swing/PopupFactory;)V", "getPopup", "Ljavax/swing/Popup;", "owner", "Ljava/awt/Component;", "contents", "x", "", "y", "Companion", "intellij.platform.ide.impl"})
final class OurPopupFactory
extends PopupFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PopupFactory delegate;
    public static final int WEIGHT_LIGHT = 0;
    public static final int WEIGHT_MEDIUM = 1;
    public static final int WEIGHT_HEAVY = 2;

    public OurPopupFactory(@NotNull PopupFactory delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public Popup getPopup(@NotNull Component owner, @NotNull Component contents, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        Point point = OurPopupFactory.Companion.fixPopupLocation(contents, x, y);
        int popupType = PopupUtil.getPopupType((PopupFactory)this);
        if (popupType >= 0) {
            PopupUtil.setPopupType((PopupFactory)this.delegate, (int)popupType);
        }
        Popup popup2 = this.delegate.getPopup(owner, contents, point.x, point.y);
        Window window = ComponentUtil.getWindow((Component)contents);
        if (!(window instanceof RootPaneContainer) || window == ComponentUtil.getWindow((Component)owner)) {
            Popup popup3 = popup2;
            Intrinsics.checkNotNull((Object)popup3);
            return popup3;
        }
        popup2 = new HeavyWeightPopup(popup2, window);
        JRootPane rootPane = ((RootPaneContainer)((Object)window)).getRootPane();
        Intrinsics.checkNotNull((Object)rootPane);
        rootPane.setGlassPane(new IdeGlassPaneImpl(rootPane, false));
        rootPane.putClientProperty("Window.alpha", Float.valueOf(1.0f));
        window.addWindowListener(new WindowAdapter(rootPane, window){
            final /* synthetic */ JRootPane $rootPane;
            final /* synthetic */ Window $window;
            {
                this.$rootPane = $rootPane;
                this.$window = $window;
            }

            public void windowOpened(WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (PopupUtil.getPopupContainerFor((Component)this.$rootPane) != null) {
                    this.$window.removeWindowListener(this);
                }
            }

            public void windowClosed(WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$window.removeWindowListener(this);
                DialogWrapper.cleanupRootPane((JRootPane)this.$rootPane);
                DialogWrapper.cleanupWindowListeners((Window)this.$window);
            }
        });
        if ((IdeaPopupMenuUI.isUnderPopup(contents) || SystemInfoRt.isWindows || IdeaPopupMenuUI.isUnderMainMenu(contents)) && WindowRoundedCornersManager.isAvailable()) {
            if (SystemInfoRt.isMac && StartupUiUtil.INSTANCE.isDarkTheme() || SystemInfoRt.isWindows) {
                WindowRoundedCornersManager.setRoundedCorners(window, JBUI.CurrentTheme.Popup.borderColor((boolean)true));
            } else {
                WindowRoundedCornersManager.setRoundedCorners(window);
            }
            if (SystemInfoRt.isMac) {
                Container container = ((RootPaneContainer)((Object)window)).getContentPane();
                Intrinsics.checkNotNull((Object)container, (String)"null cannot be cast to non-null type javax.swing.JComponent");
                JComponent contentPane = (JComponent)container;
                contentPane.setOpaque(true);
                contentPane.setBackground(contents.getBackground());
            }
        }
        return popup2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/ui/laf/OurPopupFactory$Companion;", "", "<init>", "()V", "WEIGHT_LIGHT", "", "WEIGHT_MEDIUM", "WEIGHT_HEAVY", "fixPopupLocation", "Ljava/awt/Point;", "contents", "Ljava/awt/Component;", "x", "y", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final Point fixPopupLocation(Component contents, int x, int y) {
            PointerInfo invoker2;
            int y2 = y;
            if (!(contents instanceof JToolTip)) {
                if (IdeaPopupMenuUI.isUnderPopup(contents)) {
                    int topBorder = JBUI.insets((String)"PopupMenu.borderInsets", (JBInsets)JBInsets.emptyInsets()).top;
                    Intrinsics.checkNotNull((Object)contents, (String)"null cannot be cast to non-null type javax.swing.JPopupMenu");
                    Component invoker2 = ((JPopupMenu)contents).getInvoker();
                    if (invoker2 instanceof ActionMenu) {
                        y2 -= topBorder / 2;
                        if (SystemInfoRt.isMac) {
                            y2 += JBUI.scale((int)1);
                        }
                    } else {
                        y2 -= topBorder;
                        y2 -= JBUI.scale((int)1);
                    }
                }
                return new Point(x, y2);
            }
            try {
                invoker2 = MouseInfo.getPointerInfo();
            }
            catch (InternalError internalError) {
                return new Point(x, y2);
            }
            PointerInfo info = invoker2;
            int deltaY = 0;
            if (info != null) {
                Point mouse = info.getLocation();
                deltaY = mouse.y - y2;
            }
            Dimension size2 = ((JToolTip)contents).getPreferredSize();
            Rectangle rec = new Rectangle(new Point(x, y2), size2);
            ScreenUtil.moveRectangleToFitTheScreen((Rectangle)rec);
            if (rec.y < y2) {
                rec.y += deltaY;
            }
            Point point = rec.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocation(...)");
            return point;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

