/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.ui.DarculaSliderUIThemes;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.ui.JBInsets;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.plaf.basic.BasicSliderUI;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 12\u00020\u0001:\u00011B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J8\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J8\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\b\u0010\u0016\u001a\u00020\tH\u0014J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\"\u0010\u001a\u001a\u00020\u000f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000fH\u0016J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020\tH\u0014J\b\u0010#\u001a\u00020\tH\u0014J\b\u0010$\u001a\u00020\tH\u0014J\b\u0010%\u001a\u00020\u000fH\u0014J\u0012\u0010&\u001a\u00020\t2\b\u0010'\u001a\u0004\u0018\u00010(H\u0014J \u0010)\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000fH\u0014J \u0010-\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000fH\u0014J \u0010.\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+2\u0006\u0010/\u001a\u00020\u000fH\u0014J \u00100\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+2\u0006\u0010/\u001a\u00020\u000fH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/ide/ui/laf/darcula/ui/DarculaSliderUI;", "Ljavax/swing/plaf/basic/BasicSliderUI;", "b", "Ljavax/swing/JComponent;", "<init>", "(Ljavax/swing/JComponent;)V", "theme", "Lcom/intellij/ide/ui/laf/darcula/ui/DarculaSliderUIThemes;", "paintThumb", "", "g", "Ljava/awt/Graphics;", "getHPath", "Ljava/awt/geom/GeneralPath;", "x1", "", "y1", "x2", "y2", "x3", "y3", "getVPath", "calculateThumbLocation", "setThumbLocation", "x", "y", "getBaseline", "c", "width", "height", "paintTrack", "paintFocus", "getThumbSize", "Ljava/awt/Dimension;", "calculateTrackBuffer", "calculateLabelRect", "calculateTickRect", "getTickLength", "installDefaults", "slider", "Ljavax/swing/JSlider;", "paintMinorTickForHorizSlider", "tickBounds", "Ljava/awt/Rectangle;", "x_", "paintMajorTickForHorizSlider", "paintMinorTickForVertSlider", "y_", "paintMajorTickForVertSlider", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public class DarculaSliderUI
extends BasicSliderUI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DarculaSliderUIThemes theme;

    public DarculaSliderUI(@Nullable JComponent b) {
        Intrinsics.checkNotNull((Object)b, (String)"null cannot be cast to non-null type javax.swing.JSlider");
        super((JSlider)b);
        this.theme = new DarculaSliderUIThemes();
    }

    public /* synthetic */ DarculaSliderUI(JComponent jComponent, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            jComponent = null;
        }
        this(jComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintThumb(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            GeneralPath path;
            if (this.slider.getOrientation() == 0) {
                x1 = this.thumbRect.x + this.theme.getFocusBorderThickness();
                x2 = x1 + this.thumbRect.width - this.theme.getFocusBorderThickness() * 2;
                x3 = this.theme.getThumbHalfWidth() + 1 + x1;
                y1 = this.thumbRect.y + this.theme.getFocusBorderThickness();
                y2 = y1 + this.theme.getThumbOverhang();
                y3 = y1 + this.thumbRect.height - this.theme.getFocusBorderThickness() * 2;
                v1 = this.getHPath(x1, y1, x2, y2, x3, y3);
            } else {
                x1 = this.thumbRect.x + this.theme.getFocusBorderThickness();
                x2 = x1 + this.theme.getThumbOverhang();
                x3 = x1 + this.thumbRect.width - this.theme.getFocusBorderThickness() * 2;
                y1 = this.thumbRect.y + this.theme.getFocusBorderThickness();
                y2 = y1 + this.theme.getThumbHalfWidth() + 1;
                y3 = y1 + this.thumbRect.height - this.theme.getFocusBorderThickness() * 2;
                v1 = path = this.getVPath(x1, y1, x2, x3, y2, y3);
            }
            if (this.slider.hasFocus()) {
                g2d.setStroke(new BasicStroke(this.theme.getFocusBorderThickness() + this.theme.getBorderThickness()));
                g2d.setPaint(this.theme.getFocusedOuterColor());
                g2d.draw(path);
            }
            g2d.setPaint(this.slider.isEnabled() ? (Paint)this.theme.getButtonColor() : (Paint)this.theme.getDisabledButtonColor());
            g2d.fill(path);
            g2d.setPaint(this.slider.hasFocus() ? (Paint)this.theme.getFocusedBorderColor() : (this.slider.isEnabled() ? (Paint)this.theme.getButtonBorderColor() : (Paint)this.theme.getDisabledButtonBorderColor()));
            g2d.setStroke(new BasicStroke(this.theme.getBorderThickness()));
            g2d.draw(path);
        }
        finally {
            g2d.dispose();
        }
    }

    private final GeneralPath getHPath(int x1, int y1, int x2, int y2, int x3, int y3) {
        GeneralPath path = new GeneralPath();
        path.moveTo((double)(x1 + this.theme.getArc()), (double)y1);
        path.lineTo((double)(x2 - this.theme.getArc()), (double)y1);
        path.lineTo((double)x2, (double)(y1 + this.theme.getArc()));
        path.lineTo((double)x2, (double)y2);
        path.lineTo((double)x3, (double)y3);
        path.lineTo((double)x1, (double)y2);
        path.lineTo((double)x1, (double)(y1 + this.theme.getArc()));
        path.lineTo((double)x1 + (double)this.theme.getArc(), (double)y1);
        path.closePath();
        return path;
    }

    private final GeneralPath getVPath(int x1, int y1, int x2, int x3, int y2, int y3) {
        GeneralPath path = new GeneralPath();
        path.moveTo((double)(x1 + this.theme.getArc()), (double)y1);
        path.lineTo((double)x2, (double)y1);
        path.lineTo((double)x3, (double)y2);
        path.lineTo((double)x2, (double)y3);
        path.lineTo((double)(x1 + this.theme.getArc()), (double)y3);
        path.lineTo((double)x1, (double)(y3 - this.theme.getArc()));
        path.lineTo((double)x1, (double)(y1 + this.theme.getArc()));
        path.lineTo((double)(x1 + this.theme.getArc()), (double)y1);
        path.closePath();
        return path;
    }

    @Override
    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        if (this.slider.getOrientation() == 0) {
            int valuePosition = this.xPositionForValue(this.slider.getValue());
            this.thumbRect.x = valuePosition - this.theme.getFocusedThumbHalfWidth();
            this.thumbRect.y = this.trackRect.y;
        } else {
            int valuePosition = this.yPositionForValue(this.slider.getValue());
            this.thumbRect.x = this.trackRect.x;
            this.thumbRect.y = valuePosition - this.theme.getFocusedThumbHalfWidth();
        }
    }

    @Override
    public void setThumbLocation(int x, int y) {
        super.setThumbLocation(x, y);
        this.slider.repaint();
    }

    @Override
    public int getBaseline(@Nullable JComponent c, int width, int height) {
        if (this.slider.getOrientation() == 0) {
            return this.theme.getThumbOverhang() + 2 * this.theme.getFocusBorderThickness() + this.slider.getInsets().top + this.theme.getBorderThickness();
        }
        return super.getBaseline(c, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTrack(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setPaint(this.slider.isEnabled() ? (Paint)this.theme.getTrackColor() : (Paint)this.theme.getDisabledTrackColor());
        try {
            if (this.slider.getOrientation() == 0) {
                int y = this.thumbRect.y + this.theme.getFocusBorderThickness() + this.theme.getThumbOverhang() - this.theme.getTrackThickness();
                LinePainter2D.paint((Graphics2D)g2d, (double)this.trackRect.getX(), (double)y, (double)this.trackRect.getMaxX(), (double)y, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)this.theme.getTrackThickness());
            } else {
                int x = this.thumbRect.x + this.theme.getFocusBorderThickness() + this.theme.getThumbOverhang() - this.theme.getTrackThickness();
                LinePainter2D.paint((Graphics2D)g2d, (double)x, (double)this.trackRect.y, (double)x, (double)this.trackRect.getMaxY(), (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)this.theme.getTrackThickness());
            }
        }
        finally {
            g2d.dispose();
        }
    }

    @Override
    public void paintFocus(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.paintThumb(g);
    }

    @Override
    @NotNull
    protected Dimension getThumbSize() {
        int width = this.theme.getFocusedThumbHalfWidth() * 2 + 1;
        return this.slider.getOrientation() == 0 ? new Dimension(width, this.theme.getThumbHeight()) : new Dimension(this.theme.getThumbHeight(), width);
    }

    @Override
    protected void calculateTrackBuffer() {
        if (this.slider.getPaintLabels() && this.slider.getLabelTable() != null) {
            Component highLabel = this.getHighestValueLabel();
            Component lowLabel = this.getLowestValueLabel();
            if (this.slider.getOrientation() == 0) {
                if (highLabel != null && lowLabel != null) {
                    this.trackBuffer = RangesKt.coerceAtLeast((int)highLabel.getBounds().width, (int)lowLabel.getBounds().width) / 2;
                }
                this.trackBuffer = RangesKt.coerceAtLeast((int)this.trackBuffer, (int)this.theme.getFocusedThumbHalfWidth());
            } else {
                if (highLabel != null && lowLabel != null) {
                    this.trackBuffer = RangesKt.coerceAtLeast((int)highLabel.getBounds().height, (int)lowLabel.getBounds().height) / 2;
                }
                this.trackBuffer = RangesKt.coerceAtLeast((int)this.trackBuffer, (int)this.theme.getFocusedThumbHalfWidth()) + 1;
            }
        } else {
            this.trackBuffer = this.theme.getFocusedThumbHalfWidth() + 1;
        }
    }

    @Override
    protected void calculateLabelRect() {
        super.calculateLabelRect();
        if (this.slider.getOrientation() == 0) {
            Rectangle rectangle = this.labelRect;
            rectangle.y += this.theme.getTickBottom();
        } else {
            Rectangle rectangle = this.labelRect;
            rectangle.x += this.theme.getTickBottom();
        }
    }

    @Override
    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.theme.getFocusBorderThickness() + this.theme.getThumbOverhang() + this.theme.getTickTop();
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.slider.getPaintTicks() ? this.getTickLength() : 0;
        } else {
            this.tickRect.width = this.slider.getPaintTicks() ? this.getTickLength() : 0;
            this.tickRect.x = this.slider.getComponentOrientation().isLeftToRight() ? this.trackRect.x + this.theme.getFocusBorderThickness() + this.theme.getThumbOverhang() + this.theme.getTickTop() : this.trackRect.x - (this.theme.getFocusBorderThickness() + this.theme.getThumbOverhang() + this.theme.getTickTop());
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
        }
    }

    @Override
    protected int getTickLength() {
        return this.theme.getMajorTickHeight();
    }

    @Override
    protected void installDefaults(@Nullable JSlider slider) {
        LookAndFeel.installColorsAndFont(slider, "Slider.background", "Slider.foreground", "Slider.font");
        this.focusInsets = (Insets)JBInsets.emptyInsets();
    }

    @Override
    protected void paintMinorTickForHorizSlider(@NotNull Graphics g, @NotNull Rectangle tickBounds, int x_) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)tickBounds, (String)"tickBounds");
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        ((Graphics2D)g).setColor(this.slider.isEnabled() ? this.theme.getTickColor() : this.theme.getDisabledTickColor());
        int x = x_ + 1;
        ((Graphics2D)g).setStroke(new BasicStroke(this.theme.getBorderThickness()));
        g.drawLine(x, 0, x, this.theme.getMinorTickHeight());
    }

    @Override
    protected void paintMajorTickForHorizSlider(@NotNull Graphics g, @NotNull Rectangle tickBounds, int x_) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)tickBounds, (String)"tickBounds");
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        ((Graphics2D)g).setColor(this.slider.isEnabled() ? this.theme.getTickColor() : this.theme.getDisabledTickColor());
        int x = x_ + 1;
        ((Graphics2D)g).setStroke(new BasicStroke(this.theme.getBorderThickness()));
        g.drawLine(x, 0, x, this.theme.getMajorTickHeight());
    }

    @Override
    protected void paintMinorTickForVertSlider(@NotNull Graphics g, @NotNull Rectangle tickBounds, int y_) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)tickBounds, (String)"tickBounds");
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        ((Graphics2D)g).setColor(this.slider.isEnabled() ? this.theme.getTickColor() : this.theme.getDisabledTickColor());
        int y = y_ + 1;
        ((Graphics2D)g).setStroke(new BasicStroke(this.theme.getBorderThickness()));
        g.drawLine(0, y, this.theme.getMinorTickHeight(), y);
    }

    @Override
    protected void paintMajorTickForVertSlider(@NotNull Graphics g, @NotNull Rectangle tickBounds, int y_) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)tickBounds, (String)"tickBounds");
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        ((Graphics2D)g).setColor(this.slider.isEnabled() ? this.theme.getTickColor() : this.theme.getDisabledTickColor());
        int y = y_ + 1;
        ((Graphics2D)g).setStroke(new BasicStroke(this.theme.getBorderThickness()));
        g.drawLine(0, y, this.theme.getMajorTickHeight(), y);
    }

    public DarculaSliderUI() {
        this(null, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final DarculaSliderUI createUI(@NotNull JComponent c) {
        return Companion.createUI(c);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/ui/laf/darcula/ui/DarculaSliderUI$Companion;", "", "<init>", "()V", "createUI", "Lcom/intellij/ide/ui/laf/darcula/ui/DarculaSliderUI;", "c", "Ljavax/swing/JComponent;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DarculaSliderUI createUI(@NotNull JComponent c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            return new DarculaSliderUI(c);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

