/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.laf.MouseDragSelectionEventHandler;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.FontUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class TextFieldWithPopupHandlerUI
extends BasicTextFieldUI
implements Condition {
    @NonNls
    private static final String DOCUMENT = "document";
    @NonNls
    private static final String MONOSPACED = "monospaced";
    @NonNls
    private static final String VARIANT = "JTextField.variant";
    @NonNls
    private static final String INPLACE_HISTORY = "JTextField.Search.InplaceHistory";
    @NonNls
    private static final String ON_CLEAR = "JTextField.Search.CancelAction";
    @NonNls
    private static final String SEARCH_ICON = "JTextField.Search.Icon";
    @NonNls
    private static final String HISTORY_POPUP_ENABLED = "History.Popup.Enabled";
    @NonNls
    private static final String SEARCH_VARIANT_VALUE = "search";
    private final LinkedHashMap<String, IconHolder> icons = new LinkedHashMap();
    private final Handler handler = new Handler();
    private boolean monospaced;
    private Object variant;
    private int cursor;

    protected Icon getSearchIcon(boolean hovered, boolean clickable) {
        return clickable ? AllIcons.Actions.SearchWithHistory : AllIcons.Actions.Search;
    }

    protected int getSearchIconPreferredSpace() {
        Icon icon2 = this.getSearchIcon(true, TextFieldWithPopupHandlerUI.isSearchFieldWithHistoryPopup(this.getComponent()));
        return icon2 == null ? 0 : icon2.getIconWidth() + this.getSearchIconGap();
    }

    protected int getSearchIconGap() {
        return JBUIScale.scale((int)2);
    }

    protected Icon getClearIcon(boolean hovered, boolean clickable) {
        return !clickable ? null : (hovered ? AllIcons.Actions.CloseHovered : AllIcons.Actions.Close);
    }

    protected int getClearIconPreferredSpace() {
        Icon icon2 = this.getClearIcon(true, true);
        return icon2 == null ? 0 : icon2.getIconWidth() + this.getClearIconGap();
    }

    protected int getClearIconGap() {
        return JBUIScale.scale((int)2);
    }

    protected boolean hasText() {
        JTextComponent component2 = this.getComponent();
        return component2 != null && !Strings.isEmpty((String)component2.getText());
    }

    private void updateIconsLayout(Rectangle bounds) {
        JTextComponent c = this.getComponent();
        JBInsets margin = ComponentUtil.getParentOfType(JComboBox.class, (Component)c) != null || ComponentUtil.getParentOfType(JSpinner.class, (Component)c) != null || ClientProperty.isTrue((Component)c, (Object)"TextFieldWithoutMargins") ? JBInsets.emptyInsets() : this.getDefaultMargins();
        JBInsets.removeFrom((Rectangle)bounds, (Insets)c.getInsets());
        JBInsets.removeFrom((Rectangle)bounds, (Insets)margin);
        for (IconHolder holder : this.icons.values()) {
            int gap = holder.extension.getIconGap();
            if (holder.extension.isIconBeforeText()) {
                int offset = holder.extension.getAfterIconOffset();
                holder.bounds.x = bounds.x;
                int extensionWidth = holder.bounds.width + gap + offset;
                bounds.x += extensionWidth;
                bounds.width -= extensionWidth;
                margin.left += extensionWidth;
            } else {
                holder.bounds.x = bounds.x + bounds.width - holder.bounds.width;
                int extensionWidth = holder.bounds.width + gap;
                bounds.width -= extensionWidth;
                margin.right += extensionWidth;
            }
            int top = (bounds.height - holder.bounds.height) / 2;
            if (top > gap) {
                boolean multiline;
                JTextComponent component2 = this.getComponent();
                boolean bl = multiline = component2 != null && !Boolean.TRUE.equals(component2.getDocument().getProperty("filterNewlines"));
                if (multiline) {
                    top = gap;
                }
            }
            holder.bounds.y = bounds.y + top;
            if (holder.iconButton == null) continue;
            holder.iconButton.setBounds(holder.bounds);
        }
        if (!Objects.equals(c.getMargin(), margin)) {
            c.setMargin((Insets)margin);
        }
    }

    protected SearchAction getActionUnder(@NotNull Point p) {
        if (p == null) {
            TextFieldWithPopupHandlerUI.$$$reportNull$$$0(0);
        }
        return null;
    }

    protected void showSearchPopup() {
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (SystemInfo.isMacOSCatalina) {
            JTextComponent component2 = this.getComponent();
            component2.setFont(FontUtil.disableKerning((Font)component2.getFont()));
        }
    }

    @Override
    protected void installListeners() {
        JTextComponent component2 = this.getComponent();
        this.handler.installListener(component2.getDocument());
        component2.addPropertyChangeListener(this.handler);
        component2.addMouseMotionListener(this.handler);
        component2.addMouseListener(this.handler);
        component2.addFocusListener(this.handler);
        this.setVariant(component2.getClientProperty(VARIANT));
        this.setMonospaced(component2.getClientProperty(MONOSPACED));
    }

    @Override
    protected void uninstallListeners() {
        JTextComponent component2 = this.getComponent();
        component2.removeFocusListener(this.handler);
        component2.removeMouseListener(this.handler);
        component2.removeMouseMotionListener(this.handler);
        component2.removePropertyChangeListener(this.handler);
        this.handler.uninstallListener(component2.getDocument());
        for (IconHolder holder : this.icons.values()) {
            JButton jButton = holder.iconButton;
            if (!(jButton instanceof IconButton)) continue;
            IconButton iconButton = (IconButton)jButton;
            iconButton.removeListeners();
        }
    }

    @Override
    public int getNextVisualPositionFrom(JTextComponent t, int pos, Position.Bias b, int direction, Position.Bias[] biasRet) throws BadLocationException {
        int position = DarculaUIUtil.getPatchedNextVisualPositionFrom(t, pos, direction);
        return position != -1 ? position : super.getNextVisualPositionFrom(t, pos, b, direction, biasRet);
    }

    @Override
    protected Caret createCaret() {
        return new MouseDragAwareCaret();
    }

    public boolean value(Object o) {
        MouseEvent me;
        if (o instanceof MouseEvent && this.getActionUnder((me = (MouseEvent)o).getPoint()) != null) {
            if (me.getID() == 500) {
                SwingUtilities.invokeLater(() -> this.handler.mouseClicked(me));
            }
            return true;
        }
        return false;
    }

    public static boolean isSearchField(Component c) {
        if (!(c instanceof JTextField)) {
            return false;
        }
        Object variant = ((JTextField)c).getClientProperty(VARIANT);
        return SEARCH_VARIANT_VALUE.equals(variant) || "searchWithJbPopup".equals(variant);
    }

    @Nullable
    public static AbstractAction getNewLineAction(Component c) {
        if (!TextFieldWithPopupHandlerUI.isSearchField(c)) {
            return null;
        }
        Object action2 = ((JTextField)c).getClientProperty("JTextField.Search.NewLineAction");
        return action2 instanceof AbstractAction ? (AbstractAction)action2 : null;
    }

    @TestOnly
    @NotNull
    public Point getExtensionIconLocation(@NotNull String extensionName) {
        IconHolder iconHolder;
        if (extensionName == null) {
            TextFieldWithPopupHandlerUI.$$$reportNull$$$0(1);
        }
        if ((iconHolder = this.icons.get(extensionName)) == null) {
            throw new IllegalArgumentException("The " + extensionName + " extension does not exist in this text field");
        }
        Point point = iconHolder.bounds.getLocation();
        if (point == null) {
            TextFieldWithPopupHandlerUI.$$$reportNull$$$0(2);
        }
        return point;
    }

    @NotNull
    public Rectangle getExtensionIconBounds(@NotNull ExtendableTextComponent.Extension extension) {
        if (extension == null) {
            TextFieldWithPopupHandlerUI.$$$reportNull$$$0(3);
        }
        for (IconHolder holder : this.icons.values()) {
            if (holder.extension != extension) continue;
            return new Rectangle(holder.bounds);
        }
        throw new IllegalArgumentException("The " + String.valueOf(extension) + " extension does not exist in this text field");
    }

    @Override
    public String getToolTipText(JTextComponent component2, Point point) {
        if (!this.icons.isEmpty() && component2 != null && component2.isEnabled()) {
            for (IconHolder holder : this.icons.values()) {
                if (!holder.bounds.contains(point)) continue;
                return holder.extension.getTooltip();
            }
        }
        return super.getToolTipText(component2, point);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension size2 = super.getMinimumSize(c);
        if (size2 != null) {
            this.updatePreferredSize(c, size2);
        }
        return size2;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size2 = super.getPreferredSize(c);
        if (size2 != null) {
            int columns;
            JTextComponent component2 = this.getComponent();
            int n = columns = component2 instanceof JTextField ? ((JTextField)component2).getColumns() : 0;
            if (columns != 0) {
                Insets insets = component2.getInsets();
                FontMetrics fm = component2.getFontMetrics(component2.getFont());
                size2.width = columns * fm.charWidth('m') + insets.left + insets.right;
            }
            this.updatePreferredSize(component2, size2);
        }
        return size2;
    }

    protected void updatePreferredSize(JComponent c, Dimension size2) {
        if (!TextFieldWithPopupHandlerUI.isUnderComboBox(c)) {
            JBInsets.addTo((Dimension)size2, (Insets)this.getDefaultMargins());
            size2.width += this.icons.values().stream().mapToInt(h -> h.extension.getPreferredSpace()).sum();
            size2.height = Math.max(size2.height, this.getMinimumHeight(size2.height));
            size2.width = Math.max(size2.width, JBUI.CurrentTheme.TextField.minimumSize().width);
        }
    }

    private static boolean isUnderComboBox(JComponent c) {
        Container parent = c.getParent();
        return parent instanceof JComboBox || parent != null && parent.getParent() instanceof JComboBox;
    }

    protected int getMinimumHeight(int textHeight) {
        return 0;
    }

    protected Insets getDefaultMargins() {
        return JBInsets.emptyInsets();
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        JTextComponent c = this.getComponent();
        Rectangle bounds = new Rectangle(c.getSize());
        this.updateIconsLayout(bounds);
        return bounds;
    }

    @Override
    protected void paintSafely(Graphics g) {
        JTextComponent component2 = this.getComponent();
        if (!component2.isOpaque()) {
            this.paintBackground(g);
        }
        Shape clip = g.getClip();
        super.paintSafely(g);
        if (!this.icons.isEmpty()) {
            g.setClip(clip);
            for (IconHolder holder : this.icons.values()) {
                if (holder.icon == null) continue;
                this.paintHolder(g, holder);
            }
        }
    }

    @Override
    public int viewToModel(JTextComponent tc, Point pt, Position.Bias[] biasReturn) {
        return this.icons.values().stream().anyMatch(p -> p.bounds.contains(pt)) ? -1 : super.viewToModel(tc, pt, biasReturn);
    }

    private void paintHolder(@NotNull Graphics g, @NotNull IconHolder holder) {
        if (g == null) {
            TextFieldWithPopupHandlerUI.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            TextFieldWithPopupHandlerUI.$$$reportNull$$$0(5);
        }
        if (holder.iconButton != null) {
            return;
        }
        holder.paintBackground(g, holder.bounds);
        if (holder.icon != null) {
            holder.icon.paintIcon(this.getComponent(), g, holder.bounds.x + (holder.bounds.width - holder.icon.getIconWidth()) / 2, holder.bounds.y + (holder.bounds.height - holder.icon.getIconHeight()) / 2);
        }
    }

    private void repaint(boolean invalid) {
        JTextComponent component2 = this.getComponent();
        if (component2 != null) {
            if (invalid) {
                component2.revalidate();
            }
            component2.repaint();
        }
    }

    private void updateIcon(IconHolder holder) {
        Icon icon2;
        if (holder != null && holder.icon != (icon2 = holder.extension.getIcon(holder.hovered))) {
            this.repaint(holder.setIcon(icon2));
        }
    }

    private void handleMouse(MouseEvent event, boolean run2) {
        JTextComponent component2 = this.getComponent();
        if (component2 != null) {
            Runnable action2;
            IconHolder result2 = this.getIconHolder(component2, event.getX(), event.getY());
            Runnable runnable2 = action2 = result2 == null ? null : result2.extension.getActionOnClick();
            if (action2 == null) {
                this.setCursor(2);
            } else {
                this.setCursor(12);
                if (run2) {
                    action2.run();
                    this.getIconHolder(component2, event.getX(), event.getY());
                    event.consume();
                }
            }
        }
    }

    @Nullable
    private IconHolder getIconHolder(@NotNull JTextComponent component2, int x, int y) {
        if (component2 == null) {
            TextFieldWithPopupHandlerUI.$$$reportNull$$$0(6);
        }
        boolean invalid = false;
        boolean repaint = false;
        IconHolder result2 = null;
        for (IconHolder holder : this.icons.values()) {
            Icon icon2;
            boolean hovered;
            boolean bl = hovered = component2.isEnabled() && holder.bounds.contains(x, y);
            if (ExperimentalUI.isNewUI()) {
                repaint |= hovered != holder.hovered;
            }
            holder.hovered = hovered;
            if (holder.hovered) {
                result2 = holder;
            }
            if (holder.icon == (icon2 = holder.extension.getIcon(holder.hovered))) continue;
            if (holder.setIcon(icon2)) {
                invalid = true;
            }
            repaint = true;
        }
        if (repaint) {
            this.repaint(invalid);
        }
        return result2;
    }

    private void setCursor(int cursor) {
        if (this.cursor != cursor) {
            this.cursor = cursor;
            JTextComponent component2 = this.getComponent();
            if (component2 != null) {
                component2.setCursor(Cursor.getPredefinedCursor(cursor));
            }
        }
    }

    private void setVariant(Object variant) {
        if (!Objects.equals(this.variant, variant)) {
            this.variant = variant;
            JTextComponent component2 = this.getComponent();
            if (component2 != null) {
                for (IconHolder holder : this.icons.values()) {
                    JButton jButton = holder.iconButton;
                    if (!(jButton instanceof IconButton)) continue;
                    IconButton iconButton = (IconButton)jButton;
                    iconButton.removeListeners();
                    component2.remove(iconButton);
                }
            }
            this.icons.clear();
            if ("extendable".equals(variant)) {
                if (component2 instanceof ExtendableTextComponent) {
                    ExtendableTextComponent field = (ExtendableTextComponent)component2;
                    for (ExtendableTextComponent.Extension extension : field.getExtensions()) {
                        if (extension == null) continue;
                        this.addExtension(extension);
                    }
                }
            } else if (SEARCH_VARIANT_VALUE.equals(variant)) {
                Object extension = this.getComponent().getClientProperty("search.extension");
                if (extension instanceof ExtendableTextComponent.Extension) {
                    this.addExtension((ExtendableTextComponent.Extension)extension);
                }
                this.addExtension(new SearchExtension());
                if (this.getComponent().getClientProperty("JTextField.Search.HideClearAction") == null) {
                    this.addExtension(new ClearExtension());
                }
            }
        }
        this.updateIconsLayout(new Rectangle(this.getComponent().getSize()));
    }

    protected void addExtension(ExtendableTextComponent.Extension extension) {
        IconHolder holder = new IconHolder(extension);
        this.icons.put(extension.toString(), holder);
        JTextComponent component2 = this.getComponent();
        if (component2 != null && holder.iconButton != null) {
            component2.add(holder.iconButton);
            holder.iconButton.setEnabled(component2.isEnabled());
        }
    }

    private void setMonospaced(Object value) {
        boolean monospaced = Boolean.TRUE.equals(value);
        if (this.monospaced != monospaced) {
            Font font;
            this.monospaced = monospaced;
            JTextComponent component2 = this.getComponent();
            if (component2 != null && ((font = component2.getFont()) == null || font instanceof UIResource)) {
                font = UIManager.getFont(this.getPropertyPrefix() + ".font");
                if (font == null) {
                    font = UIManager.getFont("TextField.font");
                }
                if (font == null) {
                    font = UIManager.getFont("Label.font");
                }
                component2.setFont(!monospaced ? (!SystemInfo.isMacOSCatalina ? font : FontUtil.disableKerning((Font)font)) : EditorUtil.getEditorFont(font.getSize()));
            }
        }
    }

    public static boolean isSearchFieldWithHistoryPopup(Component c) {
        if (c instanceof JComponent) {
            Object historyPopupEnabled = ((JComponent)c).getClientProperty(HISTORY_POPUP_ENABLED);
            boolean searchPopupDisabled = historyPopupEnabled != null && historyPopupEnabled.equals(false);
            return TextFieldWithPopupHandlerUI.isSearchField(c) && !searchPopupDisabled;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/laf/darcula/ui/TextFieldWithPopupHandlerUI";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/laf/darcula/ui/TextFieldWithPopupHandlerUI";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionIconLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActionUnder";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionIconLocation";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionIconBounds";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "paintHolder";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIconHolder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private final class Handler
    extends MouseAdapter
    implements DocumentListener,
    FocusListener,
    PropertyChangeListener {
        private Handler() {
        }

        private void installListener(Document document2) {
            if (document2 != null) {
                document2.addDocumentListener(this);
            }
        }

        private void uninstallListener(Document document2) {
            if (document2 != null) {
                document2.removeDocumentListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (TextFieldWithPopupHandlerUI.DOCUMENT.equals(event.getPropertyName())) {
                if (event.getOldValue() instanceof Document) {
                    this.uninstallListener((Document)event.getOldValue());
                }
                if (event.getNewValue() instanceof Document) {
                    this.installListener((Document)event.getNewValue());
                }
            } else if (TextFieldWithPopupHandlerUI.MONOSPACED.equals(event.getPropertyName())) {
                TextFieldWithPopupHandlerUI.this.setMonospaced(event.getNewValue());
            } else if (TextFieldWithPopupHandlerUI.VARIANT.equals(event.getPropertyName())) {
                TextFieldWithPopupHandlerUI.this.setVariant(event.getNewValue());
            } else if (TextFieldWithPopupHandlerUI.SEARCH_ICON.equals(event.getPropertyName())) {
                this.updateIcons();
            } else if ("enabled".equals(event.getPropertyName())) {
                boolean enabled2 = Boolean.TRUE.equals(event.getNewValue());
                for (IconHolder holder : TextFieldWithPopupHandlerUI.this.icons.values()) {
                    if (holder.iconButton == null) continue;
                    holder.iconButton.setEnabled(enabled2);
                }
            }
        }

        @Override
        public void focusGained(FocusEvent event) {
            TextFieldWithPopupHandlerUI.this.repaint(false);
        }

        @Override
        public void focusLost(FocusEvent event) {
            TextFieldWithPopupHandlerUI.this.repaint(false);
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            this.updateIcons();
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            this.updateIcons();
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            this.updateIcons();
        }

        private void updateIcons() {
            if (!TextFieldWithPopupHandlerUI.this.icons.isEmpty()) {
                for (IconHolder holder : TextFieldWithPopupHandlerUI.this.icons.values()) {
                    TextFieldWithPopupHandlerUI.this.updateIcon(holder);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!TextFieldWithPopupHandlerUI.this.icons.isEmpty()) {
                TextFieldWithPopupHandlerUI.this.handleMouse(e, false);
            } else if (TextFieldWithPopupHandlerUI.this.getComponent() != null && TextFieldWithPopupHandlerUI.isSearchField(TextFieldWithPopupHandlerUI.this.getComponent())) {
                SearchAction action2 = TextFieldWithPopupHandlerUI.this.getActionUnder(e.getPoint());
                TextFieldWithPopupHandlerUI.this.setCursor(action2 != null ? 12 : 2);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!TextFieldWithPopupHandlerUI.this.icons.isEmpty()) {
                TextFieldWithPopupHandlerUI.this.handleMouse(e, false);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SearchAction action2;
            if (!TextFieldWithPopupHandlerUI.this.icons.isEmpty()) {
                TextFieldWithPopupHandlerUI.this.handleMouse(e, true);
            } else if (TextFieldWithPopupHandlerUI.isSearchField(TextFieldWithPopupHandlerUI.this.getComponent()) && (action2 = TextFieldWithPopupHandlerUI.this.getActionUnder(e.getPoint())) != null) {
                switch (action2.ordinal()) {
                    case 0: {
                        Object listener2 = TextFieldWithPopupHandlerUI.this.getComponent().getClientProperty(TextFieldWithPopupHandlerUI.ON_CLEAR);
                        if (listener2 instanceof ActionListener) {
                            ((ActionListener)listener2).actionPerformed(new ActionEvent(TextFieldWithPopupHandlerUI.this.getComponent(), 1001, "action"));
                        }
                        TextFieldWithPopupHandlerUI.this.getComponent().setText("");
                        break;
                    }
                    case 1: {
                        AbstractAction newLineAction = TextFieldWithPopupHandlerUI.getNewLineAction(TextFieldWithPopupHandlerUI.this.getComponent());
                        if (newLineAction == null) break;
                        newLineAction.actionPerformed(new ActionEvent(TextFieldWithPopupHandlerUI.this.getComponent(), 1001, "action"));
                    }
                }
                e.consume();
            }
        }
    }

    public static final class IconHolder {
        public final Rectangle bounds = new Rectangle();
        public final ExtendableTextComponent.Extension extension;
        public boolean hovered;
        public Icon icon;
        @Nullable
        public JButton iconButton;

        private IconHolder(ExtendableTextComponent.Extension extension) {
            this.extension = extension;
            if (extension.isFocusable() && Registry.is((String)"text.field.extension.buttons.focusable", (boolean)true)) {
                this.iconButton = new IconButton(this);
                this.iconButton.setToolTipText(extension.getTooltip());
                this.iconButton.getAccessibleContext().setAccessibleName(extension.getTooltip());
            }
            this.setIcon(extension.getIcon(false));
        }

        private boolean setIcon(Icon icon2) {
            int height;
            int width;
            Dimension size2;
            this.icon = icon2;
            if (this.iconButton != null) {
                this.iconButton.setIcon(icon2);
            }
            if ((size2 = this.extension.getButtonSize()) == null) {
                int doubleIconInset = ExperimentalUI.isNewUI() ? JBUI.scale((int)1) * 2 : 0;
                width = icon2 == null ? 0 : icon2.getIconWidth() + doubleIconInset;
                height = icon2 == null ? 0 : icon2.getIconHeight() + doubleIconInset;
            } else {
                width = size2.width;
                height = size2.height;
            }
            if (this.iconButton != null) {
                int lw = DarculaUIUtil.LW.get() * 2;
                width += lw;
                height += lw;
            }
            if (this.bounds.width == width && this.bounds.height == height) {
                return false;
            }
            this.bounds.setSize(width, height);
            return true;
        }

        public boolean isClickable() {
            return null != this.extension.getActionOnClick();
        }

        private void paintBackground(Graphics g, Rectangle bounds) {
            Object background;
            boolean selected = this.extension.isSelected();
            if (!ExperimentalUI.isNewUI() && !selected || !this.isClickable() || this.icon == AllIcons.Actions.CloseHovered) {
                return;
            }
            if (selected) {
                background = this.hovered ? JBUI.CurrentTheme.SearchOption.BUTTON_SELECTED_HOVERED_BACKGROUND : JBUI.CurrentTheme.SearchOption.BUTTON_SELECTED_BACKGROUND;
            } else {
                Color color = background = this.hovered ? JBUI.CurrentTheme.ActionButton.hoverBackground() : null;
            }
            if (background != null) {
                GraphicsUtil.setupAAPainting((Graphics)g);
                int arc = DarculaUIUtil.BUTTON_ARC.get();
                g.setColor((Color)background);
                g.fillRoundRect(bounds.x, bounds.y, bounds.width, bounds.height, arc, arc);
            }
        }
    }

    private static class IconButton
    extends JButton {
        private final IconHolder myIconHolder;
        private final ActionListener myActionListener;

        private IconButton(IconHolder holder) {
            this.myIconHolder = holder;
            this.setOpaque(false);
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.myActionListener = e -> {
                Runnable action2 = this.myIconHolder.extension.getActionOnClick();
                if (action2 != null) {
                    action2.run();
                }
            };
            this.addActionListener(this.myActionListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g) {
            Rectangle r = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            this.myIconHolder.paintBackground(g, r);
            if (this.hasFocus()) {
                Graphics2D g2 = (Graphics2D)g.create();
                try {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                    g2.setColor(JBUI.CurrentTheme.ActionButton.focusedBorder());
                    float arc = DarculaUIUtil.BUTTON_ARC.getFloat();
                    float lw = DarculaUIUtil.LW.getFloat();
                    Path2D.Float border = new Path2D.Float(0);
                    border.append(new RoundRectangle2D.Float(r.x, r.y, r.width, r.height, arc, arc), false);
                    border.append(new RoundRectangle2D.Float((float)r.x + lw, (float)r.y + lw, (float)r.width - lw * 2.0f, (float)r.height - lw * 2.0f, arc - lw, arc - lw), false);
                    g2.fill(border);
                }
                finally {
                    g2.dispose();
                }
            }
            super.paintComponent(g);
        }

        private void removeListeners() {
            this.removeActionListener(this.myActionListener);
        }
    }

    static final class MouseDragAwareCaret
    extends MarginAwareCaret {
        private final MouseDragSelectionEventHandler handler = new MouseDragSelectionEventHandler((Function1<? super MouseEvent, Unit>)((Function1)e -> {
            super.mouseDragged((MouseEvent)e);
            return Unit.INSTANCE;
        }));

        MouseDragAwareCaret() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.handler.setNativeSelectionEnabled(!this.isMultiline(this.getComponent()));
            this.handler.mouseDragged(e);
        }

        public boolean isMultiline(JTextComponent component2) {
            return component2.getText().contains("\n") || component2 instanceof JTextArea && ((JTextArea)component2).getLineWrap();
        }
    }

    public static enum SearchAction {
        CLEAR,
        NEWLINE;

    }

    private final class SearchExtension
    implements ExtendableTextComponent.Extension {
        private SearchExtension() {
        }

        public Icon getIcon(boolean hovered) {
            Icon icon2 = (Icon)TextFieldWithPopupHandlerUI.this.getComponent().getClientProperty(TextFieldWithPopupHandlerUI.SEARCH_ICON);
            if (icon2 != null) {
                return icon2;
            }
            return TextFieldWithPopupHandlerUI.this.getSearchIcon(hovered, TextFieldWithPopupHandlerUI.isSearchFieldWithHistoryPopup(TextFieldWithPopupHandlerUI.this.getComponent()));
        }

        public int getAfterIconOffset() {
            Integer gap = (Integer)TextFieldWithPopupHandlerUI.this.getComponent().getClientProperty("JTextField.Search.Gap");
            return gap == null ? 0 : gap;
        }

        public int getIconGap() {
            return TextFieldWithPopupHandlerUI.this.getSearchIconGap();
        }

        public boolean isIconBeforeText() {
            return true;
        }

        public String getTooltip() {
            String prefix = null;
            if (ClientProperty.get((Component)TextFieldWithPopupHandlerUI.this.getComponent(), (Object)TextFieldWithPopupHandlerUI.INPLACE_HISTORY) != null) {
                prefix = IdeBundle.message((String)"tooltip.recent.search", (Object[])new Object[0]);
            }
            if (this.getActionOnClick() != null) {
                prefix = IdeBundle.message((String)"tooltip.search.history", (Object[])new Object[0]);
            }
            return prefix == null ? null : SearchExtension.createTooltip(prefix);
        }

        @NlsContexts.Tooltip
        @NotNull
        private static String createTooltip(@Nls @NotNull String prefix) {
            if (prefix == null) {
                SearchExtension.$$$reportNull$$$0(0);
            }
            String shortcut = HelpTooltip.getShortcutAsHtml((String)KeymapUtil.getFirstKeyboardShortcutText((String)"ShowSearchHistory"));
            String string = XmlStringUtil.wrapInHtml((CharSequence)(prefix + shortcut));
            if (string == null) {
                SearchExtension.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String toString() {
            return TextFieldWithPopupHandlerUI.SEARCH_VARIANT_VALUE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/ui/laf/darcula/ui/TextFieldWithPopupHandlerUI$SearchExtension";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/ui/laf/darcula/ui/TextFieldWithPopupHandlerUI$SearchExtension";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTooltip";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createTooltip";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private final class ClearExtension
    implements ExtendableTextComponent.Extension {
        private ClearExtension() {
        }

        public Icon getIcon(boolean hovered) {
            return TextFieldWithPopupHandlerUI.this.getClearIcon(hovered, TextFieldWithPopupHandlerUI.this.hasText());
        }

        public int getPreferredSpace() {
            Icon icon2 = TextFieldWithPopupHandlerUI.this.getClearIcon(false, true);
            return icon2 != null ? this.getIconGap() + icon2.getIconWidth() : 0;
        }

        public int getIconGap() {
            return TextFieldWithPopupHandlerUI.this.getClearIconGap();
        }

        public Runnable getActionOnClick() {
            JTextComponent component2 = TextFieldWithPopupHandlerUI.this.getComponent();
            return component2 == null ? null : () -> {
                component2.setText(null);
                Object property = component2.getClientProperty(TextFieldWithPopupHandlerUI.ON_CLEAR);
                if (property instanceof ActionListener) {
                    ActionListener listener2 = (ActionListener)property;
                    listener2.actionPerformed(new ActionEvent(component2, 1001, "clear"));
                }
            };
        }

        public String toString() {
            return "clear";
        }
    }

    public static class MarginAwareCaret
    extends BasicTextUI.BasicCaret {
        @Override
        protected void adjustVisibility(Rectangle r) {
            Insets m = this.getComponent().getMargin();
            r.x -= m.left;
            r.width += m.left;
            super.adjustVisibility(r);
        }
    }
}

