/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.PorterStemmerUtil;
import com.intellij.ide.ui.search.SearchUtilKt;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.SearchableOptionsRegistrarImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.IntPair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0007J\"\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u0007J.\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00192\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001dH\u0002J*\u0010\u001e\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010 \u001a\u00020\tH\u0003J6\u0010!\u001a\u00020\t2\b\u0010\"\u001a\u0004\u0018\u00010\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010 \u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010#\u001a\u00020$H\u0007J\u001a\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\b\u0010'\u001a\u0004\u0018\u00010\u0007H\u0007J*\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\b\u0010'\u001a\u0004\u0018\u00010\u00072\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0007J\u0018\u0010+\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007H\u0002J0\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0002J0\u0010.\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0002JV\u0010/\u001a\u00020\r2\b\u0010'\u001a\u0004\u0018\u00010\u00072\u000b\u0010\"\u001a\u00070\u0007\u00a2\u0006\u0002\b02\f\u00101\u001a\b\u0012\u0004\u0012\u000203022\b\b\u0001\u00104\u001a\u00020\u00192\b\u00105\u001a\u0004\u0018\u00010)2\b\u00106\u001a\u0004\u0018\u00010)2\u0006\u00107\u001a\u000208\u00a2\u0006\u0002\u00109JG\u0010:\u001a\u00020\r2\b\u0010'\u001a\u0004\u0018\u00010\u00072\r\u0010\"\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b02\b\b\u0001\u00104\u001a\u00020\u00192\b\u00105\u001a\u0004\u0018\u00010)2\b\u00106\u001a\u0004\u0018\u00010)2\u0006\u00107\u001a\u000208H\u0007J8\u0010;\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u00072\u000e\u0010<\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00070=2\u0006\u0010>\u001a\u00020\u00192\u0006\u0010?\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0007H\u0002J,\u0010@\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070A0\u00062\b\u0010'\u001a\u0004\u0018\u00010\u00072\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011H\u0007J!\u0010C\u001a\b\u0012\u0004\u0012\u00020D0\u00062\f\u0010E\u001a\b\u0012\u0004\u0012\u00020F02H\u0007\u00a2\u0006\u0002\u0010GJ\u0014\u0010H\u001a\b\u0012\u0004\u0012\u00020D0\u00062\u0006\u0010I\u001a\u00020FR\u001c\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/intellij/ide/ui/search/SearchUtil;", "", "<init>", "()V", "ADDITIONAL_SEARCH_LABELS_KEY", "Lcom/intellij/openapi/util/Key;", "", "", "SEARCH_SKIP_COMPONENT_KEY", "", "HIGHLIGHT_WITH_BORDER", "STYLE_END", "processComponent", "", "configurable", "Lcom/intellij/openapi/options/SearchableConfigurable;", "configurableOptions", "", "Lcom/intellij/ide/ui/search/OptionDescription;", "component", "Ljavax/swing/JComponent;", "i18n", "lightOptions", "option", "getSelection", "", "tabIndex", "tabCount", "titleGetter", "Lkotlin/Function1;", "traverseComponentsTree", "rootComponent", "force", "isComponentHighlighted", "text", "searchableOptionsRegistrar", "Lcom/intellij/ide/ui/search/SearchableOptionsRegistrar;", "markup", "textToMarkup", "filter", "textColor", "Ljava/awt/Color;", "backgroundColor", "quoteStrictOccurrences", "insideHtmlTagPattern", "Ljava/util/regex/Pattern;", "markupInText", "appendRangedFragments", "Lcom/intellij/openapi/util/NlsSafe;", "matchingRanges", "", "Lcom/intellij/util/IntPair;", "style", "foreground", "background", "textRenderer", "Lcom/intellij/ui/SimpleColoredComponent;", "(Ljava/lang/String;Ljava/lang/String;[Lcom/intellij/util/IntPair;ILjava/awt/Color;Ljava/awt/Color;Lcom/intellij/ui/SimpleColoredComponent;)V", "appendFragments", "appendSelectedWords", "selectedWords", "", "pos", "end", "findKeys", "", "quoted", "expand", "Lcom/intellij/openapi/options/Configurable;", "groups", "Lcom/intellij/openapi/options/ConfigurableGroup;", "([Lcom/intellij/openapi/options/ConfigurableGroup;)Ljava/util/List;", "expandGroup", "group", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nSearchUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchUtil.kt\ncom/intellij/ide/ui/search/SearchUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,780:1\n1761#2,3:781\n739#2,9:785\n739#2,9:794\n1#3:784\n*S KotlinDebug\n*F\n+ 1 SearchUtil.kt\ncom/intellij/ide/ui/search/SearchUtil\n*L\n124#1:781,3\n281#1:785,9\n465#1:794,9\n*E\n"})
public final class SearchUtil {
    @NotNull
    public static final SearchUtil INSTANCE = new SearchUtil();
    @JvmField
    @ApiStatus.Internal
    @NotNull
    public static final Key<List<String>> ADDITIONAL_SEARCH_LABELS_KEY;
    @JvmField
    @ApiStatus.Internal
    @NotNull
    public static final Key<Boolean> SEARCH_SKIP_COMPONENT_KEY;
    @NotNull
    public static final String HIGHLIGHT_WITH_BORDER = "searchUtil.highlightWithBorder";
    @NotNull
    private static final String STYLE_END = "</style>";

    private SearchUtil() {
    }

    @JvmStatic
    public static final void processComponent(@NotNull SearchableConfigurable configurable, @NotNull Set<OptionDescription> configurableOptions, @Nullable JComponent component2, boolean i18n) {
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        Intrinsics.checkNotNullParameter(configurableOptions, (String)"configurableOptions");
        if (component2 != null) {
            String string = configurable.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            SearchUtilKt.processUiLabel(string, configurableOptions, null, i18n, null);
            SearchUtilKt.collectSearchItemsForComponent(component2, configurableOptions, null, null, i18n);
        }
    }

    @ApiStatus.Internal
    public final void lightOptions(@NotNull SearchableConfigurable configurable, @NotNull JComponent component2, @Nullable String option2) {
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        if (!this.traverseComponentsTree(configurable, component2, option2, true)) {
            this.traverseComponentsTree(configurable, component2, option2, false);
        }
    }

    private final int getSelection(String tabIndex, int tabCount, Function1<? super Integer, String> titleGetter) {
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        for (int i2 = 0; i2 < tabCount; ++i2) {
            String title2;
            Set pathWords = searchableOptionsRegistrar.getProcessedWords(tabIndex);
            String string = (String)titleGetter.invoke((Object)i2);
            if (string == null) {
                string = title2 = "";
            }
            if (!pathWords.isEmpty()) {
                Set titleWords = searchableOptionsRegistrar.getProcessedWords(title2);
                Intrinsics.checkNotNull((Object)titleWords);
                pathWords.removeAll(titleWords);
                if (!pathWords.isEmpty()) continue;
                return i2;
            }
            if (!StringsKt.equals((String)tabIndex, (String)title2, (boolean)true)) continue;
            return i2;
        }
        return -1;
    }

    @Contract(pure=false)
    private final boolean traverseComponentsTree(SearchableConfigurable configurable, JComponent rootComponent, String option2, boolean force) {
        Border border;
        rootComponent.putClientProperty(HIGHLIGHT_WITH_BORDER, null);
        CharSequence charSequence = option2;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        List label2 = SearchUtilKt.access$getLabelsFromComponent(rootComponent);
        if (!label2.isEmpty()) {
            for (String each : label2) {
                Intrinsics.checkNotNull((Object)searchableOptionsRegistrar);
                if (!this.isComponentHighlighted(each, option2, force, configurable, searchableOptionsRegistrar)) continue;
                SearchUtilKt.access$highlightComponent(rootComponent, option2);
                return true;
            }
        } else if (rootComponent instanceof JComboBox) {
            boolean bl;
            block19: {
                List labels = SearchUtilKt.access$getItemsFromComboBox((JComboBox)rootComponent);
                $this$any$iv = labels;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv = iterator.next();
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)searchableOptionsRegistrar);
                        if (!INSTANCE.isComponentHighlighted(it, option2, force, configurable, searchableOptionsRegistrar)) continue;
                        bl = true;
                        break block19;
                    }
                    bl = false;
                }
            }
            if (bl) {
                SearchUtilKt.access$highlightComponent(rootComponent, option2);
                return true;
            }
        } else if (rootComponent instanceof JTabbedPane) {
            $this$any$iv = SearchableOptionsRegistrar.getInstance();
            SearchableOptionsRegistrar it = $this$any$iv;
            boolean bl = false;
            Object optionRegistrar = it.isInitialized() ? $this$any$iv : null;
            Object object = optionRegistrar;
            if (object == null || (object = object.getInnerPaths(configurable, option2)) == null) {
                object = SetsKt.emptySet();
            }
            paths = object;
            Iterator iterator = paths.iterator();
            while (iterator.hasNext()) {
                String path = (String)iterator.next();
                int index = this.getSelection(path, ((JTabbedPane)rootComponent).getTabCount(), (Function1<? super Integer, String>)((Function1)arg_0 -> SearchUtil.traverseComponentsTree$lambda$2(rootComponent, arg_0)));
                if (index <= -1 || index >= ((JTabbedPane)rootComponent).getTabCount() || !(((JTabbedPane)rootComponent).getTabComponentAt(index) instanceof JComponent)) continue;
                Component component2 = ((JTabbedPane)rootComponent).getTabComponentAt(index);
                Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type javax.swing.JComponent");
                SearchUtilKt.access$highlightComponent((JComponent)component2, option2);
            }
        } else if (rootComponent instanceof TabbedPaneWrapper.TabbedPaneHolder) {
            TabbedPaneWrapper tabbedPaneWrapper = ((TabbedPaneWrapper.TabbedPaneHolder)rootComponent).getTabbedPaneWrapper();
            Set set = SearchableOptionsRegistrar.getInstance().getInnerPaths(configurable, option2);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getInnerPaths(...)");
            paths = set;
            Iterator iterator = paths.iterator();
            while (iterator.hasNext()) {
                String path = (String)iterator.next();
                int index = this.getSelection(path, tabbedPaneWrapper.getTabCount(), (Function1<? super Integer, String>)((Function1)arg_0 -> SearchUtil.traverseComponentsTree$lambda$3(tabbedPaneWrapper, arg_0)));
                if (index <= -1 || index >= tabbedPaneWrapper.getTabCount()) continue;
                Component component3 = tabbedPaneWrapper.getTabComponentAt(index);
                Intrinsics.checkNotNull((Object)component3, (String)"null cannot be cast to non-null type javax.swing.JComponent");
                SearchUtilKt.access$highlightComponent((JComponent)component3, option2);
            }
        }
        if ((border = rootComponent.getBorder()) instanceof TitledBorder) {
            String title2 = ((TitledBorder)border).getTitle();
            Intrinsics.checkNotNull((Object)searchableOptionsRegistrar);
            if (this.isComponentHighlighted(title2, option2, force, configurable, searchableOptionsRegistrar)) {
                SearchUtilKt.access$highlightComponent(rootComponent, option2);
                rootComponent.putClientProperty(HIGHLIGHT_WITH_BORDER, true);
                return true;
            }
        }
        boolean highlightedChild = false;
        Component[] componentArray = rootComponent.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        for (Component child : componentArray) {
            if (!(child instanceof JComponent)) continue;
            boolean highlighted = this.traverseComponentsTree(configurable, (JComponent)child, option2, force);
            highlightedChild = highlightedChild || highlighted;
        }
        return highlightedChild;
    }

    @ApiStatus.Internal
    public final boolean isComponentHighlighted(@Nullable String text2, @Nullable String option2, boolean force, @Nullable SearchableConfigurable configurable, @NotNull SearchableOptionsRegistrar searchableOptionsRegistrar) {
        Set options2;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)searchableOptionsRegistrar, (String)"searchableOptionsRegistrar");
        if (text2 == null || (charSequence = (CharSequence)option2) == null || charSequence.length() == 0) {
            return false;
        }
        Set words = searchableOptionsRegistrar.getProcessedWords(option2);
        Set set = options2 = configurable == null ? words : searchableOptionsRegistrar.replaceSynonyms(words, configurable);
        if (options2.isEmpty()) {
            return StringsKt.contains((CharSequence)text2, (CharSequence)option2, (boolean)true);
        }
        Set tokens = searchableOptionsRegistrar.getProcessedWords(text2);
        if (!force) {
            Intrinsics.checkNotNull((Object)tokens);
            options2.retainAll(tokens);
            boolean highlight = !options2.isEmpty();
            return highlight || StringsKt.contains((CharSequence)text2, (CharSequence)option2, (boolean)true);
        }
        Intrinsics.checkNotNull((Object)tokens);
        options2.removeAll(tokens);
        return options2.isEmpty();
    }

    @JvmStatic
    @NotNull
    public static final String markup(@NotNull String textToMarkup, @Nullable String filter2) {
        Intrinsics.checkNotNullParameter((Object)textToMarkup, (String)"textToMarkup");
        Color color = (Color)new JBColor((Color)Gray._50, (Color)Gray._0);
        JBColor jBColor = JBColor.namedColor((String)"SearchMatch.startBackground", (Color)ColorUtil.fromHex((String)"1d5da7"));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        return SearchUtil.markup(textToMarkup, filter2, color, (Color)jBColor);
    }

    @JvmStatic
    @NotNull
    public static final String markup(@NotNull String textToMarkup, @Nullable String filter2, @NotNull Color textColor, @NotNull Color backgroundColor) {
        Intrinsics.checkNotNullParameter((Object)textToMarkup, (String)"textToMarkup");
        Intrinsics.checkNotNullParameter((Object)textColor, (String)"textColor");
        Intrinsics.checkNotNullParameter((Object)backgroundColor, (String)"backgroundColor");
        String textToMarkup2 = textToMarkup;
        String filter3 = filter2;
        CharSequence charSequence = filter3;
        if (charSequence == null || charSequence.length() == 0) {
            return textToMarkup2;
        }
        int bodyStart = StringsKt.indexOf$default((CharSequence)textToMarkup2, (String)"<body>", (int)0, (boolean)false, (int)6, null);
        int bodyEnd = StringsKt.indexOf$default((CharSequence)textToMarkup2, (String)"</body>", (int)0, (boolean)false, (int)6, null);
        String head = null;
        String foot = null;
        if (bodyStart >= 0) {
            String string;
            String string2 = textToMarkup2.substring(0, bodyStart += 6);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            head = string2;
            if (bodyEnd >= 0) {
                String string3 = textToMarkup2.substring(bodyEnd);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                string = "";
            }
            foot = string;
            String string4 = textToMarkup2.substring(bodyStart, bodyEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            textToMarkup2 = string4;
        } else {
            foot = "";
            head = "";
        }
        Pattern insideHtmlTagPattern = Pattern.compile("[<[^<>]*>]*<[^<>]*");
        SearchableOptionsRegistrar registrar = SearchableOptionsRegistrar.getInstance();
        HashSet quoted = new HashSet();
        filter3 = SearchUtilKt.access$processFilter(INSTANCE.quoteStrictOccurrences(textToMarkup2, filter3), quoted);
        Set options2 = registrar.getProcessedWords(filter3);
        Set words = registrar.getProcessedWords(textToMarkup2);
        for (String option2 : options2) {
            if (!words.contains(option2)) continue;
            Intrinsics.checkNotNull((Object)insideHtmlTagPattern);
            Intrinsics.checkNotNull((Object)option2);
            textToMarkup2 = INSTANCE.markup(textToMarkup2, insideHtmlTagPattern, option2, textColor, backgroundColor);
        }
        Iterator iterator = quoted.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String stripped = (String)iterator2.next();
            if (registrar.isStopWord(stripped)) continue;
            Intrinsics.checkNotNull((Object)insideHtmlTagPattern);
            textToMarkup2 = INSTANCE.markup(textToMarkup2, insideHtmlTagPattern, stripped, textColor, backgroundColor);
        }
        return head + textToMarkup2 + foot;
    }

    private final String quoteStrictOccurrences(String textToMarkup, String filter2) {
        List list2;
        StringBuilder cur = new StringBuilder();
        String string = textToMarkup.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String s = string;
        char[] cArray = new char[]{' '};
        List $this$dropLastWhile$iv = StringsKt.split$default((CharSequence)filter2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        for (String part : list2) {
            StringBuilder stringBuilder = StringsKt.contains$default((CharSequence)s, (CharSequence)part, (boolean)false, (int)2, null) ? cur.append('\"').append(part).append("\" ") : cur.append(part).append(' ');
        }
        String string2 = cur.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final String markup(String textToMarkup, Pattern insideHtmlTagPattern, String option2, Color textColor, Color backgroundColor) {
        int styleIdx = StringsKt.indexOf$default((CharSequence)textToMarkup, (String)"<style", (int)0, (boolean)false, (int)6, null);
        int styleEndIdx = StringsKt.indexOf$default((CharSequence)textToMarkup, (String)STYLE_END, (int)0, (boolean)false, (int)6, null);
        if (styleIdx < 0 || styleEndIdx < 0) {
            return this.markupInText(textToMarkup, insideHtmlTagPattern, option2, textColor, backgroundColor);
        }
        String string = textToMarkup.substring(0, styleIdx);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = this.markup(string, insideHtmlTagPattern, option2, textColor, backgroundColor);
        String string3 = textToMarkup.substring(styleEndIdx + 8);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return string2 + this.markup(string3, insideHtmlTagPattern, option2, textColor, backgroundColor);
    }

    private final String markupInText(String textToMarkup, Pattern insideHtmlTagPattern, String option2, Color textColor, Color backgroundColor) {
        StringBuilder result2 = new StringBuilder();
        int beg = 0;
        int idx = 0;
        while (true) {
            String toMark;
            String prefix;
            int n;
            int it = n = StringsKt.indexOf((CharSequence)textToMarkup, (String)option2, (int)beg, (boolean)true);
            boolean bl = false;
            idx = it;
            if (n == -1) break;
            Intrinsics.checkNotNullExpressionValue((Object)textToMarkup.substring(beg, idx), (String)"substring(...)");
            Intrinsics.checkNotNullExpressionValue((Object)textToMarkup.substring(idx, idx + option2.length()), (String)"substring(...)");
            if (insideHtmlTagPattern.matcher(prefix).matches()) {
                int lastIdx = StringsKt.indexOf$default((CharSequence)textToMarkup, (char)'>', (int)idx, (boolean)false, (int)4, null);
                result2.append(prefix).append(textToMarkup, idx, lastIdx + 1);
                beg = lastIdx + 1;
                continue;
            }
            result2.append(prefix).append("<font color='#").append(ColorUtil.toHex((Color)textColor)).append("' bgColor='#").append(ColorUtil.toHex((Color)backgroundColor)).append("'>").append(toMark).append("</font>");
            beg = idx + option2.length();
        }
        String string = textToMarkup.substring(beg);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        result2.append(string);
        String string2 = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    public final void appendRangedFragments(@Nullable String filter2, @NotNull String text2, @NotNull IntPair[] matchingRanges, @SimpleTextAttributes.StyleAttributeConstant int style, @Nullable Color foreground, @Nullable Color background, @NotNull SimpleColoredComponent textRenderer) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)matchingRanges, (String)"matchingRanges");
        Intrinsics.checkNotNullParameter((Object)textRenderer, (String)"textRenderer");
        if (matchingRanges.length == 0) {
            SearchUtil.appendFragments(filter2, text2, style, foreground, background, textRenderer);
        }
        if ((charSequence = (CharSequence)filter2) == null || charSequence.length() == 0) {
            textRenderer.setDynamicSearchMatchHighlighting(false);
            textRenderer.append(text2, new SimpleTextAttributes(background, foreground, (Color)JBColor.RED, style));
            return;
        }
        textRenderer.setDynamicSearchMatchHighlighting(true);
        int index = 0;
        for (IntPair range : matchingRanges) {
            String before;
            Intrinsics.checkNotNullExpressionValue((Object)text2.substring(index, range.first), (String)"substring(...)");
            if (!(((CharSequence)before).length() == 0)) {
                textRenderer.append(before, new SimpleTextAttributes(background, foreground, null, style));
            }
            index = range.second;
            String string = text2.substring(range.first, range.second);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            textRenderer.append(string, new SimpleTextAttributes(background, foreground, null, style | 0x40));
        }
        String string = text2.substring(index);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String after = string;
        if (!(((CharSequence)after).length() == 0)) {
            textRenderer.append(after, new SimpleTextAttributes(background, foreground, null, style));
        }
    }

    @JvmStatic
    public static final void appendFragments(@Nullable String filter2, @Nullable String text2, @SimpleTextAttributes.StyleAttributeConstant int style, @Nullable Color foreground, @Nullable Color background, @NotNull SimpleColoredComponent textRenderer) {
        Intrinsics.checkNotNullParameter((Object)textRenderer, (String)"textRenderer");
        String filter3 = filter2;
        String string = text2;
        if (string == null) {
            return;
        }
        String text3 = string;
        CharSequence charSequence = filter3;
        if (charSequence == null || charSequence.length() == 0) {
            textRenderer.setDynamicSearchMatchHighlighting(false);
            textRenderer.append(text3, new SimpleTextAttributes(background, foreground, (Color)JBColor.RED, style));
        } else {
            textRenderer.setDynamicSearchMatchHighlighting(true);
            HashSet quoted = new HashSet();
            filter3 = SearchUtilKt.access$processFilter(INSTANCE.quoteStrictOccurrences(text3, filter3), quoted);
            Int2ObjectRBTreeMap indexToString = new Int2ObjectRBTreeMap();
            Iterator iterator = quoted.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            block0: while (iterator2.hasNext()) {
                String stripped = (String)iterator2.next();
                int beg = 0;
                int idx = 0;
                while (true) {
                    int n;
                    int it = n = StringsKt.indexOf((CharSequence)text3, (String)stripped, (int)beg, (boolean)true);
                    boolean bl = false;
                    idx = it;
                    if (n == -1) continue block0;
                    String string2 = text3.substring(idx, idx + stripped.length());
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    indexToString.put(idx, (Object)string2);
                    beg = idx + stripped.length();
                }
            }
            ArrayList<String> selectedWords = new ArrayList<String>();
            int pos = 0;
            ObjectIterator objectIterator = Int2ObjectMaps.fastIterable((Int2ObjectMap)((Int2ObjectMap)indexToString)).iterator();
            Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
            ObjectIterator beg = objectIterator;
            while (beg.hasNext()) {
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)beg.next();
                String stripped = (String)entry.getValue();
                int start2 = entry.getIntKey();
                if (pos > start2) {
                    Object e = selectedWords.get(selectedWords.size() - 1);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                    String highlighted = (String)e;
                    if (highlighted.length() >= stripped.length()) continue;
                    selectedWords.remove(highlighted);
                }
                INSTANCE.appendSelectedWords(text3, (List<? super String>)selectedWords, pos, start2, filter3);
                selectedWords.add(stripped);
                pos = start2 + stripped.length();
            }
            INSTANCE.appendSelectedWords(text3, (List<? super String>)selectedWords, pos, text3.length(), filter3);
            int idx = 0;
            Iterator iterator3 = selectedWords.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
            Iterator entry = iterator3;
            while (entry.hasNext()) {
                String before;
                String word = (String)entry.next();
                Intrinsics.checkNotNullExpressionValue((Object)text3.substring(idx), (String)"substring(...)");
                Intrinsics.checkNotNullExpressionValue((Object)text3.substring(0, StringsKt.indexOf$default((CharSequence)text3, (String)word, (int)0, (boolean)false, (int)6, null)), (String)"substring(...)");
                if (!(((CharSequence)before).length() == 0)) {
                    textRenderer.append(before, new SimpleTextAttributes(background, foreground, null, style));
                }
                idx = StringsKt.indexOf$default((CharSequence)text3, (String)word, (int)0, (boolean)false, (int)6, null) + word.length();
                String string3 = text3.substring(idx - word.length(), idx);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                textRenderer.append(string3, new SimpleTextAttributes(background, foreground, null, style | 0x40));
            }
            String string4 = text3.substring(idx);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            String after = string4;
            if (!(((CharSequence)after).length() == 0)) {
                textRenderer.append(after, new SimpleTextAttributes(background, foreground, null, style));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void appendSelectedWords(String text2, List<? super String> selectedWords, int pos, int end, String filter2) {
        if (pos < end) {
            List list2;
            void $this$dropLastWhile$iv;
            Set filters = SearchableOptionsRegistrar.getInstance().getProcessedWords(filter2);
            String string = text2.substring(pos, end);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Iterator iterator = string;
            Regex regex = new Regex("[^\\pL&&[^-]]+");
            int n = 0;
            iterator = regex.split((CharSequence)((Object)iterator), n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            List words = list2;
            for (String word : words) {
                String string2 = word.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                if (!filters.contains(PorterStemmerUtil.stem(string2))) continue;
                selectedWords.add(word);
            }
        }
    }

    @JvmStatic
    @NotNull
    public static final List<Set<String>> findKeys(@Nullable String filter2, @NotNull Set<String> quoted) {
        Intrinsics.checkNotNullParameter(quoted, (String)"quoted");
        String string = filter2;
        if (string == null) {
            string = "";
        }
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String filter3 = SearchUtilKt.access$processFilter(string2, quoted);
        ArrayList<Set> keySetList = new ArrayList<Set>();
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        Intrinsics.checkNotNull((Object)searchableOptionsRegistrar, (String)"null cannot be cast to non-null type com.intellij.ide.ui.search.SearchableOptionsRegistrarImpl");
        SearchableOptionsRegistrarImpl optionsRegistrar = (SearchableOptionsRegistrarImpl)searchableOptionsRegistrar;
        for (String word : optionsRegistrar.getProcessedWords(filter3)) {
            Sequence<OptionDescription> descriptions;
            if (optionsRegistrar.findAcceptableDescriptions(word) == null) continue;
            HashSet<String> keySet = new HashSet<String>();
            for (OptionDescription description : descriptions) {
                String it;
                if (description.getPath() == null) continue;
                boolean bl = false;
                keySet.add(it);
            }
            keySetList.add(keySet);
        }
        if (keySetList.isEmpty() && !StringsKt.isBlank((CharSequence)filter3)) {
            keySetList.add(SetsKt.setOf((Object)filter3));
        }
        return keySetList;
    }

    @JvmStatic
    @NotNull
    public static final List<Configurable> expand(@NotNull ConfigurableGroup[] groups) {
        Intrinsics.checkNotNullParameter((Object)groups, (String)"groups");
        ArrayList result2 = new ArrayList();
        for (ConfigurableGroup group2 : groups) {
            SearchUtilKt.processExpandedGroups(group2, result2);
        }
        return result2;
    }

    @NotNull
    public final List<Configurable> expandGroup(@NotNull ConfigurableGroup group2) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        ArrayList result2 = new ArrayList();
        SearchUtilKt.processExpandedGroups(group2, result2);
        return result2;
    }

    private static final String traverseComponentsTree$lambda$2(JComponent $rootComponent, int i2) {
        return ((JTabbedPane)$rootComponent).getTitleAt(i2);
    }

    private static final String traverseComponentsTree$lambda$3(TabbedPaneWrapper $tabbedPaneWrapper, int i2) {
        return $tabbedPaneWrapper.getTitleAt(i2);
    }

    static {
        Key key = Key.create((String)"ADDITIONAL_SEARCH_LABELS");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        ADDITIONAL_SEARCH_LABELS_KEY = key;
        Key key2 = Key.create((String)"SEARCH_SKIP_COMPONENT_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        SEARCH_SKIP_COMPONENT_KEY = key2;
    }
}

