/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.text.parts;

import com.intellij.ide.ui.text.StyledTextPaneUtils;
import com.intellij.ide.ui.text.parts.RegularTextPart;
import com.intellij.ide.ui.text.parts.TextPart;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.JTextPane;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ide/ui/text/parts/CodeTextPart;", "Lcom/intellij/ide/ui/text/parts/TextPart;", "text", "", "<init>", "(Ljava/lang/String;)V", "frameColor", "Ljava/awt/Color;", "getFrameColor", "()Ljava/awt/Color;", "setFrameColor", "(Ljava/awt/Color;)V", "delimiter", "getDelimiter", "()Lcom/intellij/ide/ui/text/parts/TextPart;", "setDelimiter", "(Lcom/intellij/ide/ui/text/parts/TextPart;)V", "insertToTextPane", "", "textPane", "Ljavax/swing/JTextPane;", "startOffset", "intellij.platform.ide.impl"})
@ApiStatus.Experimental
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCodeTextPart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeTextPart.kt\ncom/intellij/ide/ui/text/parts/CodeTextPart\n+ 2 TextPart.kt\ncom/intellij/ide/ui/text/parts/TextPart\n*L\n1#1,49:1\n34#2,2:50\n*S KotlinDebug\n*F\n+ 1 CodeTextPart.kt\ncom/intellij/ide/ui/text/parts/CodeTextPart\n*L\n29#1:50,2\n*E\n"})
public class CodeTextPart
extends TextPart {
    @NotNull
    private Color frameColor;
    @NotNull
    private TextPart delimiter;

    public CodeTextPart(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(text2);
        Color color = JBUI.CurrentTheme.Button.buttonOutlineColorEnd((boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"buttonOutlineColorEnd(...)");
        this.frameColor = color;
        this.delimiter = new RegularTextPart("", false, 2, null);
        this.setFontGetter((Function0<? extends Font>)((Function0)CodeTextPart::_init_$lambda$0));
        TextPart this_$iv = this;
        boolean $i$f$editAttributes = false;
        SimpleAttributeSet $this$_init__u24lambda_u241 = this_$iv.getAttributes();
        boolean bl = false;
        StyleConstants.setForeground($this$_init__u24lambda_u241, JBUI.CurrentTheme.Label.foreground());
    }

    @NotNull
    public final Color getFrameColor() {
        return this.frameColor;
    }

    public final void setFrameColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.frameColor = color;
    }

    @NotNull
    public final TextPart getDelimiter() {
        return this.delimiter;
    }

    public final void setDelimiter(@NotNull TextPart textPart) {
        Intrinsics.checkNotNullParameter((Object)textPart, (String)"<set-?>");
        this.delimiter = textPart;
    }

    @Override
    public int insertToTextPane(@NotNull JTextPane textPane, int startOffset) {
        Intrinsics.checkNotNullParameter((Object)textPane, (String)"textPane");
        int curOffset = startOffset;
        curOffset = this.delimiter.insertToTextPane(textPane, curOffset);
        textPane.getDocument().insertString(curOffset, this.getText(), this.getAttributes());
        curOffset += this.getText().length();
        curOffset = this.delimiter.insertToTextPane(textPane, curOffset);
        int delimiterLength = this.delimiter.getText().length();
        int highlightStart = startOffset + delimiterLength;
        int highlightEnd = curOffset - delimiterLength;
        textPane.getHighlighter().addHighlight(highlightStart, highlightEnd, (arg_0, arg_1, arg_2, arg_3, arg_4) -> CodeTextPart.insertToTextPane$lambda$0(highlightStart, highlightEnd, this, arg_0, arg_1, arg_2, arg_3, arg_4));
        return curOffset;
    }

    private static final Font _init_$lambda$0() {
        return EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN).deriveFont((float)JBFont.label().getSize());
    }

    private static final void insertToTextPane$lambda$0(int $highlightStart, int $highlightEnd, CodeTextPart this$0, Graphics g, int n, int n2, Shape shape, JTextComponent c) {
        Intrinsics.checkNotNull((Object)c);
        Intrinsics.checkNotNull((Object)g);
        StyledTextPaneUtils.INSTANCE.drawRectangleAroundText(c, $highlightStart, $highlightEnd, g, this$0.frameColor, (Font)this$0.getFontGetter().invoke(), (Font)this$0.delimiter.getFontGetter().invoke(), false, -0.5f);
    }
}

