/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.InjectedDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0003J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/DataContextUtils;", "", "<init>", "()V", "getFileLanguage", "Lcom/intellij/lang/Language;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getInjectedOrFileLanguage", "project", "Lcom/intellij/openapi/project/Project;", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getFileTypeLanguage", "getFileTypeLanguageByEditor", "getLanguageByFileName", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getInjectedLanguage", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class DataContextUtils {
    @NotNull
    public static final DataContextUtils INSTANCE = new DataContextUtils();

    private DataContextUtils() {
    }

    @JvmStatic
    @Nullable
    public static final Language getFileLanguage(@NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext2);
        if ((psiFile == null || (psiFile = psiFile.getLanguage()) == null) && (psiFile = DataContextUtils.getFileTypeLanguage(dataContext2)) == null) {
            psiFile = (Language)CommonDataKeys.LANGUAGE.getData(dataContext2);
        }
        return psiFile;
    }

    @Nullable
    public final Language getInjectedOrFileLanguage(@Nullable Project project2, @NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        Language injected = this.getInjectedLanguage(dataContext2, project2);
        Language language = injected;
        if (language == null) {
            language = DataContextUtils.getFileLanguage(dataContext2);
        }
        return language;
    }

    @JvmStatic
    @Nullable
    public static final FileType getFileType(@NotNull DataContext dataContext2) {
        FileType fileType2;
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext2);
        Object object = fileType2 = psiFile != null ? psiFile.getFileType() : null;
        if (fileType2 != null) {
            return fileType2;
        }
        Object object2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext2);
        if (object2 == null) {
            FileEditor fileEditor = (FileEditor)PlatformCoreDataKeys.FILE_EDITOR.getData(dataContext2);
            object2 = fileEditor != null ? fileEditor.getFile() : null;
            if (object2 == null) {
                return null;
            }
        }
        VirtualFile virtualFile = object2;
        return FileTypeRegistry.getInstance().getFileTypeByFileName(virtualFile.getNameSequence());
    }

    @JvmStatic
    @Nullable
    public static final Language getFileTypeLanguage(@NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        Object object = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext2);
        if (object == null) {
            FileEditor fileEditor = (FileEditor)PlatformCoreDataKeys.FILE_EDITOR.getData(dataContext2);
            object = fileEditor != null ? fileEditor.getFile() : null;
            if (object == null) {
                return null;
            }
        }
        VirtualFile virtualFile = object;
        return DataContextUtils.getLanguageByFileName(virtualFile);
    }

    @JvmStatic
    @Nullable
    public static final Language getFileTypeLanguageByEditor(@NotNull DataContext dataContext2) {
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        FileEditor fileEditor = (FileEditor)PlatformCoreDataKeys.FILE_EDITOR.getData(dataContext2);
        if (fileEditor == null || (fileEditor = fileEditor.getFile()) == null) {
            return null;
        }
        FileEditor virtualFile = fileEditor;
        return DataContextUtils.getLanguageByFileName((VirtualFile)virtualFile);
    }

    @JvmStatic
    private static final Language getLanguageByFileName(VirtualFile file2) {
        FileType fileType2 = FileTypeRegistry.getInstance().getFileTypeByFileName(file2.getNameSequence());
        Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileTypeByFileName(...)");
        FileType fileType3 = fileType2;
        if (fileType3 instanceof LanguageFileType) {
            return ((LanguageFileType)fileType3).getLanguage();
        }
        return null;
    }

    private final Language getInjectedLanguage(DataContext dataContext2, Project project2) {
        PsiFile injectedFile;
        Editor editor2;
        PsiFile file2 = (PsiFile)InjectedDataKeys.PSI_FILE.getData(dataContext2);
        if (file2 != null) {
            return file2.getLanguage();
        }
        if (project2 != null && (editor2 = (Editor)InjectedDataKeys.EDITOR.getData(dataContext2)) != null && !project2.isDisposed() && (injectedFile = (PsiFile)ActionsKt.runReadAction(() -> DataContextUtils.getInjectedLanguage$lambda$0(project2, editor2))) != null) {
            return injectedFile.getLanguage();
        }
        return null;
    }

    private static final PsiFile getInjectedLanguage$lambda$0(Project $project, Editor $editor) {
        return PsiDocumentManager.getInstance((Project)$project).getCachedPsiFile($editor.getDocument());
    }
}

