/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

final class FileNamePatternCustomValidationRule
extends CustomValidationRule {
    FileNamePatternCustomValidationRule() {
    }

    @NotNull
    public String getRuleId() {
        return "file_name_pattern";
    }

    @NotNull
    protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
        Object fileTypeName;
        FileType fileType2;
        if (data2 == null) {
            FileNamePatternCustomValidationRule.$$$reportNull$$$0(0);
        }
        if (context == null) {
            FileNamePatternCustomValidationRule.$$$reportNull$$$0(1);
        }
        FileType fileType3 = fileType2 = (fileTypeName = context.eventData.get("file_type")) != null ? FileTypeManager.getInstance().findFileTypeByName(fileTypeName.toString()) : null;
        if (fileType2 == null || fileType2 == UnknownFileType.INSTANCE) {
            ValidationResultType validationResultType = ValidationResultType.THIRD_PARTY;
            if (validationResultType == null) {
                FileNamePatternCustomValidationRule.$$$reportNull$$$0(2);
            }
            return validationResultType;
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (!(fileTypeManager instanceof FileTypeManagerImpl)) {
            ValidationResultType validationResultType = ValidationResultType.THIRD_PARTY;
            if (validationResultType == null) {
                FileNamePatternCustomValidationRule.$$$reportNull$$$0(3);
            }
            return validationResultType;
        }
        List<FileNameMatcher> fileNameMatchers = ((FileTypeManagerImpl)fileTypeManager).getStandardMatchers(fileType2);
        Optional<FileNameMatcher> fileNameMatcher = fileNameMatchers.stream().filter(x -> x.getPresentableString().equals(data2)).findFirst();
        if (fileNameMatcher.isEmpty()) {
            ValidationResultType validationResultType = ValidationResultType.THIRD_PARTY;
            if (validationResultType == null) {
                FileNamePatternCustomValidationRule.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }
        ValidationResultType validationResultType = FileNamePatternCustomValidationRule.acceptWhenReportedByJetBrainsPlugin((EventContext)context);
        if (validationResultType == null) {
            FileNamePatternCustomValidationRule.$$$reportNull$$$0(5);
        }
        return validationResultType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileNamePatternCustomValidationRule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileNamePatternCustomValidationRule";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doValidate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

