/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.net.ssl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.net.ssl.CertificateWarningDialog$unselectOtherNodes$;
import com.intellij.net.ssl.CertificateWarningStatisticsCollector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.InlineBanner;
import com.intellij.ui.JBColor;
import com.intellij.ui.RoundedLineBorder;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.CollapsibleRow;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.IntelliJSpacingConfiguration;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Placeholder;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SpacingConfiguration;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.CertificateProvider;
import com.intellij.util.net.ssl.CertificateWrapper;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001=B>\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000f\b\u0002\u0010\u0005\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\n\u0010!\u001a\u0004\u0018\u00010\"H\u0014J\b\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020\u0018H\u0002J\u0018\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0002J\u001e\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020-0,2\b\u0010.\u001a\u0004\u0018\u00010/H\u0003J\b\u00100\u001a\u00020$H\u0002J\u0010\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u0004H\u0002J-\u00103\u001a\u00020$*\u0002042\u0017\u00105\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u00122\u0006\u00106\u001a\u00020\u0010H\u0002J\u000e\u00107\u001a\u00020\u00062\u0006\u00108\u001a\u00020\u0006J\u0012\u00109\u001a\u00020:2\b\b\u0001\u0010;\u001a\u00020\u0006H\u0002J\u001a\u0010<\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00030\u0012H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0005\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00030\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/intellij/net/ssl/CertificateWarningDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "certificates", "", "Ljava/security/cert/X509Certificate;", "remoteHost", "", "Lcom/intellij/openapi/util/NlsSafe;", "manager", "Ljavax/net/ssl/X509ExtendedTrustManager;", "authType", "certificateProvider", "Lcom/intellij/util/net/ssl/CertificateProvider;", "<init>", "(Ljava/util/List;Ljava/lang/String;Ljavax/net/ssl/X509ExtendedTrustManager;Ljava/lang/String;Lcom/intellij/util/net/ssl/CertificateProvider;)V", "expandedByButton", "", "certificateErrorsMap", "", "Lcom/intellij/net/ssl/CertificateWarningDialog$CertificateError;", "hasUntrusted", "currentCertificate", "Lcom/intellij/util/net/ssl/CertificateWrapper;", "tree", "Ljavax/swing/JTree;", "errorColor", "Lcom/intellij/ui/JBColor;", "Lorg/jetbrains/annotations/NotNull;", "isDetailsShown", "detailsPlaceholder", "Lcom/intellij/ui/dsl/builder/Placeholder;", "detailsCollapsibleRow", "Lcom/intellij/ui/dsl/builder/CollapsibleRow;", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "doCancelAction", "createCertificateTree", "unselectOtherNodes", "root", "Lcom/intellij/ui/CheckedTreeNode;", "selectedNode", "getTreeCellTextAndColor", "Lkotlin/Pair;", "Ljava/awt/Color;", "value", "", "updateDetails", "getCertificateName", "cert", "addPrincipalData", "Lcom/intellij/ui/dsl/builder/Panel;", "fields", "isIssuedTo", "formatHex", "hex", "getTextPane", "Ljavax/swing/JTextPane;", "text", "getCertificateErrorsMap", "CertificateError", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nCertificateWarningDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificateWarningDialog.kt\ncom/intellij/net/ssl/CertificateWarningDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 8 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,472:1\n1761#2,3:473\n295#2,2:476\n1761#2,3:478\n1869#2,2:489\n1869#2,2:491\n1869#2,2:496\n1285#2,2:498\n1299#2,4:500\n1869#2,2:513\n295#2,2:515\n536#3:481\n521#3,6:482\n1#4:488\n477#5:493\n1321#5,2:494\n37#6,2:504\n13#7:506\n77#8:507\n97#8,5:508\n*S KotlinDebug\n*F\n+ 1 CertificateWarningDialog.kt\ncom/intellij/net/ssl/CertificateWarningDialog\n*L\n59#1:473,3\n60#1:476,2\n160#1:478,3\n176#1:489,2\n216#1:491,2\n390#1:496,2\n436#1:498,2\n436#1:500,4\n89#1:513,2\n360#1:515,2\n173#1:481\n173#1:482,6\n251#1:493\n252#1:494,2\n439#1:504,2\n444#1:506\n467#1:507\n467#1:508,5\n*E\n"})
public final class CertificateWarningDialog
extends DialogWrapper {
    @NotNull
    private final List<X509Certificate> certificates;
    @Nullable
    private final String remoteHost;
    @NotNull
    private final X509ExtendedTrustManager manager;
    @NotNull
    private final String authType;
    @NotNull
    private final CertificateProvider certificateProvider;
    private boolean expandedByButton;
    @NotNull
    private final Map<X509Certificate, List<CertificateError>> certificateErrorsMap;
    private final boolean hasUntrusted;
    @NotNull
    private CertificateWrapper currentCertificate;
    @NotNull
    private final JTree tree;
    @NotNull
    private final JBColor errorColor;
    private boolean isDetailsShown;
    private Placeholder detailsPlaceholder;
    private CollapsibleRow detailsCollapsibleRow;

    /*
     * WARNING - void declaration
     */
    public CertificateWarningDialog(@NotNull List<? extends X509Certificate> certificates, @Nullable String remoteHost, @NotNull X509ExtendedTrustManager manager2, @NotNull String authType, @NotNull CertificateProvider certificateProvider) {
        X509Certificate x509Certificate;
        Object v3;
        block6: {
            void $this$firstOrNull$iv;
            boolean bl;
            boolean bl2;
            CertificateWarningDialog certificateWarningDialog;
            block5: {
                void $this$any$iv;
                Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
                Intrinsics.checkNotNullParameter((Object)manager2, (String)"manager");
                Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
                Intrinsics.checkNotNullParameter((Object)certificateProvider, (String)"certificateProvider");
                super(false);
                this.certificates = certificates;
                this.remoteHost = remoteHost;
                this.manager = manager2;
                this.authType = authType;
                this.certificateProvider = certificateProvider;
                this.certificateErrorsMap = this.getCertificateErrorsMap();
                Iterable iterable = this.certificateErrorsMap.entrySet();
                certificateWarningDialog = this;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Map.Entry it = (Map.Entry)element$iv;
                        boolean bl3 = false;
                        if (!((List)it.getValue()).contains((Object)CertificateError.UNTRUSTED_AUTHORITY)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            certificateWarningDialog.hasUntrusted = bl = bl2;
            Iterable $i$f$any = CollectionsKt.reversed((Iterable)this.certificates);
            certificateWarningDialog = this;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                X509Certificate it = (X509Certificate)element$iv;
                boolean bl4 = false;
                List<CertificateError> list2 = this.certificateErrorsMap.get(it);
                Intrinsics.checkNotNull(list2);
                boolean bl5 = !((Collection)list2).isEmpty();
                if (!bl5) continue;
                v3 = element$iv;
                break block6;
            }
            v3 = null;
        }
        if ((x509Certificate = (X509Certificate)v3) == null) {
            x509Certificate = (X509Certificate)CollectionsKt.first(this.certificates);
        }
        X509Certificate x509Certificate2 = x509Certificate;
        certificateWarningDialog.currentCertificate = new CertificateWrapper(x509Certificate2);
        this.tree = this.createCertificateTree();
        JBColor jBColor = JBColor.namedColor((String)"Label.errorForeground", (Color)((Color)JBColor.red));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        this.errorColor = jBColor;
        this.setTitle(IdeBundle.message((String)"dialog.title.untrusted.server.s.certificate", (Object[])new Object[0]));
        this.setOKButtonText(IdeBundle.message((String)"show.details", (Object[])new Object[0]));
        this.getOKAction().putValue("DefaultAction", null);
        this.getOKAction().putValue("MacActionOrder", -10);
        this.setCancelButtonText(IdeBundle.message((String)"button.reject", (Object[])new Object[0]));
        this.getCancelAction().putValue("DefaultAction", true);
        this.getCancelAction().putValue("MacActionOrder", 100);
        this.init();
    }

    public /* synthetic */ CertificateWarningDialog(List list2, String string, X509ExtendedTrustManager x509ExtendedTrustManager, String string2, CertificateProvider certificateProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(list2, string, x509ExtendedTrustManager, string2, certificateProvider);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JBScrollPane jBScrollPane;
        DialogPanel panel2 = (DialogPanel)((DialogPanel)BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> CertificateWarningDialog.createCenterPanel$lambda$0(this, arg_0))).withMinimumWidth(JBUIScale.scale((int)400))).withPreferredWidth(JBUIScale.scale((int)600));
        JBScrollPane $this$createCenterPanel_u24lambda_u241 = jBScrollPane = new JBScrollPane((Component)panel2, 20, 31);
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u241.setBorder((Border)JBUI.Borders.empty());
        return (JComponent)jBScrollPane;
    }

    /*
     * Unable to fully structure code
     */
    protected void doOKAction() {
        block8: {
            block6: {
                block7: {
                    if (this.isDetailsShown) break block7;
                    this.expandedByButton = true;
                    v0 = this.detailsCollapsibleRow;
                    if (v0 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"detailsCollapsibleRow");
                        v0 = null;
                    }
                    v0.setExpanded(true);
                    break block8;
                }
                certificate = this.currentCertificate.getCertificate();
                this.certificateProvider.setSelectedCertificate(certificate);
                v1 = this.certificateProvider;
                if (Intrinsics.areEqual((Object)certificate, (Object)CollectionsKt.first(this.certificates))) ** GOTO lbl-1000
                var2_2 = this.certificates.subList(0, this.certificates.indexOf(certificate) - 1);
                var8_3 = v1;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v2 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (X509Certificate)element$iv;
                        $i$a$-any-CertificateWarningDialog$doOKAction$1 = false;
                        v3 = this.certificateErrorsMap.get(it);
                        Intrinsics.checkNotNull(v3);
                        v4 = !((Collection)v3).isEmpty();
                        if (!v4) continue;
                        v2 = true;
                        break block6;
                    }
                    v2 = false;
                }
            }
            var9_9 = v2;
            v1 = var8_3;
            if (var9_9) {
                v5 = true;
            } else lbl-1000:
            // 2 sources

            {
                v5 = false;
            }
            v1.setChainRemainUnsafe(v5);
            super.doOKAction();
            CertificateWarningStatisticsCollector.INSTANCE.certificateAccepted();
        }
    }

    public void doCancelAction() {
        super.doCancelAction();
        CertificateWarningStatisticsCollector.INSTANCE.certificateRejected();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final JTree createCertificateTree() {
        if (this.hasUntrusted && this.certificates.size() > 1) ** GOTO lbl-1000
        $this$filter$iv = this.certificateErrorsMap;
        $i$f$filter = false;
        var4_4 = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$filterTo = false;
        var7_11 = $this$filterTo$iv$iv.entrySet().iterator();
        while (var7_11.hasNext()) {
            entry = element$iv$iv = var7_11.next();
            $i$a$-filter-CertificateWarningDialog$createCertificateTree$certificatesTree$1 = false;
            v0 = !((Collection)entry.getValue()).isEmpty();
            if (!v0) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        if (destination$iv$iv.size() > 1) lbl-1000:
        // 2 sources

        {
            $this$createCertificateTree_u24lambda_u241 = $i$f$filter = new CheckedTreeNode((Object)"root");
            $i$a$-apply-CertificateWarningDialog$createCertificateTree$certificatesTree$root$1 = false;
            $this$createCertificateTree_u24lambda_u241.setChecked(false);
            root /* !! */  = $i$f$filter;
            lastNode /* !! */  = null;
            lastNode /* !! */  = root /* !! */ ;
            $this$forEach$iv = CollectionsKt.reversed((Iterable)this.certificates);
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (X509Certificate)element$iv;
                $i$a$-forEach-CertificateWarningDialog$createCertificateTree$certificatesTree$2 = false;
                $this$createCertificateTree_u24lambda_u242_u240 = $i$a$-filter-CertificateWarningDialog$createCertificateTree$certificatesTree$1 = new CheckedTreeNode((Object)it);
                $i$a$-apply-CertificateWarningDialog$createCertificateTree$certificatesTree$2$node$1 = false;
                $this$createCertificateTree_u24lambda_u242_u240.setChecked(Intrinsics.areEqual((Object)it, (Object)this.currentCertificate.getCertificate()));
                node = $i$a$-filter-CertificateWarningDialog$createCertificateTree$certificatesTree$1;
                lastNode /* !! */ .add((MutableTreeNode)node);
                lastNode /* !! */  = node;
            }
            renderer = new CheckboxTree.CheckboxTreeCellRenderer(this){
                final /* synthetic */ CertificateWarningDialog this$0;
                {
                    this.this$0 = $receiver;
                    this.myIgnoreInheritance = true;
                }

                public void customizeRenderer(JTree tree2, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
                    Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    super.customizeRenderer(tree2, value, selected, expanded, leaf, row2, hasFocus);
                    Pair textAndColor = CertificateWarningDialog.access$getTreeCellTextAndColor(this.this$0, value);
                    this.getTextRenderer().append((String)textAndColor.getFirst(), new SimpleTextAttributes(0, (Color)textAndColor.getSecond()));
                }
            };
            var6_10 = new CheckboxTreeBase.CheckPolicy(false, false, false, false, true);
            checkboxTree = new CheckboxTree(renderer, root /* !! */ , this, var6_10){
                final /* synthetic */ CheckedTreeNode $root;
                final /* synthetic */ CertificateWarningDialog this$0;
                {
                    this.$root = $root;
                    this.this$0 = $receiver;
                    super($renderer, $root, $super_call_param$1);
                }

                protected void onNodeStateChanged(CheckedTreeNode node) {
                    CheckedTreeNode checkedTreeNode = node;
                    Object object = checkedTreeNode != null ? checkedTreeNode.getUserObject() : null;
                    X509Certificate x509Certificate = object instanceof X509Certificate ? (X509Certificate)object : null;
                    if (x509Certificate == null) {
                        return;
                    }
                    X509Certificate userObject = x509Certificate;
                    if (node.isChecked()) {
                        CertificateWarningDialog.access$unselectOtherNodes(this.this$0, this.$root, node);
                        CertificateWarningDialog.access$setCurrentCertificate$p(this.this$0, new CertificateWrapper(userObject));
                        CertificateWarningDialog.access$updateDetails(this.this$0);
                    } else {
                        node.setChecked(true);
                    }
                    if (CertificateWarningDialog.access$isDetailsShown$p(this.this$0)) {
                        this.this$0.setOKActionEnabled(true);
                    }
                }
            };
            v1 = (Tree)checkboxTree;
        } else {
            root /* !! */  = new DefaultMutableTreeNode("root");
            lastNode /* !! */  = null;
            lastNode /* !! */  = root /* !! */ ;
            $this$forEach$iv = CollectionsKt.reversed((Iterable)this.certificates);
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (X509Certificate)element$iv;
                $i$a$-forEach-CertificateWarningDialog$createCertificateTree$certificatesTree$3 = false;
                node = new DefaultMutableTreeNode(it);
                lastNode /* !! */ .add(node);
                lastNode /* !! */  = node;
            }
            defaultTree = new Tree((TreeNode)root /* !! */ );
            TreeUtil.selectInTree((DefaultMutableTreeNode)lastNode /* !! */ , (boolean)false, (JTree)((JTree)defaultTree));
            defaultTree.setCellRenderer(new TreeCellRenderer(this){
                final /* synthetic */ CertificateWarningDialog this$0;
                {
                    this.this$0 = $receiver;
                }

                public Component getTreeCellRendererComponent(JTree tree2, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
                    Pair textAndColor = CertificateWarningDialog.access$getTreeCellTextAndColor(this.this$0, value);
                    JBLabel component2 = new JBLabel((String)textAndColor.getFirst());
                    component2.setForeground((Color)textAndColor.component2());
                    return (Component)component2;
                }
            });
            v1 = defaultTree;
        }
        certificatesTree = v1;
        TreeUtil.expandAll((JTree)((JTree)certificatesTree));
        certificatesTree.getSelectionModel().setSelectionMode(1);
        certificatesTree.setRootVisible(false);
        certificatesTree.setBorder((Border)BorderFactory.createCompoundBorder((Border)new RoundedLineBorder(JBColor.border(), 10, 0, 4, null), JBUI.Borders.empty((int)3)));
        certificatesTree.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"ssl.certificate.tree.accessible.name", (Object[])new Object[0]));
        return (JTree)certificatesTree;
    }

    private final void unselectOtherNodes(CheckedTreeNode root, CheckedTreeNode selectedNode) {
        Enumeration enumeration = root.children();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"children(...)");
        Sequence $this$filterIsInstance$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator((Enumeration)enumeration));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)unselectOtherNodes$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence $this$forEach$iv = sequence;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CheckedTreeNode child = (CheckedTreeNode)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)child, (Object)selectedNode) && child.isChecked()) {
                child.setChecked(false);
            }
            this.unselectOtherNodes(child, selectedNode);
        }
    }

    @NlsSafe
    private final Pair<String, Color> getTreeCellTextAndColor(Object value) {
        Color color = JBUI.CurrentTheme.Label.foreground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"foreground(...)");
        Color labelForeground = color;
        DefaultMutableTreeNode defaultMutableTreeNode = value instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)value : null;
        Object object = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
        X509Certificate x509Certificate = object instanceof X509Certificate ? (X509Certificate)object : null;
        if (x509Certificate == null) {
            return new Pair((Object)"", (Object)labelForeground);
        }
        X509Certificate userObject = x509Certificate;
        List<CertificateError> list2 = this.certificateErrorsMap.get(userObject);
        Intrinsics.checkNotNull(list2);
        List<CertificateError> certErrors = list2;
        List errors = new ArrayList();
        if (certErrors.contains((Object)CertificateError.NOT_YET_VALID)) {
            String string = IdeBundle.message((String)"label.certificate.not.yet.valid", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            errors.add(string);
        } else if (certErrors.contains((Object)CertificateError.EXPIRED)) {
            String string = IdeBundle.message((String)"label.certificate.expired", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            errors.add(string);
        }
        if (certErrors.contains((Object)CertificateError.SELF_SIGNED)) {
            String string = IdeBundle.message((String)"label.certificate.self.signed", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            errors.add(string);
        } else if (certErrors.contains((Object)CertificateError.UNTRUSTED_AUTHORITY)) {
            String string = !Intrinsics.areEqual((Object)userObject, (Object)CollectionsKt.first(this.certificates)) ? IdeBundle.message((String)"label.certificate.untrusted.authority", (Object[])new Object[0]) : IdeBundle.message((String)"label.certificate.signed.by.untrusted.authority", (Object[])new Object[0]);
            Intrinsics.checkNotNull((Object)string);
            String error = string;
            errors.add(error);
        }
        String certificateName = this.getCertificateName(userObject);
        String errorText = CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)(" " + IdeBundle.message((String)"label.certificate.and", (Object[])new Object[0]) + " "), null, null, (int)0, null, null, (int)62, null);
        return !((Collection)errors).isEmpty() ? new Pair((Object)(certificateName + " (" + errorText + ")"), (Object)this.errorColor) : new Pair((Object)certificateName, (Object)labelForeground);
    }

    private final void updateDetails() {
        Placeholder placeholder;
        List errors;
        List list2 = this.certificateErrorsMap.get(this.currentCertificate.getCertificate());
        if (list2 == null) {
            list2 = errors = CollectionsKt.emptyList();
        }
        if ((placeholder = this.detailsPlaceholder) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"detailsPlaceholder");
            placeholder = null;
        }
        placeholder.setComponent((JComponent)BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> CertificateWarningDialog.updateDetails$lambda$0(this, errors, arg_0))));
    }

    private final String getCertificateName(X509Certificate cert) {
        String string = (String)new CertificateWrapper(cert).getSubjectFields().get(CertificateWrapper.CommonField.COMMON_NAME.getShortName());
        if (string == null) {
            String string2 = cert.getSubjectX500Principal().getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        }
        return string;
    }

    private final void addPrincipalData(Panel $this$addPrincipalData, Map<String, String> fields, boolean isIssuedTo) {
        List list2 = this.certificateErrorsMap.get(this.currentCertificate.getCertificate());
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List errors = list2;
        String errorText = isIssuedTo && errors.contains((Object)CertificateError.SELF_SIGNED) ? IdeBundle.message((String)"label.certificate.self.signed", (Object[])new Object[0]) : (!isIssuedTo && errors.contains((Object)CertificateError.UNTRUSTED_AUTHORITY) ? IdeBundle.message((String)"label.certificate.untrusted.authority", (Object[])new Object[0]) : null);
        Ref.BooleanRef isErrorHighlighted = new Ref.BooleanRef();
        Iterable $this$forEach$iv = (Iterable)EntriesMappings.entries$0;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v1;
            CertificateWrapper.CommonField commonField;
            block3: {
                commonField = (CertificateWrapper.CommonField)element$iv;
                boolean bl = false;
                Iterable iterable = fields.entrySet();
                for (Object t : iterable) {
                    Map.Entry it = (Map.Entry)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getKey(), (Object)commonField.getShortName())) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            Map.Entry field = v1;
            if (field == null) continue;
            $this$addPrincipalData.row(commonField.getLongName() + ":", (Function1<? super Row, Unit>)((Function1)arg_0 -> CertificateWarningDialog.addPrincipalData$lambda$0$1(isIssuedTo, errorText, isErrorHighlighted, commonField, field, this, arg_0)));
        }
    }

    @NotNull
    public final String formatHex(@NotNull String hex) {
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        if (Intrinsics.areEqual((Object)"N/A", (Object)hex)) {
            return hex;
        }
        StringBuilder builder = new StringBuilder();
        for (int i2 = 0; i2 < hex.length(); i2 += 2) {
            builder.append(hex, i2, i2 + 2);
            builder.append(' ');
        }
        if (((CharSequence)hex).length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        String string = StringUtil.toUpperCase((String)builder.toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return string;
    }

    private final JTextPane getTextPane(@NlsSafe String text2) {
        JTextPane pane2 = new JTextPane();
        pane2.setOpaque(false);
        pane2.setEditable(false);
        pane2.setBorder(null);
        pane2.setContentType("text/plain");
        pane2.setText(text2);
        return pane2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<X509Certificate, List<CertificateError>> getCertificateErrorsMap() {
        void $this$flatMapTo$iv$iv;
        boolean $this$toTypedArray$iv22;
        X509Certificate[] x509CertificateArray;
        void $this$associateWithTo$iv$iv;
        Iterable $this$associateWith$iv = this.certificates;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            x509CertificateArray = (X509Certificate)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            List list2 = new ArrayList();
            map2.put(t, list2);
        }
        Map result2 = MapsKt.toMutableMap((Map)destination$iv$iv);
        String errorMessage = "unable to find valid certification path";
        try {
            Collection $this$toTypedArray$iv22 = this.certificates;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv22;
            this.manager.checkServerTrusted(thisCollection$iv.toArray(new X509Certificate[0]), this.authType);
            $this$toTypedArray$iv22 = false;
        }
        catch (CertificateException e) {
            boolean hasPathError;
            String string = e.getMessage();
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)errorMessage, (boolean)false, (int)2, null) : (hasPathError = false);
            if (!hasPathError) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(CertificateWarningDialog.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Certificate validation message: " + e.getMessage());
            }
            $this$toTypedArray$iv22 = hasPathError;
        }
        boolean isPureUntrustedServer = $this$toTypedArray$iv22;
        List reversedCertList = CollectionsKt.reversed((Iterable)this.certificates);
        int hasPathError = ((Collection)reversedCertList).size();
        for (int i2 = 0; i2 < hasPathError; ++i2) {
            X509Certificate cert = (X509Certificate)reversedCertList.get(i2);
            CertificateWrapper model2 = new CertificateWrapper(cert);
            Object v = result2.get(cert);
            Intrinsics.checkNotNull(v);
            List errors = (List)v;
            if (i2 == reversedCertList.size() - 1 && !((Collection)CollectionsKt.flatten((Iterable)result2.values())).isEmpty()) {
                errors.add(CertificateError.UNTRUSTED_AUTHORITY);
            }
            try {
                x509CertificateArray = new X509Certificate[]{cert};
                this.manager.checkServerTrusted(x509CertificateArray, this.authType);
                continue;
            }
            catch (CertificateException certificateException) {
                if (isPureUntrustedServer && !model2.isSelfSigned() && !CollectionsKt.flatten((Iterable)result2.values()).contains((Object)CertificateError.UNTRUSTED_AUTHORITY)) {
                    errors.add(CertificateError.UNTRUSTED_AUTHORITY);
                    continue;
                }
                if (model2.isSelfSigned()) {
                    errors.add(CertificateError.SELF_SIGNED);
                }
                if (model2.isNotYetValid()) {
                    errors.add(CertificateError.NOT_YET_VALID);
                }
                if (!model2.isExpired()) continue;
                errors.add(CertificateError.EXPIRED);
            }
        }
        Map $this$flatMap$iv = result2;
        boolean $i$f$flatMap = false;
        Map cert = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        x509CertificateArray = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (x509CertificateArray.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = (Map.Entry)x509CertificateArray.next();
            boolean bl = false;
            Iterable list$iv$iv = (Iterable)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        if (((List)destination$iv$iv2).isEmpty()) {
            CertificateError[] certificateErrorArray = new CertificateError[]{CertificateError.UNTRUSTED_AUTHORITY};
            result2.put(CollectionsKt.first(this.certificates), CollectionsKt.mutableListOf((Object[])certificateErrorArray));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$0(CertificateWarningDialog this$0, Panel $this$panel) {
        void $this$createCenterPanel_u24lambda_u240_u244;
        CollapsibleRow collapsibleRow;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default($this$panel, null, arg_0 -> CertificateWarningDialog.createCenterPanel$lambda$0$0(this$0, arg_0), 1, null);
        if (this$0.remoteHost != null) {
            String string = IdeBundle.message((String)"ssl.certificate.server.address", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $this$panel.row(string, (Function1<? super Row, Unit>)((Function1)arg_0 -> CertificateWarningDialog.createCenterPanel$lambda$0$1(this$0, arg_0)));
        }
        Panel.row$default($this$panel, null, arg_0 -> CertificateWarningDialog.createCenterPanel$lambda$0$2(this$0, arg_0), 1, null);
        String string = IdeBundle.message((String)"ssl.certificate.details", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        CollapsibleRow collapsibleRow2 = collapsibleRow = Panel.collapsibleGroup$default($this$panel, string, false, arg_0 -> CertificateWarningDialog.createCenterPanel$lambda$0$3(this$0, arg_0), 2, null);
        CertificateWarningDialog certificateWarningDialog = this$0;
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u240_u244.addExpandedListener((Function1<? super Boolean, Unit>)((Function1)arg_0 -> CertificateWarningDialog.createCenterPanel$lambda$0$4$0(this$0, arg_0)));
        certificateWarningDialog.detailsCollapsibleRow = collapsibleRow;
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0(CertificateWarningDialog this$0, Row $this$row) {
        String string;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                String error = null;
                Row $this$createCenterPanel_u24lambda_u240_u240_u240 = $this$row;
                boolean bl = false;
                Iterable $this$forEach$iv = this$0.certificates;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    List<CertificateError> errors;
                    X509Certificate it = (X509Certificate)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull(this$0.certificateErrorsMap.get(it));
                    String string2 = errors.contains((Object)CertificateError.SELF_SIGNED) ? IdeBundle.message((String)"ssl.certificate.error.self.signed", (Object[])new Object[0]) : (errors.contains((Object)CertificateError.NOT_YET_VALID) ? IdeBundle.message((String)"ssl.certificate.error.not.yet.valid", (Object[])new Object[0]) : (errors.contains((Object)CertificateError.EXPIRED) ? IdeBundle.message((String)"ssl.certificate.error.expired", (Object[])new Object[0]) : (errors.contains((Object)CertificateError.UNTRUSTED_AUTHORITY) ? IdeBundle.message((String)"ssl.certificate.error.untrusted.authority", (Object[])new Object[0]) : null)));
                    if (string2 == null) continue;
                    String it2 = string2;
                    boolean bl3 = false;
                    error = it2;
                    break;
                }
                Icon icon2 = AllIcons.General.WarningDialog;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"WarningDialog");
                $this$row.icon(icon2);
                string = error;
                if (string == null) break block3;
                String it = string;
                boolean bl4 = false;
                Object[] objectArray = new Object[]{it, this$0.hasUntrusted ? IdeBundle.message((String)"ssl.certificate.warning.plural", (Object[])new Object[0]) : IdeBundle.message((String)"ssl.certificate.warning.singular", (Object[])new Object[0])};
                String string3 = IdeBundle.message((String)"ssl.certificate.warning", (Object[])objectArray);
                string = string3;
                if (string3 != null) break block4;
            }
            String string4 = IdeBundle.message((String)"ssl.certificate.warning.default", (Object[])new Object[0]);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        }
        String errorText = string;
        String string5 = HtmlChunk.text((String)errorText).bold().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        Row.text$default($this$row, string5, 0, null, 6, null).applyToComponent(CertificateWarningDialog::createCenterPanel$lambda$0$0$2);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0$2(JEditorPane $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        if (ScreenReader.isActive()) {
            $this$applyToComponent.setFocusable(true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1(CertificateWarningDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default($this$row, this$0.remoteHost, 0, null, 6, null).align(AlignX.LEFT.INSTANCE).applyToComponent(CertificateWarningDialog::createCenterPanel$lambda$0$1$0);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1$0(JEditorPane $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        if (ScreenReader.isActive()) {
            $this$applyToComponent.setFocusable(true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$2(CertificateWarningDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.tree).align(AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$3(CertificateWarningDialog this$0, Panel $this$collapsibleGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$collapsibleGroup, (String)"$this$collapsibleGroup");
        Panel.row$default($this$collapsibleGroup, null, arg_0 -> CertificateWarningDialog.createCenterPanel$lambda$0$3$0(this$0, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$3$0(CertificateWarningDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.detailsPlaceholder = $this$row.placeholder().align(AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$4$0(CertificateWarningDialog this$0, boolean it) {
        if (it) {
            CertificateWarningStatisticsCollector.INSTANCE.detailsShown(this$0.expandedByButton);
            this$0.expandedByButton = false;
        }
        if (it && !this$0.isDetailsShown) {
            this$0.setOKButtonText(IdeBundle.message((String)"save.as.trusted.certificate", (Object[])new Object[0]));
            this$0.isDetailsShown = true;
            this$0.setOKActionEnabled(true);
            this$0.updateDetails();
        }
        this$0.pack();
        return Unit.INSTANCE;
    }

    private static final Unit updateDetails$lambda$0(CertificateWarningDialog this$0, List $errors, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> CertificateWarningDialog.updateDetails$lambda$0$0(this$0, $errors, arg_0)));
        Panel.row$default($this$panel, null, CertificateWarningDialog::updateDetails$lambda$0$1, 1, null).topGap(TopGap.SMALL);
        return Unit.INSTANCE;
    }

    private static final Unit updateDetails$lambda$0$0(CertificateWarningDialog this$0, List $errors, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.customizeSpacingConfiguration((SpacingConfiguration)new IntelliJSpacingConfiguration(){
            private final int verticalMediumGap;
            private final int verticalSmallGap;
            private final int verticalComponentGap;
            private final int horizontalIndent;
            {
                this.verticalMediumGap = 6;
                this.verticalSmallGap = 2;
                this.verticalComponentGap = 3;
                this.horizontalIndent = 20;
            }

            public int getVerticalMediumGap() {
                return this.verticalMediumGap;
            }

            public int getVerticalSmallGap() {
                return this.verticalSmallGap;
            }

            public int getVerticalComponentGap() {
                return this.verticalComponentGap;
            }

            public int getHorizontalIndent() {
                return this.horizontalIndent;
            }
        }, (Function1<? super Panel, Unit>)((Function1)arg_0 -> CertificateWarningDialog.updateDetails$lambda$0$0$0(this$0, $errors, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit updateDetails$lambda$0$0$0(CertificateWarningDialog this$0, List $errors, Panel $this$customizeSpacingConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$customizeSpacingConfiguration, (String)"$this$customizeSpacingConfiguration");
        Panel.row$default($this$customizeSpacingConfiguration, null, CertificateWarningDialog::updateDetails$lambda$0$0$0$0, 1, null).bottomGap(BottomGap.SMALL).topGap(TopGap.MEDIUM);
        $this$customizeSpacingConfiguration.indent((Function1<? super Panel, Unit>)((Function1)arg_0 -> CertificateWarningDialog.updateDetails$lambda$0$0$0$1(this$0, arg_0)));
        Panel.row$default($this$customizeSpacingConfiguration, null, CertificateWarningDialog::updateDetails$lambda$0$0$0$2, 1, null).bottomGap(BottomGap.SMALL).topGap(TopGap.MEDIUM);
        $this$customizeSpacingConfiguration.indent((Function1<? super Panel, Unit>)((Function1)arg_0 -> CertificateWarningDialog.updateDetails$lambda$0$0$0$3(this$0, arg_0)));
        Panel.row$default($this$customizeSpacingConfiguration, null, CertificateWarningDialog::updateDetails$lambda$0$0$0$4, 1, null).bottomGap(BottomGap.SMALL).topGap(TopGap.MEDIUM);
        $this$customizeSpacingConfiguration.indent((Function1<? super Panel, Unit>)((Function1)arg_0 -> CertificateWarningDialog.updateDetails$lambda$0$0$0$5(this$0, $errors, arg_0)));
        Panel.row$default($this$customizeSpacingConfiguration, null, CertificateWarningDialog::updateDetails$lambda$0$0$0$6, 1, null).bottomGap(BottomGap.SMALL).topGap(TopGap.MEDIUM);
        $this$customizeSpacingConfiguration.indent((Function1<? super Panel, Unit>)((Function1)arg_0 -> CertificateWarningDialog.updateDetails$lambda$0$0$0$7(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit updateDetails$lambda$0$0$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"section.title.issued.to", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        return Unit.INSTANCE;
    }

    private static final Unit updateDetails$lambda$0$0$0$1(CertificateWarningDialog this$0, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Map map2 = this$0.currentCertificate.getSubjectFields();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getSubjectFields(...)");
        this$0.addPrincipalData($this$indent, map2, true);
        return Unit.INSTANCE;
    }

    private static final Unit updateDetails$lambda$0$0$0$2(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"section.title.issued.by", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        return Unit.INSTANCE;
    }

    private static final Unit updateDetails$lambda$0$0$0$3(CertificateWarningDialog this$0, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Map map2 = this$0.currentCertificate.getIssuerFields();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getIssuerFields(...)");
        this$0.addPrincipalData($this$indent, map2, false);
        return Unit.INSTANCE;
    }

    private static final Unit updateDetails$lambda$0$0$0$4(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"section.title.validity.period", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        return Unit.INSTANCE;
    }

    private static final Unit updateDetails$lambda$0$0$0$5(CertificateWarningDialog this$0, List $errors, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        String string = IdeBundle.message((String)"label.valid.from", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$indent.row(string, (Function1<? super Row, Unit>)((Function1)arg_0 -> CertificateWarningDialog.updateDetails$lambda$0$0$0$5$0(dateFormat, this$0, $errors, arg_0)));
        String string2 = IdeBundle.message((String)"label.valid.until", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$indent.row(string2, (Function1<? super Row, Unit>)((Function1)arg_0 -> CertificateWarningDialog.updateDetails$lambda$0$0$0$5$1(dateFormat, this$0, $errors, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit updateDetails$lambda$0$0$0$5$0(DateFormat $dateFormat, CertificateWarningDialog this$0, List $errors, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String notBefore = $dateFormat.format(this$0.currentCertificate.getNotBefore());
        boolean hasError = $errors.contains((Object)CertificateError.NOT_YET_VALID);
        String text2 = hasError ? notBefore + " (" + IdeBundle.message((String)"label.certificate.not.yet.valid", (Object[])new Object[0]) + ")" : String.valueOf(notBefore);
        Cell $this$updateDetails_u24lambda_u240_u240_u240_u245_u240_u240 = cell = Row.text$default($this$row, text2, 0, null, 6, null);
        boolean bl = false;
        if (hasError) {
            ((JEditorPane)$this$updateDetails_u24lambda_u240_u240_u240_u245_u240_u240.getComponent()).setForeground((Color)this$0.errorColor);
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateDetails$lambda$0$0$0$5$1(DateFormat $dateFormat, CertificateWarningDialog this$0, List $errors, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String notAfter = $dateFormat.format(this$0.currentCertificate.getNotAfter());
        boolean hasError = $errors.contains((Object)CertificateError.EXPIRED);
        String text2 = hasError ? notAfter + " (" + IdeBundle.message((String)"label.certificate.expired", (Object[])new Object[0]) + ")" : String.valueOf(notAfter);
        Cell $this$updateDetails_u24lambda_u240_u240_u240_u245_u241_u240 = cell = Row.text$default($this$row, text2, 0, null, 6, null);
        boolean bl = false;
        if (hasError) {
            ((JEditorPane)$this$updateDetails_u24lambda_u240_u240_u240_u245_u241_u240.getComponent()).setForeground((Color)this$0.errorColor);
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateDetails$lambda$0$0$0$6(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"section.title.fingerprints", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        return Unit.INSTANCE;
    }

    private static final Unit updateDetails$lambda$0$0$0$7(CertificateWarningDialog this$0, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.row("SHA-256:", (Function1<? super Row, Unit>)((Function1)arg_0 -> CertificateWarningDialog.updateDetails$lambda$0$0$0$7$0(this$0, arg_0)));
        $this$indent.row("SHA-1:", (Function1<? super Row, Unit>)((Function1)arg_0 -> CertificateWarningDialog.updateDetails$lambda$0$0$0$7$1(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit updateDetails$lambda$0$0$0$7$0(CertificateWarningDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = this$0.currentCertificate.getSha256Fingerprint();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSha256Fingerprint(...)");
        JTextPane pane2 = this$0.getTextPane(this$0.formatHex(string));
        $this$row.cell((JComponent)pane2).align(AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit updateDetails$lambda$0$0$0$7$1(CertificateWarningDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = this$0.currentCertificate.getSha1Fingerprint();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSha1Fingerprint(...)");
        $this$row.cell((JComponent)this$0.getTextPane(this$0.formatHex(string))).align(AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit updateDetails$lambda$0$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        EditorNotificationPanel.Status status2 = EditorNotificationPanel.Status.Warning;
        String string = IdeBundle.message((String)"trust.certificate.warning.details", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        InlineBanner banner = new InlineBanner(string, status2);
        banner.showCloseButton(false);
        String string2 = IdeBundle.message((String)"trust.certificate.warning.details.action", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        banner.addAction(string2, () -> CertificateWarningDialog.updateDetails$lambda$0$1$0(banner));
        $this$row.cell((JComponent)banner).align(AlignX.FILL.INSTANCE).applyToComponent((Function1<JComponent, Unit>)((Function1)CertificateWarningDialog::updateDetails$lambda$0$1$1));
        return Unit.INSTANCE;
    }

    private static final void updateDetails$lambda$0$1$0(InlineBanner $banner) {
        LinkLabel linkLabel;
        Object v3;
        Color foreground;
        Color backgroundColor;
        CertificateManager certManager;
        block2: {
            certManager = CertificateManager.Companion.getInstance();
            Color color = UIUtil.getToolTipBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getToolTipBackground(...)");
            backgroundColor = color;
            Color color2 = UIUtil.getToolTipForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getToolTipForeground(...)");
            foreground = color2;
            List list2 = ComponentUtil.findComponentsOfType((JComponent)((JComponent)$banner), LinkLabel.class);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"findComponentsOfType(...)");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LinkLabel it = (LinkLabel)element$iv;
                boolean bl = false;
                if (!it.isVisible()) continue;
                v3 = element$iv;
                break block2;
            }
            v3 = null;
        }
        if ((linkLabel = (LinkLabel)v3) == null) {
            linkLabel = $banner;
        }
        LinkLabel component2 = linkLabel;
        Object[] objectArray = new Object[]{certManager.getCacertsPath(), certManager.getPassword()};
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(IdeBundle.message((String)"trust.certificate.warning.details.popup", (Object[])objectArray), null, foreground, backgroundColor, null).setBorderColor(backgroundColor).setAnimationCycle(0).createBalloon().show(new RelativePoint((Component)component2, new Point()), Balloon.Position.above);
    }

    private static final Unit updateDetails$lambda$0$1$1(InlineBanner $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.putClientProperty((Object)DslComponentProperty.VISUAL_PADDINGS, (Object)UnscaledGaps.EMPTY);
        return Unit.INSTANCE;
    }

    private static final Unit addPrincipalData$lambda$0$1(boolean $isIssuedTo, String $errorText, Ref.BooleanRef $isErrorHighlighted, CertificateWrapper.CommonField $commonField, Map.Entry $field, CertificateWarningDialog this$0, Row $this$row) {
        Cell cell;
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        if ($isIssuedTo) {
            Object[] objectArray = new CertificateWrapper.CommonField[]{CertificateWrapper.CommonField.ORGANIZATION_UNIT, CertificateWrapper.CommonField.ORGANIZATION};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list2 = CollectionsKt.listOf((Object)CertificateWrapper.CommonField.COMMON_NAME);
        }
        List errorFields = list2;
        boolean errorCondition = $errorText != null && !$isErrorHighlighted.element && errorFields.contains($commonField);
        Object text2 = errorCondition ? $field.getValue() + " (" + $errorText + ")" : (String)$field.getValue();
        Cell $this$addPrincipalData_u24lambda_u240_u241_u240 = cell = Row.text$default($this$row, (String)text2, 0, null, 6, null);
        boolean bl = false;
        if (errorCondition) {
            ((JEditorPane)$this$addPrincipalData_u24lambda_u240_u241_u240.getComponent()).setForeground((Color)this$0.errorColor);
            $isErrorHighlighted.element = true;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Pair access$getTreeCellTextAndColor(CertificateWarningDialog $this, Object value) {
        return $this.getTreeCellTextAndColor(value);
    }

    public static final /* synthetic */ void access$unselectOtherNodes(CertificateWarningDialog $this, CheckedTreeNode root, CheckedTreeNode selectedNode) {
        $this.unselectOtherNodes(root, selectedNode);
    }

    public static final /* synthetic */ void access$setCurrentCertificate$p(CertificateWarningDialog $this, CertificateWrapper certificateWrapper) {
        $this.currentCertificate = certificateWrapper;
    }

    public static final /* synthetic */ void access$updateDetails(CertificateWarningDialog $this) {
        $this.updateDetails();
    }

    public static final /* synthetic */ boolean access$isDetailsShown$p(CertificateWarningDialog $this) {
        return $this.isDetailsShown;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/net/ssl/CertificateWarningDialog$CertificateError;", "", "<init>", "(Ljava/lang/String;I)V", "EXPIRED", "NOT_YET_VALID", "UNTRUSTED_AUTHORITY", "SELF_SIGNED", "intellij.platform.ide.impl"})
    private static final class CertificateError
    extends Enum<CertificateError> {
        public static final /* enum */ CertificateError EXPIRED = new CertificateError();
        public static final /* enum */ CertificateError NOT_YET_VALID = new CertificateError();
        public static final /* enum */ CertificateError UNTRUSTED_AUTHORITY = new CertificateError();
        public static final /* enum */ CertificateError SELF_SIGNED = new CertificateError();
        private static final /* synthetic */ CertificateError[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CertificateError[] values() {
            return (CertificateError[])$VALUES.clone();
        }

        public static CertificateError valueOf(String value) {
            return Enum.valueOf(CertificateError.class, value);
        }

        @NotNull
        public static EnumEntries<CertificateError> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = certificateErrorArray = new CertificateError[]{CertificateError.EXPIRED, CertificateError.NOT_YET_VALID, CertificateError.UNTRUSTED_AUTHORITY, CertificateError.SELF_SIGNED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<CertificateWrapper.CommonField> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])CertificateWrapper.CommonField.values()));
        }
    }
}

