/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.BitUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionButtonWithText
extends ActionButton {
    private static final int ICON_TEXT_SPACE = 2;
    private static final int TEXT_ARROW_SPACE = 2;
    private static final int BUTTONS_GAP = 4;
    private int myHorizontalTextPosition;
    private int myHorizontalTextAlignment;
    public static final Key<Boolean> SHORTCUT_SHOULD_SHOWN = new Key("SHORTCUT_SHOULD_SHOWN");

    public ActionButtonWithText(@NotNull AnAction action2, @Nullable Presentation presentation2, @NotNull String place, @NotNull Dimension minimumSize) {
        if (action2 == null) {
            ActionButtonWithText.$$$reportNull$$$0(0);
        }
        if (place == null) {
            ActionButtonWithText.$$$reportNull$$$0(1);
        }
        if (minimumSize == null) {
            ActionButtonWithText.$$$reportNull$$$0(2);
        }
        this(action2, presentation2, place, () -> minimumSize);
    }

    public ActionButtonWithText(@NotNull AnAction action2, @Nullable Presentation presentation2, @NotNull String place, Supplier<? extends @NotNull Dimension> minimumSize) {
        if (action2 == null) {
            ActionButtonWithText.$$$reportNull$$$0(3);
        }
        if (place == null) {
            ActionButtonWithText.$$$reportNull$$$0(4);
        }
        super(action2, presentation2, place, minimumSize);
        this.myHorizontalTextPosition = 11;
        this.myHorizontalTextAlignment = 0;
        boolean useSmallFonts = Boolean.TRUE.equals(this.myPresentation.getClientProperty(ActionUtil.USE_SMALL_FONT_IN_TOOLBAR));
        this.setFont((Font)(useSmallFonts ? JBUI.Fonts.toolbarSmallComboBoxFont() : StartupUiUtil.getLabelFont()));
        this.setForeground(UIUtil.getLabelForeground());
        this.myPresentation.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("mnemonicKey")) {
                    int oldValue = evt.getOldValue() instanceof Integer ? (Integer)evt.getOldValue() : 0;
                    int newValue = evt.getNewValue() instanceof Integer ? (Integer)evt.getNewValue() : 0;
                    ActionButtonWithText.this.updateMnemonic(oldValue, newValue);
                }
                if (evt.getPropertyName().equals(SHORTCUT_SHOULD_SHOWN.toString())) {
                    ActionButtonWithText.this.updateToolTipText();
                }
                if (evt.getPropertyName().equals("icon")) {
                    ActionButtonWithText.this.revalidate();
                }
            }
        });
        this.getActionMap().put("doClick", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionButtonWithText.this.click();
            }
        });
        this.updateMnemonic(0, this.myPresentation.getMnemonic());
        ClientProperty.put((JComponent)this, (Key)MnemonicHelper.MNEMONIC_CHECKER, keyCode -> this.getMnemonic() == keyCode);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if ("EditorToolbar".equals(this.myPlace)) {
            this.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
            this.setForeground(ColorUtil.dimmer((Color)JBColor.BLACK));
        } else {
            boolean useSmallFonts = Boolean.TRUE.equals(this.myPresentation.getClientProperty(ActionUtil.USE_SMALL_FONT_IN_TOOLBAR));
            this.setFont((Font)(useSmallFonts ? JBUI.Fonts.toolbarSmallComboBoxFont() : StartupUiUtil.getLabelFont()));
        }
    }

    @Override
    @NotNull
    protected Icon getFallbackIcon(boolean enabled2) {
        Icon icon2 = EmptyIcon.ICON_0;
        if (icon2 == null) {
            ActionButtonWithText.$$$reportNull$$$0(5);
        }
        return icon2;
    }

    private void updateMnemonic(int lastMnemonic, int mnemonic) {
        int mask;
        if (mnemonic == lastMnemonic) {
            return;
        }
        InputMap windowInputMap = SwingUtilities.getUIInputMap(this, 2);
        int n = mask = SystemInfo.isMac ? 10 : 8;
        if (lastMnemonic != 0 && windowInputMap != null) {
            windowInputMap.remove(KeyStroke.getKeyStroke(lastMnemonic, mask, false));
        }
        if (mnemonic != 0) {
            if (windowInputMap == null) {
                windowInputMap = new ComponentInputMapUIResource(this);
                SwingUtilities.replaceUIInputMap(this, 2, windowInputMap);
            }
            windowInputMap.put(KeyStroke.getKeyStroke(mnemonic, mask, false), "doClick");
        }
    }

    @NotNull
    protected Insets getMargins() {
        JBInsets jBInsets = JBUI.insets((int)0, (int)4);
        if (jBInsets == null) {
            ActionButtonWithText.$$$reportNull$$$0(6);
        }
        return jBInsets;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension basicSize = super.getPreferredSize();
        Icon icon2 = this.getIcon();
        int position = this.horizontalTextPosition();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Rectangle viewRect = new Rectangle(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        Insets insets = this.getInsets();
        int dx = insets.left + insets.right;
        int dy = insets.top + insets.bottom;
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        SwingUtilities.layoutCompoundLabel(this, fm, this.getText(), icon2, 0, this.horizontalTextAlignment(), 0, position, viewRect, iconR, textR, this.iconTextSpace());
        int x1 = Math.min(iconR.x, textR.x);
        int x2 = Math.max(iconR.x + iconR.width, textR.x + textR.width);
        int y1 = Math.min(iconR.y, textR.y);
        int y2 = Math.max(iconR.y + iconR.height, textR.y + textR.height);
        Dimension rv = new Dimension(x2 - x1 + dx, y2 - y1 + dy);
        if (this.shallPaintDownArrow()) {
            rv.width += this.getDownArrowIcon().getIconWidth() + JBUI.scale((int)2);
        }
        Insets m = this.getMargins();
        JBInsets.addTo((Dimension)rv, (Insets)m);
        rv.width = Math.max(rv.width, basicSize.width);
        rv.height = Math.max(rv.height, basicSize.height);
        return rv;
    }

    @Override
    protected void updateToolTipText() {
        String description = this.myPresentation.getDescription();
        if (UISettings.isIdeHelpTooltipEnabled()) {
            HelpTooltip.dispose((Component)this);
            HelpTooltip tooltip = (HelpTooltip)this.myPresentation.getClientProperty(CUSTOM_HELP_TOOLTIP);
            if (tooltip == null && !StringUtil.isEmpty((String)description)) {
                tooltip = new HelpTooltip().setDescription(description);
                Boolean property = (Boolean)this.myPresentation.getClientProperty(SHORTCUT_SHOULD_SHOWN);
                if (property != null && property.booleanValue()) {
                    tooltip.setShortcut(this.getShortcutText());
                }
            }
            if (tooltip != null) {
                tooltip.installOn((JComponent)this);
            }
        } else {
            this.setToolTipText(description);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Icon icon2 = this.getIcon();
        Icon arrowIcon = this.shallPaintDownArrow() ? this.getEnableOrDisable(this.getDownArrowIcon()) : null;
        UISettings.setupAntialiasing((Graphics)g);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Rectangle viewRect = this.getButtonRect();
        JBInsets.removeFrom((Rectangle)viewRect, (Insets)this.getInsets());
        JBInsets.removeFrom((Rectangle)viewRect, (Insets)this.getMargins());
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        String text2 = SwingUtilities.layoutCompoundLabel(this, fm, this.getText(), icon2, 0, this.horizontalTextAlignment(), 0, this.horizontalTextPosition(), viewRect, iconRect, textRect, this.iconTextSpace());
        if (arrowIcon != null) {
            int alignment = this.horizontalTextAlignment();
            int dx = alignment == 0 ? arrowIcon.getIconWidth() / 2 - 2 : (alignment == 4 ? arrowIcon.getIconWidth() : 0);
            iconRect.x -= dx;
            textRect.x -= dx;
        }
        ActionButtonLook look = this.getButtonLook();
        look.paintBackground(g, this);
        look.paintIcon(g, this, icon2, iconRect.x, iconRect.y);
        look.paintBorder(g, this);
        g.setColor(this.isEnabled() ? this.getForeground() : this.getInactiveTextColor());
        UIUtilities.drawStringUnderlineCharAt((JComponent)this, (Graphics)g, (String)text2, (int)this.getMnemonicCharIndex(text2), (int)textRect.x, (int)(textRect.y + fm.getAscent()));
        if (arrowIcon != null) {
            int x = Math.max(iconRect.x + iconRect.width, textRect.x + textRect.width) + JBUI.scale((int)2);
            int y = textRect.y + (textRect.height - arrowIcon.getIconHeight()) / 2 + 1;
            this.getButtonLook().paintIcon(g, this, arrowIcon, x, y);
        }
    }

    @NotNull
    protected Icon getDownArrowIcon() {
        Icon icon2 = AllIcons.General.LinkDropTriangle;
        if (icon2 == null) {
            ActionButtonWithText.$$$reportNull$$$0(7);
        }
        return icon2;
    }

    protected Rectangle getButtonRect() {
        return new Rectangle(this.getSize());
    }

    @Override
    protected void presentationPropertyChanged(@NotNull PropertyChangeEvent e) {
        if (e == null) {
            ActionButtonWithText.$$$reportNull$$$0(8);
        }
        super.presentationPropertyChanged(e);
        if ("textWithSuffix".equals(e.getPropertyName())) {
            this.revalidate();
            this.repaint();
        }
    }

    public Color getInactiveTextColor() {
        return NamedColorUtil.getInactiveTextColor();
    }

    public void setHorizontalTextPosition(int position) {
        this.myHorizontalTextPosition = position;
    }

    public void setHorizontalTextAlignment(int alignment) {
        this.myHorizontalTextAlignment = alignment;
    }

    protected int horizontalTextPosition() {
        return this.myHorizontalTextPosition;
    }

    protected int horizontalTextAlignment() {
        return this.myHorizontalTextAlignment;
    }

    protected int iconTextSpace() {
        Icon icon2 = this.getIcon();
        return icon2 instanceof EmptyIcon || icon2 == null ? 0 : JBUI.scale((int)2);
    }

    protected int getMnemonicCharIndex(String text2) {
        Shortcut[] shortcuts;
        int mnemonicIndex = this.myPresentation.getDisplayedMnemonicIndex();
        if (mnemonicIndex != -1) {
            return mnemonicIndex;
        }
        ShortcutSet shortcutSet = this.myAction.getShortcutSet();
        for (Shortcut shortcut : shortcuts = shortcutSet.getShortcuts()) {
            KeyStroke keyStroke;
            int modifiers;
            KeyboardShortcut keyboardShortcut;
            if (!(shortcut instanceof KeyboardShortcut) || (keyboardShortcut = (KeyboardShortcut)shortcut).getSecondKeyStroke() != null || !BitUtil.isSet((int)(modifiers = (keyStroke = keyboardShortcut.getFirstKeyStroke()).getModifiers()), (int)8)) continue;
            return keyStroke.getKeyChar() != '\uffff' ? text2.indexOf(keyStroke.getKeyChar()) : text2.indexOf(KeyEvent.getKeyText(keyStroke.getKeyCode()));
        }
        return -1;
    }

    @NotNull
    @NlsActions.ActionText
    protected String getText() {
        String text2 = this.myPresentation.getText(true);
        return text2 != null ? text2 : "";
    }

    public int getMnemonic() {
        return this.myPresentation.getMnemonic();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimumSize";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionButtonWithText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionButtonWithText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFallbackIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMargins";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownArrowIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "presentationPropertyChanged";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

