/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.InitialConfigImportState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0002J\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/application/ConfigBackup;", "", "configDir", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "moveToBackup", "dirToMove", "migratePreviousBackupIfExists", "", "backupDir", "looksLikeDate", "", "", "cleanupOldBackups", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nConfigBackup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigBackup.kt\ncom/intellij/openapi/application/ConfigBackup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,106:1\n1056#2:107\n13#3:108\n*S KotlinDebug\n*F\n+ 1 ConfigBackup.kt\ncom/intellij/openapi/application/ConfigBackup\n*L\n64#1:107\n81#1:108\n*E\n"})
public final class ConfigBackup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path configDir;
    public static final int MAX_BACKUPS_NUMBER = 10;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String DATE_FORMAT = "yyyy-MM-dd-HH-mm";

    public ConfigBackup(@NotNull Path configDir) {
        Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
        this.configDir = configDir;
    }

    @NotNull
    public final Path moveToBackup(@NotNull Path dirToMove) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dirToMove, (String)"dirToMove");
        Path backupDir = ConfigBackup.Companion.getBackupDir(this.configDir);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(backupDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            this.migratePreviousBackupIfExists(backupDir);
            this.cleanupOldBackups(backupDir);
        }
        Path backupPath = com.intellij.openapi.application.ConfigBackup$Companion.getNextBackupPath$default(Companion, this.configDir, null, 2, null);
        LOG.info("Move backup from " + dirToMove + " to " + backupPath);
        NioFiles.copyRecursively((Path)dirToMove, (Path)backupPath);
        NioFiles.deleteRecursively((Path)dirToMove);
        return backupPath;
    }

    private final void migratePreviousBackupIfExists(Path backupDir) {
        if (InitialConfigImportState.INSTANCE.isConfigDirectory(backupDir)) {
            try {
                Path path = backupDir.resolve("1970-01-01-00-00");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                Path path2 = path;
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Path path3 = Files.createDirectory(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectory(...)");
                Path oldBackup = path3;
                for (Path file2 : PathsKt.listDirectoryEntries$default((Path)backupDir, null, (int)1, null)) {
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.isDirectory(file2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && this.looksLikeDate(PathsKt.getName((Path)file2))) continue;
                    NioFiles.copyRecursively((Path)file2, (Path)oldBackup.resolve(PathsKt.getName((Path)file2)));
                    NioFiles.deleteRecursively((Path)file2);
                }
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    private final boolean looksLikeDate(String $this$looksLikeDate) {
        try {
            DateTimeFormatter format = DateTimeFormatter.ofPattern(DATE_FORMAT);
            format.parse($this$looksLikeDate);
            return true;
        }
        catch (DateTimeParseException dateTimeParseException) {
            return false;
        }
    }

    private final void cleanupOldBackups(Path backupDir) {
        int n;
        int i2;
        Iterable $this$sortedBy$iv = PathsKt.listDirectoryEntries$default((Path)backupDir, null, (int)1, null);
        boolean $i$f$sortedBy = false;
        List children2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Path it = (Path)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)PathsKt.getName((Path)it));
                it = (Path)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)PathsKt.getName((Path)it))));
            }
        });
        if (children2.size() >= 10 && (i2 = 0) <= (n = children2.size() - 10)) {
            while (true) {
                Path oldDir = (Path)children2.get(i2);
                try {
                    PathKt.delete((Path)oldDir, (boolean)true);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
                if (i2 == n) break;
                ++i2;
            }
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ConfigBackup.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/application/ConfigBackup$Companion;", "", "<init>", "()V", "MAX_BACKUPS_NUMBER", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "DATE_FORMAT", "", "getNextBackupPath", "Ljava/nio/file/Path;", "configDir", "currentDate", "Ljava/time/LocalDateTime;", "getBackupDir", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmOverloads
        @NotNull
        public final Path getNextBackupPath(@NotNull Path configDir, @NotNull LocalDateTime currentDate) {
            Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
            Intrinsics.checkNotNullParameter((Object)currentDate, (String)"currentDate");
            DateTimeFormatter format = DateTimeFormatter.ofPattern(ConfigBackup.DATE_FORMAT);
            String date = currentDate.format(format);
            Path dir = this.getBackupDir(configDir).resolve(date);
            Intrinsics.checkNotNull((Object)dir);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(dir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return dir;
            }
            LOG.info(dir + " already exists");
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String id2 = string;
            Path dirWithIndex = this.getBackupDir(configDir).resolve(date + "-" + id2);
            Intrinsics.checkNotNull((Object)dirWithIndex);
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.exists(dirWithIndex, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                LOG.warn("Even " + dirWithIndex + " already exists");
            }
            return dirWithIndex;
        }

        public static /* synthetic */ Path getNextBackupPath$default(Companion companion, Path path, LocalDateTime localDateTime, int n, Object object) {
            if ((n & 2) != 0) {
                LocalDateTime localDateTime2 = LocalDateTime.now();
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"now(...)");
                localDateTime = localDateTime2;
            }
            return companion.getNextBackupPath(path, localDateTime);
        }

        private final Path getBackupDir(Path configDir) {
            Path path = configDir.resolveSibling(PathsKt.getName((Path)configDir) + "-backup");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolveSibling(...)");
            return path;
        }

        @JvmOverloads
        @NotNull
        public final Path getNextBackupPath(@NotNull Path configDir) {
            Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
            return com.intellij.openapi.application.ConfigBackup$Companion.getNextBackupPath$default(this, configDir, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

