/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.concurrency.ThreadContext;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ThreadingSupport;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.util.Ref;
import com.intellij.platform.locking.impl.IntelliJLockingUtil;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.ui.EDT;
import java.awt.event.InvocationEvent;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.CoroutineContext;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\u0007H\u0007J\b\u0010\u000b\u001a\u00020\tH\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/application/impl/InternalThreading;", "", "<init>", "()V", "backgroundWriteActionCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "incrementBackgroundWriteActionCount", "", "isBackgroundWriteActionRunning", "", "decrementBackgroundWriteActionCount", "isBackgroundWriteActionAllowed", "invokeAndWaitWithTransferredWriteAction", "runnable", "Ljava/lang/Runnable;", "RunInBackgroundWriteActionMarker", "TransferredWriteActionEvent", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nappImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 appImpl.kt\ncom/intellij/openapi/application/impl/InternalThreading\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,252:1\n1#2:253\n*E\n"})
public final class InternalThreading {
    @NotNull
    public static final InternalThreading INSTANCE = new InternalThreading();
    @NotNull
    private static final AtomicInteger backgroundWriteActionCounter = new AtomicInteger(0);

    private InternalThreading() {
    }

    @JvmStatic
    public static final void incrementBackgroundWriteActionCount() {
        backgroundWriteActionCounter.incrementAndGet();
    }

    @JvmStatic
    public static final boolean isBackgroundWriteActionRunning() {
        return backgroundWriteActionCounter.get() > 0;
    }

    @JvmStatic
    public static final void decrementBackgroundWriteActionCount() {
        backgroundWriteActionCounter.decrementAndGet();
    }

    @JvmStatic
    @ApiStatus.Internal
    public static final boolean isBackgroundWriteActionAllowed() {
        return ThreadContext.currentThreadContext().get((CoroutineContext.Key)RunInBackgroundWriteActionMarker.INSTANCE) != null;
    }

    @JvmStatic
    @RequiresBackgroundThread(generateAssertion=false)
    @RequiresWriteLock(generateAssertion=false)
    public static final void invokeAndWaitWithTransferredWriteAction(@NotNull Runnable runnable2) throws Throwable {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        ThreadingSupport lock = IntelliJLockingUtil.getGlobalThreadingSupport();
        boolean bl = lock.isWriteAccessAllowed();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-InternalThreading$invokeAndWaitWithTransferredWriteAction$32 = false;
            String $i$a$-assert-InternalThreading$invokeAndWaitWithTransferredWriteAction$32 = "Transferring of write action is permitted only if write lock is acquired";
            throw new AssertionError((Object)$i$a$-assert-InternalThreading$invokeAndWaitWithTransferredWriteAction$32);
        }
        boolean bl2 = bl = !EDT.isCurrentThreadEdt();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-InternalThreading$invokeAndWaitWithTransferredWriteAction$42 = false;
            String $i$a$-assert-InternalThreading$invokeAndWaitWithTransferredWriteAction$42 = "Transferring of write action is permitted only on background thread";
            throw new AssertionError((Object)$i$a$-assert-InternalThreading$invokeAndWaitWithTransferredWriteAction$42);
        }
        Ref ref2 = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref2, (String)"create(...)");
        Ref exceptionRef = ref2;
        Runnable runnable3 = AppScheduledExecutorService.captureContextCancellationForRunnableThatDoesNotOutliveContextScope(() -> InternalThreading.invokeAndWaitWithTransferredWriteAction$lambda$2(lock, exceptionRef, runnable2));
        Intrinsics.checkNotNullExpressionValue((Object)runnable3, (String)"captureContextCancellati\u2026tOutliveContextScope(...)");
        Runnable capturedRunnable = runnable3;
        lock.transferWriteActionAndBlock(arg_0 -> InternalThreading.invokeAndWaitWithTransferredWriteAction$lambda$3(exceptionRef, arg_0), capturedRunnable);
        Throwable throwable = (Throwable)exceptionRef.get();
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl3 = false;
            throw it;
        }
    }

    private static final void invokeAndWaitWithTransferredWriteAction$lambda$2(ThreadingSupport $lock, Ref $exceptionRef, Runnable $runnable) {
        try {
            $lock.allowTakingLocksInsideAndRun(() -> InternalThreading.invokeAndWaitWithTransferredWriteAction$lambda$2$0($runnable));
        }
        catch (Throwable e) {
            $exceptionRef.set((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void invokeAndWaitWithTransferredWriteAction$lambda$2$0(Runnable $runnable) {
        AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.startSection((String)"  reset  ");
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            TransactionGuard transactionGuard = TransactionGuard.getInstance();
            Intrinsics.checkNotNull((Object)transactionGuard, (String)"null cannot be cast to non-null type com.intellij.openapi.application.TransactionGuardImpl");
            ((TransactionGuardImpl)transactionGuard).performUserActivity($runnable);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final Unit invokeAndWaitWithTransferredWriteAction$lambda$3(Ref $exceptionRef, ThreadingSupport.RunnableWithTransferredWriteAction toRun) {
        Intrinsics.checkNotNullParameter((Object)toRun, (String)"toRun");
        TransferredWriteActionEvent event = new TransferredWriteActionEvent(toRun);
        try {
            IdeEventQueue.Companion.getInstance().doPostEvent(event, true);
            event.blockingWait();
        }
        catch (InterruptedException e) {
            $exceptionRef.set((Object)e);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0018\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/application/impl/InternalThreading$RunInBackgroundWriteActionMarker;", "Lkotlin/coroutines/CoroutineContext$Element;", "Lkotlin/coroutines/CoroutineContext$Key;", "<init>", "()V", "key", "getKey", "()Lkotlin/coroutines/CoroutineContext$Key;", "intellij.platform.ide.impl"})
    public static final class RunInBackgroundWriteActionMarker
    implements CoroutineContext.Element,
    CoroutineContext.Key<RunInBackgroundWriteActionMarker> {
        @NotNull
        public static final RunInBackgroundWriteActionMarker INSTANCE = new RunInBackgroundWriteActionMarker();

        private RunInBackgroundWriteActionMarker() {
        }

        @NotNull
        public CoroutineContext.Key<?> getKey() {
            return this;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B!\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/application/impl/InternalThreading$TransferredWriteActionEvent;", "Ljava/awt/event/InvocationEvent;", "action", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/application/ThreadingSupport$RunnableWithTransferredWriteAction;", "job", "Lkotlinx/coroutines/CompletableJob;", "<init>", "(Ljava/util/concurrent/atomic/AtomicReference;Lkotlinx/coroutines/CompletableJob;)V", "(Lcom/intellij/openapi/application/ThreadingSupport$RunnableWithTransferredWriteAction;)V", "getAction", "()Ljava/util/concurrent/atomic/AtomicReference;", "getJob", "()Lkotlinx/coroutines/CompletableJob;", "execute", "", "blockingWait", "Companion", "intellij.platform.ide.impl"})
    @ApiStatus.Internal
    public static final class TransferredWriteActionEvent
    extends InvocationEvent {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final AtomicReference<ThreadingSupport.RunnableWithTransferredWriteAction> action;
        @NotNull
        private final CompletableJob job;

        private TransferredWriteActionEvent(AtomicReference<ThreadingSupport.RunnableWithTransferredWriteAction> action2, CompletableJob job2) {
            super((Object)INSTANCE, () -> TransferredWriteActionEvent._init_$lambda$0(action2, job2));
            this.action = action2;
            this.job = job2;
        }

        /* synthetic */ TransferredWriteActionEvent(AtomicReference atomicReference, CompletableJob completableJob, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                completableJob = JobKt.Job((Job)((Job)ThreadContext.currentThreadContext().get((CoroutineContext.Key)Job.Key)));
            }
            this(atomicReference, completableJob);
        }

        @NotNull
        public final AtomicReference<ThreadingSupport.RunnableWithTransferredWriteAction> getAction() {
            return this.action;
        }

        @NotNull
        public final CompletableJob getJob() {
            return this.job;
        }

        public TransferredWriteActionEvent(@NotNull ThreadingSupport.RunnableWithTransferredWriteAction action2) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            this(new AtomicReference<ThreadingSupport.RunnableWithTransferredWriteAction>(action2), null, 2, null);
        }

        public final void execute() {
            Companion.execute(this.action, this.job);
        }

        public final void blockingWait() {
            FutureKt.asCompletableFuture((Job)((Job)this.job)).join();
        }

        private static final void _init_$lambda$0(AtomicReference $action, CompletableJob $job) {
            Companion.execute($action, $job);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/application/impl/InternalThreading$TransferredWriteActionEvent$Companion;", "", "<init>", "()V", "execute", "", "action", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/application/ThreadingSupport$RunnableWithTransferredWriteAction;", "job", "Lkotlinx/coroutines/CompletableJob;", "intellij.platform.ide.impl"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void execute(@NotNull AtomicReference<ThreadingSupport.RunnableWithTransferredWriteAction> action2, @NotNull CompletableJob job2) {
                Intrinsics.checkNotNullParameter(action2, (String)"action");
                Intrinsics.checkNotNullParameter((Object)job2, (String)"job");
                try {
                    ThreadingSupport.RunnableWithTransferredWriteAction runnableWithTransferredWriteAction;
                    if ((ThreadingSupport.RunnableWithTransferredWriteAction)action2.getAndSet(null) == null) {
                        return;
                    }
                    ThreadingSupport.RunnableWithTransferredWriteAction action3 = runnableWithTransferredWriteAction;
                    action3.run();
                }
                finally {
                    job2.complete();
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

