/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl.islands;

import com.intellij.ide.ProjectWindowCustomizerService;
import com.intellij.ide.actions.DistractionFreeModeController;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.RegistryBooleanOptionDescriptor;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.experimental.ExperimentalUiCollector;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.BorderPainterHolder;
import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.application.impl.ToolWindowUIDecorator;
import com.intellij.openapi.application.impl.islands.IslandsGradientPainter;
import com.intellij.openapi.application.impl.islands.IslandsGradientPainterKt;
import com.intellij.openapi.application.impl.islands.IslandsTabPainter;
import com.intellij.openapi.application.impl.islands.IslandsTabPainterAdapter;
import com.intellij.openapi.application.impl.islands.IslandsUICustomization;
import com.intellij.openapi.application.impl.islands.IslandsUICustomizationKt;
import com.intellij.openapi.application.impl.islands.ManyIslandDivider;
import com.intellij.openapi.application.impl.islands.WindowBackgroundComponentData;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.editor.impl.SearchReplaceFacade;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorEmptyTextPainter;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.ui.Splittable;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneEx;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.ToolWindowTypeExtensionsKt;
import com.intellij.openapi.wm.impl.content.ContentLayout;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomWindowHeaderUtil;
import com.intellij.openapi.wm.impl.headertoolbar.MainToolbar;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.toolWindow.ToolWindowButtonManager;
import com.intellij.toolWindow.ToolWindowPane;
import com.intellij.toolWindow.ToolWindowPaneNewButtonManager;
import com.intellij.toolWindow.xNext.island.XNextIslandHolder;
import com.intellij.ui.AbstractBorderPainter;
import com.intellij.ui.BorderPainter;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.DefaultBorderPainter;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.mac.WindowTabsComponent;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.RectanglePainter2D;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tabs.JBTabPainter;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabPainterAdapter;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0002=@\b\u0000\u0018\u00002\u00020\u0001:\u0002\u00af\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0005H\u0002J\b\u0010\u0013\u001a\u00020\u0005H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\u0005H\u0002J\b\u0010-\u001a\u00020\u0015H\u0002J\b\u0010.\u001a\u00020\u0015H\u0002J\b\u0010/\u001a\u00020\u0015H\u0002J\u0010\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u000202H\u0002J\u0018\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u0002052\u0006\u00101\u001a\u000202H\u0002J\u0010\u00106\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020 H\u0002J\u001d\u00107\u001a\u00020\u00152\u0006\u00108\u001a\u00020 2\u0006\u00109\u001a\u00020:H\u0010\u00a2\u0006\u0002\b;J\u0010\u0010B\u001a\u00020\u00152\u0006\u0010C\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020\u00152\u0006\u0010F\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020 H\u0016J\u0018\u0010B\u001a\u00020\u00152\u0006\u0010C\u001a\u00020D2\u0006\u0010I\u001a\u00020\u0005H\u0002J\u0018\u0010J\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020K2\u0006\u0010I\u001a\u00020\u0005H\u0002J\u0018\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\u00052\u0006\u0010O\u001a\u00020PH\u0016J\u0010\u0010Q\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020 H\u0016J\u0010\u0010R\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020 H\u0016J\u0010\u0010S\u001a\u00020 2\u0006\u0010\"\u001a\u00020TH\u0016J\u0018\u0010S\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020T2\u0006\u0010U\u001a\u00020\u0005H\u0002J\u0010\u0010V\u001a\u00020\u00052\u0006\u0010W\u001a\u00020 H\u0016J\u0010\u0010X\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020YH\u0016J\u0018\u0010Z\u001a\u00020\u00152\u0006\u00104\u001a\u0002052\u0006\u0010\"\u001a\u000202H\u0002J\u0010\u0010[\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020YH\u0002J \u0010\\\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020 2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020`H\u0002J \u0010a\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020 2\u0006\u0010b\u001a\u00020^2\u0006\u0010c\u001a\u00020\u0005H\u0002J\u0018\u0010d\u001a\u00020\u00152\u0006\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020hH\u0002J\u0010\u0010i\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020 H\u0002J\u0018\u0010j\u001a\u00020\u00152\u0006\u0010e\u001a\u00020f2\u0006\u0010k\u001a\u00020hH\u0002J0\u0010x\u001a\u00020\u00052\u0006\u0010b\u001a\u00020^2\u0006\u0010y\u001a\u00020z2\u0006\u0010{\u001a\u00020|2\u0006\u0010}\u001a\u00020\u00052\u0006\u0010~\u001a\u00020\u0005H\u0016JO\u0010\u007f\u001a\u00020\u00052\u0006\u0010b\u001a\u00020^2\u0007\u0010\u0080\u0001\u001a\u00020\r2\u0007\u0010\u0081\u0001\u001a\u00020\r2\u0007\u0010\u0082\u0001\u001a\u00020\r2\u0007\u0010\u0083\u0001\u001a\u00020\r2\u0007\u0010\u0084\u0001\u001a\u00020\r2\u0007\u0010\u0085\u0001\u001a\u00020\r2\u0007\u0010\u0086\u0001\u001a\u00020\u0005H\u0016J\u0013\u0010\u0087\u0001\u001a\u00020\r2\b\u0010\u0088\u0001\u001a\u00030\u0089\u0001H\u0016J\u0015\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u00012\u0007\u0010\u008c\u0001\u001a\u00020zH\u0016J\n\u0010\u008d\u0001\u001a\u00030\u008e\u0001H\u0002J\f\u0010\u008f\u0001\u001a\u0005\u0018\u00010\u008e\u0001H\u0016J\u001c\u0010\u0090\u0001\u001a\u00020\u00152\u0007\u0010C\u001a\u00030\u0091\u00012\b\u0010\u0092\u0001\u001a\u00030\u0093\u0001H\u0016J\"\u0010\u0094\u0001\u001a\u00020\u00152\u0007\u0010C\u001a\u00030\u0091\u00012\u0006\u0010\"\u001a\u00020K2\u0006\u0010b\u001a\u00020fH\u0016J\u0019\u0010\u0095\u0001\u001a\u00020^2\u0006\u0010\"\u001a\u00020 2\u0006\u0010]\u001a\u00020^H\u0016J\u0011\u0010\u0096\u0001\u001a\u00020^2\u0006\u0010]\u001a\u00020^H\u0016J\u0011\u0010\u0097\u0001\u001a\u00020^2\u0006\u0010]\u001a\u00020^H\u0016J\u0019\u0010\u0098\u0001\u001a\u00020^2\u0006\u0010\"\u001a\u00020 2\u0006\u0010]\u001a\u00020^H\u0016J\u0013\u0010\u009a\u0001\u001a\u00020\u00152\b\u0010\u009b\u0001\u001a\u00030\u009c\u0001H\u0002J\f\u0010\u009d\u0001\u001a\u0005\u0018\u00010\u008b\u0001H\u0016J\u0012\u0010\u00a3\u0001\u001a\u00020\u00052\u0007\u0010C\u001a\u00030\u00a4\u0001H\u0002J\u001c\u0010\u00a5\u0001\u001a\u00020\u00152\u0007\u0010C\u001a\u00030\u00a4\u00012\b\u0010\u00a6\u0001\u001a\u00030\u00a7\u0001H\u0016JH\u0010\u00a8\u0001\u001a\u00020\u00052\u0007\u0010C\u001a\u00030\u00a4\u00012\b\u0010\u00a9\u0001\u001a\u00030\u00aa\u00012\u0006\u0010b\u001a\u00020^2\b\u0010\u00ab\u0001\u001a\u00030\u00ac\u00012\u0006\u0010~\u001a\u00020\u00052\u0007\u0010\u00ad\u0001\u001a\u00020\r2\u0007\u0010\u00ae\u0001\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0014\u0010\u0012\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0016\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\nR\u0014\u0010\u0017\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\nR\u0014\u0010\u0018\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\nR\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010%\u001a\u00020&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b'\u0010(R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010<\u001a\u00020=X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010>R\u0010\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010AR\u0014\u0010l\u001a\u00020mX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bn\u0010oR\u0014\u0010p\u001a\u00020qX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\br\u0010sR\u0014\u0010t\u001a\u00020mX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bu\u0010oR\u0014\u0010v\u001a\u00020mX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bw\u0010oR\u0016\u0010\u0099\u0001\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u0099\u0001\u0010\nR\u0016\u0010\u009e\u0001\u001a\t0\u009f\u0001\u00a2\u0006\u0003\b\u00a0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u00a1\u0001\u001a\t0\u009f\u0001\u00a2\u0006\u0003\b\u00a0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u00a2\u0001\u001a\t0\u009f\u0001\u00a2\u0006\u0003\b\u00a0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00b0\u0001"}, d2={"Lcom/intellij/openapi/application/impl/islands/IslandsUICustomization;", "Lcom/intellij/openapi/application/impl/InternalUICustomization;", "<init>", "()V", "isIslandsAvailable", "", "isManyIslandEnabledCache", "Ljava/lang/Boolean;", "isManyIslandCustomTheme", "isManyIslandEnabled", "()Z", "isBreadcrumbsAbove", "searchReplaceEmptyTopSpace", "", "getSearchReplaceEmptyTopSpace", "()I", "isDefaultTheme", "isIslandsGradientEnabledCache", "isIslandsGradientEnabled", "isBackgroundImageSet", "updateBackgroundPainter", "", "isProjectCustomDecorationGradientPaint", "isMainMenuBottomBorder", "isTabOccupiesWholeHeight", "toolWindowUIDecorator", "Lcom/intellij/openapi/application/impl/ToolWindowUIDecorator;", "getToolWindowUIDecorator", "()Lcom/intellij/openapi/application/impl/ToolWindowUIDecorator;", "forcedBackground", "noBackground", "Ljava/util/function/Predicate;", "Ljavax/swing/JComponent;", "configureBackgroundPainting", "component", "recursive", "isBrightCached", "uiSettings", "Lcom/intellij/ide/ui/UISettings;", "getUiSettings", "()Lcom/intellij/ide/ui/UISettings;", "uiSettings$delegate", "Lkotlin/Lazy;", "awtListener", "Ljava/awt/event/AWTEventListener;", "applyMissingKeys", "enableManyIslands", "disableManyIslands", "setOriginalToolWindowBorder", "holder", "Lcom/intellij/toolWindow/xNext/island/XNextIslandHolder;", "setToolWindowManyBorder", "toolwindow", "Lcom/intellij/openapi/wm/ToolWindow;", "clearParentNoBackground", "configureToolWindowPane", "toolWindowPaneParent", "buttonManager", "Lcom/intellij/toolWindow/ToolWindowButtonManager;", "configureToolWindowPane$intellij_platform_ide_impl", "inactivePainter", "com/intellij/openapi/application/impl/islands/IslandsUICustomization$inactivePainter$1", "Lcom/intellij/openapi/application/impl/islands/IslandsUICustomization$inactivePainter$1;", "frameActiveListener", "com/intellij/openapi/application/impl/islands/IslandsUICustomization$frameActiveListener$1", "Lcom/intellij/openapi/application/impl/islands/IslandsUICustomization$frameActiveListener$1;", "configureMainFrame", "frame", "Lcom/intellij/openapi/wm/impl/IdeFrameImpl;", "configureMainToolbar", "toolbar", "Lcom/intellij/openapi/wm/impl/headertoolbar/MainToolbar;", "registerWindowBackgroundComponent", "install", "configureMainFrameChildren", "Ljava/awt/Component;", "createCustomDivider", "Lcom/intellij/openapi/ui/Divider;", "isVertical", "splitter", "Lcom/intellij/openapi/ui/Splittable;", "configureRendererComponent", "installEditorBackground", "configureSearchReplaceComponent", "Lcom/intellij/openapi/editor/impl/EditorHeaderComponent;", "enabled", "shouldPaintEditorTabsBottomBorder", "editorCompositePanel", "configureEditorsSplitters", "Lcom/intellij/openapi/fileEditor/impl/EditorsSplitters;", "createToolWindowBorderPainter", "createEditorBorderPainter", "paintBeforeEditorEmptyText", "graphics", "Ljava/awt/Graphics;", "editorTabPainter", "Lcom/intellij/ui/tabs/impl/TabPainterAdapter;", "paintIslandBorder", "g", "editor", "paintIslandBackground", "gg", "Ljava/awt/Graphics2D;", "shape", "Ljava/awt/geom/Area;", "isIslandBorderLineNeeded", "paintIslandBorderLine", "border", "editorTabPainterAdapter", "Lcom/intellij/openapi/application/impl/islands/IslandsTabPainterAdapter;", "getEditorTabPainterAdapter", "()Lcom/intellij/openapi/application/impl/islands/IslandsTabPainterAdapter;", "toolWindowTabPainter", "Lcom/intellij/openapi/application/impl/islands/IslandsTabPainter;", "getToolWindowTabPainter", "()Lcom/intellij/openapi/application/impl/islands/IslandsTabPainter;", "commonTabPainterAdapter", "getCommonTabPainterAdapter", "debuggerTabPainterAdapter", "getDebuggerTabPainterAdapter", "paintTab", "position", "Lcom/intellij/ui/tabs/JBTabsPosition;", "rect", "Ljava/awt/Rectangle;", "hovered", "selected", "paintTabBorder", "tabPlacement", "tabIndex", "x", "y", "w", "h", "isSelected", "getTabLayoutStart", "layout", "Lcom/intellij/openapi/wm/impl/content/ContentLayout;", "getSingleRowTabInsets", "Ljava/awt/Insets;", "tabsPosition", "getMainBackgroundColor", "Ljava/awt/Color;", "getCustomMainBackgroundColor", "attachIdeFrameBackgroundPainter", "Lcom/intellij/openapi/wm/IdeFrame;", "glassPane", "Lcom/intellij/openapi/wm/IdeGlassPane;", "paintFrameBackground", "transformGraphics", "transformButtonGraphics", "preserveGraphics", "backgroundImageGraphics", "isMacScrollBar", "updateToolStripesVisibility", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "getProjectTabContentInsets", "PROJECT_TAB_SELECTED_BACKGROUND", "Lcom/intellij/ui/JBColor;", "Lorg/jetbrains/annotations/NotNull;", "PROJECT_TAB_HOVER_BACKGROUND", "PROJECT_TAB_SEPARATOR_COLOR", "isColorfulToolbar", "Ljavax/swing/JFrame;", "createProjectTab", "tabsComponent", "Lcom/intellij/ui/mac/WindowTabsComponent;", "paintProjectTab", "label", "Lcom/intellij/ui/tabs/impl/TabLabel;", "tabs", "Lcom/intellij/ui/tabs/impl/JBTabsImpl;", "index", "lastIndex", "SearchReplaceWrapper", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nIslandsUICustomization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IslandsUICustomization.kt\ncom/intellij/openapi/application/impl/islands/IslandsUICustomization\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 UiUtils.kt\ncom/intellij/openapi/ui/UiUtils\n*L\n1#1,1025:1\n12970#2,2:1026\n61#3:1028\n*S KotlinDebug\n*F\n+ 1 IslandsUICustomization.kt\ncom/intellij/openapi/application/impl/islands/IslandsUICustomization\n*L\n128#1:1026,2\n579#1:1028\n*E\n"})
public final class IslandsUICustomization
extends InternalUICustomization {
    private final boolean isIslandsAvailable = ExperimentalUI.Companion.isNewUI();
    @Nullable
    private Boolean isManyIslandEnabledCache;
    private boolean isManyIslandCustomTheme;
    @Nullable
    private Boolean isIslandsGradientEnabledCache;
    @NotNull
    private final ToolWindowUIDecorator toolWindowUIDecorator = new ToolWindowUIDecorator(this){
        final /* synthetic */ IslandsUICustomization this$0;
        {
            this.this$0 = $receiver;
        }

        public JComponent decorateAndReturnHolder(JComponent divider, JComponent child, ToolWindow toolWindow2, Function0<? extends Border> originalBorderBuilder) {
            Intrinsics.checkNotNullParameter((Object)divider, (String)"divider");
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
            Intrinsics.checkNotNullParameter(originalBorderBuilder, (String)"originalBorderBuilder");
            XNextIslandHolder xNextIslandHolder = new XNextIslandHolder();
            IslandsUICustomization islandsUICustomization = this.this$0;
            XNextIslandHolder $this$decorateAndReturnHolder_u24lambda_u240 = xNextIslandHolder;
            boolean bl = false;
            $this$decorateAndReturnHolder_u24lambda_u240.setLayout(new BorderLayout());
            $this$decorateAndReturnHolder_u24lambda_u240.add((Component)divider, "North");
            $this$decorateAndReturnHolder_u24lambda_u240.add((Component)child, "Center");
            $this$decorateAndReturnHolder_u24lambda_u240.putClientProperty("originalBorderBuilder", originalBorderBuilder);
            if (IslandsUICustomization.access$isManyIslandEnabled(islandsUICustomization)) {
                $this$decorateAndReturnHolder_u24lambda_u240.setBackground(JBUI.CurrentTheme.ToolWindow.background());
                IslandsUICustomization.access$createToolWindowBorderPainter(islandsUICustomization, toolWindow2, $this$decorateAndReturnHolder_u24lambda_u240);
                IslandsUICustomization.access$configureBackgroundPainting(islandsUICustomization, child, false);
            } else {
                $this$decorateAndReturnHolder_u24lambda_u240.setBorder((Border)originalBorderBuilder.invoke());
            }
            return xNextIslandHolder;
        }
    };
    private boolean forcedBackground;
    @NotNull
    private final Predicate<JComponent> noBackground = arg_0 -> IslandsUICustomization.noBackground$lambda$0(this, arg_0);
    private boolean isBrightCached;
    @NotNull
    private final Lazy uiSettings$delegate = LazyKt.lazy(IslandsUICustomization::uiSettings_delegate$lambda$0);
    @NotNull
    private final AWTEventListener awtListener = arg_0 -> IslandsUICustomization.awtListener$lambda$0(this, arg_0);
    @NotNull
    private final inactivePainter.1 inactivePainter;
    @NotNull
    private final frameActiveListener.1 frameActiveListener;
    @NotNull
    private final IslandsTabPainterAdapter editorTabPainterAdapter;
    @NotNull
    private final IslandsTabPainter toolWindowTabPainter;
    @NotNull
    private final IslandsTabPainterAdapter commonTabPainterAdapter;
    @NotNull
    private final IslandsTabPainterAdapter debuggerTabPainterAdapter;
    @NotNull
    private final JBColor PROJECT_TAB_SELECTED_BACKGROUND;
    @NotNull
    private final JBColor PROJECT_TAB_HOVER_BACKGROUND;
    @NotNull
    private final JBColor PROJECT_TAB_SEPARATOR_COLOR;

    public IslandsUICustomization() {
        if (this.isManyIslandEnabled()) {
            this.isBrightCached = JBColor.isBright();
            Toolkit.getDefaultToolkit().addAWTEventListener(this.awtListener, 32768L);
            this.applyMissingKeys();
        }
        Ref.BooleanRef oldManyIsland = new Ref.BooleanRef();
        oldManyIsland.element = this.isManyIslandEnabled();
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, arg_0 -> IslandsUICustomization._init_$lambda$0(this, oldManyIsland, arg_0));
        connection.subscribe(AdvancedSettingsChangeListener.TOPIC, (Object)new AdvancedSettingsChangeListener(){

            public void advancedSettingChanged(String id2, Object oldValue, Object newValue) {
                Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
                Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
                Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
                if (Intrinsics.areEqual((Object)id2, (Object)"ide.ui.theme.custom.islands")) {
                    RegistryBooleanOptionDescriptor.suggestRestart(null);
                }
            }
        });
        this.inactivePainter = new DefaultBorderPainter(this){
            final /* synthetic */ IslandsUICustomization this$0;
            {
                this.this$0 = $receiver;
            }

            public void paintAfterChildren(JComponent component2, Graphics g) {
                Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Window window = UIUtil.getWindow((Component)component2);
                if (window == null) {
                    return;
                }
                Window window2 = window;
                if (!window2.isActive()) {
                    if (component2 instanceof MainToolbar && !(((MainToolbar)component2).getParent() instanceof JBLayeredPane)) {
                        return;
                    }
                    if (component2 instanceof ToolWindowPane && JBColor.isBright()) {
                        return;
                    }
                    String alphaKey = component2 instanceof IdeStatusBarImpl ? "Island.inactiveAlphaInStatusBar" : "Island.inactiveAlpha";
                    Graphics2D cfr_ignored_0 = (Graphics2D)g;
                    ((Graphics2D)g).setColor(IslandsUICustomization.access$getMainBackgroundColor(this.this$0));
                    ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, JBUI.getFloat((String)alphaKey, (float)0.5f)));
                    if (component2 instanceof ToolWindowPane) {
                        int extraBorder = JBUI.scale((int)4);
                        g.fillRect(0, 0, ((ToolWindowPane)component2).getWidth(), extraBorder);
                        g.fillRect(0, extraBorder, extraBorder, ((ToolWindowPane)component2).getHeight());
                    } else {
                        g.fillRect(0, 0, component2.getWidth(), component2.getHeight());
                    }
                }
            }
        };
        this.frameActiveListener = new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Window window = e.getWindow();
                    if (window == null) break block0;
                    window.repaint();
                }
            }

            public void windowDeactivated(WindowEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Window window = e.getWindow();
                    if (window == null) break block0;
                    window.repaint();
                }
            }
        };
        this.editorTabPainterAdapter = new IslandsTabPainterAdapter(false, false, this.isManyIslandEnabled());
        this.toolWindowTabPainter = new IslandsTabPainter(this){
            private final JBTabPainter defaultPainter;
            final /* synthetic */ IslandsUICustomization this$0;
            {
                this.this$0 = $receiver;
                super(false, false);
                this.defaultPainter = JBTabPainter.Companion.getTOOL_WINDOW();
            }

            public void paintTab(JBTabsPosition position, Graphics2D g, Rectangle rect, int borderThickness, Color tabColor, boolean active, boolean hovered) {
                Intrinsics.checkNotNullParameter((Object)position, (String)"position");
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
                if (IslandsUICustomization.access$isManyIslandEnabled(this.this$0)) {
                    super.paintTab(position, g, rect, borderThickness, tabColor, active, hovered);
                } else {
                    this.defaultPainter.paintTab(position, g, rect, borderThickness, tabColor, active, hovered);
                }
            }

            public void paintSelectedTab(JBTabsPosition position, Graphics2D g, Rectangle rect, int borderThickness, Color tabColor, boolean active, boolean hovered) {
                Intrinsics.checkNotNullParameter((Object)position, (String)"position");
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
                if (IslandsUICustomization.access$isManyIslandEnabled(this.this$0)) {
                    super.paintSelectedTab(position, g, rect, borderThickness, tabColor, active, hovered);
                } else {
                    this.defaultPainter.paintSelectedTab(position, g, rect, borderThickness, tabColor, active, hovered);
                }
            }

            public void paintTab(Graphics2D g, JBTabsPosition position, Rectangle rect, Color tabColor, boolean active, boolean hovered, boolean selected) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)position, (String)"position");
                Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paintTab(g, position, rect, tabColor, active, hovered, selected);
            }
        };
        this.commonTabPainterAdapter = new IslandsTabPainterAdapter(true, false, this.isManyIslandEnabled());
        this.debuggerTabPainterAdapter = new IslandsTabPainterAdapter(true, true, this.isManyIslandEnabled());
        JBColor jBColor = JBColor.namedColor((String)"MainWindow.Tab.selectedBackground", (Color)JBUI.CurrentTheme.ToolWindow.background());
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        this.PROJECT_TAB_SELECTED_BACKGROUND = jBColor;
        JBColor jBColor2 = JBColor.namedColor((String)"MainWindow.Tab.hoverBackground", (Color)((Color)JBColor.namedColor((String)"MainToolbar.Dropdown.transparentHoverBackground")));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(...)");
        this.PROJECT_TAB_HOVER_BACKGROUND = jBColor2;
        JBColor jBColor3 = JBColor.namedColor((String)"MainWindow.Tab.separatorColor", (int)13882843, (int)4408650);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor3, (String)"namedColor(...)");
        this.PROJECT_TAB_SEPARATOR_COLOR = jBColor3;
    }

    private final boolean isManyIslandEnabled() {
        Boolean value = this.isManyIslandEnabledCache;
        if (value == null) {
            if (this.isIslandsAvailable) {
                int themeValue = JBUI.getInt((String)"Islands", (int)0);
                this.isManyIslandCustomTheme = themeValue == 0 && !this.isDefaultTheme() && AdvancedSettings.Companion.getBoolean("ide.ui.theme.custom.islands");
                value = this.isManyIslandCustomTheme || themeValue == 1;
            } else {
                value = false;
                this.isManyIslandCustomTheme = false;
            }
            this.isManyIslandEnabledCache = value;
        }
        return value;
    }

    private final boolean isBreadcrumbsAbove() {
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        return settings.isBreadcrumbsShown() && settings.isBreadcrumbsAbove();
    }

    private final int getSearchReplaceEmptyTopSpace() {
        return UISettings.Companion.getInstance().getEditorTabPlacement() == 1 && !this.isBreadcrumbsAbove() ? 0 : 6;
    }

    private final boolean isDefaultTheme() {
        Object object = LafManager.getInstance().getCurrentUIThemeLookAndFeel();
        if (object == null || (object = object.getId()) == null) {
            return false;
        }
        Object id2 = object;
        return Intrinsics.areEqual((Object)id2, (Object)"ExperimentalDark") || Intrinsics.areEqual((Object)id2, (Object)"ExperimentalLight") || Intrinsics.areEqual((Object)id2, (Object)"ExperimentalLightWithLightHeader") || Intrinsics.areEqual((Object)id2, (Object)"JetBrainsHighContrastTheme") || Intrinsics.areEqual((Object)id2, (Object)"Darcula");
    }

    private final boolean isIslandsGradientEnabled() {
        Boolean value = this.isIslandsGradientEnabledCache;
        if (value == null) {
            this.isIslandsGradientEnabledCache = value = Boolean.valueOf(UISettings.Companion.getInstance().getDifferentiateProjects() && !this.isBackgroundImageSet());
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isBackgroundImageSet() {
        if (IdeBackgroundUtil.isEditorBackgroundImageSet(null)) return true;
        if (IdeBackgroundUtil.isFrameBackgroundImageSet(null)) return true;
        Project[] $this$any$iv = ProjectUtil.getOpenProjects();
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            Project element$iv;
            Project it = element$iv = $this$any$iv[n];
            boolean bl = false;
            if (IdeBackgroundUtil.isEditorBackgroundImageSet(it)) return true;
            if (IdeBackgroundUtil.isFrameBackgroundImageSet(it)) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public void updateBackgroundPainter() {
        this.isIslandsGradientEnabledCache = null;
    }

    @Override
    public boolean isProjectCustomDecorationGradientPaint() {
        return !this.isManyIslandEnabled();
    }

    @Override
    public boolean isMainMenuBottomBorder() {
        return !this.isManyIslandEnabled();
    }

    @Override
    public boolean isTabOccupiesWholeHeight() {
        return !this.isManyIslandEnabled();
    }

    @Override
    @NotNull
    public ToolWindowUIDecorator getToolWindowUIDecorator() {
        return this.toolWindowUIDecorator;
    }

    private final void configureBackgroundPainting(JComponent component2, boolean recursive) {
        if (recursive) {
            ClientProperty.putRecursive((JComponent)component2, IdeBackgroundUtil.NO_BACKGROUND_PREDICATE, this.noBackground);
        } else {
            component2.putClientProperty(IdeBackgroundUtil.NO_BACKGROUND_PREDICATE, this.noBackground);
        }
    }

    private final UISettings getUiSettings() {
        Lazy lazy = this.uiSettings$delegate;
        return (UISettings)lazy.getValue();
    }

    private final void applyMissingKeys() {
        if (this.isManyIslandCustomTheme) {
            UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
            Intrinsics.checkNotNull((Object)uiDefaults);
            ((Map)uiDefaults).put("MainToolbar.borderColor", Gray.TRANSPARENT);
            ((Map)uiDefaults).put("ToolWindow.borderColor", Gray.TRANSPARENT);
            ((Map)uiDefaults).put("ToolWindow.Stripe.borderColor", Gray.TRANSPARENT);
            ((Map)uiDefaults).put("StatusBar.borderColor", Gray.TRANSPARENT);
            Color color = EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultBackground(...)");
            Color background = color;
            if (Intrinsics.areEqual((Object)this.getMainBackgroundColor(), (Object)background)) {
                float[] hsb = Color.RGBtoHSB(background.getRed(), background.getGreen(), background.getBlue(), null);
                ((Map)uiDefaults).put("MainWindow.background", Color.getHSBColor(hsb[0], hsb[1], RangesKt.coerceAtMost((float)(hsb[2] + 0.03f), (float)1.0f)));
            }
            ((Map)uiDefaults).put("ToolWindow.background", background);
            ((Map)uiDefaults).put("ToolWindow.Header.background", background);
            ((Map)uiDefaults).put("ToolWindow.Header.inactiveBackground", background);
            ((Map)uiDefaults).put("EditorTabs.background", background);
            ((Map)uiDefaults).put("Island.borderColor", background);
            ((Map)uiDefaults).put("Island.arc", 20);
        }
    }

    private final void enableManyIslands() {
        this.getEditorTabPainterAdapter().setEnabled(true);
        this.getCommonTabPainterAdapter().setEnabled(true);
        this.getDebuggerTabPainterAdapter().setEnabled(true);
        IdeFrame[] ideFrameArray = WindowManager.getInstance().getAllProjectFrames();
        Intrinsics.checkNotNullExpressionValue((Object)ideFrameArray, (String)"getAllProjectFrames(...)");
        for (IdeFrame ideFrame : ideFrameArray) {
            Intrinsics.checkNotNull((Object)ideFrame);
            IdeFrame frameHelper = ideFrame;
            if (frameHelper instanceof ProjectFrameHelper) {
                this.configureMainFrame(((ProjectFrameHelper)frameHelper).getFrame(), true);
            }
            UIUtil.forEachComponentInHierarchy((Component)frameHelper.getComponent(), arg_0 -> IslandsUICustomization.enableManyIslands$lambda$1(arg_0 -> IslandsUICustomization.enableManyIslands$lambda$0(this, arg_0), arg_0));
            Project project2 = frameHelper.getProject();
            if (project2 == null) continue;
            ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project2);
            Intrinsics.checkNotNull((Object)toolWindowManager, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.ex.ToolWindowManagerEx");
            ToolWindowManagerEx manager2 = (ToolWindowManagerEx)toolWindowManager;
            this.updateToolStripesVisibility(manager2);
            for (ToolWindow toolwindow : manager2.getToolWindows()) {
                XNextIslandHolder xNextIslandHolder;
                InternalDecoratorImpl internalDecoratorImpl;
                if (!(toolwindow instanceof ToolWindowImpl)) continue;
                if (((ToolWindowImpl)toolwindow).getNullableDecorator$intellij_platform_ide_impl() == null) continue;
                InternalDecoratorImpl it = internalDecoratorImpl;
                boolean bl = false;
                if ((XNextIslandHolder)UIUtil.findComponentOfType((JComponent)((JComponent)((Object)it)), XNextIslandHolder.class) == null) continue;
                XNextIslandHolder holder = xNextIslandHolder;
                boolean bl2 = false;
                this.setToolWindowManyBorder(toolwindow, holder);
            }
        }
        ExperimentalUiCollector.getIslandsThemeOn().log();
    }

    private final void disableManyIslands() {
        this.getEditorTabPainterAdapter().setEnabled(false);
        this.getCommonTabPainterAdapter().setEnabled(false);
        this.getDebuggerTabPainterAdapter().setEnabled(false);
        IdeFrame[] ideFrameArray = WindowManager.getInstance().getAllProjectFrames();
        Intrinsics.checkNotNullExpressionValue((Object)ideFrameArray, (String)"getAllProjectFrames(...)");
        for (IdeFrame ideFrame : ideFrameArray) {
            Intrinsics.checkNotNull((Object)ideFrame);
            IdeFrame frameHelper = ideFrame;
            if (frameHelper instanceof ProjectFrameHelper) {
                this.configureMainFrame(((ProjectFrameHelper)frameHelper).getFrame(), false);
            }
            UIUtil.forEachComponentInHierarchy((Component)frameHelper.getComponent(), arg_0 -> IslandsUICustomization.disableManyIslands$lambda$1(arg_0 -> IslandsUICustomization.disableManyIslands$lambda$0(this, arg_0), arg_0));
            Project project2 = frameHelper.getProject();
            if (project2 == null) continue;
            ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project2);
            Intrinsics.checkNotNull((Object)toolWindowManager, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.ex.ToolWindowManagerEx");
            ToolWindowManagerEx manager2 = (ToolWindowManagerEx)toolWindowManager;
            this.updateToolStripesVisibility(manager2);
            for (ToolWindow toolwindow : manager2.getToolWindows()) {
                XNextIslandHolder xNextIslandHolder;
                InternalDecoratorImpl internalDecoratorImpl;
                if (!(toolwindow instanceof ToolWindowImpl)) continue;
                if (((ToolWindowImpl)toolwindow).getNullableDecorator$intellij_platform_ide_impl() == null) continue;
                InternalDecoratorImpl it = internalDecoratorImpl;
                boolean bl = false;
                if ((XNextIslandHolder)UIUtil.findComponentOfType((JComponent)((JComponent)((Object)it)), XNextIslandHolder.class) == null) continue;
                XNextIslandHolder holder = xNextIslandHolder;
                boolean bl2 = false;
                this.setOriginalToolWindowBorder(holder);
            }
        }
        ExperimentalUiCollector.getIslandsThemeOff().log();
    }

    private final void setOriginalToolWindowBorder(XNextIslandHolder holder) {
        Object border;
        Object builder = holder.getClientProperty("originalBorderBuilder");
        if (TypeIntrinsics.isFunctionOfArity((Object)builder, (int)0) && (border = ((Function0)builder).invoke()) instanceof Border) {
            holder.setBorder((Border)border);
        }
        holder.setBorderPainter$intellij_platform_ide_impl(new DefaultBorderPainter());
        holder.setBackground(JBColor.PanelBackground);
    }

    private final void setToolWindowManyBorder(ToolWindow toolwindow, XNextIslandHolder holder) {
        holder.setBackground(JBUI.CurrentTheme.ToolWindow.background());
        this.createToolWindowBorderPainter(toolwindow, holder);
        this.clearParentNoBackground(holder);
        Component[] componentArray = holder.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        for (Component child : componentArray) {
            Intrinsics.checkNotNull((Object)child, (String)"null cannot be cast to non-null type javax.swing.JComponent");
            this.configureBackgroundPainting((JComponent)child, true);
        }
    }

    private final void clearParentNoBackground(JComponent component2) {
        for (JComponent nextComponent = component2; nextComponent != null && ClientProperty.get((Component)nextComponent, IdeBackgroundUtil.NO_BACKGROUND_PREDICATE) != null; nextComponent = (JComponent)nextComponent.getParent()) {
            ClientProperty.removeRecursive((JComponent)nextComponent, IdeBackgroundUtil.NO_BACKGROUND_PREDICATE);
        }
    }

    @Override
    public void configureToolWindowPane$intellij_platform_ide_impl(@NotNull JComponent toolWindowPaneParent, @NotNull ToolWindowButtonManager buttonManager) {
        Intrinsics.checkNotNullParameter((Object)toolWindowPaneParent, (String)"toolWindowPaneParent");
        Intrinsics.checkNotNullParameter((Object)buttonManager, (String)"buttonManager");
        if (buttonManager instanceof ToolWindowPaneNewButtonManager) {
            ((ToolWindowPaneNewButtonManager)buttonManager).addVisibleToolbarsListener$intellij_platform_ide_impl((Function2<? super Boolean, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> IslandsUICustomization.configureToolWindowPane$lambda$0(this, toolWindowPaneParent, buttonManager, arg_0, arg_1)));
            ((ToolWindowPaneNewButtonManager)buttonManager).updateToolStripesVisibility$intellij_platform_ide_impl();
        }
    }

    @Override
    public void configureMainFrame(@NotNull IdeFrameImpl frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        if (this.isManyIslandEnabled()) {
            this.configureMainFrame(frame, true);
            UIUtil.forEachComponentInHierarchy((Component)frame.getComponent(), arg_0 -> IslandsUICustomization.configureMainFrame$lambda$1(arg_0 -> IslandsUICustomization.configureMainFrame$lambda$0(this, arg_0), arg_0));
        }
    }

    @Override
    public void configureMainToolbar(@NotNull MainToolbar toolbar2) {
        Intrinsics.checkNotNullParameter((Object)toolbar2, (String)"toolbar");
        if (this.isManyIslandEnabled()) {
            this.configureMainFrameChildren(toolbar2, true);
        }
    }

    @Override
    public void registerWindowBackgroundComponent(@NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        UiUtils.putUserData((JComponent)component2, (Key)IslandsUICustomizationKt.access$getWINDOW_BACKGROUND_COMPONENT_KEY$p(), (Object)new WindowBackgroundComponentData(component2.isOpaque(), component2.getBackground()));
        if (this.isManyIslandEnabled()) {
            this.configureMainFrameChildren(component2, true);
        }
    }

    private final void configureMainFrame(IdeFrameImpl frame, boolean install2) {
        if (install2) {
            frame.addWindowListener(this.frameActiveListener);
        } else {
            frame.removeWindowListener(this.frameActiveListener);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void configureMainFrameChildren(Component component2, boolean install2) {
        Component component3 = component2;
        if (component3 instanceof IdeStatusBarImpl) {
            ((IdeStatusBarImpl)component2).setBorderPainter$intellij_platform_ide_impl(install2 ? (BorderPainter)this.inactivePainter : (BorderPainter)new DefaultBorderPainter());
        } else if (component3 instanceof BorderPainterHolder) {
            ((BorderPainterHolder)((Object)component2)).setBorderPainter(install2 ? (BorderPainter)this.inactivePainter : (BorderPainter)new DefaultBorderPainter());
        }
        if (component2 instanceof JComponent) {
            WindowBackgroundComponentData data2;
            void $this$getUserData$iv;
            JComponent jComponent = (JComponent)component2;
            Key key$iv = IslandsUICustomizationKt.access$getWINDOW_BACKGROUND_COMPONENT_KEY$p();
            boolean $i$f$getUserData = false;
            Object object = $this$getUserData$iv.getClientProperty(key$iv);
            if (!(object instanceof WindowBackgroundComponentData)) {
                object = null;
            }
            if ((data2 = (WindowBackgroundComponentData)object) != null) {
                if (install2) {
                    ((JComponent)component2).setOpaque(true);
                    ((JComponent)component2).setBackground(this.getMainBackgroundColor());
                } else {
                    ((JComponent)component2).setOpaque(data2.getOrigOpaque());
                    ((JComponent)component2).setBackground(data2.getOrigBackground());
                }
            }
        }
    }

    @Override
    @NotNull
    public Divider createCustomDivider(boolean isVertical, @NotNull Splittable splitter2) {
        ManyIslandDivider manyIslandDivider;
        Intrinsics.checkNotNullParameter((Object)splitter2, (String)"splitter");
        ManyIslandDivider it = manyIslandDivider = new ManyIslandDivider(isVertical, splitter2);
        boolean bl = false;
        it.configure(this.isManyIslandEnabled());
        return (Divider)manyIslandDivider;
    }

    @Override
    public void configureRendererComponent(@NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.configureBackgroundPainting(component2, true);
    }

    @Override
    public void installEditorBackground(@NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.configureBackgroundPainting(component2, true);
    }

    @Override
    @NotNull
    public JComponent configureSearchReplaceComponent(@NotNull EditorHeaderComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        component2.putClientProperty("originalBorder", component2.getBorder());
        SearchReplaceWrapper wrapper2 = new SearchReplaceWrapper(component2);
        wrapper2.setBackground(JBUI.CurrentTheme.EditorTabs.background());
        wrapper2.setOpaque(true);
        if (this.isManyIslandEnabled()) {
            this.configureSearchReplaceComponent(component2, true);
        }
        return (JComponent)((Object)wrapper2);
    }

    private final void configureSearchReplaceComponent(EditorHeaderComponent component2, boolean enabled2) {
        Object originalBorder = component2.getClientProperty("originalBorder");
        Container parent = component2.getParent();
        if (!(originalBorder instanceof Border) || !(parent instanceof JComponent)) {
            return;
        }
        if (enabled2) {
            component2.setBorder(null);
            Supplier<Insets> supplier = () -> IslandsUICustomization.configureSearchReplaceComponent$lambda$0(this);
            JComponent jComponent = (JComponent)parent;
            Intrinsics.checkNotNull(supplier, (String)"null cannot be cast to non-null type java.util.function.Supplier<java.awt.Insets?>");
            jComponent.setBorder(JBUI.Borders.empty((Insets)((Insets)JBInsets.create(supplier, (Insets)supplier.get()))));
        } else {
            component2.setBorder((Border)originalBorder);
            ((JComponent)parent).setBorder(null);
        }
        Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.SearchReplaceFacade");
        ((SearchReplaceFacade)((Object)component2)).configureUI(enabled2);
    }

    @Override
    public boolean shouldPaintEditorTabsBottomBorder(@NotNull JComponent editorCompositePanel) {
        Intrinsics.checkNotNullParameter((Object)editorCompositePanel, (String)"editorCompositePanel");
        if (this.isManyIslandEnabled() && !this.isBreadcrumbsAbove()) {
            return UIUtil.findComponentOfType((JComponent)editorCompositePanel, SearchReplaceWrapper.class) == null;
        }
        return true;
    }

    @Override
    public void configureEditorsSplitters(@NotNull EditorsSplitters component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        if (this.isManyIslandEnabled()) {
            this.createEditorBorderPainter(component2);
        }
    }

    private final void createToolWindowBorderPainter(ToolWindow toolwindow, XNextIslandHolder component2) {
        component2.setBorder((Border)new JBEmptyBorder((Insets)JBUI.insets((String)"Island.ToolWindow.border", (JBInsets)JBUI.insets((int)3))));
        component2.setBorderPainter$intellij_platform_ide_impl(new AbstractBorderPainter(toolwindow, this){
            final /* synthetic */ ToolWindow $toolwindow;
            final /* synthetic */ IslandsUICustomization this$0;
            {
                this.$toolwindow = $toolwindow;
                this.this$0 = $receiver;
            }

            public void paintAfterChildren(JComponent component2, Graphics g) {
                Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                ToolWindowType toolWindowType = this.$toolwindow.getType();
                Intrinsics.checkNotNullExpressionValue((Object)toolWindowType, (String)"getType(...)");
                if (ToolWindowTypeExtensionsKt.isInternal(toolWindowType)) {
                    IslandsUICustomization.access$paintIslandBorder(this.this$0, component2, g, false);
                }
            }
        });
    }

    private final void createEditorBorderPainter(EditorsSplitters component2) {
        component2.setBorder((Border)new JBEmptyBorder((Insets)JBUI.insets((String)"Island.Editor.border", (JBInsets)JBUI.insets((int)2))));
        this.configureBackgroundPainting(component2, true);
        component2.setBorderPainter$intellij_platform_ide_impl(new AbstractBorderPainter(this){
            final /* synthetic */ IslandsUICustomization this$0;
            {
                this.this$0 = $receiver;
            }

            public void paintAfterChildren(JComponent component2, Graphics g) {
                Project project2;
                Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Project project3 = project2 = ProjectUtil.getProjectForComponent(component2);
                VirtualFile[] fileEditorManager = project3 != null ? (VirtualFile[])project3.getServiceIfCreated(FileEditorManager.class) : null;
                Graphics2D graphics2D = IdeBackgroundUtil.withFrameBackground(g, component2);
                Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"withFrameBackground(...)");
                Graphics2D frameBG = graphics2D;
                Graphics2D graphics2D2 = IdeBackgroundUtil.withEditorBackground(g, component2);
                Intrinsics.checkNotNullExpressionValue((Object)graphics2D2, (String)"withEditorBackground(...)");
                Graphics2D editorBG = graphics2D2;
                VirtualFile[] virtualFileArray = fileEditorManager;
                boolean bl = fileEditorManager != null && (virtualFileArray = virtualFileArray.getOpenFiles()) != null ? virtualFileArray.length == 0 : false;
                if (bl) {
                    IslandsUICustomization.access$paintBeforeEditorEmptyText(this.this$0, component2, frameBG, this.this$0.getEditorTabPainterAdapter());
                    EditorEmptyTextPainter editorEmptyTextPainter = (EditorEmptyTextPainter)ApplicationManager.getApplication().getService(EditorEmptyTextPainter.class);
                    editorEmptyTextPainter.doPaintEmptyText(component2, frameBG);
                }
                IslandsUICustomization.access$paintIslandBorder(this.this$0, component2, editorBG, true);
            }
        });
    }

    private final void paintBeforeEditorEmptyText(JComponent component2, Graphics graphics, TabPainterAdapter editorTabPainter) {
        graphics.setColor(editorTabPainter.getTabPainter().getBackgroundColor());
        graphics.fillRect(0, 0, component2.getWidth(), component2.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void paintIslandBorder(JComponent component2, Graphics g, boolean editor2) {
        boolean isGradient = this.isIslandsGradientEnabled();
        Graphics2D gg = null;
        if (isGradient) {
            Graphics2D graphics2D;
            this.forcedBackground = true;
            if (editor2) {
                Graphics2D graphics2D2 = IdeBackgroundUtil.withEditorBackground(g, component2);
                graphics2D = graphics2D2;
                Intrinsics.checkNotNullExpressionValue((Object)graphics2D2, (String)"withEditorBackground(...)");
            } else {
                Graphics2D graphics2D3 = IdeBackgroundUtil.withFrameBackground(g, component2);
                graphics2D = graphics2D3;
                Intrinsics.checkNotNullExpressionValue((Object)graphics2D3, (String)"withFrameBackground(...)");
            }
            gg = graphics2D;
        } else {
            Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            gg = (Graphics2D)g;
        }
        gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            int width = component2.getWidth();
            int height = component2.getHeight();
            Area shape = new Area(new Rectangle(0, 0, width, height));
            float cornerRadius = JBUIScale.scale((float)JBUI.getInt((String)"Island.arc", (int)10));
            int borderWith = JBUI.scale((int)JBUI.getInt((String)"Island.borderWidth", (int)4));
            float offset = (float)borderWith / 2.0f;
            float offsetWidth = (float)borderWith + 0.5f;
            Area border = new Area(new RoundRectangle2D.Float(offset, offset, (float)width - offsetWidth, (float)height - offsetWidth, cornerRadius, cornerRadius));
            shape.subtract(border);
            this.paintIslandBackground(gg, shape);
            if (this.isIslandBorderLineNeeded(component2)) {
                this.paintIslandBorderLine(gg, border);
            }
        }
        finally {
            if (isGradient) {
                this.forcedBackground = false;
            }
        }
    }

    private final void paintIslandBackground(Graphics2D gg, Area shape) {
        gg.setColor(this.getMainBackgroundColor());
        gg.fill(shape);
    }

    private final boolean isIslandBorderLineNeeded(JComponent component2) {
        if (this.isIslandsGradientEnabled()) {
            return true;
        }
        Project project2 = ProjectUtil.getProjectForComponent(component2);
        return !IdeBackgroundUtil.isEditorBackgroundImageSet(project2);
    }

    private final void paintIslandBorderLine(Graphics2D gg, Area border) {
        gg.setColor((Color)JBColor.namedColor((String)"Island.borderColor", (Color)this.getMainBackgroundColor()));
        gg.setStroke(new BasicStroke(JBUIScale.scale((float)1.0f), 1, 1));
        gg.draw(border);
    }

    @Override
    @NotNull
    public IslandsTabPainterAdapter getEditorTabPainterAdapter() {
        return this.editorTabPainterAdapter;
    }

    @Override
    @NotNull
    public IslandsTabPainter getToolWindowTabPainter() {
        return this.toolWindowTabPainter;
    }

    @Override
    @NotNull
    public IslandsTabPainterAdapter getCommonTabPainterAdapter() {
        return this.commonTabPainterAdapter;
    }

    @Override
    @NotNull
    public IslandsTabPainterAdapter getDebuggerTabPainterAdapter() {
        return this.debuggerTabPainterAdapter;
    }

    @Override
    public boolean paintTab(@NotNull Graphics g, @NotNull JBTabsPosition position, @NotNull Rectangle rect, boolean hovered, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        if (this.isManyIslandEnabled()) {
            this.getToolWindowTabPainter().paintTab((Graphics2D)g, position, rect, null, true, hovered, selected);
            return true;
        }
        return true;
    }

    @Override
    public boolean paintTabBorder(@NotNull Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        return this.isManyIslandEnabled();
    }

    @Override
    public int getTabLayoutStart(@NotNull ContentLayout layout2) {
        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
        if (this.isManyIslandEnabled() && !layout2.isIdVisible()) {
            return JBUI.scale((int)4);
        }
        return 0;
    }

    @Override
    @Nullable
    public Insets getSingleRowTabInsets(@NotNull JBTabsPosition tabsPosition) {
        Intrinsics.checkNotNullParameter((Object)tabsPosition, (String)"tabsPosition");
        boolean compactMode = UISettings.Companion.getInstance().getCompactMode();
        return this.isManyIslandEnabled() && tabsPosition.isSide() && compactMode ? (Insets)JBUI.insetsTop((int)3) : null;
    }

    private final Color getMainBackgroundColor() {
        JBColor jBColor = JBColor.namedColor((String)"MainWindow.background", (Color)JBColor.PanelBackground);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        return (Color)jBColor;
    }

    @Override
    @Nullable
    public Color getCustomMainBackgroundColor() {
        if (this.isManyIslandEnabled()) {
            return this.getMainBackgroundColor();
        }
        return null;
    }

    @Override
    public void attachIdeFrameBackgroundPainter(@NotNull IdeFrame frame, @NotNull IdeGlassPane glassPane) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)glassPane, (String)"glassPane");
        if (glassPane instanceof IdeGlassPaneImpl) {
            ((IdeGlassPaneImpl)glassPane).addFallbackBackgroundPainter((Painter)new IslandsGradientPainter(frame, this.getMainBackgroundColor(), (Function0<Boolean>)((Function0)() -> IslandsUICustomization.attachIdeFrameBackgroundPainter$lambda$0(this))));
        }
    }

    @Override
    public void paintFrameBackground(@NotNull IdeFrame frame, @NotNull Component component2, @NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (this.isManyIslandEnabled() && this.isIslandsGradientEnabled()) {
            Point point = SwingUtilities.convertPoint(component2, 0, 0, frame.getComponent());
            g.translate(-point.x, -point.y);
            IslandsGradientPainterKt.islandsGradientPaint(frame, this.getMainBackgroundColor(), ProjectWindowCustomizerService.Companion.getInstance(), component2, g);
            g.translate(point.x, point.y);
        }
    }

    @Override
    @NotNull
    public Graphics transformGraphics(@NotNull JComponent component2, @NotNull Graphics graphics) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        if (this.isManyIslandEnabled() && this.isIslandsGradientEnabled()) {
            Graphics2D graphics2D = JBSwingUtilities.runGlobalCGTransform((JComponent)component2, (Graphics)graphics);
            Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"runGlobalCGTransform(...)");
            return graphics2D;
        }
        return graphics;
    }

    @Override
    @NotNull
    public Graphics transformButtonGraphics(@NotNull Graphics graphics) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        return this.preserveGraphics(graphics);
    }

    @Override
    @NotNull
    public Graphics preserveGraphics(@NotNull Graphics graphics) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        if (this.isManyIslandEnabled() && this.isIslandsGradientEnabled()) {
            Graphics2D graphics2D = IdeBackgroundUtil.getOriginalGraphics(graphics);
            Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"getOriginalGraphics(...)");
            return graphics2D;
        }
        return graphics;
    }

    @Override
    @NotNull
    public Graphics backgroundImageGraphics(@NotNull JComponent component2, @NotNull Graphics graphics) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        if (this.isManyIslandEnabled() && this.isIslandsGradientEnabled()) {
            Graphics2D graphics2D = IdeBackgroundUtil.getOriginalGraphics(graphics);
            Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"getOriginalGraphics(...)");
            return graphics2D;
        }
        Graphics2D graphics2D = JBSwingUtilities.runGlobalCGTransform((JComponent)component2, (Graphics)graphics);
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"runGlobalCGTransform(...)");
        return graphics2D;
    }

    @Override
    public boolean isMacScrollBar() {
        return !SystemInfoRt.isMac && this.isManyIslandEnabled();
    }

    private final void updateToolStripesVisibility(ToolWindowManager toolWindowManager) {
        if (toolWindowManager instanceof ToolWindowManagerImpl) {
            for (ToolWindowPane pane2 : ((ToolWindowManagerImpl)toolWindowManager).getToolWindowPanes$intellij_platform_ide_impl()) {
                ToolWindowButtonManager buttonManager = pane2.buttonManager;
                if (!(buttonManager instanceof ToolWindowPaneNewButtonManager)) continue;
                ((ToolWindowPaneNewButtonManager)buttonManager).updateToolStripesVisibility$intellij_platform_ide_impl();
            }
        }
    }

    @Override
    @Nullable
    public Insets getProjectTabContentInsets() {
        if (this.isManyIslandEnabled()) {
            return (Insets)JBUI.insets((int)0, (int)4, (int)0, (int)15);
        }
        return null;
    }

    private final boolean isColorfulToolbar(JFrame frame) {
        Component glassPane = frame.getGlassPane();
        if (glassPane instanceof IdeGlassPaneEx) {
            return ((IdeGlassPaneEx)((Object)glassPane)).isColorfulToolbar();
        }
        return true;
    }

    @Override
    public void createProjectTab(@NotNull JFrame frame, @NotNull WindowTabsComponent tabsComponent) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)tabsComponent, (String)"tabsComponent");
        if (this.isManyIslandEnabled()) {
            if (frame instanceof IdeFrame) {
                Project project2 = ((IdeFrame)frame).getProject();
                if (project2 != null) {
                    Project project3;
                    Project project4 = project3 = project2;
                    boolean bl = false;
                    this.updateToolStripesVisibility(ToolWindowManager.Companion.getInstance(project4));
                }
            }
            this.configureMainFrameChildren((Component)((Object)tabsComponent), true);
        }
    }

    @Override
    public boolean paintProjectTab(@NotNull JFrame frame, @NotNull TabLabel label2, @NotNull Graphics g, @NotNull JBTabsImpl tabs, boolean selected, int index, int lastIndex) {
        TabInfo nextTab;
        Project project2;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)tabs, (String)"tabs");
        if (!this.isManyIslandEnabled()) {
            return false;
        }
        Container parent = tabs.getParent();
        if (parent instanceof JComponent && frame instanceof IdeFrame && (project2 = ((IdeFrame)frame).getProject()) != null && (((JComponent)parent).getBorder() == null || !Intrinsics.areEqual((Object)project2.getLocationHash(), (Object)((JComponent)parent).getClientProperty("PROJECT_ID")))) {
            this.updateToolStripesVisibility(ToolWindowManager.Companion.getInstance(project2));
        }
        boolean hovered = tabs.isHoveredTab(label2);
        boolean isGradient = this.isIslandsGradientEnabled() && !CustomWindowHeaderUtil.INSTANCE.isCompactHeader$intellij_platform_ide_impl() && this.isColorfulToolbar(frame);
        Rectangle rect = new Rectangle(label2.getWidth(), label2.getHeight());
        g.setColor(this.getMainBackgroundColor());
        g.fillRect(0, 0, rect.width, rect.height);
        if (selected || hovered) {
            Graphics graphics;
            if (isGradient) {
                Graphics2D graphics2D = IdeBackgroundUtil.getOriginalGraphics(g);
                Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"getOriginalGraphics(...)");
                graphics = graphics2D;
            } else {
                graphics = g;
            }
            Graphics gg = graphics;
            int cornerRadius = JBUI.scale((int)JBUI.getInt((String)"Island.arc", (int)10));
            rect.x += JBUI.scale((int)1);
            rect.width -= rect.x * 2;
            ((Graphics2D)gg).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)gg).setColor(selected ? (Color)this.PROJECT_TAB_SELECTED_BACKGROUND : (Color)this.PROJECT_TAB_HOVER_BACKGROUND);
            gg.fillRoundRect(rect.x, rect.y, rect.width, rect.height, cornerRadius, cornerRadius);
        } else if (lastIndex > 1 && index < lastIndex && !Intrinsics.areEqual((Object)(nextTab = tabs.getTabAt(index + 1)), (Object)tabs.getSelectedInfo()) && !tabs.isHoveredTab(tabs.getTabLabel(nextTab))) {
            Graphics graphics;
            if (isGradient) {
                Graphics2D graphics2D = IdeBackgroundUtil.getOriginalGraphics(g);
                Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"getOriginalGraphics(...)");
                graphics = graphics2D;
            } else {
                graphics = g;
            }
            Graphics gg = graphics;
            double border = JBUI.scale((int)1);
            double width = (double)label2.getWidth() - border;
            double offset = JBUI.scale((int)5);
            g.setColor((Color)this.PROJECT_TAB_SEPARATOR_COLOR);
            LinePainter2D.paint((Graphics2D)((Graphics2D)gg), (double)width, (double)offset, (double)width, (double)((double)rect.height - offset), (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)border);
        }
        return true;
    }

    private static final boolean noBackground$lambda$0(IslandsUICustomization this$0, JComponent component2) {
        Object explicitlySetValue;
        return this$0.forcedBackground ? false : ((explicitlySetValue = component2.getClientProperty(IdeBackgroundUtil.NO_BACKGROUND)) instanceof Boolean ? (Boolean)explicitlySetValue : this$0.isManyIslandEnabled() && this$0.isIslandsGradientEnabled());
    }

    private static final UISettings uiSettings_delegate$lambda$0() {
        return UISettings.Companion.getInstance();
    }

    private static final void awtListener$lambda$0(IslandsUICustomization this$0, AWTEvent event) {
        boolean isToolWindow;
        Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type java.awt.event.HierarchyEvent");
        Component component2 = ((HierarchyEvent)event).getComponent();
        if (!this$0.isBrightCached && !this$0.getUiSettings().getDifferentToolwindowBackground() || (((HierarchyEvent)event).getChangeFlags() & 4L) == 0L || !component2.isShowing()) {
            return;
        }
        boolean bl = isToolWindow = UIUtil.getGeneralizedParentOfType(InternalDecorator.class, (Component)component2) != null;
        if (isToolWindow && Intrinsics.areEqual((Object)component2.getBackground(), (Object)JBColor.PanelBackground)) {
            component2.setBackground(JBUI.CurrentTheme.ToolWindow.background());
        }
    }

    private static final void _init_$lambda$0(IslandsUICustomization this$0, Ref.BooleanRef $oldManyIsland, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.removeAWTEventListener(this$0.awtListener);
        this$0.isManyIslandEnabledCache = null;
        boolean newManyIsland = this$0.isManyIslandEnabled();
        if (newManyIsland) {
            this$0.isBrightCached = JBColor.isBright();
            toolkit.addAWTEventListener(this$0.awtListener, 32768L);
            this$0.applyMissingKeys();
        }
        if ($oldManyIsland.element == newManyIsland) {
            return;
        }
        if (newManyIsland) {
            this$0.enableManyIslands();
        } else {
            this$0.disableManyIslands();
        }
        $oldManyIsland.element = newManyIsland;
    }

    private static final Unit enableManyIslands$lambda$0(IslandsUICustomization this$0, Component it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.configureMainFrameChildren(it, true);
        Component component2 = it;
        if (component2 instanceof EditorsSplitters) {
            this$0.createEditorBorderPainter((EditorsSplitters)it);
            this$0.clearParentNoBackground((JComponent)it);
        } else if (component2 instanceof JBEditorTabs) {
            if (((JBEditorTabs)it).getParent() instanceof EditorsSplitters) {
                this$0.configureBackgroundPainting((JComponent)it, true);
            }
        } else if (component2 instanceof ManyIslandDivider) {
            ((ManyIslandDivider)((Object)it)).configure(true);
        } else if (component2 instanceof SearchReplaceFacade) {
            this$0.configureSearchReplaceComponent((EditorHeaderComponent)it, true);
        }
        return Unit.INSTANCE;
    }

    private static final void enableManyIslands$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit disableManyIslands$lambda$0(IslandsUICustomization this$0, Component it) {
        Component component2;
        Intrinsics.checkNotNull((Object)it);
        this$0.configureMainFrameChildren(it, false);
        if (it instanceof JComponent) {
            ClientProperty.removeRecursive((JComponent)((JComponent)it), IdeBackgroundUtil.NO_BACKGROUND_PREDICATE);
        }
        if ((component2 = it) instanceof EditorsSplitters) {
            ((EditorsSplitters)it).setBorder(null);
            ((EditorsSplitters)it).setBorderPainter$intellij_platform_ide_impl(new DefaultBorderPainter());
        } else if (component2 instanceof ManyIslandDivider) {
            ((ManyIslandDivider)((Object)it)).configure(false);
        } else if (component2 instanceof SearchReplaceFacade) {
            this$0.configureSearchReplaceComponent((EditorHeaderComponent)it, false);
        }
        return Unit.INSTANCE;
    }

    private static final void disableManyIslands$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureToolWindowPane$lambda$0(IslandsUICustomization this$0, JComponent $toolWindowPaneParent, ToolWindowButtonManager $buttonManager, boolean leftVisible, boolean rightVisible) {
        boolean isIslands = this$0.isManyIslandEnabled();
        int gap = JBUI.getInt((String)"Islands.emptyGap", (int)4);
        if (SystemInfo.isMac) {
            JRootPane jRootPane = UIUtil.getRootPane((Component)$toolWindowPaneParent);
            if (jRootPane != null) {
                JRootPane rootPane = jRootPane;
                boolean bl = false;
                Object tabContainer = rootPane.getClientProperty("WINDOW_TABS_CONTAINER_KEY");
                if (tabContainer instanceof JComponent) {
                    if (isIslands) {
                        Project project2;
                        Container frame = rootPane.getParent();
                        if (frame instanceof IdeFrame && (project2 = ((IdeFrame)frame).getProject()) != null) {
                            ((JComponent)tabContainer).putClientProperty("PROJECT_ID", project2.getLocationHash());
                        }
                        if (DistractionFreeModeController.isDistractionFreeModeEnabled()) {
                            ((JComponent)tabContainer).setBorder((Border)JBUI.Borders.emptyBottom((int)2));
                        } else {
                            int left = leftVisible ? JBUI.unscale((int)((ToolWindowPaneNewButtonManager)$buttonManager).getLeft$intellij_platform_ide_impl().getWidth()) + 1 : gap;
                            int right = rightVisible ? JBUI.unscale((int)((ToolWindowPaneNewButtonManager)$buttonManager).getRight$intellij_platform_ide_impl().getWidth()) + 2 : gap + 1;
                            ((JComponent)tabContainer).setBorder((Border)JBUI.Borders.empty((int)0, (int)left, (int)2, (int)right));
                        }
                    } else if (((JComponent)tabContainer).getBorder() != null) {
                        ((JComponent)tabContainer).setBorder(null);
                    }
                }
            }
        }
        if (!isIslands) {
            if ($toolWindowPaneParent.getBorder() != null) {
                $toolWindowPaneParent.setBorder(null);
            }
            return Unit.INSTANCE;
        }
        if (leftVisible && rightVisible || DistractionFreeModeController.isDistractionFreeModeEnabled()) {
            if ($toolWindowPaneParent.getBorder() != null) {
                $toolWindowPaneParent.setBorder(null);
            }
        } else {
            int left = leftVisible ? 0 : gap;
            int right = rightVisible ? 0 : gap;
            Border border = $toolWindowPaneParent.getBorder();
            if (border == null) {
                $toolWindowPaneParent.setBorder((Border)JBUI.Borders.empty((int)0, (int)left, (int)0, (int)right));
            } else {
                Insets insets = border.getBorderInsets($toolWindowPaneParent);
                if (insets.left != left || insets.right != right) {
                    $toolWindowPaneParent.setBorder((Border)JBUI.Borders.empty((int)0, (int)left, (int)0, (int)right));
                }
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit configureMainFrame$lambda$0(IslandsUICustomization this$0, Component it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.configureMainFrameChildren(it, true);
        return Unit.INSTANCE;
    }

    private static final void configureMainFrame$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Insets configureSearchReplaceComponent$lambda$0(IslandsUICustomization this$0) {
        return new Insets(5 + this$0.getSearchReplaceEmptyTopSpace(), 10, 5, 10);
    }

    private static final boolean attachIdeFrameBackgroundPainter$lambda$0(IslandsUICustomization this$0) {
        return this$0.isManyIslandEnabled() && this$0.isIslandsGradientEnabled();
    }

    public static final /* synthetic */ void access$paintIslandBorder(IslandsUICustomization $this, JComponent component2, Graphics g, boolean editor2) {
        $this.paintIslandBorder(component2, g, editor2);
    }

    public static final /* synthetic */ void access$paintBeforeEditorEmptyText(IslandsUICustomization $this, JComponent component2, Graphics graphics, TabPainterAdapter editorTabPainter) {
        $this.paintBeforeEditorEmptyText(component2, graphics, editorTabPainter);
    }

    public static final /* synthetic */ void access$createToolWindowBorderPainter(IslandsUICustomization $this, ToolWindow toolwindow, XNextIslandHolder component2) {
        $this.createToolWindowBorderPainter(toolwindow, component2);
    }

    public static final /* synthetic */ void access$configureBackgroundPainting(IslandsUICustomization $this, JComponent component2, boolean recursive) {
        $this.configureBackgroundPainting(component2, recursive);
    }

    public static final /* synthetic */ Color access$getMainBackgroundColor(IslandsUICustomization $this) {
        return $this.getMainBackgroundColor();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00070\b\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/application/impl/islands/IslandsUICustomization$SearchReplaceWrapper;", "Lcom/intellij/ui/components/panels/Wrapper;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "component", "Lcom/intellij/openapi/editor/impl/EditorHeaderComponent;", "<init>", "(Lcom/intellij/openapi/application/impl/islands/IslandsUICustomization;Lcom/intellij/openapi/editor/impl/EditorHeaderComponent;)V", "fillColor", "Lcom/intellij/ui/JBColor;", "Lorg/jetbrains/annotations/NotNull;", "getFillColor", "()Lcom/intellij/ui/JBColor;", "borderColor", "getBorderColor", "paintComponent", "", "g", "Ljava/awt/Graphics;", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "intellij.platform.ide.impl"})
    private final class SearchReplaceWrapper
    extends Wrapper
    implements UiDataProvider {
        @NotNull
        private final EditorHeaderComponent component;
        @NotNull
        private final JBColor fillColor;
        @NotNull
        private final JBColor borderColor;

        public SearchReplaceWrapper(EditorHeaderComponent component2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            super((JComponent)component2);
            this.component = component2;
            JBColor jBColor = JBColor.namedColor((String)"Editor.SearchField.background");
            Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
            this.fillColor = jBColor;
            JBColor jBColor2 = JBColor.namedColor((String)"Editor.SearchField.borderColor");
            Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(...)");
            this.borderColor = jBColor2;
        }

        @NotNull
        public final JBColor getFillColor() {
            return this.fillColor;
        }

        @NotNull
        public final JBColor getBorderColor() {
            return this.borderColor;
        }

        protected void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            super.paintComponent(g);
            if (IslandsUICustomization.this.isManyIslandEnabled()) {
                Rectangle rect = new Rectangle(this.getSize());
                JBInsets.removeFrom((Rectangle)rect, (Insets)((Insets)new JBInsets(IslandsUICustomization.this.getSearchReplaceEmptyTopSpace(), 7, 0, 7)));
                Graphics2D cfr_ignored_0 = (Graphics2D)g;
                ((Graphics2D)g).setColor((Color)this.fillColor);
                RectanglePainter2D.FILL.paint((Graphics2D)g, (double)rect.x, (double)rect.y, (double)rect.width, (double)rect.height, Double.valueOf(12.0), LinePainter2D.StrokeType.CENTERED, 1.0, RenderingHints.VALUE_ANTIALIAS_ON);
                ((Graphics2D)g).setColor((Color)this.borderColor);
                RectanglePainter2D.DRAW.paint((Graphics2D)g, (double)rect.x, (double)rect.y, (double)rect.width, (double)rect.height, Double.valueOf(12.0), LinePainter2D.StrokeType.CENTERED, 1.0, RenderingHints.VALUE_ANTIALIAS_ON);
            }
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            EditorHeaderComponent editorHeaderComponent = this.component;
            Intrinsics.checkNotNull((Object)editorHeaderComponent, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.UiDataProvider");
            ((UiDataProvider)editorHeaderComponent).uiDataSnapshot(sink);
        }
    }
}

