/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UndoCommandListener
implements CommandListener {
    @Nullable
    private final Project project;
    @NotNull
    private final UndoManagerImpl undoManager;
    private boolean isTransparentActionStarted;

    UndoCommandListener(@NotNull Project project2) {
        if (project2 == null) {
            UndoCommandListener.$$$reportNull$$$0(0);
        }
        this(project2, UndoManager.getInstance((Project)project2));
    }

    UndoCommandListener() {
        this(null, UndoManager.getGlobalInstance());
    }

    private UndoCommandListener(@Nullable Project project2, @NotNull UndoManager undoManager) {
        if (undoManager == null) {
            UndoCommandListener.$$$reportNull$$$0(1);
        }
        this.project = project2;
        this.undoManager = (UndoManagerImpl)undoManager;
    }

    public void commandStarted(@NotNull CommandEvent event) {
        if (event == null) {
            UndoCommandListener.$$$reportNull$$$0(2);
        }
        if (!this.isTransparentActionStarted && !this.isProjectDisposed()) {
            this.undoManager.onCommandStarted(event.getProject(), event.getUndoConfirmationPolicy(), event.shouldRecordActionForOriginalDocument());
        }
    }

    public void commandFinished(@NotNull CommandEvent event) {
        if (event == null) {
            UndoCommandListener.$$$reportNull$$$0(3);
        }
        if (!this.isTransparentActionStarted && !this.isProjectDisposed()) {
            this.undoManager.onCommandFinished(event.getProject(), event.getCommandName(), event.getCommandGroupId());
        }
    }

    public void undoTransparentActionStarted() {
        if (!this.isProjectDisposed() && !this.undoManager.isInsideCommand()) {
            this.isTransparentActionStarted = true;
            this.undoManager.onCommandStarted(this.project, UndoConfirmationPolicy.DEFAULT, true);
        }
    }

    public void undoTransparentActionFinished() {
        if (this.isTransparentActionStarted && !this.isProjectDisposed()) {
            this.isTransparentActionStarted = false;
            this.undoManager.onCommandFinished(this.project, "", null);
        }
    }

    private boolean isProjectDisposed() {
        return this.project != null && this.project.isDisposed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/command/impl/UndoCommandListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "commandStarted";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "commandFinished";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

