/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.DocumentReferenceByDocument;
import com.intellij.openapi.command.impl.SharedAdjustableUndoableActionsHolder;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoRedoList;
import com.intellij.openapi.command.impl.UndoRedoStacksHolderBase;
import com.intellij.openapi.command.impl.UndoableGroup;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class UndoRedoStacksHolder
extends UndoRedoStacksHolderBase<UndoableGroup> {
    private final SharedAdjustableUndoableActionsHolder undoableActionsHolder;
    private final UndoRedoList<UndoableGroup> globalStack;

    UndoRedoStacksHolder(@NotNull SharedAdjustableUndoableActionsHolder undoableActionsHolder, boolean isUndo) {
        if (undoableActionsHolder == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(0);
        }
        super(isUndo);
        this.undoableActionsHolder = undoableActionsHolder;
        this.globalStack = new UndoRedoList();
    }

    @Override
    void clearDocumentReferences(@NotNull Document document2) {
        if (document2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(1);
        }
        super.clearDocumentReferences(document2);
        DocumentReference referenceFile = DocumentReferenceManager.getInstance().create(document2);
        DocumentReferenceByDocument referenceDoc = new DocumentReferenceByDocument(document2);
        this.globalStack.removeIf(group2 -> ContainerUtil.and(group2.getAffectedDocuments(), ref2 -> ref2.equals((Object)referenceFile) || ref2.equals((Object)referenceDoc)));
    }

    boolean canBeUndoneOrRedone(@NotNull Collection<DocumentReference> refs) {
        if (refs == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(2);
        }
        if (refs.isEmpty()) {
            return !this.globalStack.isEmpty() && this.globalStack.getLast().isValid();
        }
        for (DocumentReference docRef : refs) {
            UndoRedoList stack = (UndoRedoList)this.getStack(docRef);
            if (stack.isEmpty() || !((UndoableGroup)stack.getLast()).isValid()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    UndoableGroup getLastAction(@NotNull Collection<DocumentReference> refs) {
        if (refs == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(3);
        }
        if (refs.isEmpty()) {
            return this.globalStack.getLast();
        }
        UndoableGroup mostRecentAction = null;
        int mostRecentDocTimestamp = 0;
        for (DocumentReference docRef : refs) {
            UndoRedoList stack = (UndoRedoList)this.getStack(docRef);
            if (stack.isEmpty()) continue;
            UndoableGroup lastAction = (UndoableGroup)stack.getLast();
            int timestamp = lastAction.getCommandTimestamp();
            if (mostRecentAction != null && (!lastAction.isTemporary() || mostRecentAction.isTemporary()) && (lastAction.isTemporary() != mostRecentAction.isTemporary() || !(this.isUndo() ? timestamp > mostRecentDocTimestamp : timestamp < mostRecentDocTimestamp))) continue;
            mostRecentAction = lastAction;
            mostRecentDocTimestamp = timestamp;
        }
        return mostRecentAction;
    }

    @NotNull
    Set<DocumentReference> collectClashingActions(@NotNull UndoableGroup group2) {
        UndoableGroup last;
        if (group2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(4);
        }
        HashSet<DocumentReference> result2 = new HashSet<DocumentReference>();
        for (DocumentReference docRef : group2.getAffectedDocuments()) {
            UndoableGroup last2 = (UndoableGroup)((UndoRedoList)this.getStack(docRef)).peekLast();
            if (last2 == null || last2 == group2) continue;
            result2.addAll(last2.getAffectedDocuments());
        }
        if (group2.isGlobal() && (last = this.globalStack.peekLast()) != null && last != group2) {
            result2.addAll(last.getAffectedDocuments());
        }
        HashSet<DocumentReference> hashSet = result2;
        if (hashSet == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    void addToStacks(@NotNull UndoableGroup group2) {
        if (group2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(6);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding to " + this.getStacksDescription() + ": " + group2.dumpState());
        }
        for (UndoRedoList<UndoableGroup> stack : this.getAffectedStacks(group2)) {
            if (this.isUndo() && !group2.isTemporary()) {
                UndoRedoStacksHolder.convertTemporaryActionsToPermanent(stack);
            }
            int undoLimit = stack == this.globalStack ? UndoManagerImpl.getGlobalUndoLimit() : UndoManagerImpl.getDocumentUndoLimit();
            this.doAddToStack(stack, group2, undoLimit);
        }
    }

    void removeFromStacks(@NotNull UndoableGroup group2) {
        if (group2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(7);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing from " + this.getStacksDescription() + ": " + group2.dumpState());
        }
        for (UndoRedoList<UndoableGroup> stack : this.getAffectedStacks(group2)) {
            assert (stack.getLast() == group2);
            stack.removeLast();
        }
    }

    boolean replaceOnStacks(@NotNull UndoableGroup group2, @NotNull UndoableGroup newGroup) {
        if (group2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(8);
        }
        if (newGroup == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(9);
        }
        boolean hasAffectedItems = false;
        for (UndoRedoList<UndoableGroup> stack : this.getAffectedStacks(group2)) {
            ListIterator<UndoableGroup> stackIterator = stack.listIterator();
            while (stackIterator.hasNext()) {
                UndoableGroup currentGroup = stackIterator.next();
                if (currentGroup != group2) continue;
                stackIterator.set(newGroup);
                hasAffectedItems = true;
            }
        }
        return hasAffectedItems;
    }

    void clearStacks(@NotNull Collection<DocumentReference> refs, boolean clearGlobal) {
        if (refs == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(10);
        }
        for (UndoRedoList<UndoableGroup> stack : this.getAffectedStacks(refs, clearGlobal)) {
            while (!stack.isEmpty()) {
                this.clearStacksFrom(stack.getLast());
            }
        }
        this.removeEmptyStacks();
    }

    void collectAllAffectedDocuments(@NotNull Collection<DocumentReference> result2) {
        if (result2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(11);
        }
        for (UndoableGroup undoableGroup : this.globalStack) {
            result2.addAll(undoableGroup.getAffectedDocuments());
        }
        this.collectLocalAffectedDocuments(result2);
    }

    int getLastCommandTimestamp(@NotNull DocumentReference r) {
        UndoRedoList stack;
        if (r == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(12);
        }
        if ((stack = (UndoRedoList)this.getStack(r)).isEmpty()) {
            return 0;
        }
        return Math.max(((UndoableGroup)stack.getFirst()).getCommandTimestamp(), ((UndoableGroup)stack.getLast()).getCommandTimestamp());
    }

    void invalidateActionsFor(@NotNull DocumentReference ref2) {
        if (ref2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(13);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invalidating actions in " + this.getStacksDescription() + " for " + String.valueOf(ref2));
        }
        for (UndoRedoList<UndoableGroup> stack : this.getAffectedStacks(Collections.singleton(ref2), true)) {
            for (UndoableGroup undoableGroup : stack) {
                undoableGroup.invalidateActionsFor(ref2);
            }
        }
    }

    int getStackSize(@Nullable DocumentReference docRef) {
        if (docRef == null) {
            return this.globalStack.size();
        }
        return ((UndoRedoList)this.getStack(docRef)).size();
    }

    @NotNull
    Collection<DocumentReference> getAffectedDocuments(@Nullable Collection<DocumentReference> docRefs) {
        if (docRefs == null) {
            return this.getAffectedDocuments();
        }
        HashSet<DocumentReference> result2 = new HashSet<DocumentReference>(docRefs);
        List<UndoRedoList<UndoableGroup>> stacks = this.getAffectedStacks(docRefs, true);
        for (UndoRedoList<UndoableGroup> stack : stacks) {
            for (UndoableGroup group2 : stack) {
                result2.addAll(group2.getAffectedDocuments());
            }
        }
        HashSet<DocumentReference> hashSet = result2;
        if (hashSet == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    @NotNull
    String dump(@Nullable DocumentReference docRef) {
        String stackName = this.isUndo() ? "UndoStack" : "RedoStack";
        UndoRedoList stack = docRef == null ? this.globalStack : (UndoRedoList)this.getStack(docRef);
        String affected = stack.stream().flatMap(group2 -> group2.getAffectedDocuments().stream()).distinct().map(Objects::toString).collect(Collectors.joining(", ", "[", "]"));
        String string = "%s affected %s\n%s".formatted(stackName, affected, UndoRedoStacksHolder.dumpStack(stack));
        if (string == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(15);
        }
        return string;
    }

    @TestOnly
    void clearAllStacksInTests() {
        this.clearStacks(this.getAffectedDocuments(), true);
        this.globalStack.clear();
        this.myDocumentStacks.clear();
        this.myDocumentsWithStacks.clear();
        this.myNonlocalVirtualFilesWithStacks.clear();
    }

    private void doAddToStack(@NotNull UndoRedoList<UndoableGroup> stack, @NotNull UndoableGroup group2, int limit) {
        if (stack == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(16);
        }
        if (group2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(17);
        }
        if (!group2.isUndoable() && stack.isEmpty()) {
            return;
        }
        stack.add(group2);
        while (stack.size() > limit) {
            this.clearStacksFrom(stack.getFirst());
        }
    }

    private void clearStacksFrom(@NotNull UndoableGroup from) {
        if (from == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(18);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Clearing " + this.getStacksDescription() + " from " + from.dumpState());
        }
        for (UndoRedoList<UndoableGroup> stack : this.getAffectedStacks(from)) {
            int pos = stack.indexOf(from);
            if (pos == -1) continue;
            if (pos > 0) {
                int top = stack.size() - pos;
                this.clearStacksFrom(stack.get(pos - 1));
                assert (stack.size() == top && stack.indexOf(from) == 0);
            }
            stack.removeFirstSlow();
        }
        from.invalidateChangeRanges(this.undoableActionsHolder);
    }

    @NotNull
    private List<UndoRedoList<UndoableGroup>> getAffectedStacks(@NotNull UndoableGroup group2) {
        if (group2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(19);
        }
        return this.getAffectedStacks(group2.getAffectedDocuments(), group2.isGlobal());
    }

    @NotNull
    private List<UndoRedoList<UndoableGroup>> getAffectedStacks(@NotNull Collection<DocumentReference> refs, boolean global) {
        if (refs == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(20);
        }
        ArrayList<UndoRedoList<UndoableGroup>> result2 = new ArrayList<UndoRedoList<UndoableGroup>>(refs.size() + 1);
        if (global) {
            result2.add(this.globalStack);
        }
        for (DocumentReference ref2 : refs) {
            result2.add((UndoRedoList)this.getStack(ref2));
        }
        ArrayList<UndoRedoList<UndoableGroup>> arrayList = result2;
        if (arrayList == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    private void collectLocalAffectedDocuments(@NotNull Collection<DocumentReference> result2) {
        if (result2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(22);
        }
        result2.addAll(this.myDocumentStacks.keySet());
        DocumentReferenceManager documentReferenceManager = DocumentReferenceManager.getInstance();
        for (Document document2 : this.myDocumentsWithStacks) {
            result2.add(documentReferenceManager.create(document2));
        }
        for (VirtualFile file2 : this.myNonlocalVirtualFilesWithStacks) {
            result2.add(documentReferenceManager.create(file2));
        }
    }

    @NotNull
    private Set<DocumentReference> getAffectedDocuments() {
        HashSet<DocumentReference> result2 = new HashSet<DocumentReference>();
        this.collectAllAffectedDocuments(result2);
        HashSet<DocumentReference> hashSet = result2;
        if (hashSet == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(23);
        }
        return hashSet;
    }

    private static void convertTemporaryActionsToPermanent(@NotNull UndoRedoList<UndoableGroup> stack) {
        UndoableGroup undoableGroup;
        if (stack == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(24);
        }
        for (int i2 = stack.size() - 1; i2 >= 0 && (undoableGroup = stack.get(i2)).isTemporary(); --i2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Converting to permanent: " + String.valueOf(undoableGroup));
            }
            undoableGroup.makePermanent();
        }
    }

    @NotNull
    private static String dumpStack(@NotNull UndoRedoList<UndoableGroup> stack) {
        if (stack == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(25);
        }
        if (stack.isEmpty()) {
            return "  empty";
        }
        StringBuilder rows = new StringBuilder();
        for (int i2 = stack.size() - 1; i2 >= 0; --i2) {
            String row2 = "  " + i2 + " " + stack.get(i2).dumpState0();
            rows.append(row2);
            if (i2 == 0) continue;
            rows.append("\n");
        }
        String string = rows.toString();
        if (string == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(26);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 14, 15, 21, 23, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoableActionsHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 5: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/UndoRedoStacksHolder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newGroup";
                break;
            }
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 16: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stack";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/UndoRedoStacksHolder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClashingActions";
                break;
            }
            case 14: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedDocuments";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "dump";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedStacks";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpStack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "clearDocumentReferences";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canBeUndoneOrRedone";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLastAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectClashingActions";
                break;
            }
            case 5: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 26: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addToStacks";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeFromStacks";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replaceOnStacks";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "clearStacks";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectAllAffectedDocuments";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommandTimestamp";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "invalidateActionsFor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doAddToStack";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "clearStacksFrom";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedStacks";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "collectLocalAffectedDocuments";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "convertTemporaryActionsToPermanent";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "dumpStack";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 14, 15, 21, 23, 26 -> new IllegalStateException(string);
        };
    }
}

