/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.editor.ComponentInlayAlignment;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017J\u0012\u0010\u0018\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017J*\u0010\u0019\u001a\u00020\u001a2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/editor/ComponentInlayRenderer;", "T", "Ljava/awt/Component;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "component", "alignment", "Lcom/intellij/openapi/editor/ComponentInlayAlignment;", "<init>", "(Ljava/awt/Component;Lcom/intellij/openapi/editor/ComponentInlayAlignment;)V", "getComponent", "()Ljava/awt/Component;", "Ljava/awt/Component;", "getAlignment", "()Lcom/intellij/openapi/editor/ComponentInlayAlignment;", "inlaySize", "Ljava/awt/Dimension;", "getInlaySize$intellij_platform_ide_impl", "()Ljava/awt/Dimension;", "setInlaySize$intellij_platform_ide_impl", "(Ljava/awt/Dimension;)V", "calcWidthInPixels", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "calcHeightInPixels", "paint", "", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "intellij.platform.ide.impl"})
@ApiStatus.Experimental
public class ComponentInlayRenderer<T extends Component>
implements EditorCustomElementRenderer {
    @NotNull
    private final T component;
    @Nullable
    private final ComponentInlayAlignment alignment;
    @NotNull
    private Dimension inlaySize;

    public ComponentInlayRenderer(@NotNull T component2, @Nullable ComponentInlayAlignment alignment) {
        Intrinsics.checkNotNullParameter(component2, (String)"component");
        this.component = component2;
        this.alignment = alignment;
        Dimension dimension = ((Component)this.component).getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        this.inlaySize = dimension;
    }

    public /* synthetic */ ComponentInlayRenderer(Component component2, ComponentInlayAlignment componentInlayAlignment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            componentInlayAlignment = null;
        }
        this(component2, componentInlayAlignment);
    }

    @NotNull
    public final T getComponent() {
        return this.component;
    }

    @Nullable
    public final ComponentInlayAlignment getAlignment() {
        return this.alignment;
    }

    @NotNull
    public final Dimension getInlaySize$intellij_platform_ide_impl() {
        return this.inlaySize;
    }

    public final void setInlaySize$intellij_platform_ide_impl(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"<set-?>");
        this.inlaySize = dimension;
    }

    public final int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return this.inlaySize.width;
    }

    public final int calcHeightInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return this.inlaySize.height;
    }

    public final void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
    }
}

