/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DeleteInColumnModeHandler
extends EditorWriteActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public DeleteInColumnModeHandler(EditorActionHandler handler) {
        this.myOriginalHandler = handler;
    }

    public void executeWriteAction(@NotNull Editor editor2, @Nullable Caret caret, DataContext dataContext2) {
        if (editor2 == null) {
            DeleteInColumnModeHandler.$$$reportNull$$$0(0);
        }
        if (editor2.isColumnMode() && caret == null && editor2.getCaretModel().getCaretCount() > 1) {
            EditorUIUtil.hideCursorInEditor(editor2);
            CommandProcessor.getInstance().setCurrentCommandGroupId(EditorActionUtil.DELETE_COMMAND_GROUP);
            CopyPasteManager.getInstance().stopKillRings();
            editor2.getCaretModel().runForEachCaret(c -> {
                int lineEndOffset;
                int offset = c.getOffset();
                if (offset < (lineEndOffset = DocumentUtil.getLineEndOffset((int)offset, (Document)editor2.getDocument())) || c.hasSelection()) {
                    this.myOriginalHandler.execute(editor2, c, dataContext2);
                }
            });
        } else {
            this.myOriginalHandler.execute(editor2, caret, dataContext2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/DeleteInColumnModeHandler", "executeWriteAction"));
    }
}

