/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.DocumentUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/editor/actions/TransposeAction;", "Lcom/intellij/openapi/editor/actionSystem/EditorAction;", "<init>", "()V", "TransposeHandler", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class TransposeAction
extends EditorAction {
    public TransposeAction() {
        super((EditorActionHandler)new TransposeHandler());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\u0004\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00130\u00122\u0006\u0010\u0014\u001a\u00020\rH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/editor/actions/TransposeAction$TransposeHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorWriteActionHandler;", "<init>", "()V", "executeWriteAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isSuitableForTranspose", "", "performTranspose", "isSuitableForRotateSelections", "performRotateSelections", "rotateElements", "", "T", "isBackwards", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nTransposeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransposeAction.kt\ncom/intellij/openapi/editor/actions/TransposeAction$TransposeHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1740#2,3:91\n1740#2,3:94\n1068#2:97\n1563#2:98\n1634#2,3:99\n*S KotlinDebug\n*F\n+ 1 TransposeAction.kt\ncom/intellij/openapi/editor/actions/TransposeAction$TransposeHandler\n*L\n24#1:91,3\n56#1:94,3\n64#1:97\n67#1:98\n67#1:99,3\n*E\n"})
    private static final class TransposeHandler
    extends EditorWriteActionHandler {
        public void executeWriteAction(@NotNull Editor editor2, @Nullable Caret caret, @Nullable DataContext dataContext2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            if (this.isSuitableForTranspose(editor2)) {
                this.performTranspose(editor2);
            } else if (this.isSuitableForRotateSelections(editor2)) {
                this.performRotateSelections(editor2);
            }
        }

        private final boolean isSuitableForTranspose(Editor editor2) {
            boolean bl;
            block3: {
                List list2 = editor2.getCaretModel().getAllCarets();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllCarets(...)");
                Iterable $this$all$iv = list2;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Caret it = (Caret)element$iv;
                        boolean bl2 = false;
                        if (!it.hasSelection()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        private final void performTranspose(Editor editor2) {
            for (Caret caret : editor2.getCaretModel().getAllCarets()) {
                int offsetBeforeCaret;
                Document document2;
                if (caret.getOffset() == 0) continue;
                int line = caret.getLogicalPosition().line;
                Intrinsics.checkNotNullExpressionValue((Object)editor2.getDocument(), (String)"getDocument(...)");
                if (caret.getOffset() < document2.getLineEndOffset(line)) {
                    offsetBeforeCaret = DocumentUtil.getPreviousCodePointOffset((Document)document2, (int)caret.getOffset());
                    int offsetAfterCaret = DocumentUtil.getNextCodePointOffset((Document)document2, (int)caret.getOffset());
                    if (offsetBeforeCaret < 0) continue;
                    CharSequence codepointBeforeCaret = document2.getCharsSequence().subSequence(offsetBeforeCaret, caret.getOffset());
                    CharSequence codepointAfterCaret = document2.getCharsSequence().subSequence(caret.getOffset(), offsetAfterCaret);
                    document2.replaceString(offsetBeforeCaret, offsetAfterCaret, (CharSequence)("" + codepointAfterCaret + codepointBeforeCaret));
                    caret.moveToOffset(offsetAfterCaret);
                    continue;
                }
                offsetBeforeCaret = DocumentUtil.getPreviousCodePointOffset((Document)document2, (int)caret.getOffset());
                int offset2BeforeCaret = DocumentUtil.getPreviousCodePointOffset((Document)document2, (int)offsetBeforeCaret);
                if (offset2BeforeCaret < 0) continue;
                CharSequence codepoint2BeforeCaret = document2.getCharsSequence().subSequence(offset2BeforeCaret, offsetBeforeCaret);
                CharSequence codepointBeforeCaret = document2.getCharsSequence().subSequence(offsetBeforeCaret, caret.getOffset());
                document2.replaceString(offset2BeforeCaret, caret.getOffset(), (CharSequence)("" + codepointBeforeCaret + codepoint2BeforeCaret));
            }
        }

        private final boolean isSuitableForRotateSelections(Editor editor2) {
            boolean bl;
            block3: {
                List list2 = editor2.getCaretModel().getAllCarets();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllCarets(...)");
                Iterable $this$all$iv = list2;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Caret it = (Caret)element$iv;
                        boolean bl2 = false;
                        if (it.hasSelection()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private final void performRotateSelections(Editor editor2) {
            boolean bl;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$sortedByDescending$iv;
            if (editor2.getCaretModel().getCaretCount() <= 1) {
                return;
            }
            boolean isBackwards = false;
            List list2 = editor2.getCaretModel().getAllCarets();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllCarets(...)");
            Iterable iterable = list2;
            boolean $i$f$sortedByDescending22 = false;
            List carets = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Caret it = (Caret)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getSelectionRange().getEndOffset());
                    it = (Caret)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getSelectionRange().getEndOffset()));
                }
            });
            Iterable $i$f$sortedByDescending22 = carets;
            TransposeHandler transposeHandler = this;
            boolean $i$f$map = false;
            void var7_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Caret caret = (Caret)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(editor2.getDocument().getText(it.getSelectionRange()));
            }
            List textToReplace = transposeHandler.rotateElements((List)destination$iv$iv, true);
            boolean bl3 = bl = carets.size() == textToReplace.size();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Iterator iterator = ((Iterable)carets).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                TextRange selection;
                int i2 = n++;
                Caret caret = (Caret)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)caret.getSelectionRange(), (String)"getSelectionRange(...)");
                String newText = (String)textToReplace.get(i2);
                editor2.getDocument().replaceString(selection.getStartOffset(), selection.getEndOffset(), (CharSequence)newText);
                caret.setSelection(selection.getStartOffset(), selection.getStartOffset() + newText.length());
                caret.moveToOffset(caret.getSelectionEnd());
            }
        }

        private final <T> List<T> rotateElements(List<? extends T> $this$rotateElements, boolean isBackwards) {
            if ($this$rotateElements.size() <= 1) {
                return CollectionsKt.toList((Iterable)$this$rotateElements);
            }
            return isBackwards ? CollectionsKt.plus((Collection)$this$rotateElements.subList(1, $this$rotateElements.size()), $this$rotateElements.get(0)) : CollectionsKt.plus((Collection)CollectionsKt.listOf($this$rotateElements.get($this$rotateElements.size() - 1)), (Iterable)$this$rotateElements.subList(0, $this$rotateElements.size() - 1));
        }
    }
}

