/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.configurationStore.SchemeExtensionProvider;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.laf.TempUIThemeLookAndFeelInfo;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfo;
import com.intellij.ide.ui.laf.UiThemeProviderListManager;
import com.intellij.ide.util.RunOnceUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.AdditionalTextAttributesEP;
import com.intellij.openapi.editor.colors.impl.AdditionalTextAttributesProvider;
import com.intellij.openapi.editor.colors.impl.BundledEditorColorScheme;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorSchemesComparator;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImplKt;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerListener;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.psi.PsiManager;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.ComponentTreeEventDispatcher;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.awt.Color;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@com.intellij.openapi.components.State(name="EditorColorsManagerImpl", storages={@Storage(value="colors.scheme.xml")}, additionalExportDirectory="colors", category=SettingsCategory.UI)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u001b\b\u0007\u0018\u0000 N2\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002:\u0003NOPB\u0011\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0011H\u0007J\b\u0010\u001f\u001a\u00020\u001bH\u0002J\b\u0010 \u001a\u00020\u001bH\u0002J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J&\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110(H\u0002J\u0010\u0010)\u001a\u00020\u001b2\b\u0010*\u001a\u0004\u0018\u00010\u0011J\b\u0010+\u001a\u00020\u0011H\u0016J\"\u0010,\u001a\u00020\u001b2\u0018\u0010-\u001a\u0014\u0012\u0004\u0012\u00020&\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0(0.H\u0002J\u0010\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u000203J\u0010\u00104\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J\u0013\u00105\u001a\b\u0012\u0004\u0012\u00020\u001106H\u0016\u00a2\u0006\u0002\u00107J\u0018\u00108\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00112\u0006\u00109\u001a\u00020\u0016J\u0012\u00108\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010:\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0011H\u0017J\b\u0010;\u001a\u00020\u001bH\u0003J\u0012\u0010<\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0011H\u0003J\b\u0010=\u001a\u00020\u0011H\u0016J\n\u0010>\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010?\u001a\u00020\u0011H\u0002J\u0012\u0010@\u001a\u0004\u0018\u00010\u00112\u0006\u0010A\u001a\u00020&H\u0016J\u0012\u0010B\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\b\u0010C\u001a\u00020\u0003H\u0016J\b\u0010D\u001a\u00020\u0016H\u0016J\u0010\u0010E\u001a\u00020\u001b2\u0006\u0010F\u001a\u00020\u0016H\u0016J\u0010\u0010G\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010H\u001a\u00020\u001bH\u0016J\u0010\u0010I\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0010\u0010J\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J\u0010\u0010M\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002R2\u0010\t\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010K\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010L\u00a8\u0006Q"}, d2={"Lcom/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl;", "Lcom/intellij/openapi/editor/colors/EditorColorsManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$State;", "schemeManagerFactory", "Lcom/intellij/openapi/options/SchemeManagerFactory;", "<init>", "(Lcom/intellij/openapi/options/SchemeManagerFactory;)V", "()V", "treeDispatcher", "Lcom/intellij/util/ComponentTreeEventDispatcher;", "Lcom/intellij/openapi/editor/colors/EditorColorsListener;", "kotlin.jvm.PlatformType", "schemeModificationCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "schemeManager", "Lcom/intellij/openapi/options/SchemeManager;", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "getSchemeManager", "()Lcom/intellij/openapi/options/SchemeManager;", "state", "themeIsCustomized", "", "isInitialConfigurationLoaded", "getSchemeModificationCounter", "", "reloadKeepingActiveScheme", "", "initEditableDefaultSchemesCopies", "removeScheme", "scheme", "initEditableBundledSchemesCopies", "resolveLinksToBundledSchemes", "resolveSchemeParent", "createEditableCopy", "initialScheme", "Lcom/intellij/openapi/editor/colors/impl/AbstractColorsScheme;", "editableCopyName", "", "to", "", "schemeChangedOrSwitched", "newScheme", "getSchemeForCurrentUITheme", "loadRemainAdditionalTextAttributes", "additionalTextAttributesProviders", "", "Lcom/intellij/openapi/editor/colors/impl/AdditionalTextAttributesProvider;", "getDefaultAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "key", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "addColorScheme", "getAllSchemes", "", "()[Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "setGlobalScheme", "processChangeSynchronously", "setCurrentSchemeOnLafChange", "dropPsiCaches", "callGlobalSchemeChange", "getGlobalScheme", "getActiveVisibleScheme", "getEditableDefaultScheme", "getScheme", "schemeName", "getEditableCopy", "getState", "isUseOnlyMonospacedFonts", "setUseOnlyMonospacedFonts", "value", "loadState", "noStateLoaded", "hideIntellijLightSchemeIfNeeded", "isDefaultScheme", "isHeadlessMode", "()Z", "notifyAboutSolarizedColorSchemeDeprecationIfSet", "Companion", "State", "EditorColorSchemeProcessor", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nEditorColorsManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorColorsManagerImpl.kt\ncom/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,899:1\n1#2:900\n37#3,2:901\n295#4,2:903\n774#4:905\n865#4:906\n866#4:910\n1869#4,2:911\n188#5,3:907\n*S KotlinDebug\n*F\n+ 1 EditorColorsManagerImpl.kt\ncom/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl\n*L\n334#1:901,2\n418#1:903,2\n522#1:905\n522#1:906\n522#1:910\n526#1:911,2\n523#1:907,3\n*E\n"})
public final class EditorColorsManagerImpl
extends EditorColorsManager
implements PersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final ComponentTreeEventDispatcher<EditorColorsListener> treeDispatcher;
    @NotNull
    private final AtomicLong schemeModificationCounter;
    @NotNull
    private final SchemeManager<EditorColorsScheme> schemeManager;
    @NotNull
    private State state;
    private boolean themeIsCustomized;
    private boolean isInitialConfigurationLoaded;
    @VisibleForTesting
    @NotNull
    private static final ExtensionPointName<AdditionalTextAttributesEP> ADDITIONAL_TEXT_ATTRIBUTES_EP_NAME = new ExtensionPointName("com.intellij.additionalTextAttributes");
    @NotNull
    private static final ExtensionPointName<AdditionalTextAttributesProvider> ADDITIONAL_TEXT_ATTRIBUTES_PROVIDERS_EP_NAME = new ExtensionPointName("com.intellij.additionalTextAttributesProvider");
    @NotNull
    public static final String COMPONENT_NAME = "EditorColorsManagerImpl";
    @NotNull
    public static final String STORAGE_NAME = "colors.scheme.xml";
    @NotNull
    public static final String FILE_SPEC = "colors";

    @NonInjectable
    public EditorColorsManagerImpl(@NotNull SchemeManagerFactory schemeManagerFactory) {
        Intrinsics.checkNotNullParameter((Object)schemeManagerFactory, (String)"schemeManagerFactory");
        this.treeDispatcher = ComponentTreeEventDispatcher.create(EditorColorsListener.class);
        this.schemeModificationCounter = new AtomicLong();
        this.state = new State();
        HashMap additionalTextAttributes = new HashMap();
        ADDITIONAL_TEXT_ATTRIBUTES_EP_NAME.forEachExtensionSafe(arg_0 -> EditorColorsManagerImpl._init_$lambda$1(arg_0 -> EditorColorsManagerImpl._init_$lambda$0(additionalTextAttributes, arg_0), arg_0));
        ADDITIONAL_TEXT_ATTRIBUTES_PROVIDERS_EP_NAME.forEachExtensionSafe(arg_0 -> EditorColorsManagerImpl._init_$lambda$3(arg_0 -> EditorColorsManagerImpl._init_$lambda$2(additionalTextAttributes, arg_0), arg_0));
        this.schemeManager = schemeManagerFactory.create(FILE_SPEC, (SchemeProcessor)new EditorColorSchemeProcessor(additionalTextAttributes), null, null, SettingsCategory.UI);
        for (DefaultColorsScheme defaultScheme : DefaultColorSchemesManager.Companion.getInstance().getAllSchemes()) {
            this.schemeManager.addScheme((Object)defaultScheme);
        }
        if (!this.isHeadlessMode()) {
            this.schemeManager.loadBundledSchemes(EditorColorsManagerImplKt.createLoadBundledSchemeRequests(additionalTextAttributes, false, (Function1<? super String, ? extends EditorColorsScheme>)((Function1)new Function1<String, EditorColorsScheme>(this.schemeManager){

                public final EditorColorsScheme invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return (EditorColorsScheme)((SchemeManager)this.receiver).findSchemeByName(p0);
                }
            })));
        }
        this.schemeManager.loadSchemes();
        this.loadRemainAdditionalTextAttributes(additionalTextAttributes);
        this.initEditableDefaultSchemesCopies();
        this.initEditableBundledSchemesCopies();
        this.resolveLinksToBundledSchemes();
    }

    @NotNull
    public final SchemeManager<EditorColorsScheme> getSchemeManager() {
        return this.schemeManager;
    }

    public EditorColorsManagerImpl() {
        this(SchemeManagerFactory.Companion.getInstance());
    }

    public long getSchemeModificationCounter() {
        return this.schemeModificationCounter.get();
    }

    public void reloadKeepingActiveScheme() {
        block1: {
            String activeScheme = this.schemeManager.getCurrentSchemeName();
            this.schemeManager.reload();
            CharSequence charSequence = activeScheme;
            if (charSequence == null || charSequence.length() == 0) break block1;
            EditorColorsScheme editorColorsScheme = this.getScheme(activeScheme);
            if (editorColorsScheme != null) {
                EditorColorsScheme it = editorColorsScheme;
                boolean bl = false;
                this.setGlobalScheme(it);
            }
        }
    }

    private final void initEditableDefaultSchemesCopies() {
        ArrayList to = new ArrayList();
        for (DefaultColorsScheme defaultScheme : DefaultColorSchemesManager.Companion.getInstance().getAllSchemes()) {
            if (!defaultScheme.hasEditableCopy()) continue;
            AbstractColorsScheme abstractColorsScheme = (AbstractColorsScheme)defaultScheme;
            String string = defaultScheme.getEditableCopyName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEditableCopyName(...)");
            this.createEditableCopy(abstractColorsScheme, string, to);
        }
        Iterator iterator = to.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            EditorColorsScheme scheme = (EditorColorsScheme)e;
            this.schemeManager.addScheme((Object)scheme);
        }
    }

    @TestOnly
    public final void removeScheme(@NotNull EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        boolean bl = ApplicationManager.getApplication().isUnitTestMode();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Test-only method";
            throw new AssertionError((Object)string);
        }
        this.schemeManager.removeScheme((Object)scheme);
    }

    private final void initEditableBundledSchemesCopies() {
        ArrayList to = new ArrayList();
        for (EditorColorsScheme scheme : CollectionsKt.toList((Iterable)this.schemeManager.getAllSchemes())) {
            if (!(scheme instanceof BundledEditorColorScheme)) continue;
            this.createEditableCopy((AbstractColorsScheme)scheme, "_@user_" + ((BundledEditorColorScheme)scheme).getName(), to);
        }
        Iterator iterator = to.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            EditorColorsScheme scheme;
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            scheme = (EditorColorsScheme)e;
            this.schemeManager.addScheme((Object)scheme);
        }
    }

    private final void resolveLinksToBundledSchemes() {
        ArrayList<EditorColorsScheme> brokenSchemesList = new ArrayList<EditorColorsScheme>();
        for (EditorColorsScheme scheme : this.schemeManager.getAllSchemes()) {
            try {
                this.resolveSchemeParent(scheme);
            }
            catch (InvalidDataException e) {
                EditorColorsManagerImplKt.access$getLOG().warn("Skipping '" + scheme.getName() + "' because its parent scheme '" + e.getMessage() + "' is missing.");
                brokenSchemesList.add(scheme);
            }
        }
        Iterator iterator = brokenSchemesList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            EditorColorsScheme brokenScheme = (EditorColorsScheme)e;
            if (brokenScheme instanceof EditorColorsSchemeImpl && !((EditorColorsSchemeImpl)brokenScheme).isReadOnly()) {
                ((EditorColorsSchemeImpl)brokenScheme).setVisible(false);
                continue;
            }
            this.schemeManager.removeScheme((Object)brokenScheme);
        }
    }

    public void resolveSchemeParent(@NotNull EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        if (scheme instanceof AbstractColorsScheme && !((AbstractColorsScheme)scheme).isReadOnly()) {
            ((AbstractColorsScheme)scheme).resolveParent(arg_0 -> EditorColorsManagerImpl.resolveSchemeParent$lambda$0((Function1)new Function1<String, EditorColorsScheme>(this.schemeManager){

                public final EditorColorsScheme invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return (EditorColorsScheme)((SchemeManager)this.receiver).findSchemeByName(p0);
                }
            }, arg_0));
        }
    }

    private final void createEditableCopy(AbstractColorsScheme initialScheme, String editableCopyName, List<EditorColorsScheme> to) {
        AbstractColorsScheme editableCopy = (AbstractColorsScheme)this.getScheme(editableCopyName);
        if (editableCopy == null) {
            Object object = initialScheme.clone();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.colors.impl.AbstractColorsScheme");
            editableCopy = (AbstractColorsScheme)object;
            editableCopy.setName(editableCopyName);
            to.add((EditorColorsScheme)editableCopy);
        } else if (initialScheme instanceof BundledEditorColorScheme) {
            editableCopy.copyMissingAttributes(initialScheme);
        }
        editableCopy.setCanBeDeleted(false);
    }

    public final void schemeChangedOrSwitched(@Nullable EditorColorsScheme newScheme) {
        this.dropPsiCaches();
        this.callGlobalSchemeChange(newScheme);
    }

    @NotNull
    public EditorColorsScheme getSchemeForCurrentUITheme() {
        String schemeId;
        EditorColorsScheme globalScheme;
        UIThemeLookAndFeelInfo lookAndFeelInfo = LafManager.getInstance().getCurrentUIThemeLookAndFeel();
        EditorColorsScheme scheme = null;
        if (lookAndFeelInfo instanceof TempUIThemeLookAndFeelInfo && Companion.isTempScheme(globalScheme = this.getGlobalScheme())) {
            return globalScheme;
        }
        if (lookAndFeelInfo != null && (schemeId = lookAndFeelInfo.getEditorSchemeId()) != null && (scheme = this.getScheme(schemeId)) == null) {
            EditorColorsManagerImplKt.access$getLOG().error("Theme " + lookAndFeelInfo.getName() + " refers to unknown color scheme " + schemeId);
        }
        if (scheme == null) {
            String string;
            if (lookAndFeelInfo != null && lookAndFeelInfo.isDark()) {
                string = "Darcula";
            } else {
                String string2 = EditorColorsManager.getDefaultSchemeName();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDefaultSchemeName(...)");
            }
            String schemeName = string;
            DefaultColorSchemesManager defaultColorSchemeManager = DefaultColorSchemesManager.Companion.getInstance();
            scheme = defaultColorSchemeManager.getScheme(schemeName);
            if (scheme == null) {
                EditorColorsManagerImplKt.access$getLOG().error("The scheme '" + schemeName + "' not found, available schemes: " + defaultColorSchemeManager.listNames());
            }
        }
        EditorColorsScheme editorColorsScheme = scheme;
        Intrinsics.checkNotNull(editorColorsScheme);
        EditorColorsScheme editorColorsScheme2 = this.getEditableCopy(editorColorsScheme);
        if (editorColorsScheme2 == null) {
            editorColorsScheme2 = scheme;
        }
        return editorColorsScheme2;
    }

    private final void loadRemainAdditionalTextAttributes(Map<String, List<AdditionalTextAttributesProvider>> additionalTextAttributesProviders) {
        for (Map.Entry<String, List<AdditionalTextAttributesProvider>> entry : additionalTextAttributesProviders.entrySet()) {
            String schemeName = entry.getKey();
            List<AdditionalTextAttributesProvider> value = entry.getValue();
            EditorColorsScheme scheme = (EditorColorsScheme)this.schemeManager.findSchemeByName(schemeName);
            if (!(scheme instanceof AbstractColorsScheme)) {
                if (this.isHeadlessMode()) continue;
                EditorColorsManagerImplKt.access$getLOG().warn("Cannot find scheme: " + schemeName + " from plugins: " + CollectionsKt.joinToString$default((Iterable)value, (CharSequence)";", null, null, (int)0, null, EditorColorsManagerImpl::loadRemainAdditionalTextAttributes$lambda$0, (int)30, null));
                continue;
            }
            EditorColorsManagerImplKt.access$loadAdditionalTextAttributesForScheme((AbstractColorsScheme)scheme, value);
        }
        additionalTextAttributesProviders.clear();
    }

    @Nullable
    public final TextAttributes getDefaultAttributes(@NotNull TextAttributesKey key) {
        String string;
        boolean dark;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        boolean bl = dark = StartupUiUtil.isUnderDarcula() && this.getScheme("Darcula") != null;
        if (dark) {
            string = "Darcula";
        } else {
            String string2 = EditorColorsScheme.getDefaultSchemeName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDefaultSchemeName(...)");
        }
        EditorColorsScheme editorColorsScheme = this.getScheme(string);
        return editorColorsScheme != null ? editorColorsScheme.getAttributes(key) : null;
    }

    public void addColorScheme(@NotNull EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        if (!this.isDefaultScheme(scheme)) {
            String string = scheme.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!(((CharSequence)string).length() == 0)) {
                this.schemeManager.addScheme((Object)scheme);
            }
        }
    }

    @NotNull
    public EditorColorsScheme[] getAllSchemes() {
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.schemeManager.getAllSchemes()), EditorColorsManagerImpl::getAllSchemes$lambda$0);
        EditorColorSchemesComparator editorColorSchemesComparator = EditorColorSchemesComparator.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)editorColorSchemesComparator, (String)"INSTANCE");
        Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)sequence, (Comparator)editorColorSchemesComparator));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new EditorColorsScheme[0]);
    }

    public final void setGlobalScheme(@Nullable EditorColorsScheme scheme, boolean processChangeSynchronously) {
        boolean notify2 = LoadingState.COMPONENTS_LOADED.isOccurred();
        EditorColorsScheme editorColorsScheme = scheme;
        if (editorColorsScheme == null) {
            editorColorsScheme = this.getEditableDefaultScheme();
        }
        this.schemeManager.setCurrent((Object)editorColorsScheme, notify2, processChangeSynchronously);
    }

    public void setGlobalScheme(@Nullable EditorColorsScheme scheme) {
        this.setGlobalScheme(scheme, false);
    }

    @RequiresEdt
    public void setCurrentSchemeOnLafChange(@NotNull EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        if (scheme == this.schemeManager.getActiveScheme()) {
            return;
        }
        this.schemeManager.setCurrent((Object)scheme, false, false);
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            return;
        }
        this.callGlobalSchemeChange(scheme);
        ApplicationManager.getApplication().invokeLater(() -> EditorColorsManagerImpl.setCurrentSchemeOnLafChange$lambda$0(this));
    }

    @RequiresEdt
    private final void dropPsiCaches() {
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        for (Project project2 : projectArray) {
            PsiManager.getInstance((Project)project2).dropPsiCaches();
        }
    }

    @RequiresEdt
    private final void callGlobalSchemeChange(EditorColorsScheme scheme) {
        Object object;
        Object $this$callGlobalSchemeChange_u24lambda_u240;
        this.schemeModificationCounter.incrementAndGet();
        EditorColorsManagerImpl editorColorsManagerImpl = this;
        try {
            $this$callGlobalSchemeChange_u24lambda_u240 = editorColorsManagerImpl;
            boolean bl = false;
            MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
            Topic topic = EditorColorsManager.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            ((EditorColorsListener)messageBus.syncPublisher(topic)).globalSchemeChange(scheme);
            $this$callGlobalSchemeChange_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$callGlobalSchemeChange_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        LoggerKt.getOrLogException((Object)$this$callGlobalSchemeChange_u24lambda_u240, (Logger)EditorColorsManagerImplKt.access$getLOG());
        editorColorsManagerImpl = this;
        try {
            EditorColorsManagerImpl $this$callGlobalSchemeChange_u24lambda_u241 = editorColorsManagerImpl;
            boolean bl = false;
            ((EditorColorsListener)$this$callGlobalSchemeChange_u24lambda_u241.treeDispatcher.getMulticaster()).globalSchemeChange(scheme);
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        LoggerKt.getOrLogException((Object)object, (Logger)EditorColorsManagerImplKt.access$getLOG());
    }

    @NotNull
    public EditorColorsScheme getGlobalScheme() {
        EditorColorsScheme editorColorsScheme = this.getActiveVisibleScheme();
        if (editorColorsScheme == null) {
            editorColorsScheme = this.getEditableDefaultScheme();
        }
        return editorColorsScheme;
    }

    @Nullable
    public EditorColorsScheme getActiveVisibleScheme() {
        EditorColorsScheme editorColorsScheme;
        block9: {
            EditorColorsScheme scheme;
            block8: {
                scheme = (EditorColorsScheme)this.schemeManager.getActiveScheme();
                if (scheme instanceof AbstractColorsScheme && !((AbstractColorsScheme)scheme).isReadOnly() && !((AbstractColorsScheme)scheme).isVisible()) {
                    EditorColorsScheme editorColorsScheme2;
                    EditorColorsScheme parentScheme = ((AbstractColorsScheme)scheme).getParentScheme();
                    if (parentScheme == null) {
                        EditorColorsManagerImplKt.access$getLOG().error("Parent scheme for '" + ((AbstractColorsScheme)scheme).getName() + "' is null!");
                        editorColorsScheme2 = null;
                    } else if (parentScheme instanceof DefaultColorsScheme) {
                        String string = ((DefaultColorsScheme)parentScheme).getEditableCopyName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEditableCopyName(...)");
                        editorColorsScheme2 = this.getScheme(string);
                    } else {
                        EditorColorsManagerImplKt.access$getLOG().error("Color scheme '" + parentScheme.getName() + "' is not a DefaultColorsScheme!");
                        editorColorsScheme2 = null;
                    }
                    return editorColorsScheme2;
                }
                editorColorsScheme = scheme;
                if (editorColorsScheme == null) break block8;
                EditorColorsScheme it = editorColorsScheme;
                boolean bl = false;
                EditorColorsScheme editorColorsScheme3 = this.getEditableCopy(it);
                editorColorsScheme = editorColorsScheme3;
                if (editorColorsScheme3 != null) break block9;
            }
            editorColorsScheme = scheme;
        }
        return editorColorsScheme;
    }

    private final EditorColorsScheme getEditableDefaultScheme() {
        DefaultColorsScheme defaultScheme = DefaultColorSchemesManager.Companion.getInstance().getFirstScheme();
        String editableCopyName = defaultScheme.getEditableCopyName();
        Intrinsics.checkNotNull((Object)editableCopyName);
        EditorColorsScheme editableCopy = this.getScheme(editableCopyName);
        if (editableCopy == null) {
            EditorColorsManagerImplKt.access$getLOG().error("An editable copy of " + defaultScheme.getName() + " has not been initialized.");
            return (EditorColorsScheme)defaultScheme;
        }
        return editableCopy;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public EditorColorsScheme getScheme(@NotNull String schemeName) {
        Object element$iv;
        Object v0;
        AbstractColorsScheme abstractColorsScheme;
        AbstractColorsScheme base;
        Intrinsics.checkNotNullParameter((Object)schemeName, (String)"schemeName");
        if (!StringsKt.endsWith$default((String)schemeName, (String)".xml", (boolean)false, (int)2, null)) return (EditorColorsScheme)this.schemeManager.findSchemeByName(schemeName);
        String path = StringsKt.removePrefix((String)StringsKt.removeSuffix((String)schemeName, (CharSequence)".xml"), (CharSequence)"/");
        Iterable $this$firstOrNull$iv = this.schemeManager.getAllSchemes();
        boolean $i$f$firstOrNull = false;
        Iterator iterator = $this$firstOrNull$iv.iterator();
        do {
            if (!iterator.hasNext()) {
                v0 = null;
                return v0;
            }
            element$iv = iterator.next();
            EditorColorsScheme it = (EditorColorsScheme)element$iv;
            boolean bl = false;
            if (it instanceof EditorColorsSchemeImpl) {
                String string = ((EditorColorsSchemeImpl)it).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (StringsKt.startsWith$default((String)string, (String)"_@user_", (boolean)false, (int)2, null)) {
                    abstractColorsScheme = ((EditorColorsSchemeImpl)it).getOriginal();
                    continue;
                }
            }
            abstractColorsScheme = null;
        } while (!((base = abstractColorsScheme) instanceof BundledEditorColorScheme && Intrinsics.areEqual((Object)StringsKt.removeSuffix((String)((BundledEditorColorScheme)base).resourcePath, (CharSequence)".xml"), (Object)path)));
        v0 = element$iv;
        return v0;
    }

    private final EditorColorsScheme getEditableCopy(EditorColorsScheme scheme) {
        EditorColorsScheme editorColorsScheme;
        String editableCopyName;
        if (Companion.isTempScheme(scheme)) {
            return scheme;
        }
        String string = scheme instanceof DefaultColorsScheme && ((DefaultColorsScheme)scheme).hasEditableCopy() ? ((DefaultColorsScheme)scheme).getEditableCopyName() : (editableCopyName = scheme instanceof BundledEditorColorScheme ? "_@user_" + ((BundledEditorColorScheme)scheme).getName() : null);
        if (editableCopyName != null && (editorColorsScheme = this.getScheme(editableCopyName)) != null) {
            EditorColorsScheme it = editorColorsScheme;
            boolean bl = false;
            return it;
        }
        return null;
    }

    @NotNull
    public State getState() {
        String currentSchemeName = this.schemeManager.getCurrentSchemeName();
        if (currentSchemeName != null && !Companion.isTempScheme((EditorColorsScheme)this.schemeManager.getActiveScheme())) {
            this.state.colorScheme = currentSchemeName;
        }
        return this.state;
    }

    public boolean isUseOnlyMonospacedFonts() {
        return this.state.USE_ONLY_MONOSPACED_FONTS;
    }

    public void setUseOnlyMonospacedFonts(boolean value) {
        this.state.USE_ONLY_MONOSPACED_FONTS = value;
    }

    /*
     * WARNING - void declaration
     */
    public void loadState(@NotNull State state2) {
        UIThemeLookAndFeelInfo laf;
        Ref.ObjectRef colorScheme;
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.hideIntellijLightSchemeIfNeeded(state2);
        this.state = state2;
        String colorSchemeName = state2.colorScheme;
        Ref.ObjectRef objectRef = colorScheme = new Ref.ObjectRef();
        String string = colorSchemeName;
        if (string != null) {
            void it;
            String string2 = string;
            Ref.ObjectRef objectRef2 = objectRef;
            boolean bl = false;
            v2 = this.getScheme((String)it);
            objectRef = objectRef2;
        } else {
            v2 = objectRef.element = null;
        }
        if (colorScheme.element == null) {
            if (colorSchemeName != null) {
                EditorColorsManagerImplKt.access$getLOG().warn(colorSchemeName + " color scheme is missing");
            }
            this.noStateLoaded();
            return;
        }
        this.themeIsCustomized = true;
        String string3 = ((EditorColorsScheme)colorScheme.element).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        String schemeName = string3;
        if (ExperimentalUI.Companion.isNewUI() && (Intrinsics.areEqual((Object)schemeName, (Object)"_@user_New Dark RC") || Intrinsics.areEqual((Object)schemeName, (Object)"New Dark RC"))) {
            RunOnceUtil.runOnceForApp((String)"force.switch.from.new.dark.editor.scheme", () -> EditorColorsManagerImpl.loadState$lambda$1(this, colorScheme));
        }
        SchemeManager.setCurrent$default(this.schemeManager, (Object)colorScheme.element, (boolean)this.isInitialConfigurationLoaded, (boolean)false, (int)4, null);
        this.isInitialConfigurationLoaded = true;
        EditorColorsScheme editorColorsScheme = (EditorColorsScheme)colorScheme.element;
        if (editorColorsScheme != null) {
            EditorColorsScheme it = editorColorsScheme;
            boolean bl = false;
            this.notifyAboutSolarizedColorSchemeDeprecationIfSet(it);
        }
        Activity activity = StartUpMeasurer.startActivity((String)"editor color scheme initialization");
        Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"startActivity(...)");
        Activity activity2 = activity;
        UIThemeLookAndFeelInfo uIThemeLookAndFeelInfo = laf = ApplicationManager.getApplication().isUnitTestMode() ? null : LafManager.getInstance().getCurrentUIThemeLookAndFeel();
        if (laf != null && !this.themeIsCustomized) {
            String string4 = laf.getEditorSchemeId();
            if (string4 != null) {
                String it = string4;
                boolean bl = false;
                EditorColorsScheme editorColorsScheme2 = this.getScheme(it);
                string4 = editorColorsScheme2;
                if (editorColorsScheme2 != null) {
                    it = string4;
                    boolean bl2 = false;
                    SchemeManager.setCurrent$default(this.schemeManager, (Object)it, (boolean)false, (boolean)false, (int)4, null);
                }
            }
        }
        activity2.end();
    }

    public void noStateLoaded() {
        String string;
        Activity activity;
        block5: {
            block4: {
                String editorSchemeId;
                UIThemeLookAndFeelInfo laf;
                this.themeIsCustomized = false;
                Activity activity2 = StartUpMeasurer.startActivity((String)"editor color scheme initialization");
                Intrinsics.checkNotNullExpressionValue((Object)activity2, (String)"startActivity(...)");
                activity = activity2;
                UIThemeLookAndFeelInfo uIThemeLookAndFeelInfo = laf = ApplicationManager.getApplication().isUnitTestMode() ? null : LafManager.getInstance().getCurrentUIThemeLookAndFeel();
                String string2 = editorSchemeId = uIThemeLookAndFeelInfo != null ? uIThemeLookAndFeelInfo.getEditorSchemeId() : null;
                if (editorSchemeId == null && laf != null && laf.isDark()) {
                    editorSchemeId = "Darcula";
                }
                if ((string = editorSchemeId) == null) break block4;
                String it = string;
                boolean bl = false;
                EditorColorsScheme editorColorsScheme = this.getScheme(it);
                string = editorColorsScheme;
                if (editorColorsScheme != null) break block5;
            }
            string = this.getEditableDefaultScheme();
        }
        String scheme = string;
        SchemeManager.setCurrent$default(this.schemeManager, (Object)scheme, (boolean)this.isInitialConfigurationLoaded, (boolean)false, (int)4, null);
        this.isInitialConfigurationLoaded = true;
        activity.end();
    }

    /*
     * WARNING - void declaration
     */
    private final void hideIntellijLightSchemeIfNeeded(State state2) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        if (!ExperimentalUI.Companion.isNewUI()) {
            return;
        }
        String themeName = "IntelliJ Light";
        EditorColorsScheme editorColorsScheme = (EditorColorsScheme)this.schemeManager.findSchemeByName(themeName);
        if (editorColorsScheme == null) {
            return;
        }
        EditorColorsScheme intellijLightScheme = editorColorsScheme;
        boolean noIntellijLightCustomThemes = false;
        noIntellijLightCustomThemes = true;
        Iterable $this$filter$iv = this.schemeManager.getAllSchemes();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block11: {
                EditorColorsScheme it = (EditorColorsScheme)element$iv$iv;
                boolean bl2 = false;
                Properties properties = it.getMetaProperties();
                Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getMetaProperties(...)");
                Map $this$any$iv = properties;
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator = $this$any$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry property = element$iv = iterator.next();
                        boolean bl3 = false;
                        if (!(Intrinsics.areEqual(property.getKey(), (Object)"originalScheme") && Intrinsics.areEqual(property.getValue(), (Object)themeName))) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean isSchemeCustomized;
            EditorColorsScheme theme = (EditorColorsScheme)element$iv;
            boolean bl = false;
            AbstractColorsScheme abstractColorsScheme = theme instanceof AbstractColorsScheme ? (AbstractColorsScheme)theme : null;
            boolean bl4 = isSchemeCustomized = !(abstractColorsScheme != null ? abstractColorsScheme.settingsEqual((Object)intellijLightScheme, null, true, false) : false);
            if (isSchemeCustomized) {
                noIntellijLightCustomThemes = false;
                continue;
            }
            if (Intrinsics.areEqual((Object)state2.colorScheme, (Object)((AbstractColorsScheme)theme).getName())) {
                state2.colorScheme = "Light";
            }
            this.schemeManager.removeScheme((Object)theme);
        }
        if (noIntellijLightCustomThemes) {
            if (Intrinsics.areEqual((Object)state2.colorScheme, (Object)themeName)) {
                state2.colorScheme = "Light";
            }
            this.schemeManager.removeScheme(themeName);
        }
    }

    public boolean isDefaultScheme(@NotNull EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        return scheme instanceof DefaultColorsScheme;
    }

    private final boolean isHeadlessMode() {
        return ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    private final void notifyAboutSolarizedColorSchemeDeprecationIfSet(EditorColorsScheme scheme) {
        Object[] objectArray = new String[]{"Solarized (dark)", "Solarized (light)", "Solarized Dark", "Solarized Light", "Solarized Dark (Darcula)"};
        Set solarizedColorSchemeNames = SetsKt.setOf((Object[])objectArray);
        String string = scheme.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name2 = StringsKt.removePrefix((String)string, (CharSequence)"_@user_");
        if (!solarizedColorSchemeNames.contains(name2)) {
            return;
        }
        if (Intrinsics.areEqual((Object)name2, (Object)"Solarized Dark") || Intrinsics.areEqual((Object)name2, (Object)"Solarized Light")) {
            PluginId[] pluginIdArray = new PluginId[]{PluginId.Companion.getId("solarized"), PluginId.Companion.getId("com.tylerthrailkill.intellij.solarized")};
            for (PluginId t : pluginIdArray) {
                if (PluginManager.getInstance().findEnabledPlugin(t) == null) continue;
                return;
            }
        }
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        Topic topic = ProjectManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new ProjectManagerListener(connection, scheme, name2){
            final /* synthetic */ MessageBusConnection $connection;
            final /* synthetic */ EditorColorsScheme $scheme;
            final /* synthetic */ String $name;
            {
                this.$connection = $connection;
                this.$scheme = $scheme;
                this.$name = $name;
            }

            public void projectOpened(Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                this.$connection.disconnect();
                ApplicationManager.getApplication().invokeLater(() -> notifyAboutSolarizedColorSchemeDeprecationIfSet.1.projectOpened$lambda$0(this.$scheme, this.$name, project2), ModalityState.nonModal());
            }

            private static final void projectOpened$lambda$0(EditorColorsScheme $scheme, String $name, Project $project) {
                PluginId pluginId = PluginId.Companion.getId("com.4lex4.intellij.solarized");
                boolean isDark = ColorUtil.isDark((Color)$scheme.getDefaultBackground());
                String neededThemeName = isDark ? "Solarized Dark" : "Solarized Light";
                UIThemeLookAndFeelInfo neededTheme = UiThemeProviderListManager.Companion.getInstance().findThemeByName(neededThemeName);
                Notification notification2 = new Notification("ColorSchemeDeprecation", IdeBundle.message((String)"notification.title.solarized.color.scheme.deprecation", (Object[])new Object[0]), NotificationType.ERROR);
                if (neededTheme != null) {
                    Object object = new Object[]{$name, neededThemeName};
                    notification2.setContent(IdeBundle.message((String)"notification.content.solarized.color.scheme.deprecation.enable", (Object[])object));
                    Object[] objectArray = new Object[]{neededThemeName};
                    object = IdeBundle.message((String)"notification.title.enable.action.solarized.color.scheme.deprecation", (Object[])objectArray);
                    v0 = notification2.addAction((AnAction)new NotificationAction(neededTheme, (String)object){
                        final /* synthetic */ UIThemeLookAndFeelInfo $neededTheme;
                        {
                            this.$neededTheme = $neededTheme;
                            super($super_call_param$1);
                        }

                        public void actionPerformed(AnActionEvent e, Notification notification2) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
                            LafManager lafManager = LafManager.getInstance();
                            lafManager.setCurrentLookAndFeel(this.$neededTheme, false);
                            lafManager.updateUI();
                            notification2.expire();
                        }
                    });
                } else {
                    Object object = new Object[]{$name, "Solarized Themes"};
                    notification2.setContent(IdeBundle.message((String)"notification.content.solarized.color.scheme.deprecation.install", (Object[])object));
                    object = IdeBundle.message((String)"notification.title.install.action.solarized.color.scheme.deprecation", (Object[])new Object[0]);
                    v0 = notification2.addAction((AnAction)new NotificationAction($project, pluginId, isDark, (String)object){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ PluginId $pluginId;
                        final /* synthetic */ boolean $isDark;
                        {
                            this.$project = $project;
                            this.$pluginId = $pluginId;
                            this.$isDark = $isDark;
                            super($super_call_param$1);
                        }

                        public void actionPerformed(AnActionEvent e, Notification notification2) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
                            MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
                            Topic topic = LafManagerListener.TOPIC;
                            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                            connection.subscribe(topic, (Object)new LafManagerListener(this.$isDark, connection){
                                private UIThemeLookAndFeelInfo matchingTheme;
                                private boolean otherWasSet;
                                final /* synthetic */ boolean $isDark;
                                final /* synthetic */ MessageBusConnection $connection;
                                {
                                    this.$isDark = $isDark;
                                    this.$connection = $connection;
                                }

                                public void lookAndFeelChanged(LafManager source) {
                                    Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                                    UIThemeLookAndFeelInfo themeInfo = source.getCurrentUIThemeLookAndFeel();
                                    if (StringsKt.contains$default((CharSequence)themeInfo.getName(), (CharSequence)"Solarized", (boolean)false, (int)2, null)) {
                                        if (this.$isDark && themeInfo.isDark() || !this.$isDark && !themeInfo.isDark()) {
                                            this.matchingTheme = themeInfo;
                                        } else {
                                            this.otherWasSet = true;
                                        }
                                    }
                                    if (this.matchingTheme != null && this.otherWasSet) {
                                        this.$connection.disconnect();
                                        if (!Intrinsics.areEqual((Object)source.getCurrentUIThemeLookAndFeel(), (Object)this.matchingTheme)) {
                                            UIThemeLookAndFeelInfo uIThemeLookAndFeelInfo = this.matchingTheme;
                                            Intrinsics.checkNotNull((Object)uIThemeLookAndFeelInfo);
                                            source.setCurrentLookAndFeel(uIThemeLookAndFeelInfo, false);
                                            source.updateUI();
                                        }
                                    }
                                }
                            });
                            PluginsAdvertiser.installAndEnable$default(this.$project, SetsKt.setOf((Object)this.$pluginId), false, false, null, () -> ((Notification)notification2).expire(), 28, null);
                        }
                    });
                }
                notification2.notify($project);
            }
        });
    }

    private static final Unit _init_$lambda$0(HashMap $additionalTextAttributes, AdditionalTextAttributesEP it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $additionalTextAttributes.computeIfAbsent(it.scheme, arg_0 -> EditorColorsManagerImpl.lambda$0$1(EditorColorsManagerImpl::lambda$0$0, arg_0)).add(it);
        return Unit.INSTANCE;
    }

    private static final List lambda$0$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List lambda$0$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final void _init_$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit _init_$lambda$2(HashMap $additionalTextAttributes, AdditionalTextAttributesProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $additionalTextAttributes.computeIfAbsent(it.getScheme(), arg_0 -> EditorColorsManagerImpl.lambda$2$1(EditorColorsManagerImpl::lambda$2$0, arg_0)).add(it);
        return Unit.INSTANCE;
    }

    private static final List lambda$2$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List lambda$2$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final void _init_$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final EditorColorsScheme resolveSchemeParent$lambda$0(Function1 $tmp0, Object p0) {
        return (EditorColorsScheme)$tmp0.invoke(p0);
    }

    private static final CharSequence loadRemainAdditionalTextAttributes$lambda$0(AdditionalTextAttributesProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPluginDescriptor().getPluginId().getIdString();
    }

    private static final boolean getAllSchemes$lambda$0(EditorColorsScheme it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AbstractColorsScheme.isVisible((EditorColorsScheme)it);
    }

    private static final void setCurrentSchemeOnLafChange$lambda$0(EditorColorsManagerImpl this$0) {
        this$0.dropPsiCaches();
    }

    private static final void loadState$lambda$1(EditorColorsManagerImpl this$0, Ref.ObjectRef $colorScheme) {
        block0: {
            EditorColorsScheme editorColorsScheme = (EditorColorsScheme)this$0.schemeManager.findSchemeByName("Dark");
            if (editorColorsScheme == null) break block0;
            EditorColorsScheme it = editorColorsScheme;
            boolean bl = false;
            $colorScheme.element = it;
        }
    }

    @JvmStatic
    public static final void fireGlobalSchemeChange(@Nullable EditorColorsScheme newScheme) {
        Companion.fireGlobalSchemeChange(newScheme);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0012H\u0007R\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$Companion;", "", "<init>", "()V", "ADDITIONAL_TEXT_ATTRIBUTES_EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/openapi/editor/colors/impl/AdditionalTextAttributesEP;", "getADDITIONAL_TEXT_ATTRIBUTES_EP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "ADDITIONAL_TEXT_ATTRIBUTES_PROVIDERS_EP_NAME", "Lcom/intellij/openapi/editor/colors/impl/AdditionalTextAttributesProvider;", "COMPONENT_NAME", "", "STORAGE_NAME", "FILE_SPEC", "isTempScheme", "", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "getTempSchemeOriginalFilePath", "Ljava/nio/file/Path;", "fireGlobalSchemeChange", "", "newScheme", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<AdditionalTextAttributesEP> getADDITIONAL_TEXT_ATTRIBUTES_EP_NAME() {
            return ADDITIONAL_TEXT_ATTRIBUTES_EP_NAME;
        }

        public final boolean isTempScheme(@Nullable EditorColorsScheme scheme) {
            Object object = scheme;
            return Boolean.parseBoolean(object != null && (object = object.getMetaProperties()) != null ? ((Properties)object).getProperty("TEMP_SCHEME_KEY") : null);
        }

        @Nullable
        public final Path getTempSchemeOriginalFilePath(@NotNull EditorColorsScheme scheme) {
            String path;
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            if (this.isTempScheme(scheme) && (path = scheme.getMetaProperties().getProperty("TEMP_SCHEME_FILE_KEY")) != null) {
                return Path.of(path, new String[0]);
            }
            return null;
        }

        @JvmStatic
        public final void fireGlobalSchemeChange(@Nullable EditorColorsScheme newScheme) {
            EditorColorsManager manager2 = EditorColorsManager.getInstance();
            if (manager2 instanceof EditorColorsManagerImpl) {
                ((EditorColorsManagerImpl)manager2).schemeChangedOrSwitched(newScheme);
            } else {
                Object object;
                Companion companion = this;
                try {
                    Companion $this$fireGlobalSchemeChange_u24lambda_u240 = companion;
                    boolean bl = false;
                    MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
                    Topic topic = EditorColorsManager.TOPIC;
                    Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                    ((EditorColorsListener)messageBus.syncPublisher(topic)).globalSchemeChange(newScheme);
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                Unit cfr_ignored_0 = (Unit)LoggerKt.getOrLogException((Object)object, (Logger)EditorColorsManagerImplKt.access$getLOG());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B!\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ<\u0010\f\u001a\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J$\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00022\b\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001b\u001a\u00020\u0013H\u0016J\u0012\u0010\u001c\u001a\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u0002J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J$\u0010!\u001a\u00020\u00182\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020%H\u0016R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006&"}, d2={"Lcom/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$EditorColorSchemeProcessor;", "Lcom/intellij/configurationStore/LazySchemeProcessor;", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "Lcom/intellij/openapi/editor/colors/impl/EditorColorsSchemeImpl;", "Lcom/intellij/configurationStore/SchemeExtensionProvider;", "additionalTextAttributes", "", "", "", "Lcom/intellij/openapi/editor/colors/impl/AdditionalTextAttributesProvider;", "<init>", "(Lcom/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl;Ljava/util/Map;)V", "createScheme", "dataHolder", "Lcom/intellij/configurationStore/SchemeDataHolder;", "name", "attributeProvider", "Lkotlin/Function1;", "isBundled", "", "getState", "Lcom/intellij/openapi/options/SchemeState;", "scheme", "onCurrentSchemeSwitched", "", "oldScheme", "newScheme", "processChangeSynchronously", "handleCurrentSchemeSwitched", "schemeExtension", "getSchemeExtension", "()Ljava/lang/String;", "isSchemeEqualToBundled", "reloaded", "schemeManager", "Lcom/intellij/openapi/options/SchemeManager;", "schemes", "", "intellij.platform.ide.impl"})
    private final class EditorColorSchemeProcessor
    extends LazySchemeProcessor<EditorColorsScheme, EditorColorsSchemeImpl>
    implements SchemeExtensionProvider {
        @NotNull
        private final Map<String, List<AdditionalTextAttributesProvider>> additionalTextAttributes;

        public EditorColorSchemeProcessor(Map<String, List<AdditionalTextAttributesProvider>> additionalTextAttributes) {
            Intrinsics.checkNotNullParameter(additionalTextAttributes, (String)"additionalTextAttributes");
            super(null, 1, null);
            this.additionalTextAttributes = additionalTextAttributes;
        }

        @NotNull
        public EditorColorsSchemeImpl createScheme(@NotNull SchemeDataHolder<? super EditorColorsSchemeImpl> dataHolder, @NotNull String name2, @NotNull Function1<? super String, String> attributeProvider, boolean isBundled) {
            Intrinsics.checkNotNullParameter(dataHolder, (String)"dataHolder");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(attributeProvider, (String)"attributeProvider");
            EditorColorsSchemeImpl scheme = isBundled ? (EditorColorsSchemeImpl)new BundledEditorColorScheme(name2) : new EditorColorsSchemeImpl(null);
            scheme.readExternal(dataHolder.read());
            if (isBundled || ApplicationManager.getApplication().isUnitTestMode() && Boolean.parseBoolean(scheme.getMetaProperties().getProperty("forceOptimize"))) {
                List<AdditionalTextAttributesProvider> attributesEPs;
                Collection collection;
                EditorColorsScheme parentScheme = scheme.getParentScheme();
                if (parentScheme instanceof AbstractColorsScheme && !((collection = (Collection)(attributesEPs = this.additionalTextAttributes.remove(((AbstractColorsScheme)parentScheme).getName()))) == null || collection.isEmpty())) {
                    EditorColorsManagerImplKt.access$loadAdditionalTextAttributesForScheme((AbstractColorsScheme)parentScheme, attributesEPs);
                }
                scheme.optimizeAttributeMap();
            }
            return scheme;
        }

        @NotNull
        public SchemeState getState(@NotNull EditorColorsScheme scheme) {
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            return scheme.isReadOnly() ? SchemeState.NON_PERSISTENT : SchemeState.POSSIBLY_CHANGED;
        }

        public void onCurrentSchemeSwitched(@Nullable EditorColorsScheme oldScheme, @Nullable EditorColorsScheme newScheme, boolean processChangeSynchronously) {
            EditorColorsScheme actualNewScheme;
            EditorColorsScheme editorColorsScheme = actualNewScheme = Intrinsics.areEqual((Object)EditorColorsManagerImpl.this.getSchemeManager().getActiveScheme(), (Object)newScheme) ? EditorColorsManagerImpl.this.getActiveVisibleScheme() : newScheme;
            if (processChangeSynchronously) {
                this.handleCurrentSchemeSwitched(actualNewScheme);
            } else {
                ApplicationManager.getApplication().invokeLater(() -> EditorColorSchemeProcessor.onCurrentSchemeSwitched$lambda$0(this, actualNewScheme));
            }
        }

        private final void handleCurrentSchemeSwitched(EditorColorsScheme newScheme) {
            LafManager.getInstance().updateUI();
            EditorColorsManagerImpl.this.schemeChangedOrSwitched(newScheme);
        }

        @NotNull
        public String getSchemeExtension() {
            String string = EditorColorsManager.getColorSchemeFileExtension();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getColorSchemeFileExtension(...)");
            return string;
        }

        public boolean isSchemeEqualToBundled(@NotNull EditorColorsSchemeImpl scheme) {
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            String string = scheme.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.startsWith$default((String)string, (String)"_@user_", (boolean)false, (int)2, null)) {
                return false;
            }
            SchemeManager<EditorColorsScheme> schemeManager = EditorColorsManagerImpl.this.getSchemeManager();
            String string2 = scheme.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String string3 = string2;
            int n = 7;
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            AbstractColorsScheme abstractColorsScheme = (AbstractColorsScheme)schemeManager.findSchemeByName(string4);
            if (abstractColorsScheme == null) {
                return false;
            }
            AbstractColorsScheme bundledScheme = abstractColorsScheme;
            return scheme.settingsEqual((Object)bundledScheme);
        }

        public void reloaded(@NotNull SchemeManager<EditorColorsScheme> schemeManager, @NotNull Collection<? extends EditorColorsScheme> schemes) {
            Intrinsics.checkNotNullParameter(schemeManager, (String)"schemeManager");
            Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
            if (!EditorColorsManagerImpl.this.isHeadlessMode()) {
                schemeManager.loadBundledSchemes(EditorColorsManagerImplKt.createLoadBundledSchemeRequests(this.additionalTextAttributes, false, (Function1<? super String, ? extends EditorColorsScheme>)((Function1)new Function1<String, EditorColorsScheme>(schemeManager){

                    public final EditorColorsScheme invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return (EditorColorsScheme)((SchemeManager)this.receiver).findSchemeByName(p0);
                    }
                })));
            }
            EditorColorsManagerImpl.this.initEditableDefaultSchemesCopies();
            EditorColorsManagerImpl.this.initEditableBundledSchemesCopies();
            EditorColorsManagerImpl.this.hideIntellijLightSchemeIfNeeded(EditorColorsManagerImpl.this.state);
            ((EditorColorsManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(EditorColorsManagerListener.TOPIC)).schemesReloaded();
        }

        private static final void onCurrentSchemeSwitched$lambda$0(EditorColorSchemeProcessor this$0, EditorColorsScheme $actualNewScheme) {
            this$0.handleCurrentSchemeSwitched($actualNewScheme);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$State;", "", "<init>", "()V", "USE_ONLY_MONOSPACED_FONTS", "", "getUSE_ONLY_MONOSPACED_FONTS$annotations", "colorScheme", "", "intellij.platform.ide.impl"})
    public static final class State {
        @JvmField
        public boolean USE_ONLY_MONOSPACED_FONTS = true;
        @OptionTag(tag="global_color_scheme", nameAttribute="", valueAttribute="name")
        @JvmField
        @Nullable
        public String colorScheme;

        public static /* synthetic */ void getUSE_ONLY_MONOSPACED_FONTS$annotations() {
        }
    }
}

