/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class EditorUIUtil {
    public static void setupAntialiasing(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int lcdContrastValue = UIUtil.getLcdContrastValue();
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, lcdContrastValue);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope((boolean)true));
        UISettings.setupFractionalMetrics((Graphics2D)g2d);
    }

    public static void hideCursorInEditor(Editor editor2) {
        if (editor2 instanceof EditorImpl) {
            ((EditorImpl)editor2).hideCursor();
        }
    }

    public static Icon scaleIcon(Icon icon2, @NotNull EditorImpl editor2) {
        float scale;
        if (editor2 == null) {
            EditorUIUtil.$$$reportNull$$$0(0);
        }
        return (scale = EditorUIUtil.getEditorScaleFactor(editor2)) == 1.0f ? icon2 : IconUtil.scale((Icon)icon2, (Component)editor2.getComponent(), (float)scale);
    }

    public static int scaleWidth(int width, EditorImpl editor2) {
        return (int)(EditorUIUtil.getEditorScaleFactor(editor2) * (float)width);
    }

    private static float getEditorScaleFactor(@NotNull EditorImpl editor2) {
        float scale;
        if (editor2 == null) {
            EditorUIUtil.$$$reportNull$$$0(1);
        }
        if (Registry.is((String)"editor.scale.gutter.icons") && Math.abs(1.0f - (scale = editor2.getScale())) > 0.1f) {
            return scale;
        }
        return 1.0f;
    }

    private EditorUIUtil() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "editor";
        objectArray2[1] = "com/intellij/openapi/editor/ex/util/EditorUIUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "scaleIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditorScaleFactor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

