/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretStateTransferableData;
import com.intellij.openapi.editor.ClipboardTextPerCaretSplitter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCopyPasteHelper;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actions.BasePasteHandler;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.CopiedFromEmptySelectionPasteMode;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorCopyPasteHelperImpl
extends EditorCopyPasteHelper {
    @ApiStatus.Internal
    public static final String COPIED_FROM_EMPTY_SELECTION_PASTE_MODE = "editor.paste.line.copied.from.empty.selection";

    @Nullable
    public Transferable getSelectionTransferable(@NotNull Editor editor2, @NotNull EditorCopyPasteHelper.CopyPasteOptions options2) {
        String s;
        if (editor2 == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(0);
        }
        if (options2 == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(1);
        }
        if (editor2.getContentComponent() instanceof JPasswordField) {
            return null;
        }
        ThreadingAssertions.assertEventDispatchThread();
        ArrayList extraData = new ArrayList();
        String string = s = editor2.getCaretModel().supportsMultipleCarets() ? EditorCopyPasteHelperImpl.getSelectedTextForClipboard(editor2, options2, extraData) : editor2.getSelectionModel().getSelectedText();
        if (StringUtil.isEmpty((String)s)) {
            return null;
        }
        s = TextBlockTransferable.convertLineSeparators(s, "\n", extraData);
        return editor2.getCaretModel().supportsMultipleCarets() ? new TextBlockTransferable(s, extraData, null) : new StringSelection(s);
    }

    public static String getSelectedTextForClipboard(@NotNull Editor editor2, @NotNull Collection<? super TextBlockTransferableData> extraDataCollector) {
        if (editor2 == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(2);
        }
        if (extraDataCollector == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(3);
        }
        return EditorCopyPasteHelperImpl.getSelectedTextForClipboard(editor2, EditorCopyPasteHelper.CopyPasteOptions.DEFAULT, extraDataCollector);
    }

    @ApiStatus.Internal
    public static String getSelectedTextForClipboard(@NotNull Editor editor2, @NotNull EditorCopyPasteHelper.CopyPasteOptions options2, @NotNull Collection<? super TextBlockTransferableData> extraDataCollector) {
        if (editor2 == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(4);
        }
        if (options2 == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(5);
        }
        if (extraDataCollector == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(6);
        }
        StringBuilder buf = new StringBuilder();
        String separator = "";
        List carets = editor2.getCaretModel().getAllCarets();
        int[] startOffsets = new int[carets.size()];
        int[] endOffsets = new int[carets.size()];
        for (int i2 = 0; i2 < carets.size(); ++i2) {
            buf.append(separator);
            String caretSelectedText = StringUtil.notNullize((String)((Caret)carets.get(i2)).getSelectedText());
            startOffsets[i2] = buf.length();
            buf.append(caretSelectedText);
            if (options2.isCopiedFromEmptySelection() && !caretSelectedText.endsWith("\n")) {
                buf.append("\n");
            }
            endOffsets[i2] = buf.length();
            separator = "\n";
        }
        extraDataCollector.add(new CaretStateTransferableData(startOffsets, endOffsets));
        if (EditorCopyPasteHelperImpl.getCopiedFromEmptySelectionPasteMode() != CopiedFromEmptySelectionPasteMode.AT_CARET) {
            extraDataCollector.add(new CopyPasteOptionsTransferableData(options2));
        }
        return buf.toString();
    }

    public TextRange @Nullable [] pasteFromClipboard(@NotNull Editor editor2) throws EditorCopyPasteHelper.TooLargeContentException {
        Transferable transferable;
        if (editor2 == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(7);
        }
        return (transferable = EditorModificationUtil.getContentsToPasteToEditor(null)) == null ? null : this.pasteTransferable(editor2, transferable);
    }

    public TextRange @Nullable [] pasteTransferable(@NotNull Editor editor2, @NotNull Transferable content2) throws EditorCopyPasteHelper.TooLargeContentException {
        String text2;
        if (editor2 == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(8);
        }
        if (content2 == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(9);
        }
        if ((text2 = EditorModificationUtil.getStringContent((Transferable)content2)) == null) {
            return null;
        }
        int textLength = text2.length();
        if (BasePasteHandler.isContentTooLarge(textLength)) {
            throw new EditorCopyPasteHelper.TooLargeContentException(textLength);
        }
        EditorCopyPasteHelper.CopyPasteOptions copyPasteOptions = CopyPasteOptionsTransferableData.valueFromTransferable(content2);
        CopiedFromEmptySelectionPasteMode pasteMode = copyPasteOptions.isCopiedFromEmptySelection() ? EditorCopyPasteHelperImpl.getCopiedFromEmptySelectionPasteMode() : CopiedFromEmptySelectionPasteMode.AT_CARET;
        CaretModel caretModel = editor2.getCaretModel();
        if (caretModel.supportsMultipleCarets()) {
            CaretStateTransferableData caretData = null;
            int caretCount = caretModel.getCaretCount();
            if (caretCount == 1 && editor2.isColumnMode()) {
                int pastedLineCount = LineTokenizer.calcLineCount((CharSequence)text2, (boolean)true);
                if (pastedLineCount <= caretModel.getMaxCaretCount()) {
                    EditorModificationUtilEx.deleteSelectedText((Editor)editor2);
                    Caret caret2 = caretModel.getPrimaryCaret();
                    for (int i2 = 0; i2 < pastedLineCount - 1 && (caret2 = caret2.clone(false)) != null; ++i2) {
                    }
                    caretCount = caretModel.getCaretCount();
                }
            } else {
                caretData = CaretStateTransferableData.getFrom(content2);
            }
            boolean isInsertingEntireLineAboveCaret = pasteMode == CopiedFromEmptySelectionPasteMode.ENTIRE_LINE_ABOVE_CARET && !editor2.getSelectionModel().hasSelection(true);
            TextRange[] ranges = new TextRange[caretCount];
            Iterator<String> segments = new ClipboardTextPerCaretSplitter().split(text2, caretData, caretCount).iterator();
            int[] index = new int[]{0};
            if (isInsertingEntireLineAboveCaret) {
                caretModel.runBatchCaretOperation(() -> {
                    List caretLineStateList = ContainerUtil.map((Collection)caretModel.getAllCarets(), CaretLineState::create);
                    List<List<CaretLineState>> caretsGroupedByLine = EditorCopyPasteHelperImpl.groupSublistRuns(caretLineStateList, CaretLineState::isOnSameLine);
                    int shift = 0;
                    for (List<CaretLineState> caretsOnSameLine : caretsGroupedByLine) {
                        int lineStartOffset = caretsOnSameLine.get((int)0).lineStartOffset + shift;
                        StringBuilder sb = new StringBuilder();
                        for (int i2 = 0; i2 < caretsOnSameLine.size(); ++i2) {
                            String normalizedText = EditorCopyPasteHelperImpl.normalizeText(editor2, (String)segments.next());
                            int n = index[0];
                            index[0] = n + 1;
                            ranges[n] = EditorCopyPasteHelperImpl.appendEntireLine(sb, normalizedText).shiftRight(lineStartOffset);
                        }
                        editor2.getDocument().insertString(lineStartOffset, (CharSequence)sb);
                        for (CaretLineState caretLineState : caretsOnSameLine) {
                            caretLineState.moveCaretAfterInsertionIfNeeded(lineStartOffset, sb.length());
                        }
                        shift += sb.length();
                    }
                });
                EditorModificationUtilEx.scrollToCaret((Editor)editor2);
            } else {
                caretModel.runForEachCaret(caret -> {
                    String normalizedText = EditorCopyPasteHelperImpl.normalizeText(editor2, (String)segments.next());
                    int n = index[0];
                    index[0] = n + 1;
                    ranges[n] = EditorCopyPasteHelperImpl.insertStringAtCaret(editor2, normalizedText, pasteMode == CopiedFromEmptySelectionPasteMode.TRIM_IF_MIDDLE_LINE);
                });
            }
            return ranges;
        }
        String normalizedText = EditorCopyPasteHelperImpl.normalizeText(editor2, text2);
        TextRange textRange = EditorCopyPasteHelperImpl.insertStringAtCaret(editor2, normalizedText, pasteMode == CopiedFromEmptySelectionPasteMode.TRIM_IF_MIDDLE_LINE);
        return new TextRange[]{textRange};
    }

    @NotNull
    private static <T> List<List<T>> groupSublistRuns(@NotNull List<T> list2, @NotNull BiPredicate<? super T, ? super T> equality) {
        if (list2 == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(10);
        }
        if (equality == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(11);
        }
        if (list2.isEmpty()) {
            List<List<T>> list3 = Collections.emptyList();
            if (list3 == null) {
                EditorCopyPasteHelperImpl.$$$reportNull$$$0(12);
            }
            return list3;
        }
        ArrayList<List<T>> result2 = new ArrayList<List<T>>();
        int lastIndex = 0;
        int size2 = list2.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            if (i2 != size2 - 1 && equality.test(list2.get(i2), list2.get(i2 + 1))) continue;
            result2.add(list2.subList(lastIndex, i2 + 1));
            lastIndex = i2 + 1;
        }
        ArrayList<List<T>> arrayList = result2;
        if (arrayList == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    private static TextRange appendEntireLine(@NotNull StringBuilder sb, @NotNull String line) {
        if (sb == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(14);
        }
        if (line == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(15);
        }
        int startOffset = sb.length();
        sb.append(line);
        if (!line.endsWith("\n")) {
            sb.append("\n");
        }
        int endOffset = sb.length();
        TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
        if (textRange == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(16);
        }
        return textRange;
    }

    @NotNull
    public static TextRange insertEntireLineAboveCaret(@NotNull Editor editor2, @NotNull String text2) {
        if (editor2 == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(17);
        }
        if (text2 == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(18);
        }
        Caret caret = editor2.getCaretModel().getCurrentCaret();
        CaretLineState caretLineState = CaretLineState.create(caret);
        int lineStartOffset = caretLineState.lineStartOffset;
        if (!((String)text2).endsWith("\n")) {
            text2 = (String)text2 + "\n";
        }
        editor2.getDocument().insertString(lineStartOffset, (CharSequence)text2);
        caretLineState.moveCaretAfterInsertionIfNeeded(lineStartOffset, ((String)text2).length());
        EditorModificationUtilEx.scrollToCaret((Editor)editor2);
        TextRange textRange = TextRange.from((int)lineStartOffset, (int)((String)text2).length());
        if (textRange == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(19);
        }
        return textRange;
    }

    @ApiStatus.Internal
    @NotNull
    public static TextRange insertStringAtCaret(@NotNull Editor editor2, @NotNull String text2) {
        if (editor2 == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(20);
        }
        if (text2 == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(21);
        }
        return EditorCopyPasteHelperImpl.insertStringAtCaret(editor2, text2, false);
    }

    @NotNull
    public static TextRange insertStringAtCaret(@NotNull Editor editor2, @NotNull String text2, boolean trimIfMiddleLine) {
        int selectionEnd;
        if (editor2 == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(22);
        }
        if (text2 == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(23);
        }
        int selectionStart = editor2.getSelectionModel().getSelectionStart();
        if (trimIfMiddleLine && !DocumentUtil.isAtLineStart((int)(selectionEnd = editor2.getSelectionModel().getSelectionEnd()), (Document)editor2.getDocument())) {
            text2 = text2.trim();
        }
        int newOffset = EditorModificationUtilEx.insertStringAtCaret((Editor)editor2, (String)text2, (boolean)false, (boolean)true);
        return new TextRange(selectionStart, newOffset);
    }

    @NotNull
    private static String normalizeText(@NotNull Editor editor2, @NotNull String text2) {
        if (editor2 == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(24);
        }
        if (text2 == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(25);
        }
        text2 = TextBlockTransferable.convertLineSeparators(editor2, text2);
        String string = text2 = EditorCopyPasteHelperImpl.trimTextIfNeeded(editor2, text2);
        if (string == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(26);
        }
        return string;
    }

    private static String trimTextIfNeeded(Editor editor2, String text2) {
        javax.swing.text.Document document2;
        JComponent contentComponent = editor2.getContentComponent();
        if (contentComponent instanceof JTextComponent && (document2 = ((JTextComponent)contentComponent).getDocument()) != null && document2.getProperty("trimTextOnPaste") == Boolean.TRUE) {
            return text2.trim();
        }
        return text2;
    }

    @NotNull
    public static CopiedFromEmptySelectionPasteMode getCopiedFromEmptySelectionPasteMode() {
        CopiedFromEmptySelectionPasteMode copiedFromEmptySelectionPasteMode = (CopiedFromEmptySelectionPasteMode)AdvancedSettings.getEnum((String)COPIED_FROM_EMPTY_SELECTION_PASTE_MODE, CopiedFromEmptySelectionPasteMode.class);
        if (copiedFromEmptySelectionPasteMode == null) {
            EditorCopyPasteHelperImpl.$$$reportNull$$$0(27);
        }
        return copiedFromEmptySelectionPasteMode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13, 16, 19, 26, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraDataCollector";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equality";
                break;
            }
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorCopyPasteHelperImpl";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 18: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorCopyPasteHelperImpl";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "groupSublistRuns";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "appendEntireLine";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "insertEntireLineAboveCaret";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeText";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopiedFromEmptySelectionPasteMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionTransferable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedTextForClipboard";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "pasteFromClipboard";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "pasteTransferable";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "groupSublistRuns";
                break;
            }
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 26: 
            case 27: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendEntireLine";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "insertEntireLineAboveCaret";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "insertStringAtCaret";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "normalizeText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13, 16, 19, 26, 27 -> new IllegalStateException(string);
        };
    }

    public static final class CopyPasteOptionsTransferableData
    implements TextBlockTransferableData,
    Serializable {
        private static final DataFlavor FLAVOR = new DataFlavor(CopyPasteOptionsTransferableData.class, "Copy/paste options");
        @NotNull
        public final EditorCopyPasteHelper.CopyPasteOptions options;

        public CopyPasteOptionsTransferableData(@NotNull EditorCopyPasteHelper.CopyPasteOptions options2) {
            if (options2 == null) {
                CopyPasteOptionsTransferableData.$$$reportNull$$$0(0);
            }
            this.options = options2;
        }

        @NotNull
        public DataFlavor getFlavor() {
            DataFlavor dataFlavor = FLAVOR;
            if (dataFlavor == null) {
                CopyPasteOptionsTransferableData.$$$reportNull$$$0(1);
            }
            return dataFlavor;
        }

        @NotNull
        public static EditorCopyPasteHelper.CopyPasteOptions valueFromTransferable(@NotNull Transferable transferable) {
            CopyPasteOptionsTransferableData transferableData;
            if (transferable == null) {
                CopyPasteOptionsTransferableData.$$$reportNull$$$0(2);
            }
            EditorCopyPasteHelper.CopyPasteOptions copyPasteOptions = (transferableData = CopyPasteOptionsTransferableData.fromTransferable(transferable)) == null ? EditorCopyPasteHelper.CopyPasteOptions.DEFAULT : transferableData.options;
            if (copyPasteOptions == null) {
                CopyPasteOptionsTransferableData.$$$reportNull$$$0(3);
            }
            return copyPasteOptions;
        }

        @Nullable
        public static CopyPasteOptionsTransferableData fromTransferable(@NotNull Transferable transferable) {
            if (transferable == null) {
                CopyPasteOptionsTransferableData.$$$reportNull$$$0(4);
            }
            try {
                return transferable.isDataFlavorSupported(FLAVOR) ? (CopyPasteOptionsTransferableData)transferable.getTransferData(FLAVOR) : null;
            }
            catch (UnsupportedFlavorException | IOException e) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/EditorCopyPasteHelperImpl$CopyPasteOptionsTransferableData";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "transferable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/EditorCopyPasteHelperImpl$CopyPasteOptionsTransferableData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFlavor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "valueFromTransferable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "valueFromTransferable";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "fromTransferable";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3 -> new IllegalStateException(string);
            };
        }
    }

    private record CaretLineState(@NotNull Caret caret, @NotNull VisualPosition position, int lineStartOffset, @NotNull VisualPosition lineStartPosition) {
        @NotNull
        private final Caret caret;
        @NotNull
        private final VisualPosition position;
        @NotNull
        private final VisualPosition lineStartPosition;

        private CaretLineState(@NotNull Caret caret, @NotNull VisualPosition position, int lineStartOffset, @NotNull VisualPosition lineStartPosition) {
            if (caret == null) {
                CaretLineState.$$$reportNull$$$0(0);
            }
            if (position == null) {
                CaretLineState.$$$reportNull$$$0(1);
            }
            if (lineStartPosition == null) {
                CaretLineState.$$$reportNull$$$0(2);
            }
        }

        @NotNull
        static CaretLineState create(@NotNull Caret caret) {
            if (caret == null) {
                CaretLineState.$$$reportNull$$$0(3);
            }
            Editor editor2 = caret.getEditor();
            int lineStartOffset = EditorUtil.getNotFoldedLineStartOffset(editor2, caret.getOffset());
            VisualPosition lineStartPosition = editor2.offsetToVisualPosition(lineStartOffset);
            return new CaretLineState(caret, caret.getVisualPosition(), lineStartOffset, lineStartPosition);
        }

        void moveCaretAfterInsertionIfNeeded(int insertionLineStartOffset, int insertionLength) {
            if (this.caret.getOffset() != insertionLineStartOffset) {
                return;
            }
            int newLineStartOffset = insertionLineStartOffset + insertionLength;
            VisualPosition newLineStartPosition = this.caret.getEditor().offsetToVisualPosition(newLineStartOffset);
            int lineShift = newLineStartPosition.line - this.lineStartPosition.line;
            VisualPosition newPosition = new VisualPosition(this.position.line + lineShift, this.position.column, this.position.leansRight);
            this.caret.moveToVisualPosition(newPosition);
            if (this.caret.getOffset() != newLineStartOffset) {
                this.caret.moveToOffset(newLineStartOffset);
            }
        }

        boolean isOnSameLine(@NotNull CaretLineState other) {
            if (other == null) {
                CaretLineState.$$$reportNull$$$0(4);
            }
            return this.lineStartOffset == other.lineStartOffset;
        }

        @NotNull
        public Caret caret() {
            Caret caret = this.caret;
            if (caret == null) {
                CaretLineState.$$$reportNull$$$0(5);
            }
            return caret;
        }

        @NotNull
        public VisualPosition position() {
            VisualPosition visualPosition = this.position;
            if (visualPosition == null) {
                CaretLineState.$$$reportNull$$$0(6);
            }
            return visualPosition;
        }

        @NotNull
        public VisualPosition lineStartPosition() {
            VisualPosition visualPosition = this.lineStartPosition;
            if (visualPosition == null) {
                CaretLineState.$$$reportNull$$$0(7);
            }
            return visualPosition;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lineStartPosition";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/EditorCopyPasteHelperImpl$CaretLineState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/EditorCopyPasteHelperImpl$CaretLineState";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "caret";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "position";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "lineStartPosition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isOnSameLine";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

