/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J&\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\"\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\rH\u0016J$\u0010\u0010\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J6\u0010\u0011\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/editor/impl/EditorToolbarButtonLook;", "Lcom/intellij/openapi/actionSystem/ex/ActionButtonLook;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "paintBorder", "", "g", "Ljava/awt/Graphics;", "component", "Ljavax/swing/JComponent;", "state", "", "color", "Ljava/awt/Color;", "paintBackground", "paintIcon", "actionButton", "Lcom/intellij/openapi/actionSystem/ActionButtonComponent;", "icon", "Ljavax/swing/Icon;", "x", "y", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class EditorToolbarButtonLook
extends ActionButtonLook {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private static final ColorKey HOVER_BACKGROUND;
    @NotNull
    private static final ColorKey PRESSED_BACKGROUND;

    public EditorToolbarButtonLook(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
    }

    @Override
    public void paintBorder(@Nullable Graphics g, @Nullable JComponent component2, int state2) {
    }

    @Override
    public void paintBorder(@Nullable Graphics g, @Nullable JComponent component2, @Nullable Color color) {
    }

    @Override
    public void paintBackground(@NotNull Graphics g, @NotNull JComponent component2, @ActionButtonComponent.ButtonState int state2) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        if (state2 == 0) {
            return;
        }
        Rectangle rect = new Rectangle(component2.getSize());
        JBInsets.removeFrom((Rectangle)rect, (Insets)component2.getInsets());
        EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        Color color2 = color = state2 == -1 ? scheme.getColor(PRESSED_BACKGROUND) : scheme.getColor(HOVER_BACKGROUND);
        if (color != null) {
            ActionButtonLook.SYSTEM_LOOK.paintLookBackground(g, rect, color);
        }
    }

    @Override
    public void paintBackground(@Nullable Graphics g, @NotNull JComponent component2, @Nullable Color color) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        ActionButtonLook.SYSTEM_LOOK.paintBackground(g, component2, color);
    }

    @Override
    public void paintIcon(@Nullable Graphics g, @Nullable ActionButtonComponent actionButton, @Nullable Icon icon2, int x, int y) {
        if (icon2 != null) {
            boolean isDark = ColorUtil.isDark((Color)this.editor.getColorsScheme().getDefaultBackground());
            super.paintIcon(g, actionButton, IconLoader.getDarkIcon((Icon)icon2, (boolean)isDark), x, y);
        }
    }

    static {
        ColorKey colorKey = ColorKey.createColorKey((String)"ActionButton.hoverBackground", (Color)JBUI.CurrentTheme.ActionButton.hoverBackground());
        Intrinsics.checkNotNullExpressionValue((Object)colorKey, (String)"createColorKey(...)");
        HOVER_BACKGROUND = colorKey;
        ColorKey colorKey2 = ColorKey.createColorKey((String)"ActionButton.pressedBackground", (Color)JBUI.CurrentTheme.ActionButton.pressedBackground());
        Intrinsics.checkNotNullExpressionValue((Object)colorKey2, (String)"createColorKey(...)");
        PRESSED_BACKGROUND = colorKey2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/editor/impl/EditorToolbarButtonLook$Companion;", "", "<init>", "()V", "HOVER_BACKGROUND", "Lcom/intellij/openapi/editor/colors/ColorKey;", "Lorg/jetbrains/annotations/NotNull;", "PRESSED_BACKGROUND", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

