/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.stickyLines.ui;

import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.util.Key;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0000\u0018\u0000 /2\u00020\u0001:\u0003-./B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u000fJ\u0006\u0010\u0016\u001a\u00020\u0013J\u0016\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0012\u0010\u001d\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u001cH\u0002J\u0014\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070 H\u0002J\b\u0010!\u001a\u00020\u000fH\u0002J(\u0010\"\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007H\u0002J0\u0010&\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007H\u0002J \u0010(\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007H\u0002J\u0010\u0010)\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010*\u001a\u00020\u0007H\u0002J\b\u0010$\u001a\u00020\u0007H\u0002J\b\u0010#\u001a\u00020\u0007H\u0002J\b\u0010+\u001a\u00020\u000fH\u0002J\b\u0010,\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\u0011R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/openapi/editor/impl/stickyLines/ui/StickyLineComponent;", "Ljavax/swing/JComponent;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "primaryVisualLine", "", "scopeVisualLine", "offsetOnClick", "debugText", "", "dumbTextImage", "Ljava/awt/image/BufferedImage;", "isHovered", "", "mouseListener", "Lcom/intellij/openapi/editor/impl/stickyLines/ui/StickyLineComponent$StickyMouseListener;", "setLine", "", "resetLine", "isEmpty", "startDumb", "repaintIfInRange", "startVisualLine", "endVisualLine", "paintComponent", "g", "Ljava/awt/Graphics;", "paintStickyLine", "graphicsOrDumb", "gutterAndTextWidth", "Lkotlin/Pair;", "setStickyLineBackgroundColor", "paintGutter", "editorY", "lineHeight", "gutterWidth", "paintText", "textWidth", "prepareDumbTextImage", "doPaintText", "lineWidth", "isLineOutOfPanel", "toString", "MyMouseEvent", "StickyMouseListener", "Companion", "intellij.platform.ide.impl"})
public final class StickyLineComponent
extends JComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorEx editor;
    private int primaryVisualLine;
    private int scopeVisualLine;
    private int offsetOnClick;
    @Nullable
    private String debugText;
    @Nullable
    private BufferedImage dumbTextImage;
    private boolean isHovered;
    @NotNull
    private final StickyMouseListener mouseListener;
    @NotNull
    private static final Key<Language> EDITOR_LANGUAGE = new Key("editor.settings.language");

    public StickyLineComponent(@NotNull EditorEx editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
        this.primaryVisualLine = -1;
        this.scopeVisualLine = -1;
        this.offsetOnClick = -1;
        this.mouseListener = new StickyMouseListener();
        this.setBorder(null);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        this.addMouseWheelListener(this.mouseListener);
    }

    public final void setLine(int primaryVisualLine, int scopeVisualLine, int offsetOnClick, @Nullable String debugText) {
        this.primaryVisualLine = primaryVisualLine;
        this.scopeVisualLine = scopeVisualLine;
        this.offsetOnClick = offsetOnClick;
        this.debugText = debugText;
        this.dumbTextImage = null;
        this.isHovered = false;
        this.mouseListener.setPopup(false);
        this.mouseListener.setGutterHovered(false);
    }

    public final void resetLine() {
        this.setLine(-1, -1, -1, null);
    }

    public final boolean isEmpty() {
        return this.primaryVisualLine == -1 || this.scopeVisualLine == -1 || this.offsetOnClick == -1;
    }

    public final void startDumb() {
        this.paintStickyLine(null);
    }

    public final void repaintIfInRange(int startVisualLine, int endVisualLine) {
        int n = this.primaryVisualLine;
        boolean bl = startVisualLine <= n ? n <= endVisualLine : false;
        if (bl) {
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.paintStickyLine(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void paintStickyLine(Graphics graphicsOrDumb) {
        if (!(!this.isEmpty())) {
            boolean $i$a$-require-StickyLineComponent$paintStickyLine$22 = false;
            String $i$a$-require-StickyLineComponent$paintStickyLine$22 = "sticky panel should mark this line as not visible";
            throw new IllegalArgumentException($i$a$-require-StickyLineComponent$paintStickyLine$22.toString());
        }
        int editorY = this.editorY();
        int lineHeight = this.lineHeight();
        Pair<Integer, Integer> pair = this.gutterAndTextWidth();
        int gutterWidth = ((Number)pair.component1()).intValue();
        int textWidth = ((Number)pair.component2()).intValue();
        Color color = this.editor.getBackgroundColor();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackgroundColor(...)");
        Color editorBackground = color;
        boolean isBackgroundChanged = false;
        Graphics graphics = null;
        EditorEx editorEx = this.editor;
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        ((EditorImpl)editorEx).setStickyLinePainting(true);
        try {
            Graphics graphics2 = graphicsOrDumb;
            graphics = graphics2 != null ? graphics2.create() : null;
            isBackgroundChanged = this.setStickyLineBackgroundColor();
            if (graphics != null) {
                int editorStartY = this.isLineOutOfPanel() ? editorY + this.getY() : editorY;
                graphics.translate(0, -editorStartY);
                this.paintGutter(graphics, editorY, lineHeight, gutterWidth);
                this.paintText(graphics, editorY, lineHeight, gutterWidth, textWidth);
            } else {
                this.dumbTextImage = this.prepareDumbTextImage(editorY, lineHeight, textWidth);
            }
        }
        finally {
            ((EditorImpl)this.editor).setStickyLinePainting(false);
            Graphics graphics3 = graphics;
            if (graphics3 != null) {
                graphics3.dispose();
            }
            if (isBackgroundChanged) {
                ((EditorImpl)this.editor).setBackgroundColor(editorBackground);
            }
        }
    }

    private final Pair<Integer, Integer> gutterAndTextWidth() {
        int lineWidth = this.lineWidth();
        int gutterWidth = this.editor.getGutterComponentEx().getWidth();
        if (gutterWidth > lineWidth) {
            return TuplesKt.to((Object)lineWidth, (Object)0);
        }
        return TuplesKt.to((Object)gutterWidth, (Object)(lineWidth - gutterWidth));
    }

    private final boolean setStickyLineBackgroundColor() {
        ColorKey backgroundColorKey = this.isHovered ? EditorColors.STICKY_LINES_HOVERED_COLOR : EditorColors.STICKY_LINES_BACKGROUND;
        Color backgroundColor = this.editor.getColorsScheme().getColor(backgroundColorKey);
        if (backgroundColor != null) {
            this.editor.setBackgroundColor(backgroundColor);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void paintGutter(Graphics g, int editorY, int lineHeight, int gutterWidth) {
        Graphics g2 = g.create();
        try {
            g2.clipRect(0, editorY, gutterWidth, lineHeight);
            this.editor.getGutterComponentEx().print(g2);
        }
        finally {
            g2.dispose();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void paintText(Graphics g, int editorY, int lineHeight, int gutterWidth, int textWidth) {
        g.translate(gutterWidth, 0);
        g.clipRect(0, editorY, textWidth, lineHeight);
        BufferedImage textImage = this.dumbTextImage;
        if (textImage != null) {
            EditorEx editorEx = this.editor;
            Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
            if (((EditorImpl)editorEx).isDumb()) {
                StartupUiUtil.drawImage((Graphics)g, (Image)textImage, (int)0, (int)editorY, null);
                return;
            }
        }
        this.doPaintText(g);
        this.dumbTextImage = null;
    }

    private final BufferedImage prepareDumbTextImage(int editorY, int lineHeight, int textWidth) {
        BufferedImage bufferedImage = UIUtil.createImage((Component)this.editor.getContentComponent(), (int)textWidth, (int)lineHeight, (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
        BufferedImage textImage = bufferedImage;
        Graphics textGraphics = textImage.getGraphics();
        EditorUIUtil.setupAntialiasing(textGraphics);
        textGraphics.translate(0, -editorY);
        textGraphics.setClip(0, editorY, textWidth, lineHeight);
        Intrinsics.checkNotNull((Object)textGraphics);
        this.doPaintText(textGraphics);
        textGraphics.dispose();
        return textImage;
    }

    private final void doPaintText(Graphics g) {
        this.editor.getContentComponent().print(g);
    }

    private final int lineWidth() {
        EditorEx editorEx = this.editor;
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        return ((EditorImpl)editorEx).getStickyLinesPanelWidth();
    }

    private final int lineHeight() {
        int height = this.editor.getLineHeight();
        return this.isLineOutOfPanel() ? height + this.getY() : height;
    }

    private final int editorY() {
        int editorY = this.editor.visualLineToY(this.primaryVisualLine);
        return this.isLineOutOfPanel() ? editorY - this.getY() : editorY;
    }

    private final boolean isLineOutOfPanel() {
        return this.getY() < 0;
    }

    @Override
    @NotNull
    public String toString() {
        String string = this.debugText;
        if (string == null) {
            string = "";
        }
        return string + "(primary=" + this.primaryVisualLine + ", scope=" + this.scopeVisualLine + ", onClick=" + this.offsetOnClick + ")";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/editor/impl/stickyLines/ui/StickyLineComponent$Companion;", "", "<init>", "()V", "EDITOR_LANGUAGE", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/lang/Language;", "getEDITOR_LANGUAGE", "()Lcom/intellij/openapi/util/Key;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Language> getEDITOR_LANGUAGE() {
            return EDITOR_LANGUAGE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/editor/impl/stickyLines/ui/StickyLineComponent$MyMouseEvent;", "Ljava/awt/event/MouseEvent;", "e", "source", "Ljava/awt/Component;", "y", "", "<init>", "(Ljava/awt/event/MouseEvent;Ljava/awt/Component;I)V", "intellij.platform.ide.impl"})
    public static final class MyMouseEvent
    extends MouseEvent {
        public MyMouseEvent(@NotNull MouseEvent e, @NotNull Component source, int y) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            super(source, e.getID(), e.getWhen(), UIUtil.getAllModifiers((InputEvent)e), e.getX(), y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0014\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0015\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0016\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0017\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0018\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0019\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u001aH\u0016J\u0012\u0010\u001b\u001a\u00020\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\tH\u0002J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\tH\u0002J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J\u0010\u0010$\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0012H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\f\u00a8\u0006'"}, d2={"Lcom/intellij/openapi/editor/impl/stickyLines/ui/StickyLineComponent$StickyMouseListener;", "Ljava/awt/event/MouseListener;", "Ljava/awt/event/MouseMotionListener;", "Ljava/awt/event/MouseWheelListener;", "<init>", "(Lcom/intellij/openapi/editor/impl/stickyLines/ui/StickyLineComponent;)V", "popMenu", "Ljavax/swing/JPopupMenu;", "isPopup", "", "()Z", "setPopup", "(Z)V", "isGutterHovered", "setGutterHovered", "mousePressed", "", "e", "Ljava/awt/event/MouseEvent;", "mouseReleased", "mouseClicked", "mouseEntered", "mouseExited", "mouseDragged", "mouseMoved", "mouseWheelMoved", "Ljava/awt/event/MouseWheelEvent;", "handleEvent", "event", "forwardToScrollPane", "onHover", "onTextHover", "hovered", "onGutterHover", "gutterClick", "popupOrNavigate", "isGutterEvent", "convert", "throwUnhandledEvent", "intellij.platform.ide.impl"})
    private final class StickyMouseListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        @NotNull
        private final JPopupMenu popMenu;
        private boolean isPopup;
        private boolean isGutterHovered;

        public StickyMouseListener() {
            ActionManager actionManager = ActionManager.getInstance();
            AnAction anAction = actionManager.getAction("EditorStickyLinesSettings");
            Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DefaultActionGroup");
            DefaultActionGroup actionGroup = (DefaultActionGroup)anAction;
            JPopupMenu jPopupMenu = actionManager.createActionPopupMenu("StickyLine", (ActionGroup)actionGroup).getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jPopupMenu, (String)"getComponent(...)");
            this.popMenu = jPopupMenu;
        }

        public final boolean isPopup() {
            return this.isPopup;
        }

        public final void setPopup(boolean bl) {
            this.isPopup = bl;
        }

        public final boolean isGutterHovered() {
            return this.isGutterHovered;
        }

        public final void setGutterHovered(boolean bl) {
            this.isGutterHovered = bl;
        }

        @Override
        public void mousePressed(@Nullable MouseEvent e) {
            this.handleEvent(e);
        }

        @Override
        public void mouseReleased(@Nullable MouseEvent e) {
            this.handleEvent(e);
        }

        @Override
        public void mouseClicked(@Nullable MouseEvent e) {
            this.handleEvent(e);
        }

        @Override
        public void mouseEntered(@Nullable MouseEvent e) {
            this.handleEvent(e);
        }

        @Override
        public void mouseExited(@Nullable MouseEvent e) {
            this.handleEvent(e);
        }

        @Override
        public void mouseDragged(@Nullable MouseEvent e) {
            this.handleEvent(e);
        }

        @Override
        public void mouseMoved(@Nullable MouseEvent e) {
            this.handleEvent(e);
        }

        @Override
        public void mouseWheelMoved(@Nullable MouseWheelEvent e) {
            this.handleEvent(e);
        }

        private final void handleEvent(MouseEvent event) {
            if (event == null || event.isConsumed() || StickyLineComponent.this.isEmpty()) {
                return;
            }
            switch (event.getID()) {
                case 503: 
                case 504: 
                case 505: {
                    this.onHover(event);
                    break;
                }
                case 500: 
                case 501: 
                case 502: {
                    if (this.isGutterEvent(event)) {
                        this.gutterClick(event);
                        break;
                    }
                    this.popupOrNavigate(event);
                    break;
                }
                case 507: {
                    this.forwardToScrollPane(event);
                }
            }
            event.consume();
        }

        private final void forwardToScrollPane(MouseEvent event) {
            MouseEvent mouseEvent = MouseEventAdapter.convert((MouseEvent)event, (Component)StickyLineComponent.this.editor.getScrollPane());
            Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"convert(...)");
            MouseEvent converted = mouseEvent;
            StickyLineComponent.this.editor.getScrollPane().dispatchEvent(converted);
        }

        private final void onHover(MouseEvent event) {
            boolean isGutterEvent = this.isGutterEvent(event);
            switch (event.getID()) {
                case 504: {
                    this.onTextHover(!this.isGutterHovered);
                    this.onGutterHover(this.isGutterHovered);
                    break;
                }
                case 505: {
                    this.onTextHover(false);
                    this.onGutterHover(false);
                    break;
                }
                case 503: {
                    if (isGutterEvent && StickyLineComponent.this.isHovered && !this.isGutterHovered) {
                        this.onTextHover(false);
                        this.onGutterHover(true);
                        break;
                    }
                    if (isGutterEvent || StickyLineComponent.this.isHovered || !this.isGutterHovered) break;
                    this.onTextHover(true);
                    this.onGutterHover(false);
                    break;
                }
                default: {
                    this.throwUnhandledEvent(event);
                }
            }
        }

        private final void onTextHover(boolean hovered) {
            if (hovered != StickyLineComponent.this.isHovered) {
                StickyLineComponent.this.isHovered = hovered;
                StickyLineComponent.this.repaint();
            }
        }

        private final void onGutterHover(boolean hovered) {
            if (hovered != this.isGutterHovered) {
                this.isGutterHovered = hovered;
                StickyLineComponent.this.repaint();
            }
        }

        private final void gutterClick(MouseEvent event) {
            if (event.getID() == 501 || event.getID() == 502 && event.isPopupTrigger()) {
                MouseEvent converted = this.convert(event);
                EditorEx editorEx = StickyLineComponent.this.editor;
                Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
                MouseListener mouseListener2 = ((EditorImpl)editorEx).getMouseListener();
                if (!event.isPopupTrigger()) {
                    event.consume();
                    return;
                }
                if (event.getID() == 501) {
                    mouseListener2.mousePressed(converted);
                } else {
                    mouseListener2.mouseReleased(converted);
                }
            }
        }

        private final void popupOrNavigate(MouseEvent event) {
            switch (event.getID()) {
                case 501: {
                    this.isPopup = event.isPopupTrigger();
                    if (!this.isPopup) break;
                    this.popMenu.show(event.getComponent(), event.getX(), event.getY());
                    break;
                }
                case 502: {
                    if (this.isPopup) break;
                    this.isPopup = event.isPopupTrigger();
                    if (!this.isPopup) break;
                    this.popMenu.show(event.getComponent(), event.getX(), event.getY());
                    break;
                }
                case 500: {
                    if (this.isPopup) break;
                    StickyLineComponent.this.requestFocusInWindow();
                    CommandProcessor.getInstance().executeCommand(StickyLineComponent.this.editor.getProject(), () -> StickyMouseListener.popupOrNavigate$lambda$0(StickyLineComponent.this), "", (Object)DocCommandGroupId.noneGroupId((Document)((Document)StickyLineComponent.this.editor.getDocument())), UndoConfirmationPolicy.DEFAULT, (Document)StickyLineComponent.this.editor.getDocument());
                    UIEventLogger.StickyLineNavigate.log(StickyLineComponent.this.editor.getProject(), StickyLineComponent.this.editor.getUserData(Companion.getEDITOR_LANGUAGE()));
                    break;
                }
                default: {
                    this.throwUnhandledEvent(event);
                }
            }
        }

        private final boolean isGutterEvent(MouseEvent event) {
            return event.getX() <= StickyLineComponent.this.editor.getGutterComponentEx().getWidth();
        }

        private final MouseEvent convert(MouseEvent event) {
            int n;
            if (event.isPopupTrigger()) {
                Point point = event.getLocationOnScreen();
                SwingUtilities.convertPointFromScreen(point, StickyLineComponent.this.editor.getGutterComponentEx());
                n = point.y;
            } else {
                n = StickyLineComponent.this.editor.visualLineToY(StickyLineComponent.this.primaryVisualLine) + event.getY();
            }
            int y = n;
            EditorGutterComponentEx editorGutterComponentEx = StickyLineComponent.this.editor.getGutterComponentEx();
            Intrinsics.checkNotNullExpressionValue((Object)editorGutterComponentEx, (String)"getGutterComponentEx(...)");
            return new MyMouseEvent(event, editorGutterComponentEx, y);
        }

        private final void throwUnhandledEvent(MouseEvent event) {
            throw new IllegalArgumentException("unhandled event " + event);
        }

        private static final void popupOrNavigate$lambda$0(StickyLineComponent this$0) {
            this$0.editor.getCaretModel().moveToOffset(this$0.offsetOnClick);
            this$0.editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            this$0.editor.getSelectionModel().removeSelection(true);
            IdeDocumentHistory.getInstance(this$0.editor.getProject()).includeCurrentCommandAsNavigation();
        }
    }
}

