/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.InlayModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingKeys;
import com.intellij.openapi.editor.impl.FoldingModelInternal;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.VisualLineFragmentsIterator;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IntPair;
import com.intellij.util.ObjectUtils;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.JScrollBar;
import org.jetbrains.annotations.NotNull;

final class EditorCoordinateMapper {
    private final EditorView myView;
    private final Document myDocument;
    private final FoldingModelInternal myFoldingModel;
    private final InlayModelEx myInlayModel;
    private final SoftWrapModelImpl mySoftWrapModel;

    EditorCoordinateMapper(EditorView view2) {
        this.myView = view2;
        this.myDocument = this.myView.getDocument();
        this.myFoldingModel = this.myView.getFoldingModel();
        this.myInlayModel = this.myView.getInlayModel();
        this.mySoftWrapModel = this.myView.getSoftWrapModel();
    }

    int[] visualLineToYRange(int line) {
        if (line < 0) {
            line = 0;
        }
        int offset = line >= this.myView.getVisibleLineCount() ? this.myDocument.getTextLength() + 1 : this.visualLineToOffset(line);
        int lineHeight = this.myView.getLineHeight();
        int idx = this.myFoldingModel.getLastCollapsedRegionBefore(offset);
        IntPair adjustment = this.myFoldingModel.getCustomRegionsYAdjustment(offset, idx);
        int startY = this.myView.getInsets().top + line * lineHeight + adjustment.first + this.myInlayModel.getHeightOfBlockElementsBeforeVisualLine(line, offset, idx);
        return new int[]{startY, startY + lineHeight + adjustment.second};
    }

    int visualLineToY(int line) {
        return this.visualLineToYRange(line)[0];
    }

    int yToVisualLine(int y) {
        int lineHeight = this.myView.getLineHeight();
        if ((y = Math.max(0, y - this.myView.getInsets().top)) < lineHeight) {
            return 0;
        }
        int lineMin = 0;
        int yMin = 0;
        int lineMax = this.myView.getVisibleLineCount() - 1;
        int yMax = this.visualLineToY(lineMax + 1);
        if (y >= yMax) {
            return lineMax + 1 + (y - yMax) / lineHeight;
        }
        while (lineMin < lineMax) {
            if (yMax - yMin == (lineMax - lineMin + 1) * lineHeight) {
                return lineMin + (y - yMin) / lineHeight;
            }
            int lineMid = (lineMin + lineMax) / 2;
            int[] yMidRange = this.visualLineToYRange(lineMid);
            if (y < yMidRange[0]) {
                int yMidMin = yMidRange[0] - this.getInlaysHeight(lineMid, true);
                if (y >= yMidMin) {
                    return lineMid;
                }
                lineMax = lineMid - 1;
                yMax = yMidMin;
                continue;
            }
            int yMidMax = yMidRange[1] + this.getInlaysHeight(lineMid, false);
            if (y < yMidMax) {
                return lineMid;
            }
            lineMin = lineMid + 1;
            yMin = yMidMax;
        }
        return lineMin;
    }

    private int getInlaysHeight(int visualLine, boolean above) {
        return EditorUtil.getInlaysHeight(this.myInlayModel, visualLine, above);
    }

    @NotNull
    LogicalPosition offsetToLogicalPosition(int offset) {
        LogicalPosition logicalPosition = this.myView.getLogicalPositionCache().offsetToLogicalPosition(offset);
        if (logicalPosition == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(0);
        }
        return logicalPosition;
    }

    int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        if (pos == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(1);
        }
        return this.myView.getLogicalPositionCache().logicalPositionToOffset(pos);
    }

    @NotNull
    VisualPosition logicalToVisualPosition(@NotNull LogicalPosition pos, boolean beforeSoftWrap) {
        if (pos == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(2);
        }
        int line = pos.line;
        int column = pos.column;
        int logicalLineCount = Math.max(1, this.myDocument.getLineCount());
        if (line >= logicalLineCount) {
            return new VisualPosition(line - logicalLineCount + this.myView.getVisibleLineCount(), column, pos.leansForward);
        }
        int offset = this.logicalPositionToOffset(pos);
        int visualLine = this.offsetToVisualLine(offset, beforeSoftWrap);
        int maxVisualColumn = 0;
        int maxLogicalColumn = 0;
        int endLogicalLine = line;
        for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, offset, beforeSoftWrap)) {
            if (!pos.leansForward && offset == fragment.getVisualLineStartOffset()) {
                return new VisualPosition(visualLine, fragment.getStartVisualColumn());
            }
            endLogicalLine = fragment.getEndLogicalLine();
            maxVisualColumn = fragment.getEndVisualColumn();
            FoldRegion foldRegion = fragment.getCurrentFoldRegion();
            if (foldRegion != null) {
                if (foldRegion instanceof CustomFoldRegion) {
                    return new VisualPosition(visualLine, 0);
                }
                int startLogicalLine = fragment.getStartLogicalLine();
                int startLogicalColumn = fragment.getStartLogicalColumn();
                int endLogicalColumn = fragment.getEndLogicalColumn();
                if ((line > startLogicalLine || line == startLogicalLine && (column > startLogicalColumn || column == startLogicalColumn && pos.leansForward)) && (line < endLogicalLine || line == endLogicalLine && column < endLogicalColumn)) {
                    return new VisualPosition(visualLine, fragment.getStartVisualColumn(), true);
                }
                if (line == endLogicalLine && column == endLogicalColumn && !pos.leansForward) {
                    return new VisualPosition(visualLine, maxVisualColumn);
                }
                maxLogicalColumn = startLogicalLine == endLogicalLine ? Math.max(maxLogicalColumn, endLogicalColumn) : endLogicalColumn;
                continue;
            }
            if (fragment.getCurrentInlay() != null) continue;
            int minColumn = fragment.getMinLogicalColumn();
            int maxColumn = fragment.getMaxLogicalColumn();
            if (line == fragment.getStartLogicalLine() && (column > minColumn && column < maxColumn || column == minColumn && pos.leansForward || column == maxColumn && !pos.leansForward)) {
                return new VisualPosition(visualLine, fragment.logicalToVisualColumn(column), fragment.isRtl() ^ pos.leansForward);
            }
            maxLogicalColumn = Math.max(maxLogicalColumn, maxColumn);
        }
        int resultColumn = maxVisualColumn + this.logToVisWithInlays(endLogicalLine, column - maxLogicalColumn, pos.leansForward);
        if (resultColumn < 0) {
            resultColumn = Integer.MAX_VALUE;
        }
        return new VisualPosition(visualLine, resultColumn, pos.leansForward);
    }

    private int logToVisWithInlays(int logLine, int remainingLogColumn, boolean leansForward) {
        if (remainingLogColumn > 1 || remainingLogColumn == 1 && leansForward) {
            remainingLogColumn += this.myInlayModel.getAfterLineEndElementsForLogicalLine(logLine).size();
        }
        return remainingLogColumn;
    }

    private int visToLogWithInlays(int logLine, int remainingVisColumns, boolean[] leansForward) {
        if (remainingVisColumns == 0) {
            return 0;
        }
        int inlayCount = this.myInlayModel.getAfterLineEndElementsForLogicalLine(logLine).size();
        if (inlayCount == 0) {
            return remainingVisColumns;
        }
        if (remainingVisColumns < inlayCount + 1) {
            leansForward[0] = false;
            return 1;
        }
        if (remainingVisColumns == inlayCount + 1) {
            leansForward[0] = true;
        }
        return remainingVisColumns - inlayCount;
    }

    @NotNull
    LogicalPosition visualToLogicalPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(3);
        }
        int line = pos.line;
        int column = pos.column;
        int visualLineCount = this.myView.getVisibleLineCount();
        if (line >= visualLineCount) {
            return new LogicalPosition(line - visualLineCount + this.myDocument.getLineCount(), column, pos.leansRight);
        }
        int offset = this.visualLineToOffset(line);
        int logicalLine = this.myDocument.getLineNumber(offset);
        int maxVisualColumn = 0;
        int maxLogicalColumn = 0;
        int maxOffset = offset;
        LogicalPosition delayedResult = null;
        boolean delayedInlay = false;
        for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, offset, false)) {
            FoldRegion foldRegion = fragment.getCurrentFoldRegion();
            if (foldRegion instanceof CustomFoldRegion) {
                return new LogicalPosition(fragment.getStartLogicalLine(), fragment.getStartLogicalColumn());
            }
            int minColumn = fragment.getStartVisualColumn();
            int maxColumn = fragment.getEndVisualColumn();
            if (delayedResult != null) {
                LogicalPosition possibleResult;
                LogicalPosition logicalPosition = delayedInlay ? delayedResult.leanForward(fragment.getCurrentInlay() == null) : (possibleResult = delayedResult);
                if (minColumn != maxColumn) {
                    LogicalPosition logicalPosition2 = possibleResult;
                    if (logicalPosition2 == null) {
                        EditorCoordinateMapper.$$$reportNull$$$0(4);
                    }
                    return logicalPosition2;
                }
                if (column == minColumn && foldRegion != null && !foldRegion.isExpanded() && foldRegion.getPlaceholderText().isEmpty() && foldRegion.getUserData(FoldingKeys.ADDITIONAL_CARET_POSITION_FOR_EMPTY_PLACEHOLDER) != null) {
                    LogicalPosition logicalPosition3 = possibleResult;
                    if (logicalPosition3 == null) {
                        EditorCoordinateMapper.$$$reportNull$$$0(5);
                    }
                    return logicalPosition3;
                }
            }
            if (column < minColumn || column == minColumn && !pos.leansRight && minColumn != maxColumn) {
                LogicalPosition logicalPosition = this.offsetToLogicalPosition(offset);
                if (logicalPosition == null) {
                    EditorCoordinateMapper.$$$reportNull$$$0(6);
                }
                return logicalPosition;
            }
            if (column > minColumn && column < maxColumn || column == minColumn || column == maxColumn && !pos.leansRight) {
                delayedInlay = fragment.getCurrentInlay() != null;
                delayedResult = new LogicalPosition(column == maxColumn ? fragment.getEndLogicalLine() : fragment.getStartLogicalLine(), fragment.visualToLogicalColumn(column), foldRegion != null ? column < maxColumn : !delayedInlay && fragment.isRtl() ^ pos.leansRight);
                if (column != maxColumn) {
                    LogicalPosition logicalPosition = delayedResult;
                    if (logicalPosition == null) {
                        EditorCoordinateMapper.$$$reportNull$$$0(7);
                    }
                    return logicalPosition;
                }
            }
            maxLogicalColumn = logicalLine == fragment.getEndLogicalLine() ? Math.max(maxLogicalColumn, fragment.getMaxLogicalColumn()) : fragment.getMaxLogicalColumn();
            maxVisualColumn = maxColumn;
            logicalLine = fragment.getEndLogicalLine();
            maxOffset = Math.max(maxOffset, fragment.getMaxOffset());
        }
        if (delayedResult != null && !delayedInlay) {
            LogicalPosition logicalPosition = delayedResult;
            if (logicalPosition == null) {
                EditorCoordinateMapper.$$$reportNull$$$0(8);
            }
            return logicalPosition;
        }
        if (this.mySoftWrapModel.getSoftWrap(maxOffset) == null) {
            boolean[] leansForward = new boolean[]{pos.leansRight};
            int resultColumn = maxLogicalColumn + this.visToLogWithInlays(logicalLine, column - maxVisualColumn, leansForward);
            if (resultColumn < 0) {
                resultColumn = Integer.MAX_VALUE;
            }
            return new LogicalPosition(logicalLine, resultColumn, leansForward[0]);
        }
        LogicalPosition logicalPosition = this.offsetToLogicalPosition(maxOffset).leanForward(true);
        if (logicalPosition == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(9);
        }
        return logicalPosition;
    }

    @NotNull
    VisualPosition offsetToVisualPosition(int offset, boolean leanTowardsLargerOffsets, boolean beforeSoftWrap) {
        VisualPosition visualPosition = this.logicalToVisualPosition(this.offsetToLogicalPosition(offset).leanForward(leanTowardsLargerOffsets), beforeSoftWrap);
        if (visualPosition == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(10);
        }
        return visualPosition;
    }

    int visualPositionToOffset(VisualPosition visualPosition) {
        return this.logicalPositionToOffset(this.visualToLogicalPosition(visualPosition));
    }

    int offsetToVisualLine(int offset, boolean beforeSoftWrap) {
        int wrapIndex;
        int textLength = this.myDocument.getTextLength();
        if (offset < 0 || textLength == 0) {
            return 0;
        }
        offset = Math.min(offset, textLength);
        FoldRegion outermostCollapsed = this.myFoldingModel.getCollapsedRegionAtOffset(offset = DocumentUtil.alignToCodePointBoundary((Document)this.myDocument, (int)offset));
        if (outermostCollapsed != null && offset > outermostCollapsed.getStartOffset()) {
            assert (outermostCollapsed.isValid());
            offset = outermostCollapsed.getStartOffset();
            beforeSoftWrap = false;
        }
        int softWrapsBeforeOrAtOffset = (wrapIndex = this.mySoftWrapModel.getSoftWrapIndex(offset)) < 0 ? -wrapIndex - 1 : wrapIndex + (beforeSoftWrap ? 0 : 1);
        return this.myDocument.getLineNumber(offset) - this.myFoldingModel.getFoldedLinesCountBefore(offset) + softWrapsBeforeOrAtOffset;
    }

    int visualLineToOffset(int visualLine) {
        int start2 = 0;
        int end = this.myDocument.getTextLength();
        if (visualLine <= 0) {
            return start2;
        }
        if (visualLine >= this.myView.getVisibleLineCount()) {
            return end;
        }
        int current = ObjectUtils.binarySearch((int)0, (int)this.myDocument.getTextLength(), mid -> Integer.compare(this.offsetToVisualLine(mid, false), visualLine));
        if (current < 0) {
            current = -current - 1;
        }
        return this.visualLineStartOffset(current, true);
    }

    private int visualLineStartOffset(int offset, boolean leanForward) {
        SoftWrap currentOrPrevWrap;
        offset = DocumentUtil.alignToCodePointBoundary((Document)this.myDocument, (int)offset);
        int result2 = EditorUtil.getNotFoldedLineStartOffset(this.myDocument, this.myFoldingModel, offset, false);
        List<? extends SoftWrap> softWraps = this.mySoftWrapModel.getRegisteredSoftWraps();
        int currentOrPrevWrapIndex = this.mySoftWrapModel.getSoftWrapIndex(offset);
        if (currentOrPrevWrapIndex < 0) {
            currentOrPrevWrap = (currentOrPrevWrapIndex = -currentOrPrevWrapIndex - 2) < 0 || currentOrPrevWrapIndex >= softWraps.size() ? null : softWraps.get(currentOrPrevWrapIndex);
        } else {
            SoftWrap softWrap = currentOrPrevWrap = leanForward ? softWraps.get(currentOrPrevWrapIndex) : null;
        }
        if (currentOrPrevWrap != null && currentOrPrevWrap.getStart() > result2) {
            result2 = currentOrPrevWrap.getStart();
        }
        return result2;
    }

    private float getStartX(int line) {
        return this.isRightAligned() ? this.getRightAlignmentLineStartX(line) : (float)this.myView.getInsets().left + (line == 0 ? this.myView.getPrefixTextWidthInPixels() : 0.0f);
    }

    private boolean isRightAligned() {
        return this.myView.getEditor().isRightAligned();
    }

    float getRightAlignmentLineStartX(int visualLine) {
        float shift;
        this.checkRightAlignment();
        int max = this.getRightAlignmentMarginX();
        float f = shift = visualLine == 0 ? this.myView.getPrefixTextWidthInPixels() : 0.0f;
        if (visualLine >= this.myView.getVisibleLineCount()) {
            return (float)max - shift;
        }
        int lineWidth = this.myView.getSizeManager().getVisualLineWidth(new VisualLinesIterator(this.myView, visualLine), false);
        return Math.max(max - lineWidth, 0);
    }

    int getRightAlignmentMarginX() {
        this.checkRightAlignment();
        EditorImpl editor2 = this.myView.getEditor();
        JScrollBar vsb = editor2.getScrollPane().getVerticalScrollBar();
        int vsbWidth = vsb != null && editor2.getVerticalScrollbarOrientation() == 1 ? vsb.getWidth() : 0;
        return editor2.getContentComponent().getWidth() - this.myView.getInsets().right - editor2.getSettings().getLineCursorWidth() - vsbWidth;
    }

    private void checkRightAlignment() {
        if (!this.isRightAligned()) {
            throw new IllegalStateException("Editor is not right-aligned");
        }
    }

    @NotNull
    VisualPosition xyToVisualPosition(@NotNull Point2D p) {
        float plainSpaceWidth;
        float remainingShift;
        if (p == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(11);
        }
        int visualLine = this.yToVisualLine((int)p.getY());
        int lastColumn = 0;
        float x = this.getStartX(visualLine);
        float px = (float)p.getX();
        int logicalLine = -1;
        if (visualLine < this.myView.getVisibleLineCount()) {
            int visualLineStartOffset = this.visualLineToOffset(visualLine);
            int maxOffset = 0;
            for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, visualLineStartOffset, false, true)) {
                if (fragment.getCurrentFoldRegion() instanceof CustomFoldRegion) {
                    return new VisualPosition(visualLine, 0);
                }
                if (px <= fragment.getStartX()) {
                    if (fragment.getStartVisualColumn() == 0) {
                        return new VisualPosition(visualLine, 0);
                    }
                    int markerWidth = this.mySoftWrapModel.getMinDrawingWidthInPixels(SoftWrapDrawingType.AFTER_SOFT_WRAP);
                    float indent = fragment.getStartX() - (float)markerWidth;
                    if (px <= indent) break;
                    boolean after = px >= indent + (float)(markerWidth / 2);
                    return new VisualPosition(visualLine, fragment.getStartVisualColumn() - (after ? 0 : 1), !after);
                }
                float nextX = fragment.getEndX();
                if (px <= nextX) {
                    int[] column = fragment.xToVisualColumn(px);
                    return new VisualPosition(visualLine, column[0], column[1] > 0);
                }
                x = nextX;
                lastColumn = fragment.getEndVisualColumn();
                maxOffset = Math.max(maxOffset, fragment.getMaxOffset());
                logicalLine = fragment.getEndLogicalLine();
            }
            if (this.mySoftWrapModel.getSoftWrap(maxOffset) != null) {
                int markerWidth = this.mySoftWrapModel.getMinDrawingWidthInPixels(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED);
                if (px <= x + (float)markerWidth) {
                    boolean after = px >= x + (float)(markerWidth / 2);
                    return new VisualPosition(visualLine, lastColumn + (after ? 1 : 0), !after);
                }
                px -= (float)markerWidth;
                ++lastColumn;
                logicalLine = -1;
            } else if (logicalLine == -1) {
                logicalLine = this.myDocument.getLineNumber(visualLineStartOffset);
            }
        }
        if ((remainingShift = px - x) > (plainSpaceWidth = this.myView.getPlainSpaceWidth()) && logicalLine >= 0) {
            List inlays = this.myInlayModel.getAfterLineEndElementsForLogicalLine(logicalLine);
            int inlaysWidth = 0;
            int inlayCount = 0;
            for (Inlay inlay : inlays) {
                int width = inlay.getWidthInPixels();
                int newWidth = inlaysWidth + width;
                if (remainingShift <= plainSpaceWidth + (float)newWidth) {
                    boolean leftPart = remainingShift <= plainSpaceWidth + (float)((inlaysWidth + newWidth) / 2);
                    return new VisualPosition(visualLine, lastColumn + 1 + inlayCount + (leftPart ? 0 : 1), leftPart);
                }
                inlaysWidth = newWidth;
                ++inlayCount;
            }
            remainingShift -= (float)inlaysWidth;
            lastColumn += inlayCount;
        }
        int additionalColumns = remainingShift <= 0.0f ? 0 : Math.round(remainingShift / plainSpaceWidth);
        return new VisualPosition(visualLine, lastColumn + additionalColumns, remainingShift > (float)additionalColumns * plainSpaceWidth);
    }

    @NotNull
    Point2D visualPositionToXY(@NotNull VisualPosition pos) {
        if (pos == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(12);
        }
        int visualLine = pos.line;
        int column = pos.column;
        int y = this.visualLineToY(visualLine);
        float x = this.getStartX(visualLine);
        int lastColumn = 0;
        int logicalLine = -1;
        if (visualLine < this.myView.getVisibleLineCount()) {
            int visualLineStartOffset = this.visualLineToOffset(visualLine);
            int maxOffset = 0;
            for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, visualLineStartOffset, false, true)) {
                if (fragment.getCurrentFoldRegion() instanceof CustomFoldRegion) {
                    return new Point2D.Double(fragment.getStartX(), y);
                }
                int startVisualColumn = fragment.getStartVisualColumn();
                if (column < startVisualColumn || column == startVisualColumn && !pos.leansRight) break;
                int endColumn = fragment.getEndVisualColumn();
                if (column < endColumn || column == endColumn && !pos.leansRight) {
                    return new Point2D.Double(fragment.visualColumnToX(column), y);
                }
                x = fragment.getEndX();
                lastColumn = endColumn;
                maxOffset = Math.max(maxOffset, fragment.getMaxOffset());
                logicalLine = fragment.getEndLogicalLine();
            }
            if (column > lastColumn && this.mySoftWrapModel.getSoftWrap(maxOffset) != null) {
                --column;
                x += (float)this.mySoftWrapModel.getMinDrawingWidthInPixels(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED);
            } else if (logicalLine == -1) {
                logicalLine = this.myDocument.getLineNumber(visualLineStartOffset);
            }
        }
        if (column > lastColumn + 1 && logicalLine >= 0) {
            List inlays = this.myInlayModel.getAfterLineEndElementsForLogicalLine(logicalLine);
            int inlaysWidth = 0;
            int inlayCount = 0;
            for (Inlay inlay : inlays) {
                inlaysWidth += inlay.getWidthInPixels();
                if (column != lastColumn + 1 + ++inlayCount) continue;
                break;
            }
            x += (float)inlaysWidth;
            column -= inlayCount;
        }
        float additionalShift = column <= lastColumn ? 0.0f : (float)(column - lastColumn) * this.myView.getPlainSpaceWidth();
        return new Point2D.Double(x + additionalShift, y);
    }

    @NotNull
    Point2D offsetToXY(int offset, boolean leanTowardsLargerOffsets, boolean beforeSoftWrap) {
        offset = Math.max(0, Math.min(this.myDocument.getTextLength(), offset));
        offset = DocumentUtil.alignToCodePointBoundary((Document)this.myDocument, (int)offset);
        int logicalLine = this.myDocument.getLineNumber(offset);
        int visualLine = this.offsetToVisualLine(offset, beforeSoftWrap);
        int visualLineStartOffset = this.visualLineToOffset(visualLine);
        int y = this.visualLineToY(visualLine);
        float x = this.getStartX(logicalLine);
        boolean firstFragment = true;
        for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, offset, beforeSoftWrap, true)) {
            if (firstFragment && offset == visualLineStartOffset && !leanTowardsLargerOffsets || fragment.getCurrentFoldRegion() instanceof CustomFoldRegion) {
                x = fragment.getStartX();
                break;
            }
            firstFragment = false;
            int minOffset = fragment.getMinOffset();
            int maxOffset = fragment.getMaxOffset();
            if (fragment.getCurrentInlay() == null && (offset > minOffset && offset < maxOffset || offset == minOffset && leanTowardsLargerOffsets || offset == maxOffset && !leanTowardsLargerOffsets)) {
                x = fragment.offsetToX(offset);
                break;
            }
            x = fragment.getEndX();
        }
        return new Point2D.Double(x, y);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToLogicalPosition";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "visualToLogicalPosition";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToVisualPosition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "logicalPositionToOffset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "logicalToVisualPosition";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visualToLogicalPosition";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "xyToVisualPosition";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visualPositionToXY";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 11, 12 -> new IllegalArgumentException(string);
        };
    }
}

