/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.bidi.BidiRegionsSeparator;
import com.intellij.openapi.editor.bidi.LanguageBidiRegionsSeparator;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontFallbackIterator;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.view.ApproximationFragment;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.IterationState;
import com.intellij.openapi.editor.impl.view.LineFragment;
import com.intellij.openapi.editor.impl.view.LogicalPositionCache;
import com.intellij.openapi.editor.impl.view.SpecialCharacterFragment;
import com.intellij.openapi.editor.impl.view.TabFragment;
import com.intellij.openapi.editor.impl.view.TextFragmentFactory;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.BitUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.SmartList;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class LineLayout {
    private static final Logger LOG = Logger.getInstance(LineLayout.class);
    private static final String WHITESPACE_CHARS = " \t";

    private LineLayout() {
    }

    @NotNull
    static LineLayout create(@NotNull EditorView view2, int line, boolean skipBidiLayout) {
        if (view2 == null) {
            LineLayout.$$$reportNull$$$0(0);
        }
        List<BidiRun> runs = LineLayout.createFragments(view2, line, skipBidiLayout);
        LineLayout lineLayout = LineLayout.createLayout(view2, runs, null, line);
        if (lineLayout == null) {
            LineLayout.$$$reportNull$$$0(1);
        }
        return lineLayout;
    }

    @NotNull
    static LineLayout create(@NotNull EditorView view2, @NotNull CharSequence text2, @JdkConstants.FontStyle int fontStyle) {
        if (view2 == null) {
            LineLayout.$$$reportNull$$$0(2);
        }
        if (text2 == null) {
            LineLayout.$$$reportNull$$$0(3);
        }
        List<BidiRun> runs = LineLayout.createFragments(view2, text2, fontStyle);
        LineLayout delegate = LineLayout.createLayout(view2, runs, text2, 0);
        return new WithSize(delegate);
    }

    private static LineLayout createLayout(@NotNull EditorView view2, @NotNull List<BidiRun> runs, @Nullable CharSequence text2, int line) {
        if (view2 == null) {
            LineLayout.$$$reportNull$$$0(4);
        }
        if (runs == null) {
            LineLayout.$$$reportNull$$$0(5);
        }
        if (runs.isEmpty()) {
            return new SingleChunk(null);
        }
        if (runs.size() == 1) {
            BidiRun run2 = runs.get(0);
            if (run2.level == 0 && run2.getChunkCount() == 1) {
                Chunk chunk = run2.chunks == null ? new Chunk(0, run2.endOffset) : run2.chunks.get(0);
                return new SingleChunk(chunk);
            }
        }
        BidiRun[] runArray = new BidiRun[runs.size()];
        int prevColumn = 0;
        for (int i2 = 0; i2 < runs.size(); ++i2) {
            BidiRun run3 = runs.get(i2);
            assert (i2 == 0 || run3.startOffset == runs.get((int)(i2 - 1)).endOffset);
            int startColumn = prevColumn;
            int endColumn = text2 == null ? view2.getLogicalPositionCache().offsetToLogicalColumn(line, run3.endOffset) : LogicalPositionCache.calcColumn(text2, run3.startOffset, prevColumn, run3.endOffset, view2.getTabSize());
            run3.visualStartLogicalColumn = run3.isRtl() ? endColumn : startColumn;
            prevColumn = endColumn;
            runArray[i2] = run3;
        }
        return new MultiChunk(runArray);
    }

    private static void reorderRunsVisually(BidiRun[] bidiRuns) {
        byte[] levels = new byte[bidiRuns.length];
        for (int i2 = 0; i2 < bidiRuns.length; ++i2) {
            levels[i2] = bidiRuns[i2].level;
        }
        Bidi.reorderVisually(levels, 0, bidiRuns, 0, levels.length);
    }

    static boolean isBidiLayoutRequired(@NotNull CharSequence text2) {
        if (text2 == null) {
            LineLayout.$$$reportNull$$$0(6);
        }
        char[] chars = CharArrayUtil.fromSequence((CharSequence)text2);
        return Bidi.requiresBidi(chars, 0, chars.length);
    }

    private static List<BidiRun> createFragments(@NotNull EditorView view2, int line, boolean skipBidiLayout) {
        if (view2 == null) {
            LineLayout.$$$reportNull$$$0(7);
        }
        DocumentEx document2 = view2.getDocument();
        int lineStartOffset = document2.getLineStartOffset(line);
        int lineEndOffset = document2.getLineEndOffset(line);
        if (lineEndOffset <= lineStartOffset) {
            return Collections.emptyList();
        }
        if (skipBidiLayout) {
            return Collections.singletonList(new BidiRun(lineEndOffset - lineStartOffset));
        }
        CharSequence text2 = document2.getImmutableCharSequence().subSequence(lineStartOffset, lineEndOffset);
        char[] chars = CharArrayUtil.fromSequence((CharSequence)text2);
        return LineLayout.createRuns(view2, chars, lineStartOffset);
    }

    private static List<BidiRun> createFragments(@NotNull EditorView view2, @NotNull CharSequence text2, @JdkConstants.FontStyle int fontStyle) {
        if (view2 == null) {
            LineLayout.$$$reportNull$$$0(8);
        }
        if (text2 == null) {
            LineLayout.$$$reportNull$$$0(9);
        }
        if (text2.isEmpty()) {
            return Collections.emptyList();
        }
        FontFallbackIterator ffi = new FontFallbackIterator().setPreferredFonts(view2.getEditor().getColorsScheme().getFontPreferences()).setFontStyle(fontStyle).setFontRenderContext(view2.getFontRenderContext());
        char[] chars = CharArrayUtil.fromSequence((CharSequence)text2);
        List<BidiRun> runs = LineLayout.createRuns(view2, chars, -1);
        for (BidiRun run2 : runs) {
            for (Chunk chunk : run2.getChunks(text2, 0)) {
                chunk.fragments = new ArrayList<LineFragment>();
                LineLayout.addFragments(view2, run2, chunk, chars, chunk.startOffset, chunk.endOffset, null, false, ffi);
            }
        }
        return runs;
    }

    private static List<BidiRun> createRuns(EditorView view2, char[] text2, int startOffsetInEditor) {
        int textLength = text2.length;
        if (view2.getEditor().myDisableRtl || !Bidi.requiresBidi(text2, 0, textLength)) {
            return Collections.singletonList(new BidiRun(textLength));
        }
        view2.getEditor().bidiTextFound();
        ArrayList<BidiRun> runs = new ArrayList<BidiRun>();
        int flags = view2.getBidiFlags();
        if (startOffsetInEditor >= 0) {
            int relLastOffset;
            for (relLastOffset = 0; relLastOffset < text2.length && WHITESPACE_CHARS.indexOf(text2[relLastOffset]) >= 0; ++relLastOffset) {
            }
            LineLayout.addRuns(runs, text2, 0, relLastOffset, flags);
            IElementType lastToken = null;
            HighlighterIterator iterator = view2.getHighlighter().createIterator(startOffsetInEditor + relLastOffset);
            while (!iterator.atEnd() && iterator.getStart() - startOffsetInEditor < textLength) {
                IElementType currentToken;
                int relEndOffset;
                int iteratorRelStart = LineLayout.alignToCodePointBoundary(text2, iterator.getStart() - startOffsetInEditor);
                int iteratorRelEnd = LineLayout.alignToCodePointBoundary(text2, iterator.getEnd() - startOffsetInEditor);
                int relStartOffset = Math.max(relLastOffset, iteratorRelStart);
                int[] boundaries = LineLayout.getCommentPrefixAndOrSuffixBoundaries(text2, relStartOffset, relEndOffset = Math.min(textLength, Math.max(relStartOffset, iteratorRelEnd)), currentToken = iterator.getTokenType());
                if (boundaries != null) {
                    LineLayout.addRuns(runs, text2, relLastOffset, relStartOffset, flags);
                    LineLayout.addRuns(runs, text2, relStartOffset, boundaries[0], flags);
                    LineLayout.addRuns(runs, text2, boundaries[0], boundaries[1], flags);
                    lastToken = null;
                    relLastOffset = boundaries[1];
                } else if (LineLayout.distinctTokens(lastToken, currentToken)) {
                    LineLayout.addRuns(runs, text2, relLastOffset, relStartOffset, flags);
                    lastToken = currentToken;
                    relLastOffset = relStartOffset;
                }
                iterator.advance();
            }
            LineLayout.addRuns(runs, text2, relLastOffset, textLength, flags);
        } else {
            LineLayout.addRuns(runs, text2, 0, textLength, flags);
        }
        for (BidiRun run2 : runs) {
            assert (!LineLayout.isInsideSurrogatePair(text2, run2.startOffset));
            assert (!LineLayout.isInsideSurrogatePair(text2, run2.endOffset));
        }
        return runs;
    }

    private static boolean isInsideSurrogatePair(char[] text2, int offset) {
        return offset > 0 && offset < text2.length && Character.isHighSurrogate(text2[offset - 1]) && Character.isLowSurrogate(text2[offset]);
    }

    private static int alignToCodePointBoundary(char[] text2, int offset) {
        return LineLayout.isInsideSurrogatePair(text2, offset) ? offset - 1 : offset;
    }

    private static int alignToCodePointBoundary(CharSequence text2, int offset) {
        return offset > 0 && offset < text2.length() && Character.isHighSurrogate(text2.charAt(offset - 1)) && Character.isLowSurrogate(text2.charAt(offset)) ? offset - 1 : offset;
    }

    private static int[] getCommentPrefixAndOrSuffixBoundaries(char[] text2, int start2, int end, IElementType token) {
        if (token == null) {
            return null;
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(token.getLanguage());
        if (!(commenter instanceof CodeDocumentationAwareCommenter)) {
            return null;
        }
        CodeDocumentationAwareCommenter cdaCommenter = (CodeDocumentationAwareCommenter)commenter;
        if (token.equals(cdaCommenter.getLineCommentTokenType())) {
            String prefix = cdaCommenter.getLineCommentPrefix();
            if (prefix != null) {
                prefix = prefix.stripTrailing();
            }
            if (LineLayout.isValidSuffixOrPrefix(prefix) && CharArrayUtil.regionMatches((char[])text2, (int)start2, (int)end, (CharSequence)prefix)) {
                return new int[]{Math.min(end, CharArrayUtil.shiftForward((char[])text2, (int)(start2 + prefix.length()), (String)WHITESPACE_CHARS)), end};
            }
        } else if (token.equals(cdaCommenter.getBlockCommentTokenType())) {
            String prefix = cdaCommenter.getBlockCommentPrefix();
            String suffix = cdaCommenter.getBlockCommentSuffix();
            if (!LineLayout.isValidSuffixOrPrefix(prefix) || !LineLayout.isValidSuffixOrPrefix(suffix)) {
                return null;
            }
            int[] result2 = new int[]{start2, end};
            boolean hasPrefixOrSuffix = false;
            if (CharArrayUtil.regionMatches((char[])text2, (int)start2, (int)end, (CharSequence)prefix)) {
                result2[0] = start2 + prefix.length();
                hasPrefixOrSuffix = true;
            }
            if (CharArrayUtil.regionMatches((char[])text2, (int)(end - suffix.length()), (int)end, (CharSequence)suffix)) {
                result2[1] = end - suffix.length();
                hasPrefixOrSuffix = true;
            }
            if (hasPrefixOrSuffix && result2[0] < result2[1]) {
                result2[0] = Math.min(result2[1], CharArrayUtil.shiftForward((char[])text2, (int)result2[0], (String)WHITESPACE_CHARS));
                result2[1] = Math.max(result2[0], CharArrayUtil.shiftBackward((char[])text2, (int)(result2[1] - 1), (String)WHITESPACE_CHARS) + 1);
                return result2;
            }
        }
        return null;
    }

    private static boolean isValidSuffixOrPrefix(String value) {
        return value != null && !value.isEmpty() && !Character.isLowSurrogate(value.charAt(0)) && !Character.isHighSurrogate(value.charAt(value.length() - 1));
    }

    private static boolean distinctTokens(@Nullable IElementType token1, @Nullable IElementType token2) {
        if (token1 == token2) {
            return false;
        }
        if (token1 == null || token2 == null) {
            return true;
        }
        if (StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(token1) || StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(token2)) {
            return false;
        }
        if (token1 != TokenType.WHITE_SPACE && token2 != TokenType.WHITE_SPACE && !token1.getLanguage().is(token2.getLanguage())) {
            return true;
        }
        Language language = token1.getLanguage();
        if (language == Language.ANY) {
            language = token2.getLanguage();
        }
        BidiRegionsSeparator separator = (BidiRegionsSeparator)LanguageBidiRegionsSeparator.getInstance().forLanguage(language);
        return separator.createBorderBetweenTokens(token1, token2);
    }

    private static void addRuns(List<BidiRun> runs, char[] text2, int start2, int end, int flags) {
        if (start2 < end && !Bidi.requiresBidi(text2, start2, end)) {
            LineLayout.addOrMergeRun(runs, new BidiRun(0, start2, end));
            return;
        }
        int afterLastTabPosition = start2;
        for (int i2 = start2; i2 < end; ++i2) {
            if (text2[i2] != '\t') continue;
            LineLayout.addRunsNoTabs(runs, text2, afterLastTabPosition, i2, flags);
            afterLastTabPosition = i2 + 1;
            LineLayout.addOrMergeRun(runs, new BidiRun(0, i2, i2 + 1));
        }
        LineLayout.addRunsNoTabs(runs, text2, afterLastTabPosition, end, flags);
    }

    private static void addRunsNoTabs(List<BidiRun> runs, char[] text2, int start2, int end, int flags) {
        if (start2 >= end) {
            return;
        }
        Bidi bidi = new Bidi(text2, start2, null, 0, end - start2, flags);
        int runCount = bidi.getRunCount();
        for (int i2 = 0; i2 < runCount; ++i2) {
            LineLayout.addOrMergeRun(runs, new BidiRun((byte)bidi.getRunLevel(i2), start2 + bidi.getRunStart(i2), start2 + bidi.getRunLimit(i2)));
        }
    }

    private static void addOrMergeRun(List<BidiRun> runs, BidiRun run2) {
        int size2 = runs.size();
        if (size2 > 0 && runs.get((int)(size2 - 1)).level == 0 && run2.level == 0) {
            BidiRun lastRun = runs.remove(size2 - 1);
            assert (lastRun.endOffset == run2.startOffset);
            runs.add(new BidiRun(0, lastRun.startOffset, run2.endOffset));
        } else {
            runs.add(run2);
        }
    }

    private static void addFragments(EditorView view2, BidiRun run2, Chunk chunk, char[] text2, int start2, int end, @Nullable TabFragment tabFragment, boolean showSpecialChars, FontFallbackIterator it) {
        assert (start2 < end);
        int last = start2;
        for (int i2 = start2; i2 < end; ++i2) {
            char c = text2[i2];
            LineFragment specialFragment = null;
            if (c == '\t') {
                assert (run2.level == 0);
                specialFragment = tabFragment;
            } else if (showSpecialChars) {
                specialFragment = SpecialCharacterFragment.create(view2, c, text2, i2);
            }
            if (specialFragment == null) continue;
            LineLayout.addFragmentsNoTabs(run2, chunk, text2, last, i2, it, view2);
            chunk.fragments.add(specialFragment);
            last = i2 + 1;
        }
        LineLayout.addFragmentsNoTabs(run2, chunk, text2, last, end, it, view2);
        assert (!chunk.fragments.isEmpty());
    }

    private static void addFragmentsNoTabs(BidiRun run2, Chunk chunk, char[] text2, int start2, int end, FontFallbackIterator it, EditorView view2) {
        if (start2 < end) {
            it.start(text2, start2, end);
            while (!it.atEnd()) {
                LineLayout.addTextFragmentIfNeeded(chunk, text2, it.getStart(), it.getEnd(), it.getFontInfo(), run2.isRtl(), view2);
                it.advance();
            }
        }
    }

    private static void addTextFragmentIfNeeded(Chunk chunk, char[] chars, int from, int to, FontInfo fontInfo, boolean isRtl, EditorView view2) {
        if (to > from) {
            assert (fontInfo != null);
            TextFragmentFactory.createTextFragments(chunk.fragments, chars, from, to, isRtl, fontInfo, view2);
        }
    }

    Iterable<VisualFragment> getFragmentsInVisualOrder(float startX) {
        return () -> new VisualOrderIterator(null, 0, startX, 0, 0, this.getRunsInVisualOrder());
    }

    Iterator<VisualFragment> getFragmentsInVisualOrder(@NotNull EditorView view2, int line, float startX, int startVisualColumn, int startOffset, int endOffset, @Nullable Runnable quickEvaluationListener) {
        BidiRun[] runs;
        if (view2 == null) {
            LineLayout.$$$reportNull$$$0(10);
        }
        assert (startOffset <= endOffset);
        DocumentEx document2 = view2.getDocument();
        int lineStartOffset = document2.getLineStartOffset(line);
        assert (!DocumentUtil.isInsideSurrogatePair((Document)document2, (int)(lineStartOffset + startOffset)));
        assert (!DocumentUtil.isInsideSurrogatePair((Document)document2, (int)(lineStartOffset + endOffset)));
        if (startOffset == endOffset) {
            runs = BidiRun.EMPTY_ARRAY;
        } else {
            ArrayList<BidiRun> runList = new ArrayList<BidiRun>();
            for (BidiRun run2 : this.getRunsInLogicalOrder()) {
                if (run2.endOffset <= startOffset) continue;
                if (run2.startOffset >= endOffset) break;
                runList.add(run2.subRun(view2, line, startOffset, endOffset, quickEvaluationListener));
            }
            if ((runs = runList.toArray(BidiRun.EMPTY_ARRAY)).length > 1) {
                LineLayout.reorderRunsVisually(runs);
            }
        }
        return new VisualOrderIterator(view2, line, startX, startVisualColumn, startOffset, runs);
    }

    abstract Stream<Chunk> getChunksInLogicalOrder();

    float getWidth() {
        throw new RuntimeException("This LineLayout instance doesn't have precalculated width");
    }

    abstract boolean isLtr();

    abstract boolean isRtlLocation(int var1, boolean var2);

    abstract int findNearestDirectionBoundary(int var1, boolean var2);

    abstract BidiRun[] getRunsInLogicalOrder();

    abstract BidiRun[] getRunsInVisualOrder();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/view/LineLayout";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/view/LineLayout";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createLayout";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isBidiLayoutRequired";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFragments";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFragmentsInVisualOrder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class WithSize
    extends LineLayout {
        private final LineLayout myDelegate;
        private final float myWidth;

        private WithSize(@NotNull LineLayout delegate) {
            if (delegate == null) {
                WithSize.$$$reportNull$$$0(0);
            }
            this.myDelegate = delegate;
            this.myWidth = this.calculateWidth();
        }

        private float calculateWidth() {
            float x = 0.0f;
            for (VisualFragment fragment : this.getFragmentsInVisualOrder(x)) {
                x = fragment.getEndX();
            }
            return x;
        }

        @Override
        Stream<Chunk> getChunksInLogicalOrder() {
            return this.myDelegate.getChunksInLogicalOrder();
        }

        @Override
        float getWidth() {
            return this.myWidth;
        }

        @Override
        boolean isLtr() {
            return this.myDelegate.isLtr();
        }

        @Override
        boolean isRtlLocation(int offset, boolean leanForward) {
            return this.myDelegate.isRtlLocation(offset, leanForward);
        }

        @Override
        int findNearestDirectionBoundary(int offset, boolean lookForward) {
            return this.myDelegate.findNearestDirectionBoundary(offset, lookForward);
        }

        @Override
        BidiRun[] getRunsInLogicalOrder() {
            return this.myDelegate.getRunsInLogicalOrder();
        }

        @Override
        BidiRun[] getRunsInVisualOrder() {
            return this.myDelegate.getRunsInVisualOrder();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/editor/impl/view/LineLayout$WithSize", "<init>"));
        }
    }

    private static final class SingleChunk
    extends LineLayout {
        private final Chunk myChunk;

        private SingleChunk(Chunk chunk) {
            this.myChunk = chunk;
        }

        @Override
        Stream<Chunk> getChunksInLogicalOrder() {
            return this.myChunk == null ? Stream.empty() : Stream.of(this.myChunk);
        }

        @Override
        boolean isLtr() {
            return true;
        }

        @Override
        boolean isRtlLocation(int offset, boolean leanForward) {
            return false;
        }

        @Override
        int findNearestDirectionBoundary(int offset, boolean lookForward) {
            return -1;
        }

        @Override
        BidiRun[] getRunsInLogicalOrder() {
            return this.createRuns();
        }

        @Override
        BidiRun[] getRunsInVisualOrder() {
            return this.createRuns();
        }

        private BidiRun[] createRuns() {
            if (this.myChunk == null) {
                return BidiRun.EMPTY_ARRAY;
            }
            BidiRun run2 = new BidiRun(this.myChunk.endOffset);
            run2.chunks = Collections.singletonList(this.myChunk);
            return new BidiRun[]{run2};
        }
    }

    static class Chunk {
        List<LineFragment> fragments;
        private final int startOffset;
        private final int endOffset;

        private Chunk(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        private void ensureLayout(@NotNull EditorView view2, BidiRun run2, int line) {
            if (view2 == null) {
                Chunk.$$$reportNull$$$0(0);
            }
            if (this.isReal()) {
                view2.getTextLayoutCache().onChunkAccess(this);
            }
            if (this.fragments != null) {
                return;
            }
            assert (this.isReal());
            this.fragments = new ArrayList<LineFragment>();
            EditorImpl editor2 = view2.getEditor();
            int lineStartOffset = view2.getDocument().getLineStartOffset(line);
            int start2 = lineStartOffset + this.startOffset;
            int end = lineStartOffset + this.endOffset;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Text layout for " + String.valueOf(editor2.getVirtualFile()) + " (" + start2 + "-" + end + ")");
            }
            IterationState it = new IterationState(editor2, start2, end, null, false, true, false, false);
            FontFallbackIterator ffi = new FontFallbackIterator().setPreferredFonts(editor2.getColorsScheme().getFontPreferences()).setFontRenderContext(view2.getFontRenderContext());
            boolean specialCharsEnabled = editor2.getSettings().isShowingSpecialChars();
            char[] chars = CharArrayUtil.fromSequence((CharSequence)view2.getDocument().getImmutableCharSequence(), (int)start2, (int)end);
            int currentFontType = 0;
            Color currentColor = null;
            int currentStart = start2;
            while (!it.atEnd()) {
                int fontType = it.getMergedAttributes().getFontType();
                Color color = it.getMergedAttributes().getForegroundColor();
                if (fontType != currentFontType || !color.equals(currentColor)) {
                    int tokenStart = it.getStartOffset();
                    if (tokenStart > currentStart) {
                        LineLayout.addFragments(view2, run2, this, chars, currentStart - start2, tokenStart - start2, view2.getTabFragment(), specialCharsEnabled, ffi);
                    }
                    currentStart = tokenStart;
                    currentColor = color;
                    currentFontType = fontType;
                    ffi.setFontStyle(currentFontType);
                }
                it.advance();
            }
            if (end > currentStart) {
                LineLayout.addFragments(view2, run2, this, chars, currentStart - start2, end - start2, view2.getTabFragment(), specialCharsEnabled, ffi);
            }
            view2.getSizeManager().textLayoutPerformed(start2, end);
            assert (!this.fragments.isEmpty());
        }

        private Chunk subChunk(EditorView view2, BidiRun run2, int line, int targetStartOffset, int targetEndOffset, @Nullable Runnable quickEvaluationListener) {
            assert (this.isReal());
            assert (targetStartOffset < this.endOffset);
            assert (targetEndOffset > this.startOffset);
            int start2 = Math.max(this.startOffset, targetStartOffset);
            int end = Math.min(this.endOffset, targetEndOffset);
            if (quickEvaluationListener != null && this.fragments == null) {
                quickEvaluationListener.run();
                SyntheticChunk chunk = new SyntheticChunk(start2, end);
                int startColumn = view2.getLogicalPositionCache().offsetToLogicalColumn(line, start2);
                int endColumn = view2.getLogicalPositionCache().offsetToLogicalColumn(line, end);
                chunk.fragments = Collections.singletonList(new ApproximationFragment(end - start2, endColumn - startColumn, view2.getMaxCharWidth()));
                return chunk;
            }
            if (start2 == this.startOffset && end == this.endOffset) {
                return this;
            }
            this.ensureLayout(view2, run2, line);
            SyntheticChunk chunk = new SyntheticChunk(start2, end);
            chunk.fragments = new ArrayList<LineFragment>();
            int offset = this.startOffset;
            for (LineFragment fragment : this.fragments) {
                if (end <= offset) break;
                int endOffset = offset + fragment.getLength();
                if (start2 < endOffset) {
                    chunk.fragments.add(fragment.subFragment(Math.max(start2, offset) - offset, Math.min(end, endOffset) - offset));
                }
                offset = endOffset;
            }
            return chunk;
        }

        boolean isReal() {
            return true;
        }

        void clearCache() {
            this.fragments = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout$Chunk", "ensureLayout"));
        }
    }

    private static final class BidiRun {
        public static final BidiRun[] EMPTY_ARRAY = new BidiRun[0];
        private static final int CHUNK_CHARACTERS = 1024;
        private final byte level;
        private final int startOffset;
        private final int endOffset;
        private int visualStartLogicalColumn;
        private List<Chunk> chunks;

        private BidiRun(int length) {
            this(0, 0, length);
        }

        private BidiRun(byte level, int startOffset, int endOffset) {
            this.level = level;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        private boolean isRtl() {
            return BitUtil.isSet((int)this.level, (int)1);
        }

        @NotNull
        private List<Chunk> getChunks(CharSequence text2, int startOffsetInText) {
            List<Chunk> c = this.chunks;
            if (c == null) {
                int chunkCount = this.getChunkCount();
                this.chunks = c = new ArrayList<Chunk>(chunkCount);
                for (int i2 = 0; i2 < chunkCount; ++i2) {
                    int from = this.startOffset + i2 * 1024;
                    int to = i2 == chunkCount - 1 ? this.endOffset : from + 1024;
                    Chunk chunk = new Chunk(LineLayout.alignToCodePointBoundary(text2, from + startOffsetInText) - startOffsetInText, LineLayout.alignToCodePointBoundary(text2, to + startOffsetInText) - startOffsetInText);
                    c.add(chunk);
                }
            }
            List<Chunk> list2 = c;
            if (list2 == null) {
                BidiRun.$$$reportNull$$$0(0);
            }
            return list2;
        }

        private int getChunkCount() {
            return (this.endOffset - this.startOffset + 1024 - 1) / 1024;
        }

        private BidiRun subRun(@NotNull EditorView view2, int line, int targetStartOffset, int targetEndOffset, @Nullable Runnable quickEvaluationListener) {
            if (view2 == null) {
                BidiRun.$$$reportNull$$$0(1);
            }
            assert (targetStartOffset < this.endOffset);
            assert (targetEndOffset > this.startOffset);
            int start2 = Math.max(this.startOffset, targetStartOffset);
            int end = Math.min(this.endOffset, targetEndOffset);
            BidiRun subRun = new BidiRun(this.level, start2, end);
            SmartList subChunks = new SmartList();
            DocumentEx document2 = view2.getDocument();
            List<Chunk> chunks = this.getChunks(document2.getImmutableCharSequence(), document2.getLineStartOffset(line));
            for (int i2 = (start2 - this.startOffset) / 1024; i2 < chunks.size(); ++i2) {
                Chunk chunk = chunks.get(i2);
                if (chunk.endOffset <= start2) continue;
                if (chunk.startOffset >= end) break;
                subChunks.add(chunk.subChunk(view2, this, line, start2, end, quickEvaluationListener));
            }
            subRun.chunks = subChunks;
            subRun.visualStartLogicalColumn = (subRun.isRtl() ? end == this.endOffset : start2 == this.startOffset) ? this.visualStartLogicalColumn : view2.getLogicalPositionCache().offsetToLogicalColumn(line, subRun.isRtl() ? end : start2);
            return subRun;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/view/LineLayout$BidiRun";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChunks";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/view/LineLayout$BidiRun";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "subRun";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class MultiChunk
    extends LineLayout {
        private final BidiRun[] myBidiRunsInLogicalOrder;
        private final BidiRun[] myBidiRunsInVisualOrder;

        private MultiChunk(BidiRun[] bidiRunsInLogicalOrder) {
            this.myBidiRunsInLogicalOrder = bidiRunsInLogicalOrder;
            if (bidiRunsInLogicalOrder.length > 1) {
                this.myBidiRunsInVisualOrder = (BidiRun[])this.myBidiRunsInLogicalOrder.clone();
                LineLayout.reorderRunsVisually(this.myBidiRunsInVisualOrder);
            } else {
                this.myBidiRunsInVisualOrder = bidiRunsInLogicalOrder;
            }
        }

        @Override
        Stream<Chunk> getChunksInLogicalOrder() {
            return Stream.of(this.myBidiRunsInLogicalOrder).flatMap(r -> r.chunks == null ? Stream.empty() : r.chunks.stream());
        }

        @Override
        boolean isLtr() {
            return this.myBidiRunsInLogicalOrder.length == 0 || this.myBidiRunsInLogicalOrder.length == 1 && !this.myBidiRunsInLogicalOrder[0].isRtl();
        }

        @Override
        boolean isRtlLocation(int offset, boolean leanForward) {
            if (offset == 0 && !leanForward) {
                return false;
            }
            for (BidiRun run2 : this.myBidiRunsInLogicalOrder) {
                if (offset >= run2.endOffset && (offset != run2.endOffset || leanForward)) continue;
                return run2.isRtl();
            }
            return false;
        }

        @Override
        int findNearestDirectionBoundary(int offset, boolean lookForward) {
            byte originLevel = -1;
            if (lookForward) {
                for (BidiRun run2 : this.myBidiRunsInLogicalOrder) {
                    if (originLevel >= 0) {
                        if (run2.level == originLevel) continue;
                        return run2.startOffset;
                    }
                    if (run2.endOffset <= offset) continue;
                    originLevel = run2.level;
                }
                return originLevel > 0 ? this.myBidiRunsInLogicalOrder[this.myBidiRunsInLogicalOrder.length - 1].endOffset : -1;
            }
            for (int i2 = this.myBidiRunsInLogicalOrder.length - 1; i2 >= 0; --i2) {
                BidiRun run3 = this.myBidiRunsInLogicalOrder[i2];
                if (originLevel >= 0) {
                    if (run3.level == originLevel) continue;
                    return run3.endOffset;
                }
                if (run3.startOffset >= offset) continue;
                originLevel = run3.level;
            }
            return originLevel > 0 ? 0 : -1;
        }

        @Override
        BidiRun[] getRunsInLogicalOrder() {
            return this.myBidiRunsInLogicalOrder;
        }

        @Override
        BidiRun[] getRunsInVisualOrder() {
            return this.myBidiRunsInVisualOrder;
        }
    }

    private static final class VisualOrderIterator
    implements Iterator<VisualFragment> {
        private final EditorView myView;
        private final CharSequence myText;
        private final int myLine;
        private final int myLineStartOffset;
        private final BidiRun[] myRuns;
        private int myRunIndex;
        private int myChunkIndex;
        private int myFragmentIndex;
        private int myOffsetInsideRun;
        private final VisualFragment myFragment = new VisualFragment();

        private VisualOrderIterator(EditorView view2, int line, float startX, int startVisualColumn, int startOffset, BidiRun[] runsInVisualOrder) {
            this.myView = view2;
            this.myText = view2 == null ? null : view2.getDocument().getImmutableCharSequence();
            this.myLine = line;
            this.myLineStartOffset = view2 == null ? 0 : view2.getDocument().getLineStartOffset(line);
            this.myRuns = runsInVisualOrder;
            this.myFragment.startX = startX;
            this.myFragment.startVisualColumn = startVisualColumn;
            this.myFragment.startOffset = startOffset;
        }

        @Override
        public boolean hasNext() {
            if (this.myRunIndex >= this.myRuns.length) {
                return false;
            }
            BidiRun run2 = this.myRuns[this.myRunIndex];
            List<Chunk> chunks = run2.getChunks(this.myText, this.myLineStartOffset);
            if (this.myChunkIndex >= chunks.size()) {
                return false;
            }
            Chunk chunk = chunks.get(run2.isRtl() ? chunks.size() - 1 - this.myChunkIndex : this.myChunkIndex);
            if (this.myView != null) {
                chunk.ensureLayout(this.myView, run2, this.myLine);
            }
            return this.myFragmentIndex < chunk.fragments.size();
        }

        @Override
        public VisualFragment next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BidiRun run2 = this.myRuns[this.myRunIndex];
            if (this.myRunIndex == 0 && this.myChunkIndex == 0 && this.myFragmentIndex == 0) {
                this.myFragment.startLogicalColumn = run2.visualStartLogicalColumn;
            } else {
                this.myFragment.startLogicalColumn = this.myChunkIndex == 0 && this.myFragmentIndex == 0 ? run2.visualStartLogicalColumn : this.myFragment.getEndLogicalColumn();
                this.myFragment.startVisualColumn = this.myFragment.getEndVisualColumn();
                this.myFragment.startX = this.myFragment.getEndX();
            }
            this.myFragment.isRtl = run2.isRtl();
            List<Chunk> chunks = run2.getChunks(this.myText, this.myLineStartOffset);
            Chunk chunk = chunks.get(run2.isRtl() ? chunks.size() - 1 - this.myChunkIndex : this.myChunkIndex);
            this.myFragment.delegate = chunk.fragments.get(run2.isRtl() ? chunk.fragments.size() - 1 - this.myFragmentIndex : this.myFragmentIndex);
            this.myFragment.startOffset = run2.isRtl() ? run2.endOffset - this.myOffsetInsideRun : run2.startOffset + this.myOffsetInsideRun;
            this.myOffsetInsideRun += this.myFragment.getLength();
            ++this.myFragmentIndex;
            if (this.myFragmentIndex >= chunk.fragments.size()) {
                this.myFragmentIndex = 0;
                ++this.myChunkIndex;
                if (this.myChunkIndex >= chunks.size()) {
                    this.myChunkIndex = 0;
                    this.myOffsetInsideRun = 0;
                    ++this.myRunIndex;
                }
            }
            return this.myFragment;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static final class VisualFragment {
        private LineFragment delegate;
        private int startOffset;
        private int startLogicalColumn;
        private int startVisualColumn;
        private float startX;
        private boolean isRtl;

        VisualFragment() {
        }

        boolean isRtl() {
            return this.isRtl;
        }

        int getMinOffset() {
            return this.isRtl ? this.startOffset - this.getLength() : this.startOffset;
        }

        int getMaxOffset() {
            return this.isRtl ? this.startOffset : this.startOffset + this.getLength();
        }

        int getStartOffset() {
            return this.startOffset;
        }

        int getEndOffset() {
            return this.isRtl ? this.startOffset - this.getLength() : this.startOffset + this.getLength();
        }

        int getLength() {
            return this.delegate.getLength();
        }

        int getStartLogicalColumn() {
            return this.startLogicalColumn;
        }

        int getEndLogicalColumn() {
            return this.isRtl ? this.startLogicalColumn - this.getLogicalColumnCount() : this.startLogicalColumn + this.getLogicalColumnCount();
        }

        int getMinLogicalColumn() {
            return this.isRtl ? this.startLogicalColumn - this.getLogicalColumnCount() : this.startLogicalColumn;
        }

        int getMaxLogicalColumn() {
            return this.isRtl ? this.startLogicalColumn : this.startLogicalColumn + this.getLogicalColumnCount();
        }

        int getStartVisualColumn() {
            return this.startVisualColumn;
        }

        int getEndVisualColumn() {
            return this.startVisualColumn + this.getVisualColumnCount();
        }

        int getLogicalColumnCount() {
            return this.delegate.getLogicalColumnCount(this.isRtl ? 0 : this.getMinLogicalColumn());
        }

        int getVisualColumnCount() {
            return this.delegate.getVisualColumnCount(this.startX);
        }

        float getStartX() {
            return this.startX;
        }

        float getEndX() {
            return this.delegate.offsetToX(this.startX, 0, this.getLength());
        }

        int logicalToVisualColumn(int column) {
            return this.startVisualColumn + this.delegate.logicalToVisualColumn(this.startX, this.getMinLogicalColumn(), this.isRtl ? this.startLogicalColumn - column : column - this.startLogicalColumn);
        }

        int visualToLogicalColumn(int column) {
            int relativeLogicalColumn = this.delegate.visualToLogicalColumn(this.startX, this.getMinLogicalColumn(), column - this.startVisualColumn);
            return this.isRtl ? this.startLogicalColumn - relativeLogicalColumn : this.startLogicalColumn + relativeLogicalColumn;
        }

        int visualColumnToOffset(int relativeVisualColumn) {
            return this.delegate.visualColumnToOffset(this.startX, relativeVisualColumn);
        }

        float offsetToX(int offset) {
            return this.delegate.offsetToX(this.startX, 0, this.getRelativeOffset(offset));
        }

        float offsetToX(float startX, int startOffset, int offset) {
            return this.delegate.offsetToX(startX, this.getRelativeOffset(startOffset), this.getRelativeOffset(offset));
        }

        int[] xToVisualColumn(float x) {
            int[] column = this.delegate.xToVisualColumn(this.startX, x);
            column[0] = column[0] + this.startVisualColumn;
            return column;
        }

        float visualColumnToX(int column) {
            return this.delegate.visualColumnToX(this.startX, column - this.startVisualColumn);
        }

        void draw(Graphics2D g, float x, float y) {
            this.delegate.draw(x, y, 0, this.getLength()).accept(g);
        }

        Consumer<Graphics2D> draw(float x, float y, int startRelativeOffset, int endRelativeOffset) {
            return this.delegate.draw(x, y, startRelativeOffset, endRelativeOffset);
        }

        private int getRelativeOffset(int offset) {
            return this.isRtl ? this.startOffset - offset : offset - this.startOffset;
        }
    }

    private static final class SyntheticChunk
    extends Chunk {
        private SyntheticChunk(int startOffset, int endOffset) {
            super(startOffset, endOffset);
        }

        @Override
        boolean isReal() {
            return false;
        }
    }
}

