/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bg\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\rH&J\u000f\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/editor/markup/FillingLineMarkerRenderer;", "Lcom/intellij/openapi/editor/markup/LineMarkerRendererEx;", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "getIcon", "Ljavax/swing/Icon;", "getTextAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getMaxWidth", "", "()Ljava/lang/Integer;", "intellij.platform.ide.impl"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nFillingLineMarkerRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FillingLineMarkerRenderer.kt\ncom/intellij/openapi/editor/markup/FillingLineMarkerRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,34:1\n1#2:35\n*E\n"})
public interface FillingLineMarkerRenderer
extends LineMarkerRendererEx {
    default public void paint(@NotNull Editor editor2, @NotNull Graphics g, @NotNull Rectangle r) {
        block4: {
            Icon icon2;
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            TextAttributes color = editor2.getColorsScheme().getAttributes(this.getTextAttributesKey());
            Color bgColor = color.getBackgroundColor();
            if (bgColor == null) {
                bgColor = color.getForegroundColor();
            }
            if (bgColor != null) {
                int n;
                g.setColor(bgColor);
                Integer n2 = this.getMaxWidth();
                if (n2 != null) {
                    int it = ((Number)n2).intValue();
                    boolean bl = false;
                    n = RangesKt.coerceAtMost((int)r.width, (int)JBUI.scale((int)it));
                } else {
                    n = r.width;
                }
                int w = n;
                g.fillRect(r.x, r.y, w, r.height);
            }
            Icon icon3 = icon2 = this.getIcon();
            if (icon3 == null) break block4;
            icon3.paintIcon(editor2.getComponent(), g, r.x, r.y);
        }
    }

    @Nullable
    default public Icon getIcon() {
        return null;
    }

    @NotNull
    public TextAttributesKey getTextAttributesKey();

    @Nullable
    default public Integer getMaxWidth() {
        return null;
    }
}

